/*
     REXXPL.CMD v2.0 [REXXPL20.ZIP]  C.L.Distefano rev. 1/15/98
       Embed Rexx code in XyWrite (XPL) programs ("RexXPL!")
       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

Developers:  
**********/
DEBUG=0 /* <== Set DEBUG=1 to suppress deletion of temp files
               R2XTMP.CMD & R2XTMP.TMP, located in BootDrive:\OS2\MDOS
               Rexx output file is copied to OUTPUT.DBG for inspection
*********************************************************************/

if RxFuncQuery('SysLoadFuncs') then do
call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs
end

call SysIni 'BOTH','FolderWorkareaRunningObjects','ALL:','Objects'
BtDrv=translate(left(Objects.1,1)) /* BootDrive letter */

RxPath=BtDrv':\OS2\MDOS\'

exec=RxPath'R2XTMP.CMD'
flag=RxPath'OUTPUT.OK'
infile=RxPath'R2XTMP.TMP'

linein(infile,1,0)
if lines(infile)=0 & debug\=1 then do
  say
  say 'REXXPL.CMD v2.0 [REXXPL20.ZIP]  C.L.Distefano  rev. 1/15/98'
  say 'Include Rexx procedures in XyWrite programs (Rexx+XPL)'
  say
  say 'REXXPL.CMD is called by XyWrite (U2) routine "R2X"'
  say 'It is not issued directly from the OS/2 command line'
  say
  exit 99
  end

if stream(exec,'C','query exists')\='' then call SysFileDelete exec
if stream(flag,'C','query exists')\='' then call SysFileDelete flag

rc=lineout(exec,,1)

call lineout exec, '/* R2XTMP.CMD */'
call lineout exec, 'signal on Failure; signal on Syntax; signal on Error'
call lineout exec, 'Lg=x2c("AE"); Rg=x2c("AF")'
call lineout exec, 'EOF=x2c("1A"); CrLf=x2c("0D0A")'
call lineout exec, 'BtDrv="'||BtDrv||'"'
call lineout exec, 'OUTPUT.R2X=""; Protect=""; xy.=""'
call lineout exec, 'flag="'||flag||'"'

do while lines(infile)>0
  call lineout exec, linein(infile)
  end
call stream infile, 'C', 'close'

call lineout exec, 'Exit:'
call lineout exec, 'if Protect=1 then signal Coda'
call lineout exec, 'if length(SGs)>25 then say "Working ..."'
call lineout exec, 'do while pos(",",SGs)>1'
call lineout exec, ' parse var SGs IDz "," SGs'
call lineout exec, 'OUTPUT.R2X=OUTPUT.R2X||Lg"SV"IDz","xy.IDz||Rg'
call lineout exec, 'end'
call lineout exec, 'do while pos(EOF,output.r2x)>0'
call lineout exec, 'posEOF=pos(EOF,output.r2x)'
call lineout exec, 'output.r2x=insert(x2c('5BF262E92ACD1ED458C05D'),,'
call lineout exec, ' delstr(output.r2x,posEOF,1),posEOF-1)'
call lineout exec, 'end'
call lineout exec, 'output.r2x=translate(output.r2x," ",x2c("00"))'

call lineout exec, 'Coda:'
call lineout exec, 'if Protect\=1 then do'
call lineout exec, 'call directory "'RxPath'"'
call lineout exec, 'tempfile=SysTempFilename("OUTPUT??.???")'
call lineout exec, 'call stream tempfile,"C","open write"'
call lineout exec, 'call charout tempfile,output.r2x,1'
call lineout exec, 'call stream tempfile,"C","close"'
if debug=1 then call lineout exec,,
 '"@copy "tempfile" 'RxPath'OUTPUT.DBG>nul"'
call lineout exec, '"@ren "tempfile" output.ok"'
call lineout exec, 'end'

call lineout exec, 'EXIT 0'

call lineout exec, 'Read:'
call lineout exec, 'tmpSG=""'
call lineout exec, 'call stream SGfile,"C","open read"'
call lineout exec, 'do while chars(SGfile)>1'
call lineout exec, 'tmpSG=tmpSG||charin(SGfile)'
call lineout exec, 'end'
call lineout exec, 'call stream SGfile,"C","close"'
call lineout exec, 'call SysFileDelete SGfile'
call lineout exec, 'drop SGfile'
call lineout exec, 'return'

call lineout exec, 'Syntax:'
call lineout exec, 'if Protect\=1 then do'
call lineout exec, '  output.r2x=Lg"SV711,Error (syntax): "sourceline(sigl)||Rg||,'
call lineout exec,    'Lg"SV712,Explanation: "Errortext(rc)||Rg'
call lineout exec, '  signal Coda'
call lineout exec, '  end'
call lineout exec, 'else call beep 750,500'
call lineout exec, 'say "Error (syntax): "sourceline(sigl)'
call lineout exec, 'say "Explanation:    "Errortext(rc)'
call lineout exec, 'exit rc'

call lineout exec, 'Failure:'
call lineout exec, 'if Protect\=1 then do'
call lineout exec, '  output.r2x=Lg"SV711,Error (failure): "sourceline(sigl)||Rg||,'
call lineout exec,    'Lg"SV712,"SysGetMessage(rc)||Rg'
call lineout exec, '  signal Coda'
call lineout exec, '  end'
call lineout exec, 'else call beep 750,500'
call lineout exec, 'say "Error (failure): "sourceline(sigl)'
call lineout exec, 'say SysGetMessage(rc)'
call lineout exec, 'exit rc'

call lineout exec, 'Error:'
call lineout exec, 'if Protect\=1 then do'
call lineout exec, '  output.r2x=Lg"SV711,Error (rc="||rc||"): "sourceline(sigl)||Rg||Lg"SV712,"||SysGetMessage(rc)||Rg'
call lineout exec, '  signal Coda'
call lineout exec, '  end'
call lineout exec, 'else call beep 750,500'
call lineout exec, 'say "Error (rc="||rc||"): "sourceline(sigl)'
call lineout exec, 'say SysGetMessage(rc)'
call lineout exec, 'exit rc'

call stream exec, 'C', 'close'

'@call 'exec

if debug\=1 then do
  call SysFileDelete infile
  call SysFileDelete exec
  end

EXIT 0 /* REXXPL.CMD */
