/************************************************************************
 *
 *
 *   Licensed Materials - Property of IBM
 *
 *   IBM DOS TCP/IP (C) Copyright IBM Corp. 1991. All rights reserved.
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *
 ************************************************************************/


/*
 * TCP/IP Header Files.
 */
#include <sys\tcptypes.h>
#include <netinet\in.h>
#include <sys\socket.h>
#include <arpa\inet.h>

/*
 *  C Header files.
 */
#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <sys\errno.h>
#include <process.h>
#include <string.h>


main(argc, argv)
int argc;
char **argv;
{


   int s;
   unsigned short port;
   struct sockaddr_in server;
   char buf[32];

   /* argv[1] is internet address of server argv[2] is port of server.
    * Convert the port from ascii to integer and then from host byte
    * order to network byte order.
    */
   if(argc != 3)
   {
      printf("Usage: %s <host address> <port> \n",argv[0]);
      exit(1);
   }
   port = htons(atoi(argv[2]));

   /* Initialize with sockets */
   if ( sock_init() ) {
      fprintf(stderr, "ERROR:  INET is probably not running\n");
      fprintf(stderr, "        Please verify that you have started TCP/IP for DOS.\n");
      exit(1);
   }


   /* Create a datagram socket in the internet domain and use the
    * default protocol (UDP).
    */
   if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
   {
       fprintf(stderr, "ERROR:  socket():  tcperrno = %d\n", tcperrno);
       perror("        ");
       exit(1);
   }

   /* Set up the server name */
   server.sin_family      = AF_INET;            /* Internet Domain    */
   server.sin_port        = port;               /* Server Port        */
   server.sin_addr.s_addr = inet_addr(argv[1]); /* Server's Address   */

   strcpy(buf, "Hello");

   /* Send the message in buf to the server */
   if (sendto(s, (char far *)buf, (strlen(buf)+1), 0, (struct sockaddr __far *)&server, sizeof(server)) < 0)
   {
       fprintf(stderr, "ERROR:  sendto():  tcperrno = %d\n", tcperrno);
       perror("        ");
       exit(2);
   }

   /* Deallocate the socket */
   close(s);
   printf("Client ended successfully\n");

   return(0);

}
