#include<mem.h>
#include<jctype.h>
#include"wir.h"

#define entry(index)	peekb(FP_SEG(dir)+(index)*2,FP_OFF(dir))

const char cantfind[]="Can't find the file specified";

unsigned getdirsize(unsigned m,unsigned n)
{
  int a;

  switch(n-m){
    case 1: if(!entry(m))
	      return m;

    case 0: return n;
  }
  a=(m+n)/2;
  return entry(a)?getdirsize(a+1,n):getdirsize(m,a);
}

char*jstrchr(char*s,unsigned c)
{
  for(;*s;++s){
    if(*s==c)
      return s;

    if(flags&JAPANESE&&iskanji(*s))
      if(!*++s)
	break;
  }
  return NULL;
}

char*fncp(char*s,char*d,int n)
{
  int kanji=0;

  while(--n>=0){
    switch(*s){
      case'\\': if(!(flags&JAPANESE&&kanji))
      case'.':
      case 0:	  return s;

		kanji=0;
		break;

      default:	kanji=!kanji&&iskanji(*s);
    }
    *(d++)=*(s++);
  }
  return s;
}

#pragma option -O1 -Og -Oi -Ol -Om -Op -Ot
void tracedir(int ndir,char*path)
{
  const struct dir_entry far*pdir=dir;

  if(jstrchr(path,'\\')){
    char name83[11];

    if(*(path=fncp(path,memset(name83,' ',11),8))=='.')
      path=fncp(path+1,name83+8,3);

    if(*name83==0xE5)
      *name83=5;

    for(;*pdir->name&&--ndir>=0;FP_SEG(pdir)+=2)
      if(pdir->attrib&FA_DIREC)
	if(!_fmemcmp(pdir->name,name83,11)){
	  tracedir(loaddir(pdir->cluster),(pathterm=path)+1);
	  return;
	}
    error(cantfind);
  }
  {
    int tndir;

    if(*path){
      makepattern(path);
      if(nc==11)
	for(tndir=0;*pdir->name&&tndir<ndir;FP_SEG(pdir)+=2,++tndir)
	  if(*pdir->name!=0xE5&&pdir->attrib&FA_DIREC
	     &&!_fmemcmp(pdir->name,cand,11)){
	    nc=0;
	    showlist(getdirsize(0,loaddir(pdir->cluster)));
	    return;
	  }
	*pathterm=0;
    }
    if(!tndir)
      tndir=getdirsize(0,ndir);

    showlist(tndir);
  }
}
