#include<dos.h>
#include<stdio.h>
/*
 * Structure definitions
 */
#pragma option -a-
extern struct dpb{
  char		 drive, /* Drive number (00h = A:, 01h = B:, etc)	*/
		 unit;	/* Unit number within device driver		*/
  unsigned	 bps;	/* Bytes per sector				*/
  char		 sctcl, /* Highest sector number within a cluster	*/
		 sft;	/* Shift count to convert clusters into sectors */
  unsigned	 rsv;	/* Number of reserved sectors at beginning	*/
  char		 nfats; /* Number of FATs				*/
  unsigned	 ndir,	/* Number of root directory entries		*/
		 data,	/* Number of first sector containing user data	*/
		 maxcl, /* Highest cluster (number of clusters + 1)	*/
		 sfats, /* Number of sectors per FAT			*/
		 dir;	/* Sector number of first directory sector	*/
  void	     far*ddh;	/* address of device driver header		*/
  char		 id,	/* Media ID byte				*/
		 acf;	/* ???						*/
  struct dpb far*next;	/* Pointer to next DPB				*/
  unsigned	 alloc, /* Cluster at which to start search for free	*/
		 free;	/* Number of free clusters, FFFFh = unknown	*/
}dpb;

struct dir_entry{
  char		name[8],ext[3],attrib,reserved[10];
  unsigned	time,date,cluster;
  unsigned long size;
};

struct longname{
  char	   flags;
  unsigned name1[5];
  char	   attrib,reserved,checksum;
  unsigned name2[6],cluster,name3[2];
};
/* Common variables
 */
extern struct COUNTRY countryinfo;
#pragma option -a
extern const struct dir_entry far*dir;
extern unsigned flags;
extern int nc;
extern char*cand,*pathterm,*sortopt,truename[128],drive,attrib,mask;
extern const char cantfind[];
/*
 * Bit-assignments for the flags variable
 */
#define DOCONLY	   1
#define YEAR4	   2
#define DIGIT3	   4
#define FQ	   8
#define TWOFIELDS 16
#define LFN	  32
#define NEC	  64
#define JAPANESE 128
#define EA	 256
#define L	 512
#define N	1024
#define IGNSUM	2048
#define OS2    16384

#define DEFAULT_FLAGS YEAR4
/*
 * Function prototypes
 */
void far*farfix(void far*,unsigned long),makepattern(char*),error(const char*);
void showmem(const char*,void far*),tracedir(int,char*),getdpb(char*,char*);
void putucode(unsigned code),showlist(int);
int farabsread(unsigned long,unsigned,void far*),loaddir(unsigned);
int cmp4sort(const void*,const void*);
