/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.debug;

import com.fx702p.emulator.Fx702pConstants;
import com.fx702p.emulator.Fx702pMemory;
import com.fx702p.emulator.Variable;
import com.fx702p.parser.ASTDollar;
import com.fx702p.parser.ASTIndexedVariable;
import com.fx702p.parser.ASTInteger;
import com.fx702p.parser.ASTVariable;
import com.fx702p.parser.Node;
import com.fx702p.parser.SimpleNode;

public class WatchedVariableHelper {
    public static String getAlias(Node aNode) {
        if (aNode instanceof ASTDollar) {
            return "$";
        }
        if (aNode instanceof ASTVariable) {
            if (aNode.jjtGetNumChildren() == 0) {
                return ((ASTVariable)aNode).name;
            }
            String indexes = WatchedVariableHelper.getArrayIndexes(aNode);
            if (indexes == null) {
                return null;
            }
            return ((ASTVariable)aNode).name + indexes;
        }
        if (aNode instanceof ASTIndexedVariable) {
            return ((ASTIndexedVariable)aNode).name;
        }
        return null;
    }

    protected static String getArrayIndexes(Node aNode) {
        String name = ((ASTVariable)aNode).name;
        if (!name.equals("A")) {
            return null;
        }
        if (aNode.jjtGetNumChildren() == 1) {
            SimpleNode expression = (SimpleNode)aNode.jjtGetChild(0);
            if (!(expression instanceof ASTInteger)) {
                return null;
            }
            int index = ((ASTInteger)expression).value.intValue();
            if (index < 0 || index >= 200) {
                return null;
            }
            return "(" + index + ")";
        }
        if (aNode.jjtGetNumChildren() == 2) {
            SimpleNode expression1 = (SimpleNode)aNode.jjtGetChild(0);
            if (!(expression1 instanceof ASTInteger)) {
                return null;
            }
            int index1 = ((ASTInteger)expression1).value.intValue();
            SimpleNode expression2 = (SimpleNode)aNode.jjtGetChild(1);
            if (!(expression2 instanceof ASTInteger)) {
                return null;
            }
            int index2 = ((ASTInteger)expression2).value.intValue();
            return "(" + index1 + "," + index2 + ")";
        }
        return null;
    }

    public static Variable getVariable(Node aNode, Fx702pMemory aMemory) {
        if (aNode instanceof ASTDollar) {
            return aMemory.getDollarVariable();
        }
        if (aNode instanceof ASTVariable) {
            if (aNode.jjtGetNumChildren() == 0) {
                return WatchedVariableHelper.getNormalVariable(aNode, aMemory);
            }
            return WatchedVariableHelper.getArrayVariable(aNode, aMemory);
        }
        if (aNode instanceof ASTIndexedVariable) {
            return WatchedVariableHelper.getIndexedVariable(aNode, aMemory);
        }
        return null;
    }

    protected static Variable getNormalVariable(Node aNode, Fx702pMemory aMemory) {
        String name = ((ASTVariable)aNode).name;
        if (name.length() != 1) {
            return null;
        }
        int index = Character.getNumericValue(name.charAt(0)) - Fx702pConstants.FIRST_VARIABLE_CHARACTER_NUMERIC_VALUE;
        return aMemory.getVariable(index);
    }

    protected static Variable getIndexedVariable(Node aNode, Fx702pMemory aMemory) {
        String name = ((ASTIndexedVariable)aNode).name;
        if (name.length() != 2) {
            return null;
        }
        int index1 = Character.getNumericValue(name.charAt(0)) - Fx702pConstants.FIRST_VARIABLE_CHARACTER_NUMERIC_VALUE;
        int index2 = Character.digit(name.charAt(1), 10);
        int index = index1 * 10 + index2;
        return aMemory.getArrayVariable(index);
    }

    protected static Variable getArrayVariable(Node aNode, Fx702pMemory aMemory) {
        int index;
        String name = ((ASTVariable)aNode).name;
        if (!name.equals("A")) {
            return null;
        }
        if (aNode.jjtGetNumChildren() == 1) {
            SimpleNode expression = (SimpleNode)aNode.jjtGetChild(0);
            if (!(expression instanceof ASTInteger)) {
                return null;
            }
            index = ((ASTInteger)expression).value.intValue();
            if (index < 0 || index >= 200) {
                return null;
            }
        } else if (aNode.jjtGetNumChildren() == 2) {
            SimpleNode expression1 = (SimpleNode)aNode.jjtGetChild(0);
            if (!(expression1 instanceof ASTInteger)) {
                return null;
            }
            int index1 = ((ASTInteger)expression1).value.intValue();
            SimpleNode expression2 = (SimpleNode)aNode.jjtGetChild(1);
            if (!(expression2 instanceof ASTInteger)) {
                return null;
            }
            int index2 = ((ASTInteger)expression2).value.intValue();
            index = index1 * 10 + index2;
        } else {
            return null;
        }
        return aMemory.getArrayVariable(index);
    }
}

