/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.interpreters;

import com.fx702p.interpreters.NormalFormatter;
import com.fx702p.interpreters.formatters.Fx702pDecimalFormat;
import java.math.BigDecimal;

public class FixedFormatter
extends NormalFormatter {
    protected int precision;
    public static final String[] NO_EXPONENT_FIXED_FORMATS = new String[]{"#.000000000000", "#.00000000000", "#.0000000000", "#.000000000", "#.00000000", "##.0000000", "###.000000", "####.00000", "#####.0000", "######.000", "#######.00", "########.0", "#########"};

    public FixedFormatter(int aPrecision) {
        this.precision = aPrecision;
    }

    protected Fx702pDecimalFormat getDecimalFormat(BigDecimal aNumber) {
        Fx702pDecimalFormat decimalFormat;
        if (Math.abs(aNumber.doubleValue()) >= 1.0E10) {
            decimalFormat = new Fx702pDecimalFormat(this.getExponentFormat());
        } else {
            int magnitude = (int)Math.floor(Math.log10(Math.abs(aNumber.doubleValue()))) + 3;
            magnitude = Math.min(this.getNoExponentFormats().length - 1, Math.max(0, magnitude));
            String format = this.getNoExponentFormats()[magnitude];
            int dotIndex = format.indexOf(46);
            int length = Math.min(format.length(), dotIndex + this.precision + 1);
            decimalFormat = new Fx702pDecimalFormat(format.substring(0, length));
        }
        this.prepareDecimalFormat(decimalFormat);
        return decimalFormat;
    }

    protected String[] getNoExponentFormats() {
        return NO_EXPONENT_FIXED_FORMATS;
    }
}

