/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.interpreters;

import com.fx702p.emulator.Fx702pConstants;
import com.fx702p.emulator.Fx702pEmulator;
import com.fx702p.emulator.Variable;
import com.fx702p.emulator.exceptions.Fx702pErr2Exception;
import com.fx702p.emulator.exceptions.Fx702pErr3Exception;
import com.fx702p.emulator.exceptions.Fx702pErr5Exception;
import com.fx702p.interpreters.End;
import com.fx702p.interpreters.FixedFormatter;
import com.fx702p.interpreters.Fx702pAbstractInterpreter;
import com.fx702p.interpreters.Fx702pException;
import com.fx702p.interpreters.Fx702pInternalError;
import com.fx702p.interpreters.ScientificFormatter;
import com.fx702p.parser.ASTAbs;
import com.fx702p.parser.ASTAddition;
import com.fx702p.parser.ASTArcCos;
import com.fx702p.parser.ASTArcHyperbolicCos;
import com.fx702p.parser.ASTArcHyperbolicSin;
import com.fx702p.parser.ASTArcHyperbolicTan;
import com.fx702p.parser.ASTArcSin;
import com.fx702p.parser.ASTArcTan;
import com.fx702p.parser.ASTAssignment;
import com.fx702p.parser.ASTBreakpoint;
import com.fx702p.parser.ASTClear;
import com.fx702p.parser.ASTClosedSubExpression;
import com.fx702p.parser.ASTCnt;
import com.fx702p.parser.ASTCommand;
import com.fx702p.parser.ASTCommandArguments;
import com.fx702p.parser.ASTCommandWithParenthesisArguments;
import com.fx702p.parser.ASTCor;
import com.fx702p.parser.ASTCos;
import com.fx702p.parser.ASTDMS;
import com.fx702p.parser.ASTDeg;
import com.fx702p.parser.ASTDel;
import com.fx702p.parser.ASTDivision;
import com.fx702p.parser.ASTDollar;
import com.fx702p.parser.ASTEnd;
import com.fx702p.parser.ASTEox;
import com.fx702p.parser.ASTEoy;
import com.fx702p.parser.ASTExp;
import com.fx702p.parser.ASTFactorial;
import com.fx702p.parser.ASTFloat;
import com.fx702p.parser.ASTFrac;
import com.fx702p.parser.ASTFunctionArguments;
import com.fx702p.parser.ASTFunctionCall;
import com.fx702p.parser.ASTFunctionWithParenthesisArguments;
import com.fx702p.parser.ASTHyperbolicCos;
import com.fx702p.parser.ASTHyperbolicSin;
import com.fx702p.parser.ASTHyperbolicTan;
import com.fx702p.parser.ASTIndexedVariable;
import com.fx702p.parser.ASTInt;
import com.fx702p.parser.ASTInteger;
import com.fx702p.parser.ASTKey;
import com.fx702p.parser.ASTLength;
import com.fx702p.parser.ASTLn;
import com.fx702p.parser.ASTLog;
import com.fx702p.parser.ASTLra;
import com.fx702p.parser.ASTLrb;
import com.fx702p.parser.ASTMid;
import com.fx702p.parser.ASTMultiplePrograms;
import com.fx702p.parser.ASTMultiplication;
import com.fx702p.parser.ASTMx;
import com.fx702p.parser.ASTMy;
import com.fx702p.parser.ASTOpenSubExpression;
import com.fx702p.parser.ASTPRC;
import com.fx702p.parser.ASTPi;
import com.fx702p.parser.ASTPower;
import com.fx702p.parser.ASTProgramSignature;
import com.fx702p.parser.ASTProgramsFile;
import com.fx702p.parser.ASTRPC;
import com.fx702p.parser.ASTRandom;
import com.fx702p.parser.ASTRound;
import com.fx702p.parser.ASTSac;
import com.fx702p.parser.ASTSavedDefm;
import com.fx702p.parser.ASTSdx;
import com.fx702p.parser.ASTSdxn;
import com.fx702p.parser.ASTSdy;
import com.fx702p.parser.ASTSdyn;
import com.fx702p.parser.ASTSet;
import com.fx702p.parser.ASTSign;
import com.fx702p.parser.ASTSin;
import com.fx702p.parser.ASTSingleProgram;
import com.fx702p.parser.ASTSqrt;
import com.fx702p.parser.ASTStat;
import com.fx702p.parser.ASTStatWatchpoint;
import com.fx702p.parser.ASTStop;
import com.fx702p.parser.ASTString;
import com.fx702p.parser.ASTSubstraction;
import com.fx702p.parser.ASTSx;
import com.fx702p.parser.ASTSx2;
import com.fx702p.parser.ASTSxy;
import com.fx702p.parser.ASTSy;
import com.fx702p.parser.ASTSy2;
import com.fx702p.parser.ASTTan;
import com.fx702p.parser.ASTUnaryMinus;
import com.fx702p.parser.ASTVac;
import com.fx702p.parser.ASTVariable;
import com.fx702p.parser.ASTVariablesAndProgram;
import com.fx702p.parser.ASTWatch;
import com.fx702p.parser.ASTWatchpoint;
import com.fx702p.parser.Fx702pParserVisitor;
import com.fx702p.parser.Node;
import com.fx702p.parser.SimpleNode;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Locale;

public abstract class Fx702pAbstractCalculator
extends Fx702pAbstractInterpreter
implements Fx702pParserVisitor {
    public Fx702pAbstractCalculator(Fx702pEmulator anEmulator) {
        super(anEmulator);
    }

    public void lastAnswer() {
        String formattedAnswer = Fx702pConstants.NORMAL_FORMATTER.format(this.getMemory().getLastResult());
        this.startEnteringString(formattedAnswer);
    }

    protected void setResult(BigDecimal aResult) {
        this.getMemory().setLastResult(aResult);
    }

    protected BigDecimal toBigDecimal(Object aValue) {
        if (aValue instanceof BigDecimal) {
            return (BigDecimal)aValue;
        }
        throw new Fx702pErr2Exception(this);
    }

    protected String formatNumber(BigDecimal aNumber) {
        this.getMemory().getFormatter().setRoundingMode(this.getMemory().getRoundingMode());
        return this.getMemory().getFormatter().format(aNumber);
    }

    protected boolean isInteger(BigDecimal aNumber) {
        return aNumber.scale() >= 0;
    }

    protected int toInteger(BigDecimal aNumber) {
        return aNumber.intValue();
    }

    protected Variable getVariable(Node aNode) {
        if (aNode instanceof ASTDollar) {
            return this.getMemory().getDollarVariable();
        }
        if (aNode instanceof ASTVariable) {
            if (aNode.jjtGetNumChildren() == 0) {
                return this.getNormalVariable(aNode);
            }
            return this.getArrayVariable(aNode);
        }
        if (aNode instanceof ASTIndexedVariable) {
            return this.getIndexedVariable(aNode);
        }
        throw new Fx702pInternalError("Invalid variable type: " + aNode.getClass().getName());
    }

    protected Variable getNormalVariable(Node aNode) {
        String name = ((ASTVariable)aNode).name;
        if (name.length() != 1) {
            throw new Fx702pInternalError("Invalid variable name:" + name);
        }
        int index = Character.getNumericValue(name.charAt(0)) - Fx702pConstants.FIRST_VARIABLE_CHARACTER_NUMERIC_VALUE;
        if (((ASTVariable)aNode).isString) {
            return this.getMemory().getVariable(index).getStringVariable();
        }
        return this.getMemory().getVariable(index).getNumberVariable();
    }

    protected Variable getIndexedVariable(Node aNode) {
        String name = ((ASTIndexedVariable)aNode).name;
        if (name.length() != 2) {
            throw new Fx702pInternalError("Invalid variable name:" + name);
        }
        int index1 = Character.getNumericValue(name.charAt(0)) - Fx702pConstants.FIRST_VARIABLE_CHARACTER_NUMERIC_VALUE;
        int index2 = Character.digit(name.charAt(1), 10);
        int index = index1 * 10 + index2;
        if (((ASTIndexedVariable)aNode).isString) {
            return this.getMemory().getArrayVariable(index).getStringVariable();
        }
        return this.getMemory().getArrayVariable(index).getNumberVariable();
    }

    protected int getArrayIndex(Object aValue) {
        if (aValue instanceof BigDecimal) {
            return ((BigDecimal)aValue).intValue();
        }
        throw new Fx702pErr2Exception(this);
    }

    protected Variable getArrayVariable(Node aNode) {
        int index;
        String name = ((ASTVariable)aNode).name;
        if (!name.equals("A")) {
            throw new Fx702pInternalError("Invalid array name:" + name);
        }
        if (aNode.jjtGetNumChildren() == 1) {
            SimpleNode expression = (SimpleNode)aNode.jjtGetChild(0);
            Object value = expression.jjtAccept(this, null);
            index = this.getArrayIndex(value);
            if (index < 0 || index >= 200) {
                throw new Fx702pErr5Exception(this);
            }
        } else if (aNode.jjtGetNumChildren() == 2) {
            SimpleNode expression1 = (SimpleNode)aNode.jjtGetChild(0);
            Object value1 = expression1.jjtAccept(this, null);
            int index1 = this.getArrayIndex(value1);
            if (index1 < 0 || index1 >= 20) {
                throw new Fx702pErr5Exception(this);
            }
            SimpleNode expression2 = (SimpleNode)aNode.jjtGetChild(1);
            Object value2 = expression2.jjtAccept(this, null);
            int index2 = this.getArrayIndex(value2);
            if (index2 < 0 || index2 >= 10) {
                throw new Fx702pErr5Exception(this);
            }
            index = index1 * 10 + index2;
        } else {
            throw new Fx702pInternalError("Too many children for an array: " + aNode.jjtGetNumChildren());
        }
        if (((ASTVariable)aNode).isString) {
            return this.getMemory().getArrayVariable(index).getStringVariable();
        }
        return this.getMemory().getArrayVariable(index).getNumberVariable();
    }

    public Object visit(ASTAssignment aNode, Object aData) {
        SimpleNode expression = (SimpleNode)aNode.jjtGetChild(1);
        Object value = expression.jjtAccept(this, aData);
        this.getVariable(aNode.jjtGetChild(0)).setValue(value);
        return null;
    }

    public Object visit(ASTAddition aNode, Object aData) {
        Object left = aNode.jjtGetChild(0).jjtAccept(this, aData);
        Object right = aNode.jjtGetChild(1).jjtAccept(this, aData);
        if (left instanceof BigDecimal && right instanceof BigDecimal) {
            return ((BigDecimal)left).add((BigDecimal)right);
        }
        if (left instanceof String && right instanceof String) {
            return (String)left + (String)right;
        }
        throw new Fx702pErr2Exception(this);
    }

    public Object visit(ASTSubstraction aNode, Object aData) {
        Object left = aNode.jjtGetChild(0).jjtAccept(this, aData);
        Object right = aNode.jjtGetChild(1).jjtAccept(this, aData);
        if (left instanceof BigDecimal && right instanceof BigDecimal) {
            return ((BigDecimal)left).subtract((BigDecimal)right);
        }
        throw new Fx702pErr2Exception(this);
    }

    public Object visit(ASTMultiplication aNode, Object aData) {
        Object left = aNode.jjtGetChild(0).jjtAccept(this, aData);
        Object right = aNode.jjtGetChild(1).jjtAccept(this, aData);
        if (left instanceof BigDecimal && right instanceof BigDecimal) {
            return ((BigDecimal)left).multiply((BigDecimal)right);
        }
        throw new Fx702pErr2Exception(this);
    }

    public Object visit(ASTDivision aNode, Object aData) {
        Object left = aNode.jjtGetChild(0).jjtAccept(this, aData);
        Object right = aNode.jjtGetChild(1).jjtAccept(this, aData);
        if (left instanceof BigDecimal && right instanceof BigDecimal) {
            return ((BigDecimal)left).divide((BigDecimal)right, Fx702pConstants.MATH_CONTEXT);
        }
        throw new Fx702pErr2Exception(this);
    }

    public Object visit(ASTUnaryMinus aNode, Object aData) {
        Object child = aNode.jjtGetChild(0).jjtAccept(this, aData);
        if (child instanceof BigDecimal) {
            return ((BigDecimal)child).negate();
        }
        throw new Fx702pErr2Exception(this);
    }

    public Object visit(ASTPower aNode, Object aData) {
        Object left = aNode.jjtGetChild(0).jjtAccept(this, aData);
        Object right = aNode.jjtGetChild(1).jjtAccept(this, aData);
        if (left instanceof BigDecimal && right instanceof BigDecimal) {
            return new BigDecimal(Math.pow(((BigDecimal)left).doubleValue(), ((BigDecimal)right).doubleValue()));
        }
        throw new Fx702pErr2Exception(this);
    }

    public Object visit(ASTFactorial aNode, Object aData) {
        BigDecimal d = this.toBigDecimal(aNode.jjtGetChild(0).jjtAccept(this, aData));
        if (this.isInteger(d)) {
            int n = this.toInteger(d);
            if (n < 0 || n > 69) {
                throw new Fx702pErr3Exception(this);
            }
            BigDecimal f = BigDecimal.ONE;
            for (int i = 1; i <= n; ++i) {
                f = f.multiply(new BigDecimal(i));
            }
            return f;
        }
        throw new Fx702pErr3Exception(this);
    }

    public Object visit(ASTFunctionCall aNode, Object aData) {
        Node function = aNode.jjtGetChild(0);
        if (aNode.jjtGetNumChildren() == 2 && aNode.jjtGetChild(1).jjtGetNumChildren() > 0) {
            Node functionArguments = aNode.jjtGetChild(1);
            Object[] arguments = new Object[functionArguments.jjtGetNumChildren()];
            int last = functionArguments.jjtGetNumChildren();
            for (int i = 0; i < last; ++i) {
                arguments[i] = functionArguments.jjtGetChild(i).jjtAccept(this, aData);
            }
            return function.jjtAccept(this, arguments);
        }
        return function.jjtAccept(this, new Object[0]);
    }

    protected void checkFunctionArguments(Object[] theArguments, Class ... theClasses) {
        if (theArguments.length != theClasses.length) {
            throw new Fx702pErr2Exception(this);
        }
        int last = theArguments.length;
        for (int i = 0; i < last; ++i) {
            if (theClasses[i].isAssignableFrom(theArguments[i].getClass())) continue;
            throw new Fx702pErr2Exception(this);
        }
    }

    public Object visit(ASTRandom aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, new Class[0]);
        return new BigDecimal(Math.random());
    }

    public Object visit(ASTCnt aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, new Class[0]);
        return this.getMemory().getStatCounter();
    }

    public Object visit(ASTSdx aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, new Class[0]);
        if (this.getMemory().getStatCounter().intValue() <= 1) {
            throw new Fx702pErr3Exception(this);
        }
        return new BigDecimal(Math.sqrt(this.getMemory().getSumX2().subtract(this.getMemory().getSumX().multiply(this.getMemory().getSumX()).divide(this.getMemory().getStatCounter(), Fx702pConstants.MATH_CONTEXT)).divide(this.getMemory().getStatCounter().subtract(BigDecimal.ONE), Fx702pConstants.MATH_CONTEXT).doubleValue()));
    }

    public Object visit(ASTSdy aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, new Class[0]);
        if (this.getMemory().getStatCounter().intValue() <= 1) {
            throw new Fx702pErr3Exception(this);
        }
        return new BigDecimal(Math.sqrt(this.getMemory().getStatCounter().multiply(this.getMemory().getSumY2()).subtract(this.getMemory().getSumY().multiply(this.getMemory().getSumY())).multiply(this.getMemory().getStatCounter()).divide(this.getMemory().getStatCounter().subtract(BigDecimal.ONE), Fx702pConstants.MATH_CONTEXT).doubleValue() / (double)this.getMemory().getStatCounter().intValue()));
    }

    public Object visit(ASTSdxn aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, new Class[0]);
        if (this.getMemory().getStatCounter().compareTo(BigDecimal.ZERO) == 0) {
            throw new Fx702pErr3Exception(this);
        }
        return new BigDecimal(Math.sqrt(this.getMemory().getStatCounter().multiply(this.getMemory().getSumX2()).subtract(this.getMemory().getSumX().multiply(this.getMemory().getSumX())).doubleValue()) / (double)this.getMemory().getStatCounter().intValue());
    }

    public Object visit(ASTSdyn aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, new Class[0]);
        if (this.getMemory().getStatCounter().compareTo(BigDecimal.ZERO) == 0) {
            throw new Fx702pErr3Exception(this);
        }
        return new BigDecimal(Math.sqrt(this.getMemory().getStatCounter().multiply(this.getMemory().getSumY2()).subtract(this.getMemory().getSumY().multiply(this.getMemory().getSumY())).doubleValue()) / (double)this.getMemory().getStatCounter().intValue());
    }

    public Object visit(ASTMx aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, new Class[0]);
        if (this.getMemory().getStatCounter().compareTo(BigDecimal.ZERO) == 0) {
            throw new Fx702pErr3Exception(this);
        }
        return this.getMemory().getSumX().divide(this.getMemory().getStatCounter(), Fx702pConstants.MATH_CONTEXT);
    }

    public Object visit(ASTMy aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, new Class[0]);
        if (this.getMemory().getStatCounter().compareTo(BigDecimal.ZERO) == 0) {
            throw new Fx702pErr3Exception(this);
        }
        return this.getMemory().getSumY().divide(this.getMemory().getStatCounter(), Fx702pConstants.MATH_CONTEXT);
    }

    public Object visit(ASTSx aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, new Class[0]);
        if (this.getMemory().getStatCounter().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return this.getMemory().getSumX();
    }

    public Object visit(ASTSy aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, new Class[0]);
        if (this.getMemory().getStatCounter().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return this.getMemory().getSumY();
    }

    public Object visit(ASTSx2 aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, new Class[0]);
        if (this.getMemory().getStatCounter().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return this.getMemory().getSumX2();
    }

    public Object visit(ASTSy2 aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, new Class[0]);
        if (this.getMemory().getStatCounter().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return this.getMemory().getSumY2();
    }

    public Object visit(ASTSxy aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, new Class[0]);
        if (this.getMemory().getStatCounter().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return this.getMemory().getSumXY();
    }

    public Object visit(ASTLra aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, new Class[0]);
        if (this.getMemory().getStatCounter().intValue() <= 1) {
            throw new Fx702pErr3Exception(this);
        }
        BigDecimal b = this.getMemory().getStatCounter().multiply(this.getMemory().getSumXY()).subtract(this.getMemory().getSumX().multiply(this.getMemory().getSumY())).divide(this.getMemory().getStatCounter().multiply(this.getMemory().getSumX2()).subtract(this.getMemory().getSumX().multiply(this.getMemory().getSumX())), Fx702pConstants.MATH_CONTEXT);
        return this.getMemory().getSumY().subtract(b.multiply(this.getMemory().getSumX())).divide(this.getMemory().getStatCounter(), Fx702pConstants.MATH_CONTEXT);
    }

    public Object visit(ASTLrb aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, new Class[0]);
        if (this.getMemory().getStatCounter().intValue() <= 1) {
            throw new Fx702pErr3Exception(this);
        }
        return this.getMemory().getStatCounter().multiply(this.getMemory().getSumXY()).subtract(this.getMemory().getSumX().multiply(this.getMemory().getSumY())).divide(this.getMemory().getStatCounter().multiply(this.getMemory().getSumX2()).subtract(this.getMemory().getSumX().multiply(this.getMemory().getSumX())), Fx702pConstants.MATH_CONTEXT);
    }

    public Object visit(ASTCor aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, new Class[0]);
        if (this.getMemory().getStatCounter().intValue() <= 1) {
            throw new Fx702pErr3Exception(this);
        }
        return this.getMemory().getStatCounter().multiply(this.getMemory().getSumXY()).subtract(this.getMemory().getSumX().multiply(this.getMemory().getSumY())).divide(new BigDecimal(Math.sqrt(this.getMemory().getStatCounter().multiply(this.getMemory().getSumX2()).subtract(this.getMemory().getSumX().multiply(this.getMemory().getSumX())).multiply(this.getMemory().getStatCounter().multiply(this.getMemory().getSumY2()).subtract(this.getMemory().getSumY().multiply(this.getMemory().getSumY())), Fx702pConstants.MATH_CONTEXT).doubleValue())));
    }

    public Object visit(ASTEox aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, BigDecimal.class);
        if (this.getMemory().getStatCounter().intValue() <= 1) {
            throw new Fx702pErr3Exception(this);
        }
        BigDecimal value = (BigDecimal)((Object[])aData)[0];
        BigDecimal b = this.getMemory().getStatCounter().multiply(this.getMemory().getSumXY()).subtract(this.getMemory().getSumX().multiply(this.getMemory().getSumY())).divide(this.getMemory().getStatCounter().multiply(this.getMemory().getSumX2()).subtract(this.getMemory().getSumX().multiply(this.getMemory().getSumX())), Fx702pConstants.MATH_CONTEXT);
        if (b.compareTo(BigDecimal.ZERO) == 0) {
            throw new Fx702pErr3Exception(this);
        }
        BigDecimal a = this.getMemory().getSumY().subtract(b.multiply(this.getMemory().getSumX())).divide(this.getMemory().getStatCounter(), Fx702pConstants.MATH_CONTEXT);
        return value.subtract(a).divide(b, Fx702pConstants.MATH_CONTEXT);
    }

    public Object visit(ASTEoy aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, BigDecimal.class);
        if (this.getMemory().getStatCounter().intValue() <= 1) {
            throw new Fx702pErr3Exception(this);
        }
        BigDecimal value = (BigDecimal)((Object[])aData)[0];
        BigDecimal b = this.getMemory().getStatCounter().multiply(this.getMemory().getSumXY()).subtract(this.getMemory().getSumX().multiply(this.getMemory().getSumY())).divide(this.getMemory().getStatCounter().multiply(this.getMemory().getSumX2()).subtract(this.getMemory().getSumX().multiply(this.getMemory().getSumX())), Fx702pConstants.MATH_CONTEXT);
        BigDecimal a = this.getMemory().getSumY().subtract(b.multiply(this.getMemory().getSumX())).divide(this.getMemory().getStatCounter(), Fx702pConstants.MATH_CONTEXT);
        return b.multiply(value).add(a);
    }

    public Object visit(ASTKey aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, new Class[0]);
        Character key = this.getKey();
        if (key == null) {
            return "";
        }
        return "" + key;
    }

    public Object visit(ASTSin aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, BigDecimal.class);
        BigDecimal value = (BigDecimal)((Object[])aData)[0];
        if (Math.abs(value.doubleValue()) >= this.getMemory().getTrigonometricMaxArgument()) {
            throw new Fx702pErr3Exception(this);
        }
        return new BigDecimal(Math.sin(value.doubleValue() * this.getMemory().getTrigonometricConversionFactor()));
    }

    public Object visit(ASTCos aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, BigDecimal.class);
        BigDecimal value = (BigDecimal)((Object[])aData)[0];
        if (Math.abs(value.doubleValue()) >= this.getMemory().getTrigonometricMaxArgument()) {
            throw new Fx702pErr3Exception(this);
        }
        return new BigDecimal(Math.cos(value.doubleValue() * this.getMemory().getTrigonometricConversionFactor()));
    }

    public Object visit(ASTTan aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, BigDecimal.class);
        BigDecimal value = (BigDecimal)((Object[])aData)[0];
        if (Math.abs(value.doubleValue()) >= this.getMemory().getTrigonometricMaxArgument()) {
            throw new Fx702pErr3Exception(this);
        }
        return new BigDecimal(Math.tan(value.doubleValue() * this.getMemory().getTrigonometricConversionFactor()));
    }

    public Object visit(ASTArcSin aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, BigDecimal.class);
        BigDecimal value = (BigDecimal)((Object[])aData)[0];
        if (Math.abs(value.doubleValue()) > 1.0) {
            throw new Fx702pErr3Exception(this);
        }
        return new BigDecimal(Math.asin(value.doubleValue()) / this.getMemory().getTrigonometricConversionFactor());
    }

    public Object visit(ASTArcCos aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, BigDecimal.class);
        BigDecimal value = (BigDecimal)((Object[])aData)[0];
        if (Math.abs(value.doubleValue()) > 1.0) {
            throw new Fx702pErr3Exception(this);
        }
        return new BigDecimal(Math.acos(value.doubleValue()) / this.getMemory().getTrigonometricConversionFactor());
    }

    public Object visit(ASTArcTan aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, BigDecimal.class);
        BigDecimal value = (BigDecimal)((Object[])aData)[0];
        return new BigDecimal(Math.atan(value.doubleValue()) / this.getMemory().getTrigonometricConversionFactor());
    }

    public Object visit(ASTHyperbolicSin aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, BigDecimal.class);
        BigDecimal value = (BigDecimal)((Object[])aData)[0];
        if (Math.abs(value.doubleValue()) > 230.0) {
            throw new Fx702pErr3Exception(this);
        }
        return new BigDecimal(Math.sinh(value.doubleValue()));
    }

    public Object visit(ASTHyperbolicCos aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, BigDecimal.class);
        BigDecimal value = (BigDecimal)((Object[])aData)[0];
        if (Math.abs(value.doubleValue()) > 230.0) {
            throw new Fx702pErr3Exception(this);
        }
        return new BigDecimal(Math.cosh(value.doubleValue()));
    }

    public Object visit(ASTHyperbolicTan aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, BigDecimal.class);
        BigDecimal value = (BigDecimal)((Object[])aData)[0];
        return new BigDecimal(Math.tanh(value.doubleValue()));
    }

    public Object visit(ASTArcHyperbolicSin aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, BigDecimal.class);
        BigDecimal value = (BigDecimal)((Object[])aData)[0];
        double d = value.doubleValue();
        return new BigDecimal(Math.log(d + Math.sqrt(d * d + 1.0)));
    }

    public Object visit(ASTArcHyperbolicCos aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, BigDecimal.class);
        BigDecimal value = (BigDecimal)((Object[])aData)[0];
        double d = value.doubleValue();
        if (d < 1.0) {
            throw new Fx702pErr3Exception(this);
        }
        return new BigDecimal(Math.log(d + Math.sqrt(d * d - 1.0)));
    }

    public Object visit(ASTArcHyperbolicTan aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, BigDecimal.class);
        BigDecimal value = (BigDecimal)((Object[])aData)[0];
        double d = value.doubleValue();
        if (Math.abs(d) >= 1.0) {
            throw new Fx702pErr3Exception(this);
        }
        return new BigDecimal(Math.log((1.0 + d) / (1.0 - d)) / 2.0);
    }

    public Object visit(ASTSqrt aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, BigDecimal.class);
        BigDecimal value = (BigDecimal)((Object[])aData)[0];
        double d = value.doubleValue();
        if (d < 0.0) {
            throw new Fx702pErr3Exception(this);
        }
        return new BigDecimal(Math.sqrt(d));
    }

    public Object visit(ASTExp aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, BigDecimal.class);
        BigDecimal value = (BigDecimal)((Object[])aData)[0];
        double d = value.doubleValue();
        if (Math.abs(d) > 230.0) {
            throw new Fx702pErr3Exception(this);
        }
        return new BigDecimal(Math.exp(d));
    }

    public Object visit(ASTLn aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, BigDecimal.class);
        BigDecimal value = (BigDecimal)((Object[])aData)[0];
        double d = value.doubleValue();
        if (d < 0.0) {
            throw new Fx702pErr3Exception(this);
        }
        return new BigDecimal(Math.log(d));
    }

    public Object visit(ASTLog aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, BigDecimal.class);
        BigDecimal value = (BigDecimal)((Object[])aData)[0];
        double d = value.doubleValue();
        if (d < 0.0) {
            throw new Fx702pErr3Exception(this);
        }
        return new BigDecimal(Math.log10(d));
    }

    protected BigDecimal integerPart(BigDecimal aNumber) {
        return new BigDecimal(aNumber.toBigInteger());
    }

    protected BigDecimal fractionalPart(BigDecimal aNumber) {
        return aNumber.subtract(this.integerPart(aNumber));
    }

    public Object visit(ASTInt aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, BigDecimal.class);
        BigDecimal value = (BigDecimal)((Object[])aData)[0];
        return this.integerPart(value);
    }

    public Object visit(ASTFrac aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, BigDecimal.class);
        BigDecimal value = (BigDecimal)((Object[])aData)[0];
        return this.fractionalPart(value);
    }

    public Object visit(ASTAbs aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, BigDecimal.class);
        BigDecimal value = (BigDecimal)((Object[])aData)[0];
        return value.abs();
    }

    public Object visit(ASTSign aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, BigDecimal.class);
        BigDecimal value = (BigDecimal)((Object[])aData)[0];
        if (value.compareTo(BigDecimal.ZERO) == 0) {
            return 0;
        }
        if (value.doubleValue() > 0.0) {
            return 1;
        }
        return -1;
    }

    public Object visit(ASTDMS aNode, Object aData) {
        this.checkCommandArguments(1, aData);
        Object value = ((Node)aData).jjtGetChild(0).jjtAccept(this, null);
        if (value instanceof BigDecimal) {
            BigDecimal dms = (BigDecimal)value;
            if (Math.abs(dms.doubleValue()) >= 100000.0) {
                return new DMSResult(this.formatNumber(dms), dms);
            }
            BigDecimal fracDms = this.fractionalPart(dms);
            int degrees = this.integerPart(dms).intValue();
            int minutes = this.integerPart(fracDms.multiply(Fx702pConstants.SIXTY)).intValue();
            BigDecimal seconds = this.fractionalPart(fracDms.multiply(Fx702pConstants.SIXTY)).multiply(Fx702pConstants.SIXTY);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            printStream.printf(Locale.US, " %do%d'%.2f\"", degrees, minutes, seconds);
            return new DMSResult(byteArrayOutputStream.toString(), dms);
        }
        throw new Fx702pErr2Exception();
    }

    public Object visit(ASTLength aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, String.class);
        return new BigDecimal(((String)((Object[])aData)[0]).length());
    }

    public Object visit(ASTMid aNode, Object aData) {
        if (aData instanceof Object[]) {
            Object[] arguments = (Object[])aData;
            if (arguments.length == 1) {
                Object value = arguments[0];
                if (value instanceof BigDecimal) {
                    int start = ((BigDecimal)value).intValue();
                    if (start > ((String)this.getMemory().getDollarVariable().getValue()).length() || start < 1) {
                        throw new Fx702pErr5Exception(this);
                    }
                    return ((String)this.getMemory().getDollarVariable().getValue()).substring(start - 1);
                }
                throw new Fx702pErr2Exception();
            }
            if (arguments.length == 2) {
                Object value1 = arguments[0];
                Object value2 = arguments[1];
                if (value1 instanceof BigDecimal && value2 instanceof BigDecimal) {
                    int length;
                    int start = ((BigDecimal)value1).intValue();
                    if (start + (length = ((BigDecimal)value2).intValue()) - 1 > ((String)this.getMemory().getDollarVariable().getValue()).length() || start < 1 || length <= 0) {
                        throw new Fx702pErr5Exception(this);
                    }
                    return ((String)this.getMemory().getDollarVariable().getValue()).substring(start - 1, start - 1 + length);
                }
                throw new Fx702pErr2Exception();
            }
            throw new Fx702pErr2Exception();
        }
        throw new Fx702pInternalError("Data should be a Object[]");
    }

    public Object visit(ASTRound aNode, Object aData) {
        this.checkFunctionArguments((Object[])aData, BigDecimal.class, BigDecimal.class);
        BigDecimal value = (BigDecimal)((Object[])aData)[0];
        BigDecimal round = (BigDecimal)((Object[])aData)[1];
        int factorExponent = round.intValue() + 1;
        BigDecimal factor = null;
        factor = factorExponent >= 0 ? BigDecimal.TEN.pow(factorExponent) : BigDecimal.ONE.divide(BigDecimal.TEN.pow(-factorExponent));
        value = value.divide(factor, Fx702pConstants.MATH_CONTEXT);
        if (value.signum() > 0) {
            value = value.add(Fx702pConstants.HALF);
        } else if (value.signum() < 0) {
            value = value.subtract(Fx702pConstants.HALF);
        }
        value = new BigDecimal(value.toBigInteger());
        return value.multiply(factor);
    }

    public Object visit(ASTInteger aNode, Object aData) {
        return aNode.value;
    }

    public Object visit(ASTFloat aNode, Object aData) {
        return aNode.value;
    }

    public Object visit(ASTString aNode, Object aData) {
        return aNode.value;
    }

    public Object visit(ASTPi aNode, Object aData) {
        return Fx702pConstants.BIG_PI;
    }

    public Object visit(ASTVariable aNode, Object aData) {
        return this.getVariable(aNode).getValue();
    }

    public Object visit(ASTIndexedVariable aNode, Object aData) {
        return this.getIndexedVariable(aNode).getValue();
    }

    public Object visit(ASTDollar aNode, Object aData) {
        return this.getMemory().getDollarVariable().getValue();
    }

    public Object visit(ASTFunctionArguments aNode, Object aData) {
        throw new Fx702pInternalError("Visiting ASTFunctionArguments");
    }

    public Object visit(ASTFunctionWithParenthesisArguments aNode, Object aData) {
        throw new Fx702pInternalError("Visiting ASTFunctionWithParenthesisArguments");
    }

    protected void checkCommandArguments(int anArgumentCount, Object aData) {
        if (anArgumentCount == 0 && (aData == null || aData instanceof Node && ((Node)aData).jjtGetNumChildren() == 0)) {
            return;
        }
        if (anArgumentCount != 0 && aData != null && aData instanceof Node && ((Node)aData).jjtGetNumChildren() == anArgumentCount) {
            return;
        }
        throw new Fx702pErr2Exception();
    }

    public Object visit(ASTSet aNode, Object aData) {
        if (aNode.format.equals("0")) {
            this.getMemory().setRoundingMode(RoundingMode.DOWN);
        } else if (aNode.format.equals("5")) {
            this.getMemory().setRoundingMode(RoundingMode.HALF_DOWN);
        } else if (aNode.format.length() == 1 && aNode.format.charAt(0) == 'N') {
            this.getMemory().setFormatter(Fx702pConstants.NORMAL_FORMATTER);
        } else if (aNode.format.length() == 2 && aNode.format.charAt(0) == 'F' && Character.isDigit(aNode.format.charAt(1))) {
            int precision = Character.digit(aNode.format.charAt(1), 10);
            this.getMemory().setFormatter(new FixedFormatter(precision));
        } else if (aNode.format.length() == 2 && aNode.format.charAt(0) == 'E' && Character.isDigit(aNode.format.charAt(1))) {
            int precision = Character.digit(aNode.format.charAt(1), 10);
            this.getMemory().setFormatter(new ScientificFormatter(precision));
        }
        return null;
    }

    public Object visit(ASTCommand aNode, Object aData) {
        return aNode.jjtGetChild(0).jjtAccept(this, aNode.jjtGetChild(1));
    }

    public Object visit(ASTStop aNode, Object aData) {
        return null;
    }

    public Object visit(ASTEnd aNode, Object aData) {
        this.checkCommandArguments(0, aData);
        return new End();
    }

    public Object visit(ASTVac aNode, Object aData) {
        this.getMemory().clearAllVariables();
        return null;
    }

    public Object visit(ASTSac aNode, Object aData) {
        this.sac();
        return null;
    }

    protected String stat(BigDecimal x, BigDecimal y) {
        this.getMemory().setStatVariables(this.getMemory().getStatCounter().add(BigDecimal.ONE), this.getMemory().getSumX().add(x), this.getMemory().getSumY().add(y), this.getMemory().getSumX2().add(x.multiply(x)), this.getMemory().getSumY2().add(y.multiply(y)), this.getMemory().getSumXY().add(x.multiply(y)));
        return null;
    }

    protected String del(BigDecimal x, BigDecimal y) {
        this.getMemory().setStatVariables(this.getMemory().getStatCounter().subtract(BigDecimal.ONE), this.getMemory().getSumX().subtract(x), this.getMemory().getSumY().subtract(y), this.getMemory().getSumX2().subtract(x.multiply(x)), this.getMemory().getSumY2().subtract(y.multiply(y)), this.getMemory().getSumXY().subtract(x.multiply(y)));
        return null;
    }

    public Object visit(ASTStat aNode, Object aData) {
        if (aData instanceof Node) {
            StatisticsArguments arguments = this.getStatisticsArgument((Node)aData);
            if (arguments != null) {
                return this.stat(arguments.x, arguments.y);
            }
            throw new Fx702pErr2Exception();
        }
        throw new Fx702pInternalError("Data should be a Node");
    }

    public Object visit(ASTDel aNode, Object aData) {
        if (aData instanceof Node) {
            StatisticsArguments arguments = this.getStatisticsArgument((Node)aData);
            if (arguments != null) {
                return this.del(arguments.x, arguments.y);
            }
            throw new Fx702pErr2Exception();
        }
        throw new Fx702pInternalError("Data should be a Node");
    }

    protected StatisticsArguments getStatisticsArgument(Node aNode) {
        try {
            if (aNode.jjtGetNumChildren() == 0) {
                return null;
            }
            if (aNode.jjtGetNumChildren() == 1) {
                Object x = aNode.jjtGetChild(0).jjtAccept(this, null);
                if (x != null && x instanceof BigDecimal) {
                    BigDecimal y = this.getMemory().getLastY();
                    if (y == null) {
                        y = BigDecimal.ZERO;
                    }
                    return new StatisticsArguments((BigDecimal)x, y);
                }
                this.reportError(new Fx702pErr2Exception(this));
            } else if (aNode.jjtGetNumChildren() == 2) {
                Object y;
                Object x = aNode.jjtGetChild(0).jjtAccept(this, null);
                if (x != null && x instanceof BigDecimal && (y = aNode.jjtGetChild(1).jjtAccept(this, null)) != null && y instanceof BigDecimal) {
                    this.getMemory().setLastY((BigDecimal)y);
                    return new StatisticsArguments((BigDecimal)x, (BigDecimal)y);
                }
                this.reportError(new Fx702pErr2Exception(this));
            } else {
                this.reportError(new Fx702pErr2Exception(this));
            }
        }
        catch (ArithmeticException exception) {
            this.reportError(new Fx702pErr3Exception(this));
        }
        catch (Fx702pException exception) {
            this.reportError(exception);
        }
        return null;
    }

    public Object visit(ASTRPC aNode, Object aData) {
        this.checkCommandArguments(2, aData);
        Object value1 = ((Node)aData).jjtGetChild(0).jjtAccept(this, null);
        Object value2 = ((Node)aData).jjtGetChild(1).jjtAccept(this, null);
        if (value1 instanceof BigDecimal && value2 instanceof BigDecimal) {
            if (((BigDecimal)value1).compareTo(BigDecimal.ZERO) == 0 && ((BigDecimal)value2).compareTo(BigDecimal.ZERO) == 0) {
                throw new Fx702pErr3Exception(this);
            }
        } else {
            throw new Fx702pErr2Exception();
        }
        double x = ((BigDecimal)value1).doubleValue();
        double y = ((BigDecimal)value2).doubleValue();
        double r = Math.sqrt(x * x + y * y);
        double t = Math.acos(x / r) / this.getMemory().getTrigonometricConversionFactor();
        this.getMemory().getVariable(23).getNumberVariable().setValue(new BigDecimal(r));
        this.getMemory().getVariable(24).getNumberVariable().setValue(new BigDecimal(t));
        return null;
    }

    public Object visit(ASTPRC aNode, Object aData) {
        double t;
        double r;
        this.checkCommandArguments(2, aData);
        Object value1 = ((Node)aData).jjtGetChild(0).jjtAccept(this, null);
        Object value2 = ((Node)aData).jjtGetChild(1).jjtAccept(this, null);
        if (value1 instanceof BigDecimal && value2 instanceof BigDecimal) {
            r = ((BigDecimal)value1).doubleValue();
            t = ((BigDecimal)value2).doubleValue();
            if (Math.abs(t) > this.getMemory().getTrigonometricMaxArgument()) {
                throw new Fx702pErr3Exception(this);
            }
        } else {
            throw new Fx702pErr2Exception();
        }
        double x = r * Math.cos(t * this.getMemory().getTrigonometricConversionFactor());
        double y = r * Math.sin(t * this.getMemory().getTrigonometricConversionFactor());
        this.getMemory().getVariable(23).getNumberVariable().setValue(new BigDecimal(x));
        this.getMemory().getVariable(24).getNumberVariable().setValue(new BigDecimal(y));
        return null;
    }

    public Object visit(ASTDeg aNode, Object aData) {
        if (aData instanceof Node) {
            Node node = (Node)aData;
            if (node.jjtGetNumChildren() <= 3) {
                Object[] values = new BigDecimal[3];
                Arrays.fill(values, BigDecimal.ZERO);
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    Object value = node.jjtGetChild(i).jjtAccept(this, null);
                    if (!(value instanceof BigDecimal)) {
                        throw new Fx702pErr2Exception();
                    }
                    values[i] = (BigDecimal)value;
                }
                return ((BigDecimal)values[0]).add(((BigDecimal)values[1]).divide(Fx702pConstants.SIXTY, Fx702pConstants.MATH_CONTEXT).add(((BigDecimal)values[2]).divide(Fx702pConstants.SQUARED_SIXTY, Fx702pConstants.MATH_CONTEXT)));
            }
            throw new Fx702pErr2Exception();
        }
        throw new Fx702pInternalError("Data should be a Node");
    }

    public Object visit(ASTClosedSubExpression aNode, Object aData) {
        return aNode.jjtGetChild(0).jjtAccept(this, aData);
    }

    public Object visit(ASTOpenSubExpression aNode, Object aData) {
        return aNode.jjtGetChild(0).jjtAccept(this, aData);
    }

    public Object visit(ASTVariablesAndProgram aNode, Object aData) {
        return null;
    }

    public Object visit(ASTCommandArguments aNode, Object aData) {
        throw new Fx702pInternalError("Visiting ASTCommandArguments");
    }

    public Object visit(ASTCommandWithParenthesisArguments aNode, Object aData) {
        throw new Fx702pInternalError("Visiting ASTCommandWithParenthesisArguments");
    }

    public Object visit(ASTProgramsFile aNode, Object aData) {
        throw new Fx702pErr2Exception();
    }

    public Object visit(ASTMultiplePrograms aNode, Object aData) {
        throw new Fx702pErr2Exception();
    }

    public Object visit(ASTSingleProgram aNode, Object aData) {
        throw new Fx702pErr2Exception();
    }

    public Object visit(ASTProgramSignature aNode, Object aData) {
        throw new Fx702pErr2Exception();
    }

    public Object visit(ASTBreakpoint aNode, Object aData) {
        throw new Fx702pErr2Exception();
    }

    public Object visit(ASTWatch aNode, Object aData) {
        throw new Fx702pErr2Exception();
    }

    public Object visit(ASTWatchpoint aNode, Object aData) {
        throw new Fx702pErr2Exception();
    }

    public Object visit(ASTStatWatchpoint aNode, Object aData) {
        throw new Fx702pErr2Exception();
    }

    public Object visit(ASTClear aNode, Object aData) {
        throw new Fx702pErr2Exception();
    }

    public Object visit(ASTSavedDefm aNode, Object aData) {
        throw new Fx702pInternalError("Found SavedDefm node in a program");
    }

    protected static class DMSResult {
        public String result;
        public BigDecimal value;

        public DMSResult(String aResult, BigDecimal aValue) {
            this.result = aResult;
            this.value = aValue;
        }
    }

    protected static class StatisticsArguments {
        public BigDecimal x;
        public BigDecimal y;

        public StatisticsArguments(BigDecimal anX, BigDecimal anY) {
            this.x = anX;
            this.y = anY;
        }
    }
}

