/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.interpreters;

import com.fx702p.Fx702pFullParser;
import com.fx702p.emulator.Fx702pEmulator;
import com.fx702p.emulator.Variable;
import com.fx702p.emulator.exceptions.Fx702pErr2Exception;
import com.fx702p.emulator.exceptions.Fx702pErr3Exception;
import com.fx702p.emulator.exceptions.Fx702pErr4Exception;
import com.fx702p.emulator.exceptions.Fx702pErr5Exception;
import com.fx702p.emulator.exceptions.Fx702pErr7Exception;
import com.fx702p.interpreters.BasicInstructionIndex;
import com.fx702p.interpreters.Continuation;
import com.fx702p.interpreters.End;
import com.fx702p.interpreters.ExtraVisitor;
import com.fx702p.interpreters.FirstInstruction;
import com.fx702p.interpreters.ForLoop;
import com.fx702p.interpreters.Fx702pAbstractCalculator;
import com.fx702p.interpreters.Fx702pException;
import com.fx702p.interpreters.Fx702pFormatter;
import com.fx702p.interpreters.Fx702pInternalError;
import com.fx702p.interpreters.NextInstruction;
import com.fx702p.interpreters.NextProgramInstruction;
import com.fx702p.interpreters.NextSubInstruction;
import com.fx702p.interpreters.OtherProgramStart;
import com.fx702p.interpreters.PrintFormatter;
import com.fx702p.interpreters.PrintWaitInstruction;
import com.fx702p.parser.ASTClear;
import com.fx702p.parser.ASTComma;
import com.fx702p.parser.ASTComment;
import com.fx702p.parser.ASTCsr;
import com.fx702p.parser.ASTDMS;
import com.fx702p.parser.ASTDefm;
import com.fx702p.parser.ASTDeg;
import com.fx702p.parser.ASTEqual;
import com.fx702p.parser.ASTFor;
import com.fx702p.parser.ASTGet;
import com.fx702p.parser.ASTGoto;
import com.fx702p.parser.ASTGotoProgram;
import com.fx702p.parser.ASTGreater;
import com.fx702p.parser.ASTGreaterOrEqual;
import com.fx702p.parser.ASTGsb;
import com.fx702p.parser.ASTGsbProgram;
import com.fx702p.parser.ASTIf;
import com.fx702p.parser.ASTInput;
import com.fx702p.parser.ASTInputPrompt;
import com.fx702p.parser.ASTInputVariable;
import com.fx702p.parser.ASTLesser;
import com.fx702p.parser.ASTLesserOrEqual;
import com.fx702p.parser.ASTLine;
import com.fx702p.parser.ASTList;
import com.fx702p.parser.ASTLoad;
import com.fx702p.parser.ASTMode;
import com.fx702p.parser.ASTNext;
import com.fx702p.parser.ASTNotEqual;
import com.fx702p.parser.ASTPassword;
import com.fx702p.parser.ASTPrint;
import com.fx702p.parser.ASTPrintFormat;
import com.fx702p.parser.ASTProgram;
import com.fx702p.parser.ASTPrtExpression;
import com.fx702p.parser.ASTPut;
import com.fx702p.parser.ASTReturn;
import com.fx702p.parser.ASTRom;
import com.fx702p.parser.ASTRun;
import com.fx702p.parser.ASTSave;
import com.fx702p.parser.ASTSemicolon;
import com.fx702p.parser.ASTString;
import com.fx702p.parser.ASTVerify;
import com.fx702p.parser.ASTWait;
import com.fx702p.parser.Node;
import com.fx702p.parser.ParseException;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;

public class Fx702pBasicInterpreter
extends Fx702pAbstractCalculator {
    protected static final Comparator COMPARE_EQUAL = new Comparator(){

        public boolean compare(Comparable a, Comparable b) {
            return a.compareTo(b) == 0;
        }
    };
    protected static final Comparator COMPARE_GREATER = new Comparator(){

        public boolean compare(Comparable a, Comparable b) {
            return a.compareTo(b) > 0;
        }
    };
    protected static final Comparator COMPARE_GREATER_EQUAL = new Comparator(){

        public boolean compare(Comparable a, Comparable b) {
            return a.compareTo(b) >= 0;
        }
    };
    protected boolean programRunning = false;
    protected boolean suspendedOnBreakpoint = false;
    protected Continuation continuation = null;
    protected Continuation[] gsbStack = new Continuation[10];
    protected int gsbStackIndex = 0;
    protected ForLoop[] forLoopStack = new ForLoop[8];
    protected int forLoopStackIndex = 0;
    protected int currentLineIndex = 0;
    protected int lastLineIndex;
    protected int currentInstructionIndex = 0;
    protected int lastInstructionIndex;
    protected PrintInfos printInfos = new PrintInfos();
    protected int prtWait = 1000;
    protected Fx702pFormatter printFormatter = null;
    protected String inputPrompt = null;
    protected Variable inputVariable;
    protected Continuation inputStoppedContinuation;
    protected boolean inputError = false;
    protected ExtraVisitor extraVisitor = null;
    public static final int GSB_STACK_SIZE = 10;
    public static final int FOR_LOOP_STACK_SIZE = 8;

    public Fx702pBasicInterpreter(Fx702pEmulator anEmulator) {
        super(anEmulator);
    }

    public void setExtraVisitor(ExtraVisitor anExtraVisitor) {
        this.extraVisitor = anExtraVisitor;
    }

    public void afterError() {
        if (!this.inputError) {
            this.end();
        }
    }

    public void setRunMode() {
        this.end();
    }

    public void execute(String anInputBuffer) {
        if (anInputBuffer == null || anInputBuffer.length() == 0) {
            this.continuation = this.inputStoppedContinuation;
            this.inputPrompt = "";
            this.stopProgramOnInput();
        } else {
            try {
                if (this.inputVariable.isStringVariable()) {
                    this.inputVariable.setValue(anInputBuffer);
                } else {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(anInputBuffer.getBytes());
                    Fx702pFullParser inputParser = new Fx702pFullParser(inputStream);
                    Node expression = inputParser.Expression();
                    Object value = expression.jjtAccept(this, null);
                    this.inputVariable.setValue(value);
                }
                this.contProgramOnInput();
            }
            catch (ParseException exception) {
                this.reportInputError(new Fx702pErr2Exception());
            }
            catch (Fx702pException exception) {
                this.reportInputError(exception);
            }
            catch (UnsupportedEncodingException exception) {
                this.reportInputError(exception);
            }
        }
    }

    protected void reportInputError(Throwable anException) {
        this.inputError = true;
        super.reportError(anException);
    }

    protected void reportError(Throwable anException) {
        this.inputError = false;
        super.reportError(anException);
    }

    public void end() {
        this.programRunning = false;
        this.continuation = null;
        if (this.extraVisitor != null) {
            this.extraVisitor.visitProgramEnd();
        }
    }

    public void changeActiveProgramIndex(int aProgramIndex) {
        this.getMemory().setActiveProgramIndex(aProgramIndex);
    }

    public int getActiveProgramIndex() {
        return this.getMemory().getActiveProgramIndex();
    }

    public int getCurrentLine() {
        return this.getMemory().getActiveProgram().getParsedProgram().getLine(this.currentLineIndex).getLine();
    }

    public void runProgram() {
        this.programRunning = true;
        ASTProgram program = this.getMemory().getActiveProgram().getParsedProgram();
        if (program != null) {
            this.prepareRunningEnvironment(program);
            this.continuation = (Continuation)this.visit(program, null);
        } else {
            this.continuation = new End();
        }
    }

    public Fx702pEmulator.ProgramStatus continueExecution() {
        if (this.programRunning) {
            BasicInstructionIndex basicInstructionIndex = this.continuation.getBasicInstructionIndex();
            if (!this.suspendedOnBreakpoint && basicInstructionIndex != null && this.getMemory().getActiveProgram().containsBreakpoint(basicInstructionIndex)) {
                this.suspendProgramOnBreakpoint();
                this.suspendedOnBreakpoint = true;
                if (this.extraVisitor != null) {
                    this.extraVisitor.visitBreakpoint(basicInstructionIndex);
                }
                return Fx702pEmulator.ProgramStatus.SUSPENDED;
            }
            this.suspendedOnBreakpoint = false;
            this.continuation.callContinuation(this);
        }
        return this.programRunning ? Fx702pEmulator.ProgramStatus.RUNNING : Fx702pEmulator.ProgramStatus.ENDED;
    }

    public boolean isContinuationDebuggable() {
        return this.continuation != null && !(this.continuation instanceof PrintWaitInstruction) && !this.suspendedOnBreakpoint;
    }

    protected int getLineIndexByLineNumber(int aLineNumber) {
        return this.getMemory().getActiveProgram().getParsedProgram().getLineIndexByLineNumber(aLineNumber);
    }

    protected void executeInstruction(BasicInstructionIndex aBasicInstructionIndex) {
        try {
            ASTLine line = this.getMemory().getActiveProgram().getParsedProgram().getLine(aBasicInstructionIndex.getLineIndex());
            this.continuation = (Continuation)line.jjtAccept(this, aBasicInstructionIndex.getInstructionIndex());
            if (this.continuation == null) {
                this.continuation = this.nextInstruction();
            }
        }
        catch (ArithmeticException exception) {
            this.reportError(new Fx702pErr3Exception(this));
        }
        catch (Fx702pException exception) {
            this.reportError(exception);
        }
    }

    protected void executeSubInstruction(BasicInstructionIndex aBasicInstructionIndex, int aPrintInstructionIndex) {
        try {
            this.currentLineIndex = aBasicInstructionIndex.getLineIndex();
            this.currentInstructionIndex = aBasicInstructionIndex.getInstructionIndex();
            ASTLine line = this.getMemory().getActiveProgram().getParsedProgram().getLine(this.currentLineIndex);
            this.lastInstructionIndex = line.jjtGetNumChildren();
            this.continuation = (Continuation)line.jjtGetChild(this.currentInstructionIndex).jjtAccept(this, aPrintInstructionIndex);
            if (this.continuation == null) {
                this.continuation = this.nextInstruction();
            }
        }
        catch (ArithmeticException exception) {
            this.reportError(new Fx702pErr3Exception(this));
        }
        catch (Fx702pException exception) {
            this.reportError(exception);
        }
    }

    protected void prepareRunningEnvironment(ASTProgram aProgram) {
        this.gsbStackIndex = 0;
        this.forLoopStackIndex = 0;
        this.lastLineIndex = aProgram.jjtGetNumChildren();
    }

    protected String formatNumber(BigDecimal aNumber) {
        if (this.printFormatter != null) {
            this.printFormatter.setRoundingMode(this.getMemory().getRoundingMode());
            return this.printFormatter.format(aNumber);
        }
        return super.formatNumber(aNumber);
    }

    public void printWait() {
        this.printWait(this.prtWait);
    }

    public void setContinuation(Continuation aContinuation) {
        this.continuation = aContinuation;
    }

    public Continuation nextInstruction() {
        int nextInstructionIndex = this.currentInstructionIndex + 1;
        int nextLineIndex = this.currentLineIndex;
        if (nextInstructionIndex == this.lastInstructionIndex) {
            nextInstructionIndex = 0;
            if (++nextLineIndex == this.lastLineIndex) {
                return new End();
            }
        }
        return new NextInstruction(nextLineIndex, nextInstructionIndex);
    }

    public Continuation nextProgramInstruction() {
        Continuation continuation = this.nextInstruction();
        if (continuation instanceof End) {
            return continuation;
        }
        if (continuation instanceof NextInstruction) {
            return new NextProgramInstruction(this.getActiveProgramIndex(), ((NextInstruction)continuation).getBasicIntructionIndex());
        }
        throw new RuntimeException("Internal Error, unknown Command in nextProgramInstruction");
    }

    public Continuation nextSubInstruction(Node aNode, int aPrintInstructionIndex) {
        Node line;
        for (line = aNode.jjtGetParent(); line != null && !(line instanceof ASTLine); line = line.jjtGetParent()) {
        }
        if (line == null) {
            throw new RuntimeException("Internal Error, unable to find the line for this instruction");
        }
        int lineIndex = this.getLineIndexByLineNumber(((ASTLine)line).getLine());
        int instructionIndex = 0;
        while (aNode.jjtGetParent().jjtGetChild(instructionIndex) != aNode) {
            ++instructionIndex;
        }
        return new NextSubInstruction(lineIndex, instructionIndex, aPrintInstructionIndex);
    }

    public Continuation skipToNextLine() {
        int nextLineIndex = this.currentLineIndex;
        if (++nextLineIndex == this.lastLineIndex) {
            return new End();
        }
        return new NextInstruction(nextLineIndex, 0);
    }

    public Continuation gotoLine(int aLine) {
        Integer nextLineIndex = this.getLineIndexByLineNumber(aLine);
        if (nextLineIndex == null) {
            throw new Fx702pErr4Exception(this);
        }
        return new NextInstruction(nextLineIndex, 0);
    }

    protected void extraVisitorHook(Node aNode, Object aData) {
        if (this.extraVisitor != null) {
            aNode.jjtAccept(this.extraVisitor, aData);
        }
    }

    public Object visit(ASTDeg aNode, Object aData) {
        throw new Fx702pErr2Exception(this);
    }

    public Object visit(ASTRun aNode, Object aData) {
        throw new Fx702pErr2Exception(this);
    }

    public Object visit(ASTList aNode, Object aData) {
        throw new Fx702pErr2Exception(this);
    }

    public Object visit(ASTClear aNode, Object aData) {
        throw new Fx702pErr2Exception(this);
    }

    public Object visit(ASTDefm aNode, Object aData) {
        throw new Fx702pErr2Exception(this);
    }

    public Object visit(ASTPassword aNode, Object aData) {
        throw new Fx702pErr2Exception(this);
    }

    public Object visit(ASTRom aNode, Object aData) {
        throw new Fx702pErr2Exception(this);
    }

    public Object visit(ASTSave aNode, Object aData) {
        throw new Fx702pErr2Exception(this);
    }

    public Object visit(ASTVerify aNode, Object aData) {
        throw new Fx702pErr2Exception(this);
    }

    public Object visit(ASTLoad aNode, Object aData) {
        return null;
    }

    public Object visit(ASTGet aNode, Object aData) {
        return null;
    }

    public Object visit(ASTPut aNode, Object aData) {
        return null;
    }

    public Object visit(ASTProgram aNode, Object aData) {
        return new FirstInstruction();
    }

    public Object visit(ASTLine aNode, Object aStartingInstructionIndex) {
        this.extraVisitorHook(aNode, aStartingInstructionIndex);
        this.currentLineIndex = this.getLineIndexByLineNumber(aNode.getLine());
        this.currentInstructionIndex = (Integer)aStartingInstructionIndex;
        this.lastInstructionIndex = aNode.jjtGetNumChildren();
        Node instruction = aNode.jjtGetChild((Integer)aStartingInstructionIndex);
        Continuation continuation = (Continuation)instruction.jjtAccept(this, null);
        if (continuation == null) {
            return this.nextInstruction();
        }
        return continuation;
    }

    protected int convertGotoOrGsbArgument(Node aNode, Object aData) {
        BigDecimal bigDecimal = this.toBigDecimal(aNode.jjtAccept(this, aData));
        if (bigDecimal.signum() < 0) {
            throw new Fx702pErr5Exception();
        }
        int value = bigDecimal.intValue();
        if (value >= 10000) {
            throw new Fx702pErr5Exception();
        }
        return value;
    }

    protected void checkProgramNumber(int anIndex) {
        if (anIndex >= 10) {
            throw new Fx702pErr2Exception();
        }
    }

    public Object visit(ASTGoto aNode, Object aData) {
        return this.gotoLine(this.convertGotoOrGsbArgument(aNode.jjtGetChild(0), null));
    }

    public Object visit(ASTGotoProgram aNode, Object aData) {
        int index = this.convertGotoOrGsbArgument(aNode, aData);
        this.checkProgramNumber(index);
        return new OtherProgramStart(index);
    }

    public Object visit(ASTGsb aNode, Object aData) {
        if (this.gsbStackIndex >= 10) {
            throw new Fx702pErr7Exception(this);
        }
        this.gsbStack[this.gsbStackIndex] = this.nextInstruction();
        ++this.gsbStackIndex;
        return this.gotoLine(this.convertGotoOrGsbArgument(aNode.jjtGetChild(0), null));
    }

    public Object visit(ASTGsbProgram aNode, Object aData) {
        if (this.gsbStackIndex >= 10) {
            throw new Fx702pErr7Exception(this);
        }
        this.gsbStack[this.gsbStackIndex] = this.nextProgramInstruction();
        ++this.gsbStackIndex;
        int index = this.convertGotoOrGsbArgument(aNode, aData);
        this.checkProgramNumber(index);
        this.changeActiveProgramIndex(index);
        return new FirstInstruction();
    }

    public Object visit(ASTReturn aNode, Object aData) {
        --this.gsbStackIndex;
        if (this.gsbStackIndex < 0) {
            throw new Fx702pErr7Exception(this);
        }
        return this.gsbStack[this.gsbStackIndex];
    }

    public Object visit(ASTMode aNode, Object aData) {
        int mode = this.toBigDecimal(aNode.jjtGetChild(0).jjtAccept(this, aData)).intValue();
        if (mode < 4 || mode > 8) {
            throw new Fx702pErr5Exception(this);
        }
        this.setMode(mode);
        return null;
    }

    public Object visit(ASTIf aNode, Object aData) {
        Node comparison = aNode.jjtGetChild(0);
        Object expressionResult = comparison.jjtAccept(this, aData);
        if (!(expressionResult instanceof Boolean)) {
            throw new Fx702pErr2Exception();
        }
        if (((Boolean)expressionResult).booleanValue()) {
            if (aNode.jjtGetNumChildren() == 2) {
                if (aNode.jjtGetChild(1) instanceof ASTGoto) {
                    return this.visit((ASTGoto)aNode.jjtGetChild(1), aData);
                }
                if (aNode.jjtGetChild(1) instanceof ASTGotoProgram) {
                    return this.visit((ASTGotoProgram)aNode.jjtGetChild(1), aData);
                }
                return this.nextInstruction();
            }
            return this.nextInstruction();
        }
        return this.skipToNextLine();
    }

    protected boolean compare(Node aNode, Comparator aComparator) {
        Object a = aNode.jjtGetChild(0).jjtAccept(this, null);
        Object b = aNode.jjtGetChild(1).jjtAccept(this, null);
        if (a.getClass().equals(b.getClass())) {
            return aComparator.compare((Comparable)a, (Comparable)b);
        }
        throw new Fx702pErr2Exception();
    }

    public Object visit(ASTEqual aNode, Object aData) {
        return this.compare(aNode, COMPARE_EQUAL);
    }

    public Object visit(ASTNotEqual aNode, Object aData) {
        return !this.compare(aNode, COMPARE_EQUAL);
    }

    public Object visit(ASTGreater aNode, Object aData) {
        return this.compare(aNode, COMPARE_GREATER);
    }

    public Object visit(ASTLesser aNode, Object aData) {
        return !this.compare(aNode, COMPARE_GREATER_EQUAL);
    }

    public Object visit(ASTGreaterOrEqual aNode, Object aData) {
        return this.compare(aNode, COMPARE_GREATER_EQUAL);
    }

    public Object visit(ASTLesserOrEqual aNode, Object aData) {
        return !this.compare(aNode, COMPARE_GREATER);
    }

    public Object visit(ASTFor aNode, Object aData) {
        ForLoop forLoop;
        Object step;
        if (this.forLoopStackIndex >= 8) {
            throw new Fx702pErr7Exception(this);
        }
        Variable variable = this.getVariable(aNode.jjtGetChild(0));
        if (!variable.isLoopVariable()) {
            throw new Fx702pErr2Exception();
        }
        Object start = aNode.jjtGetChild(1).jjtAccept(this, aData);
        if (!(start instanceof BigDecimal)) {
            throw new Fx702pErr2Exception();
        }
        Object end = aNode.jjtGetChild(2).jjtAccept(this, aData);
        if (!(end instanceof BigDecimal)) {
            throw new Fx702pErr2Exception();
        }
        if (aNode.jjtGetNumChildren() == 4) {
            step = aNode.jjtGetChild(3).jjtAccept(this, aData);
            if (!(step instanceof BigDecimal)) {
                throw new Fx702pErr2Exception();
            }
        } else {
            step = BigDecimal.ONE;
        }
        this.forLoopStack[this.forLoopStackIndex] = forLoop = new ForLoop(variable, (BigDecimal)start, (BigDecimal)end, (BigDecimal)step, this.nextInstruction());
        ++this.forLoopStackIndex;
        return forLoop;
    }

    public Object visit(ASTNext aNode, Object aData) {
        Variable variable = this.getVariable(aNode.jjtGetChild(0));
        while (true) {
            if (this.forLoopStackIndex == 0) {
                throw new Fx702pErr7Exception(this);
            }
            if (this.forLoopStack[this.forLoopStackIndex - 1].getVariable().equals(variable)) break;
            --this.forLoopStackIndex;
        }
        ForLoop forLoop = this.forLoopStack[this.forLoopStackIndex - 1];
        forLoop.incrementVariable();
        if (forLoop.isLoopOver()) {
            this.invokeEndLoop(forLoop.getVariable());
            --this.forLoopStackIndex;
            return this.nextInstruction();
        }
        this.invokeNextLoop(forLoop.getVariable());
        return forLoop;
    }

    public Object visit(ASTPrint aNode, Object aData) {
        int startIndex = aData != null ? (Integer)aData : 0;
        this.printInfos.waitNeeded = true;
        if (aNode.jjtGetNumChildren() != 0) {
            int last = aNode.jjtGetNumChildren();
            for (int i = startIndex; i < last; ++i) {
                Boolean printDone = (Boolean)aNode.jjtGetChild(i).jjtAccept(this, this.printInfos);
                if (printDone == null || !printDone.booleanValue() || i == last - 1) continue;
                return this.nextSubInstruction(aNode, i + 1);
            }
            this.printFormatter = null;
            if (this.printInfos.waitNeeded) {
                return new PrintWaitInstruction(this.nextInstruction());
            }
            return null;
        }
        this.clearDisplay();
        return null;
    }

    public Object visit(ASTPrintFormat aNode, Object aData) {
        this.printFormatter = new PrintFormatter(aNode.format);
        return false;
    }

    public Object visit(ASTPrtExpression aNode, Object aData) {
        this.extraVisitorHook(aNode, aData);
        ((PrintInfos)aData).waitNeeded = true;
        Object prtExpression = aNode.jjtGetChild(0).jjtAccept(this, aData);
        if (prtExpression instanceof BigDecimal) {
            this.setResult((BigDecimal)prtExpression);
            this.setReusableResult(true);
            this.printResult(this.formatNumber((BigDecimal)prtExpression));
        } else if (prtExpression instanceof String) {
            this.setReusableResult(false);
            this.printResult((String)prtExpression);
        } else {
            throw new Fx702pInternalError("Invalid expression type in PRT, class=" + prtExpression.getClass().getName());
        }
        return true;
    }

    public Object visit(ASTCsr aNode, Object aData) {
        int prtCsr;
        this.extraVisitorHook(aNode, aData);
        Object csr = aNode.jjtGetChild(0).jjtAccept(this, aData);
        if (csr instanceof BigDecimal) {
            prtCsr = ((BigDecimal)csr).intValue();
            if (prtCsr < 0 || prtCsr >= 20) {
                throw new Fx702pErr5Exception(this);
            }
        } else {
            throw new Fx702pErr2Exception();
        }
        this.setCursorPosition(prtCsr);
        return false;
    }

    public Object visit(ASTComma aNode, Object aData) {
        this.printFormatter = null;
        this.printWait();
        return true;
    }

    public Object visit(ASTSemicolon aNode, Object aData) {
        ((PrintInfos)aData).waitNeeded = false;
        return true;
    }

    public Object visit(ASTWait aNode, Object aData) {
        this.checkCommandArguments(1, aData);
        Object wait = ((Node)aData).jjtGetChild(0).jjtAccept(this, null);
        if (!(wait instanceof BigDecimal)) {
            throw new Fx702pErr2Exception();
        }
        this.prtWait = ((BigDecimal)wait).intValue();
        return null;
    }

    public Object visit(ASTInput aNode, Object aData) {
        int startIndex;
        if (aData != null) {
            startIndex = (Integer)aData;
        } else {
            startIndex = 0;
            this.inputPrompt = "";
        }
        int last = aNode.jjtGetNumChildren();
        for (int i = startIndex; i < last; ++i) {
            this.inputStoppedContinuation = this.nextSubInstruction(aNode, i);
            Boolean inputDone = (Boolean)aNode.jjtGetChild(i).jjtAccept(this, null);
            if (inputDone == null || !inputDone.booleanValue() || i == last - 1) continue;
            return this.nextSubInstruction(aNode, i + 1);
        }
        return null;
    }

    public Object visit(ASTInputPrompt aNode, Object aData) {
        this.inputPrompt = ((ASTString)aNode.jjtGetChild((int)0)).value;
        return false;
    }

    public Object visit(ASTInputVariable aNode, Object aData) {
        this.extraVisitorHook(aNode, aData);
        this.inputVariable = this.getVariable(aNode.jjtGetChild(0));
        this.startInput(this.inputPrompt);
        return true;
    }

    public Object visit(ASTDMS aNode, Object aData) {
        Fx702pAbstractCalculator.DMSResult dmsResult = (Fx702pAbstractCalculator.DMSResult)super.visit(aNode, aData);
        this.setResult(dmsResult.value);
        this.setReusableResult(true);
        this.printResult(dmsResult.result);
        return new PrintWaitInstruction(this.nextInstruction());
    }

    public Object visit(ASTComment aNode, Object aData) {
        return null;
    }

    protected static interface Comparator {
        public boolean compare(Comparable var1, Comparable var2);
    }

    public static class PrintInfos {
        public boolean waitNeeded = false;
    }
}

