/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.interpreters;

import com.fx702p.Fx702pFullParser;
import com.fx702p.emulator.Fx702pConstants;
import com.fx702p.emulator.Fx702pEmulator;
import com.fx702p.emulator.exceptions.Fx702pErr2Exception;
import com.fx702p.emulator.exceptions.Fx702pErr3Exception;
import com.fx702p.emulator.exceptions.Fx702pErr5Exception;
import com.fx702p.emulator.implementation.MultiLinePrinter;
import com.fx702p.interpreters.Fx702pAbstractCalculator;
import com.fx702p.interpreters.Fx702pException;
import com.fx702p.interpreters.Fx702pInternalError;
import com.fx702p.parser.ASTComma;
import com.fx702p.parser.ASTCommandArguments;
import com.fx702p.parser.ASTComment;
import com.fx702p.parser.ASTCsr;
import com.fx702p.parser.ASTDefm;
import com.fx702p.parser.ASTDel;
import com.fx702p.parser.ASTEqual;
import com.fx702p.parser.ASTFor;
import com.fx702p.parser.ASTGet;
import com.fx702p.parser.ASTGoto;
import com.fx702p.parser.ASTGotoProgram;
import com.fx702p.parser.ASTGreater;
import com.fx702p.parser.ASTGreaterOrEqual;
import com.fx702p.parser.ASTGsb;
import com.fx702p.parser.ASTGsbProgram;
import com.fx702p.parser.ASTIf;
import com.fx702p.parser.ASTInput;
import com.fx702p.parser.ASTInputPrompt;
import com.fx702p.parser.ASTInputVariable;
import com.fx702p.parser.ASTLesser;
import com.fx702p.parser.ASTLesserOrEqual;
import com.fx702p.parser.ASTLine;
import com.fx702p.parser.ASTList;
import com.fx702p.parser.ASTLoad;
import com.fx702p.parser.ASTMode;
import com.fx702p.parser.ASTNext;
import com.fx702p.parser.ASTNotEqual;
import com.fx702p.parser.ASTPassword;
import com.fx702p.parser.ASTPrint;
import com.fx702p.parser.ASTPrintFormat;
import com.fx702p.parser.ASTProgram;
import com.fx702p.parser.ASTPrtExpression;
import com.fx702p.parser.ASTPut;
import com.fx702p.parser.ASTReturn;
import com.fx702p.parser.ASTRom;
import com.fx702p.parser.ASTRun;
import com.fx702p.parser.ASTSac;
import com.fx702p.parser.ASTSave;
import com.fx702p.parser.ASTSemicolon;
import com.fx702p.parser.ASTStat;
import com.fx702p.parser.ASTVerify;
import com.fx702p.parser.ASTWait;
import com.fx702p.parser.Node;
import com.fx702p.parser.ParseException;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;

public class Fx702pCalculator
extends Fx702pAbstractCalculator {
    public Fx702pCalculator(Fx702pEmulator anEmulator) {
        super(anEmulator);
    }

    public void afterError() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String anInputBuffer) {
        block17: {
            this.showBusy(true);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(anInputBuffer.getBytes());
            try {
                Object value;
                Fx702pFullParser parser = new Fx702pFullParser(inputStream);
                Node calculator = parser.Calculator();
                if (calculator == null || (value = calculator.jjtAccept(this, null)) == null) break block17;
                if (value instanceof BigDecimal) {
                    this.setResult((BigDecimal)value);
                    this.setReusableResult(true);
                    this.printResult(this.formatNumber((BigDecimal)value));
                    break block17;
                }
                if (value instanceof Fx702pAbstractCalculator.DMSResult) {
                    Fx702pAbstractCalculator.DMSResult dmsResult = (Fx702pAbstractCalculator.DMSResult)value;
                    this.setResult(dmsResult.value);
                    this.setReusableResult(true);
                    this.printResult(dmsResult.result);
                    break block17;
                }
                if (value instanceof String) {
                    String stringValue = (String)value;
                    if (stringValue != null && stringValue.trim().length() != 0) {
                        this.setReusableResult(false);
                        this.printResult((String)value);
                    }
                    break block17;
                }
                throw new Fx702pInternalError("Invalid expression type, class=" + value.getClass().getName());
            }
            catch (ParseException exception) {
                this.reportError(new Fx702pErr2Exception(this));
            }
            catch (ArithmeticException exception) {
                this.reportError(new Fx702pErr3Exception(this));
            }
            catch (Fx702pException exception) {
                this.reportError(exception);
            }
            catch (UnsupportedEncodingException exception) {
                this.reportError(exception);
            }
            catch (Throwable exception) {
                exception.printStackTrace(System.err);
            }
            finally {
                this.showBusy(false);
            }
        }
    }

    protected void printResult(String aStringResult) {
        this.setCursorPosition(0);
        super.printResult(aStringResult);
    }

    public Object visit(ASTMode aNode, Object aData) {
        int mode = this.toBigDecimal(aNode.jjtGetChild(0).jjtAccept(this, aData)).intValue();
        if (mode < 0 || mode > 8) {
            throw new Fx702pErr5Exception(this);
        }
        this.setMode(mode);
        return null;
    }

    public void stat(String anInputBuffer) {
        Fx702pAbstractCalculator.StatisticsArguments arguments = this.getStatisticsArguments(anInputBuffer);
        if (arguments != null) {
            this.printResult(this.stat(arguments.x, arguments.y));
        }
    }

    public void del(String anInputBuffer) {
        Fx702pAbstractCalculator.StatisticsArguments arguments = this.getStatisticsArguments(anInputBuffer);
        if (arguments != null) {
            this.printResult(this.del(arguments.x, arguments.y));
        }
    }

    protected Fx702pAbstractCalculator.StatisticsArguments getStatisticsArguments(String anInputBuffer) {
        if (anInputBuffer != null && anInputBuffer.length() != 0) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(anInputBuffer.getBytes());
            try {
                Fx702pFullParser parser = new Fx702pFullParser(inputStream);
                ASTCommandArguments arguments = parser.CommandArguments();
                if (arguments != null) {
                    return this.getStatisticsArgument(arguments);
                }
            }
            catch (ParseException exception) {
                this.reportError(new Fx702pErr2Exception(this));
            }
            catch (UnsupportedEncodingException exception) {
                this.reportError(exception);
            }
        }
        return null;
    }

    public void astat() {
        this.printMultiLines(new AStatPrinter());
    }

    public void sac() {
        super.sac();
        this.printResult(null);
    }

    protected String stat(BigDecimal x, BigDecimal y) {
        super.stat(x, y);
        return this.buildStatResult("STAT", x, y);
    }

    protected String del(BigDecimal x, BigDecimal y) {
        super.del(x, y);
        return this.buildStatResult("DEL", x, y);
    }

    protected String buildStatResult(String aText, BigDecimal x, BigDecimal y) {
        StringBuilder builder = new StringBuilder();
        builder.append(aText);
        builder.append(Fx702pConstants.NORMAL_FORMATTER.format(x));
        if (this.getMemory().getLastY() != null) {
            builder.append(',');
            builder.append(Fx702pConstants.NORMAL_FORMATTER.format(y));
        }
        return builder.toString();
    }

    public Object visit(ASTDefm aNode, Object aData) {
        int defm = this.toBigDecimal(aNode.jjtGetChild(0).jjtAccept(this, aData)).intValue();
        if (defm < 0 || defm > 20) {
            throw new Fx702pErr5Exception();
        }
        this.setDefm(defm);
        return null;
    }

    public Object visit(ASTPassword aNode, Object aData) {
        return null;
    }

    public Object visit(ASTRom aNode, Object aData) {
        return null;
    }

    public Object visit(ASTRun aNode, Object aData) {
        return null;
    }

    public Object visit(ASTList aNode, Object aData) {
        return null;
    }

    public Object visit(ASTProgram aNode, Object aData) {
        return null;
    }

    public Object visit(ASTLine aNode, Object aData) {
        return null;
    }

    public Object visit(ASTGoto aNode, Object aData) {
        return null;
    }

    public Object visit(ASTGotoProgram aNode, Object aData) {
        return null;
    }

    public Object visit(ASTGsb aNode, Object aData) {
        return null;
    }

    public Object visit(ASTGsbProgram aNode, Object aData) {
        return null;
    }

    public Object visit(ASTReturn aNode, Object aData) {
        return null;
    }

    public Object visit(ASTPrint aNode, Object aData) {
        return null;
    }

    public Object visit(ASTPrintFormat aNode, Object aData) {
        return null;
    }

    public Object visit(ASTPrtExpression aNode, Object aData) {
        return null;
    }

    public Object visit(ASTCsr aNode, Object aData) {
        return null;
    }

    public Object visit(ASTComma aNode, Object aData) {
        return null;
    }

    public Object visit(ASTSemicolon aNode, Object aData) {
        return null;
    }

    public Object visit(ASTInput aNode, Object aData) {
        return null;
    }

    public Object visit(ASTInputPrompt aNode, Object aData) {
        return null;
    }

    public Object visit(ASTInputVariable aNode, Object aData) {
        return null;
    }

    public Object visit(ASTWait aNode, Object aData) {
        return null;
    }

    public Object visit(ASTLoad aNode, Object aData) {
        return null;
    }

    public Object visit(ASTSave aNode, Object aData) {
        return null;
    }

    public Object visit(ASTVerify aNode, Object aData) {
        return null;
    }

    public Object visit(ASTGet aNode, Object aData) {
        return null;
    }

    public Object visit(ASTPut aNode, Object aData) {
        return null;
    }

    public Object visit(ASTIf aNode, Object aData) {
        return null;
    }

    public Object visit(ASTEqual aNode, Object aData) {
        return null;
    }

    public Object visit(ASTNotEqual aNode, Object aData) {
        return null;
    }

    public Object visit(ASTGreater aNode, Object aData) {
        return null;
    }

    public Object visit(ASTLesser aNode, Object aData) {
        return null;
    }

    public Object visit(ASTGreaterOrEqual aNode, Object aData) {
        return null;
    }

    public Object visit(ASTLesserOrEqual aNode, Object aData) {
        return null;
    }

    public Object visit(ASTFor aNode, Object aData) {
        return null;
    }

    public Object visit(ASTNext aNode, Object aData) {
        return null;
    }

    public Object visit(ASTStat aNode, Object aData) {
        throw new Fx702pErr2Exception();
    }

    public Object visit(ASTDel aNode, Object aData) {
        throw new Fx702pErr2Exception();
    }

    public Object visit(ASTSac aNode, Object aData) {
        throw new Fx702pErr2Exception();
    }

    public Object visit(ASTComment aNode, Object aData) {
        throw new Fx702pErr2Exception();
    }

    protected class AStatPrinter
    implements MultiLinePrinter {
        protected int lineNumber = 0;
        public static final int NORMAL_WAIT = 35;
        public static final int FIRST_WAIT = 43;

        protected AStatPrinter() {
        }

        public String getLine() {
            switch (this.lineNumber) {
                case 0: {
                    return "*** STAT LIST";
                }
                case 1: {
                    return "CNT=" + Fx702pConstants.NORMAL_FORMATTER.format(Fx702pCalculator.this.getMemory().getStatCounter());
                }
                case 2: {
                    return "SX=" + Fx702pConstants.NORMAL_FORMATTER.format(Fx702pCalculator.this.getMemory().getSumX());
                }
                case 3: {
                    return "SY=" + Fx702pConstants.NORMAL_FORMATTER.format(Fx702pCalculator.this.getMemory().getSumY());
                }
                case 4: {
                    return "SX2=" + Fx702pConstants.NORMAL_FORMATTER.format(Fx702pCalculator.this.getMemory().getSumX2());
                }
                case 5: {
                    return "SY2=" + Fx702pConstants.NORMAL_FORMATTER.format(Fx702pCalculator.this.getMemory().getSumY2());
                }
                case 6: {
                    return "SXY=" + Fx702pConstants.NORMAL_FORMATTER.format(Fx702pCalculator.this.getMemory().getSumXY());
                }
            }
            return null;
        }

        public int getTimeToWait() {
            if (this.lineNumber == 0) {
                return 43;
            }
            return 35;
        }

        public void next() {
            ++this.lineNumber;
        }
    }
}

