/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.parser;

import com.fx702p.emulator.Fx702pBasicSourceCode;
import com.fx702p.emulator.InstructionBoundary;
import com.fx702p.parser.Fx702pParser;
import com.fx702p.parser.Fx702pParserVisitor;
import com.fx702p.parser.Node;
import com.fx702p.parser.SimpleNode;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTLine
extends SimpleNode {
    private int line;
    private int lineIndexInSourceCode;
    private int lineIndexInProgram;
    private Vector<InstructionBoundary> instructionsBoundaries = new Vector();

    public ASTLine(int id) {
        super(id);
    }

    public ASTLine(Fx702pParser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(Fx702pParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public int getLine() {
        return this.line;
    }

    public int getLineIndexInSourceCode() {
        return this.lineIndexInSourceCode;
    }

    public void setLineIndexInSourceCode(int aLineIndexInSourceCode) {
        this.lineIndexInSourceCode = aLineIndexInSourceCode;
    }

    public int getLineIndexInProgram() {
        return this.lineIndexInProgram;
    }

    public void setLineIndexInProgram(int aLineIndexInProgram) {
        this.lineIndexInProgram = aLineIndexInProgram;
    }

    public InstructionBoundary getInstructionBoundary(int anInstructionIndex) {
        return this.instructionsBoundaries.get(anInstructionIndex);
    }

    public List<InstructionBoundary> getInstructionBoundaries() {
        return this.instructionsBoundaries;
    }

    public void addLine(int aLine, int aColumnEnd, int aLineIndexInSourceCode) {
        this.line = aLine;
        this.addInstructionPosition(aColumnEnd);
        this.lineIndexInSourceCode = aLineIndexInSourceCode;
    }

    public void addInstructionPosition(int aPosition) {
        this.instructionsBoundaries.add(new InstructionBoundary(aPosition));
    }

    public void visitAndResynchronize(int anIndex, Fx702pParserVisitor aVisitor, LineInfos aLineInfos) {
        InstructionBoundary instructionBoundary = this.instructionsBoundaries.get(anIndex);
        instructionBoundary.begin -= aLineInfos.columnDelta;
        this.jjtGetChild(anIndex).jjtAccept(aVisitor, aLineInfos);
    }

    public void resynchronizePositions(Fx702pBasicSourceCode aBasicSourceCode) {
        InstructionBoundary.resynchronizeLinePositions(aBasicSourceCode, this.lineIndexInSourceCode, this.instructionsBoundaries);
    }

    public static class LineInfos {
        public int columnDelta = 0;
        public HashMap<Node, InstructionBoundary> boundariesToFix = new HashMap();
    }
}

