/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.swing;

import com.fx702p.emulator.Fx702pEmulator;
import com.fx702p.emulator.Variable;
import com.fx702p.emulator.commands.Command;
import com.fx702p.emulator.implementation.Fx702pEmulatorComponent;
import com.fx702p.interpreters.Fx702pException;
import com.fx702p.swing.DebugWindow;
import com.fx702p.swing.SwingUtils;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DocumentFilter;

public class DebugControlPanel
extends JPanel
implements Fx702pEmulatorComponent {
    protected DebugWindow debugWindow;
    protected JButton playButton;
    protected JButton stepButton;
    protected JButton replayButton;
    protected JButton suspendButton;
    protected JButton endButton;
    protected JFormattedTextField speedTextField;
    protected JSlider speedSlider;
    protected DebugControlPanelBehavior behavior;
    protected ImageIcon playButtonRunIcon;
    protected ImageIcon playButtonStoppedIcon;
    protected boolean programEndedOnStep;
    protected boolean lastStepWasNext = false;
    protected Variable lastNextVariable = null;
    protected final RunModeBehavior RUN_MODE_BEHAVIOR = new RunModeBehavior();
    protected final ProgramRunningModeBehavior PROGRAM_RUNNING_BEHAVIOR = new ProgramRunningModeBehavior();
    protected final ProgramStoppedModeBehavior PROGRAM_STOPPED_BEHAVIOR = new ProgramStoppedModeBehavior();
    protected final ProgramSuspendedModeBehavior PROGRAM_SUSPENDED_BEHAVIOR = new ProgramSuspendedModeBehavior();
    protected final ReplayBehavior REPLAY_BEHAVIOR = new ReplayBehavior();
    public static final int MAX_SPEED_CHARACTERS = 1;
    public static final String SPEED_REGEXP = "[1-9]*";
    public static final int SPEED_SLIDER_WIDTH = 100;
    public static final int SPEED_SLIDER_MAJOR_TICK_SPACING = 1;
    public static final String PLAY_BUTTON_RUN_NAME = "icons/Play24.gif";
    public static final String PLAY_BUTTON_STOPPED_NAME = "icons/Replay24.gif";
    public static final String STEP_BUTTON_NAME = "icons/StepForward24.gif";
    public static final String REPLAY_BUTTON_NAME = "icons/FastForward24.gif";
    public static final String SUSPEND_BUTTON_NAME = "icons/Stop24.gif";
    public static final String END_BUTTON_NAME = "icons/End24.gif";
    public static final String PLAY_BUTTON_RUN_TOOLTIP = "Run";
    public static final String PLAY_BUTTON_STOPPED_TOOLTIP = "Continue";
    public static final String STEP_BUTTON_TOOLTIP = "Step";
    public static final String REPLAY_BUTTON_TOOLTIP = "Finish Loop";
    public static final String SUSPEND_BUTTON_TOOLTIP = "Suspend";
    public static final String END_BUTTON_TOOLTIP = "End";

    public DebugControlPanel(DebugWindow aDebugWindow) {
        this.debugWindow = aDebugWindow;
        this.behavior = this.RUN_MODE_BEHAVIOR;
        this.setLayout(new BoxLayout(this, 0));
        JPanel controlPanel = this.getControlPanel();
        JPanel speedPanel = this.getSpeedPanel();
        int height = Math.max(controlPanel.getPreferredSize().height, speedPanel.getPreferredSize().height);
        controlPanel.setMaximumSize(new Dimension(controlPanel.getMaximumSize().width, height));
        speedPanel.setMaximumSize(new Dimension(speedPanel.getMaximumSize().width, height));
        this.add(controlPanel);
        this.add(speedPanel);
        this.add(Box.createHorizontalGlue());
        this.setButtonsForRunMode();
    }

    public void debugActiveProgram() {
        this.behavior.playPressed();
    }

    protected Fx702pEmulator getEmulator() {
        return this.debugWindow.getEmulator();
    }

    protected JPanel getControlPanel() {
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        controlPanel.setBorder(BorderFactory.createTitledBorder("Control"));
        this.playButtonRunIcon = SwingUtils.createImageIcon(this.getClass(), PLAY_BUTTON_RUN_NAME, "Play Button Run");
        this.playButtonStoppedIcon = SwingUtils.createImageIcon(this.getClass(), PLAY_BUTTON_STOPPED_NAME, "Play Button Stopped");
        this.playButton = new JButton(this.playButtonRunIcon);
        this.playButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anActionEvent) {
                DebugControlPanel.this.behavior.playPressed();
            }
        });
        this.playButton.setToolTipText(this.buildButtonTooltip(PLAY_BUTTON_RUN_TOOLTIP, 122, 0));
        controlPanel.add(this.playButton);
        ImageIcon icon = SwingUtils.createImageIcon(this.getClass(), STEP_BUTTON_NAME, "Step Button");
        this.stepButton = new JButton(icon);
        this.stepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anActionEvent) {
                DebugControlPanel.this.behavior.stepPressed();
            }
        });
        this.stepButton.setToolTipText(this.buildButtonTooltip(STEP_BUTTON_TOOLTIP, 117, 0));
        controlPanel.add(this.stepButton);
        icon = SwingUtils.createImageIcon(this.getClass(), REPLAY_BUTTON_NAME, "Replay Button");
        this.replayButton = new JButton(icon);
        this.replayButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anActionEvent) {
                DebugControlPanel.this.behavior.replayPressed();
            }
        });
        this.replayButton.setToolTipText(this.buildButtonTooltip(REPLAY_BUTTON_TOOLTIP, 118, 0));
        controlPanel.add(this.replayButton);
        icon = SwingUtils.createImageIcon(this.getClass(), SUSPEND_BUTTON_NAME, "Stop Button");
        this.suspendButton = new JButton(icon);
        this.suspendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anActionEvent) {
                DebugControlPanel.this.behavior.suspendPressed();
            }
        });
        this.suspendButton.setToolTipText(this.buildButtonTooltip(SUSPEND_BUTTON_TOOLTIP, 114, 0));
        controlPanel.add(this.suspendButton);
        icon = SwingUtils.createImageIcon(this.getClass(), END_BUTTON_NAME, "End Button");
        this.endButton = new JButton(icon);
        this.endButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anActionEvent) {
                DebugControlPanel.this.behavior.endPressed();
            }
        });
        controlPanel.add(this.endButton);
        this.endButton.setToolTipText(this.buildButtonTooltip(END_BUTTON_TOOLTIP, 113, DebugWindow.END_GLOBAL_ACCELERATOR_MODIFIERS));
        return controlPanel;
    }

    protected String buildButtonTooltip(String aTooltipText, int aGlobalAcceleratorCode, int aGlobalAcceleratorModifiers) {
        String modifierText = KeyEvent.getKeyModifiersText(aGlobalAcceleratorModifiers);
        String keycodeText = KeyEvent.getKeyText(aGlobalAcceleratorCode);
        if (modifierText == null || modifierText.length() == 0) {
            return aTooltipText + " [" + keycodeText + "]";
        }
        return aTooltipText + " [" + modifierText + '+' + keycodeText + "]";
    }

    protected JPanel getSpeedPanel() {
        JPanel speedPanel = new JPanel();
        speedPanel.setLayout(new BoxLayout(speedPanel, 0));
        speedPanel.setBorder(BorderFactory.createTitledBorder("Speed"));
        final DocumentFilter documentFilter = new DocumentFilter(){

            public void insertString(DocumentFilter.FilterBypass aFilterBypass, int anOffset, String aString, AttributeSet anAttributeSet) throws BadLocationException {
                int length = aFilterBypass.getDocument().getLength() + aString.length();
                if (this.checkString(aString, length)) {
                    super.insertString(aFilterBypass, anOffset, aString, anAttributeSet);
                    this.synchronize();
                }
            }

            public void replace(DocumentFilter.FilterBypass aFilterBypass, int anOffset, int aLength, String aString, AttributeSet anAttributeSet) throws BadLocationException {
                int length = aFilterBypass.getDocument().getLength() + aString.length() - aLength;
                if (this.checkString(aString, length)) {
                    super.replace(aFilterBypass, anOffset, aLength, aString, anAttributeSet);
                    this.synchronize();
                }
            }

            public void remove(DocumentFilter.FilterBypass aFilterBypass, int anOffset, int aLength) throws BadLocationException {
            }

            protected boolean checkString(String aString, int aLength) {
                return aString.matches(DebugControlPanel.SPEED_REGEXP) && aLength <= 1;
            }

            protected void synchronize() {
                try {
                    DebugControlPanel.this.speedTextField.commitEdit();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                DebugControlPanel.this.speedTextField.selectAll();
                DebugControlPanel.this.speedSlider.setValue((Integer)DebugControlPanel.this.speedTextField.getValue());
            }
        };
        DefaultFormatter formatter = new DefaultFormatter(){

            public DocumentFilter getDocumentFilter() {
                return documentFilter;
            }
        };
        formatter.setValueClass(Integer.class);
        formatter.setCommitsOnValidEdit(true);
        formatter.setOverwriteMode(true);
        this.speedTextField = new JFormattedTextField(formatter){

            public void setCaretPosition(int aPosition) {
                super.setCaretPosition(0);
                this.moveCaretPosition(this.getDocument().getLength());
            }

            public void select(int selectionStart, int selectionEnd) {
            }

            public void selectAll() {
                this.setCaretPosition(0);
            }
        };
        this.speedTextField.setColumns(1);
        this.speedTextField.setHorizontalAlignment(4);
        this.speedTextField.setValue(5);
        this.speedTextField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent aPropertyChangeEvent) {
                if ("value".equals(aPropertyChangeEvent.getPropertyName())) {
                    DebugControlPanel.this.getEmulator().setSpeed((Integer)DebugControlPanel.this.speedTextField.getValue());
                }
            }
        });
        speedPanel.add(this.speedTextField);
        this.speedSlider = new JSlider();
        this.speedSlider.setMinimum(1);
        this.speedSlider.setMaximum(9);
        this.speedSlider.setPaintTicks(true);
        this.speedSlider.setMajorTickSpacing(1);
        this.speedSlider.setValue(5);
        this.speedSlider.setSnapToTicks(true);
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        labels.put(1, new JLabel("Slow"));
        labels.put(5, new JLabel("Normal"));
        labels.put(9, new JLabel("Fast"));
        this.speedSlider.setLabelTable(labels);
        this.speedSlider.setPaintLabels(true);
        Dimension dimension = this.speedSlider.getPreferredSize();
        dimension.width = 100;
        this.speedSlider.setMinimumSize(dimension);
        this.speedSlider.setMaximumSize(dimension);
        this.speedSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent aChangeEvent) {
                DebugControlPanel.this.speedTextField.setValue(DebugControlPanel.this.speedSlider.getValue());
            }
        });
        speedPanel.add(this.speedSlider);
        speedPanel.setMinimumSize(speedPanel.getPreferredSize());
        speedPanel.setMaximumSize(speedPanel.getPreferredSize());
        return speedPanel;
    }

    protected void setButtonsForProgramRunning() {
        this.playButton.setEnabled(false);
        this.playButton.setIcon(this.playButtonRunIcon);
        this.stepButton.setEnabled(false);
        this.suspendButton.setEnabled(true);
        this.endButton.setEnabled(true);
    }

    protected void setButtonsForRunMode() {
        boolean programExists = this.getEmulator().getActiveProgram() != null && !this.getEmulator().getActiveProgram().isEmpty();
        this.playButton.setEnabled(programExists);
        this.playButton.setIcon(this.playButtonRunIcon);
        this.playButton.setToolTipText(this.buildButtonTooltip(PLAY_BUTTON_RUN_TOOLTIP, 122, 0));
        this.stepButton.setEnabled(programExists);
        this.replayButton.setEnabled(false);
        this.suspendButton.setEnabled(false);
        this.endButton.setEnabled(false);
    }

    protected void setButtonsForStoppedMode() {
        this.playButton.setEnabled(true);
        this.playButton.setIcon(this.playButtonStoppedIcon);
        this.playButton.setToolTipText(this.buildButtonTooltip(PLAY_BUTTON_STOPPED_TOOLTIP, 122, 0));
        this.stepButton.setEnabled(true);
        this.replayButton.setEnabled(false);
        this.suspendButton.setEnabled(false);
        this.endButton.setEnabled(true);
    }

    protected void setButtonsForInputMode() {
        this.playButton.setEnabled(false);
        this.stepButton.setEnabled(false);
        this.replayButton.setEnabled(false);
        this.suspendButton.setEnabled(false);
        this.endButton.setEnabled(true);
    }

    protected void setButtonsForErrorMode() {
        this.playButton.setEnabled(false);
        this.stepButton.setEnabled(false);
        this.replayButton.setEnabled(false);
        this.suspendButton.setEnabled(false);
        this.endButton.setEnabled(false);
    }

    protected void setBehavior(DebugControlPanelBehavior aBehavior) {
        this.behavior = aBehavior;
    }

    public boolean isDebugActive() {
        return this.behavior.isDebugActive();
    }

    public void stopProgram() {
        this.behavior.stopProgram();
    }

    public void contProgram() {
        this.behavior.contProgram();
    }

    public void stepInProgram() {
        this.behavior.stepInProgram();
    }

    public void debugAndStepActiveProgram() {
        this.behavior.debugAndStepActiveProgram();
    }

    public void nextLoop(Variable aVariable) {
        this.behavior.nextLoop(aVariable);
    }

    public void endLoop(Variable aVariable) {
        this.behavior.endLoop(aVariable);
    }

    public void suspendProgram() {
        this.behavior.suspendProgram();
    }

    public void resumeProgram() {
        this.behavior.resumeProgram();
    }

    public void endProgram() {
        this.behavior.endProgram();
    }

    public void loadProgram(int aProgramIndex) {
        this.setButtonsForRunMode();
        this.programEndedOnStep = false;
    }

    public void clearProgram(int aProgramIndex) {
        this.setButtonsForRunMode();
        this.programEndedOnStep = false;
    }

    public void setActiveProgramIndex(int aProgramIndex) {
        this.setButtonsForRunMode();
        this.programEndedOnStep = false;
    }

    public void allClear() {
        this.setButtonsForRunMode();
        this.programEndedOnStep = false;
    }

    public void home() {
    }

    public void cont() {
    }

    public void endScroll() {
    }

    public void endWaitAfterPrint() {
    }

    public void cancelWaitAfterPrint() {
    }

    public void enterString(String aString) {
    }

    public void execute(String aString) {
        this.programEndedOnStep = false;
    }

    public void input(String anInputPrompt) {
        this.behavior.input(anInputPrompt);
    }

    public void reportFx702pError(Fx702pException anError) {
        this.setButtonsForErrorMode();
    }

    public void resultPrinted() {
    }

    public void startMultiLinePrint() {
    }

    public void endMultiLinePrint() {
    }

    public void runProgram() {
        this.behavior.runProgram();
    }

    public void setRunMode() {
        this.behavior.setRunMode();
    }

    public void setWrtMode() {
    }

    public void startScroll() {
    }

    public void stop() {
    }

    public void waitAfterPrint(int aPrintWait, Command aCommand) {
    }

    public void stepOrStart() {
        this.behavior.stepPressed();
    }

    public void replay() {
        this.behavior.replayPressed();
    }

    protected boolean confirmDebugAndStep() {
        int answer = JOptionPane.showConfirmDialog(this.debugWindow, "Program just ended. Restart debug?", "Confirmation", 0);
        return answer == 0;
    }

    protected class ReplayBehavior
    extends ProgramRunningModeBehavior {
        protected ReplayBehavior() {
        }

        public void nextLoop(Variable aVariable) {
        }

        public void endLoop(Variable aVariable) {
            if (aVariable.equals(DebugControlPanel.this.lastNextVariable)) {
                DebugControlPanel.this.getEmulator().suspendProgram();
            }
        }

        public void resumeProgram() {
            DebugControlPanel.this.playButton.setEnabled(false);
            DebugControlPanel.this.playButton.setIcon(DebugControlPanel.this.playButtonRunIcon);
            DebugControlPanel.this.stepButton.setEnabled(false);
            DebugControlPanel.this.suspendButton.setEnabled(true);
            DebugControlPanel.this.endButton.setEnabled(true);
        }
    }

    protected class ProgramSuspendedModeBehavior
    extends AbstractBehavior {
        protected ProgramSuspendedModeBehavior() {
        }

        public void playPressed() {
            DebugControlPanel.this.lastStepWasNext = false;
            DebugControlPanel.this.getEmulator().resumeProgram();
        }

        public void stepPressed() {
            DebugControlPanel.this.lastStepWasNext = false;
            DebugControlPanel.this.getEmulator().stepInProgram();
        }

        public void endProgram() {
            super.endProgram();
            DebugControlPanel.this.programEndedOnStep = true;
        }

        public void contProgram() {
            DebugControlPanel.this.lastStepWasNext = false;
            DebugControlPanel.this.setButtonsForStoppedMode();
            DebugControlPanel.this.debugWindow.toFront();
            super.contProgram();
        }

        public void suspendProgram() {
            DebugControlPanel.this.replayButton.setEnabled(DebugControlPanel.this.lastStepWasNext);
        }

        public void replayPressed() {
            DebugControlPanel.this.lastStepWasNext = false;
            DebugControlPanel.this.replayButton.setEnabled(false);
            DebugControlPanel.this.setBehavior(DebugControlPanel.this.REPLAY_BEHAVIOR);
            DebugControlPanel.this.getEmulator().resumeProgram();
        }

        public void nextLoop(Variable aVariable) {
            DebugControlPanel.this.lastStepWasNext = true;
            DebugControlPanel.this.lastNextVariable = aVariable;
        }
    }

    protected class ProgramStoppedModeBehavior
    extends AbstractBehavior {
        protected ProgramStoppedModeBehavior() {
        }

        public void playPressed() {
            DebugControlPanel.this.getEmulator().contProgram();
        }

        public void stepPressed() {
            DebugControlPanel.this.getEmulator().stepInProgram();
        }

        public void stepInProgram() {
            DebugControlPanel.this.setBehavior(DebugControlPanel.this.PROGRAM_SUSPENDED_BEHAVIOR);
        }

        public void setRunMode() {
            super.endProgram();
            DebugControlPanel.this.programEndedOnStep = false;
        }
    }

    protected class ProgramRunningModeBehavior
    extends AbstractBehavior {
        protected ProgramRunningModeBehavior() {
        }

        public void suspendPressed() {
            DebugControlPanel.this.getEmulator().suspendProgram();
        }

        public void endProgram() {
            super.endProgram();
            DebugControlPanel.this.programEndedOnStep = true;
        }

        public void setRunMode() {
            super.endProgram();
            DebugControlPanel.this.programEndedOnStep = false;
        }
    }

    protected class RunModeBehavior
    extends AbstractBehavior {
        protected RunModeBehavior() {
        }

        public void playPressed() {
            DebugControlPanel.this.getEmulator().debugActiveProgram();
        }

        public void stepPressed() {
            if (DebugControlPanel.this.programEndedOnStep) {
                if (DebugControlPanel.this.confirmDebugAndStep()) {
                    DebugControlPanel.this.programEndedOnStep = false;
                    DebugControlPanel.this.getEmulator().debugAndStepActiveProgram();
                }
            } else {
                DebugControlPanel.this.getEmulator().debugAndStepActiveProgram();
            }
        }

        public boolean isDebugActive() {
            return false;
        }
    }

    protected abstract class AbstractBehavior
    implements DebugControlPanelBehavior {
        protected AbstractBehavior() {
        }

        public void playPressed() {
        }

        public void suspendPressed() {
        }

        public void stepPressed() {
        }

        public void replayPressed() {
        }

        public void endPressed() {
            DebugControlPanel.this.getEmulator().endProgram();
            DebugControlPanel.this.programEndedOnStep = false;
        }

        public void runProgram() {
            DebugControlPanel.this.setButtonsForProgramRunning();
            DebugControlPanel.this.setBehavior(DebugControlPanel.this.PROGRAM_RUNNING_BEHAVIOR);
        }

        public void contProgram() {
            this.resumeProgram();
        }

        public void stopProgram() {
            DebugControlPanel.this.setButtonsForStoppedMode();
            DebugControlPanel.this.setBehavior(DebugControlPanel.this.PROGRAM_STOPPED_BEHAVIOR);
        }

        public void suspendProgram() {
            DebugControlPanel.this.setButtonsForStoppedMode();
            DebugControlPanel.this.setBehavior(DebugControlPanel.this.PROGRAM_SUSPENDED_BEHAVIOR);
        }

        public void resumeProgram() {
            DebugControlPanel.this.setButtonsForProgramRunning();
            DebugControlPanel.this.setBehavior(DebugControlPanel.this.PROGRAM_RUNNING_BEHAVIOR);
        }

        public void endProgram() {
            DebugControlPanel.this.setButtonsForRunMode();
            DebugControlPanel.this.setBehavior(DebugControlPanel.this.RUN_MODE_BEHAVIOR);
        }

        public void setRunMode() {
        }

        public void input(String anInputPrompt) {
            DebugControlPanel.this.setButtonsForInputMode();
            DebugControlPanel.this.debugWindow.getSwingKeyboardAndDisplay().getMainFrame().toFront();
        }

        public void disableDebugging() {
            DebugControlPanel.this.playButton.setEnabled(false);
            DebugControlPanel.this.playButton.setIcon(DebugControlPanel.this.playButtonRunIcon);
            DebugControlPanel.this.stepButton.setEnabled(false);
            DebugControlPanel.this.suspendButton.setEnabled(false);
            DebugControlPanel.this.endButton.setEnabled(false);
        }

        public void stepInProgram() {
        }

        public void debugAndStepActiveProgram() {
            this.runProgram();
        }

        public void nextLoop(Variable aVariable) {
        }

        public void endLoop(Variable aVariable) {
        }

        public boolean isDebugActive() {
            return true;
        }
    }

    protected static interface DebugControlPanelBehavior {
        public void playPressed();

        public void suspendPressed();

        public void endPressed();

        public void stepPressed();

        public void replayPressed();

        public void runProgram();

        public void stopProgram();

        public void contProgram();

        public void endProgram();

        public void stepInProgram();

        public void debugAndStepActiveProgram();

        public void nextLoop(Variable var1);

        public void endLoop(Variable var1);

        public void suspendProgram();

        public void resumeProgram();

        public void setRunMode();

        public void input(String var1);

        public void disableDebugging();

        public boolean isDebugActive();
    }
}

