/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.swing;

import com.fx702p.emulator.Console;
import com.fx702p.emulator.Fx702pBasicLine;
import com.fx702p.emulator.Fx702pBasicProgram;
import com.fx702p.emulator.Fx702pDisplay;
import com.fx702p.emulator.Fx702pEmulator;
import com.fx702p.emulator.Fx702pKey;
import com.fx702p.emulator.Fx702pKeyboardLayout;
import com.fx702p.emulator.exceptions.Fx702pLoadingException;
import com.fx702p.emulator.implementation.Fx702pAbstractEmulatorComponent;
import com.fx702p.emulator.implementation.Fx702pDefaultEmulator;
import com.fx702p.emulator.implementation.Fx702pEmulatorComponent;
import com.fx702p.interpreters.Fx702pException;
import com.fx702p.swing.DebugWindow;
import com.fx702p.swing.Fx702pPanel;
import com.fx702p.swing.IntelligentMenu;
import com.fx702p.swing.IntelligentMenuItem;
import com.fx702p.swing.SwingConsole;
import com.fx702p.swing.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;

public class Fx702pSwingKeyboardAndDisplay
extends Fx702pAbstractEmulatorComponent
implements Runnable,
Fx702pDisplay {
    protected KeyboardAndDisplayBehavior behavior;
    protected JPopupMenu popupMenu;
    protected Fx702pPanel fx702pPanel;
    protected JFrame mainFrame;
    protected File defaultDirectory;
    protected boolean showAtStartup = false;
    protected String autoRun = null;
    protected Fx702pEmulator emulator;
    protected boolean popupMenuJustClosed = false;
    protected DebugWindow debugWindow = null;
    protected int moveToFront = 0;
    protected Fx702pKey keyPressed = null;
    protected Timer autorepeatTimer;
    protected Fx702pKey lastKeyPressed = null;
    protected SwingConsole swingConsole;
    protected final KeyboardAndDisplayBehavior RUN_MODE_BEHAVIOR = new RunModeBehavior();
    protected final KeyboardAndDisplayBehavior PROGRAM_RUNNING_BEHAVIOR = new ProgramRunningBehavior();
    protected final KeyboardAndDisplayBehavior PROGRAM_STOPPED_BEHAVIOR = new ProgramStoppedBehavior();
    protected final KeyboardAndDisplayBehavior ERROR_BEHAVIOR = new ErrorBehavior();
    protected final AutoRepeatTask AUTOREPEAT_TASK = new AutoRepeatTask();
    public static final long AUTOREPEAT_FIRST_DELAY = 1000L;
    public static final long AUTOREPEAT_DELAY = 100L;
    public static final int SPACE_BETWEEN_FRAMES = 10;
    public static final int MAX_ERROR_LINES = 10;
    public static final int SPECIAL_KEYS_MODIFIERS = 896;
    public static final String FILE_MENU = "File";
    public static final String PROGRAM_MENU = "Program";
    public static final String OPEN_MENU_ITEM = "Open File...";
    public static final String RELOAD_MENU_ITEM = "Reload";
    public static final String RELOAD_ALL_MENU_ITEM = "Reload All";
    public static final String SAVE_MENU_ITEM = "Save";
    public static final String SAVE_AS_MENU_ITEM = "Save As...";
    public static final String SAVE_ALL_MENU_ITEM = "Save All";
    public static final String SAVE_ALL_AS_MENU_ITEM = "Save All As...";
    public static final String QUIT_MENU_ITEM = "Quit";
    public static final String RUN_MENU_ITEM = "Run";
    public static final String DEBUG_MENU_ITEM = "Debug";
    public static final Fx702pFileFilter FX702P_FILE_FILTER = new Fx702pFileFilter();

    public Fx702pSwingKeyboardAndDisplay(String[] theArguments) {
        if (theArguments.length == 1) {
            this.autoRun = theArguments[0];
        } else if (theArguments.length == 2 && "-show".equals(theArguments[0])) {
            this.showAtStartup = true;
            this.autoRun = theArguments[1];
        }
        this.setLookAndFeel();
        this.swingConsole = new SwingConsole(this);
        this.buildMenuBar(this.swingConsole);
        Console.setImplementation(this.swingConsole);
        this.setInitialBehavior();
        this.emulator = new Fx702pDefaultEmulator(this);
    }

    public Fx702pEmulator getEmulator() {
        return this.emulator;
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    public SwingConsole getConsole() {
        return this.swingConsole;
    }

    protected void setBehavior(KeyboardAndDisplayBehavior aBehavior) {
        this.behavior = aBehavior;
    }

    protected void setInitialBehavior() {
        this.setBehavior(this.RUN_MODE_BEHAVIOR);
    }

    protected void setLookAndFeel() {
        if (!SwingUtils.isMacOSX()) {
            for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equalsIgnoreCase(laf.getName())) continue;
                try {
                    UIManager.setLookAndFeel(laf.getClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void run() {
        try {
            this.mainFrame = new JFrame("Fx702p Emulator");
            this.fx702pPanel = new Fx702pPanel(this);
            JPanel panel = new JPanel();
            panel.add(this.fx702pPanel);
            panel.setLayout(new BoxLayout(panel, 1));
            this.mainFrame.getRootPane().setContentPane(panel);
            this.buildPopupMenu();
            this.buildMenuBar(this.mainFrame);
            this.mainFrame.setResizable(false);
            this.mainFrame.pack();
            this.mainFrame.setSize(this.mainFrame.getPreferredSize());
            this.mainFrame.setDefaultCloseOperation(3);
            this.mainFrame.addWindowListener(new WindowAdapter(){

                public void windowActivated(WindowEvent aWindowEvent) {
                    if (Fx702pSwingKeyboardAndDisplay.this.moveToFront == 0) {
                        if (Fx702pSwingKeyboardAndDisplay.this.debugWindow != null && Fx702pSwingKeyboardAndDisplay.this.debugWindow.isVisible() && !Fx702pSwingKeyboardAndDisplay.this.debugWindow.isActive()) {
                            Fx702pSwingKeyboardAndDisplay.this.debugWindow.toFront();
                            Fx702pSwingKeyboardAndDisplay.this.mainFrame.toFront();
                            Fx702pSwingKeyboardAndDisplay.this.moveToFront = 2;
                        }
                    } else {
                        --Fx702pSwingKeyboardAndDisplay.this.moveToFront;
                    }
                }
            });
            this.mainFrame.setIconImage(this.fx702pPanel.getIcon());
            this.mainFrame.setVisible(true);
            Thread emulatorThread = new Thread((Runnable)this.emulator, "Emulator");
            emulatorThread.start();
            if (this.autoRun != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            File autoRunFile = new File(Fx702pSwingKeyboardAndDisplay.this.autoRun);
                            if (autoRunFile.exists()) {
                                Fx702pSwingKeyboardAndDisplay.this.emulator.loadProgram(autoRunFile);
                            }
                            if (Fx702pSwingKeyboardAndDisplay.this.showAtStartup) {
                                Fx702pSwingKeyboardAndDisplay.this.showProgram(Fx702pSwingKeyboardAndDisplay.this.emulator.getActiveProgram(), Fx702pSwingKeyboardAndDisplay.this.emulator.getActiveProgramIndex());
                                Fx702pSwingKeyboardAndDisplay.this.moveToFront = 2;
                                Fx702pSwingKeyboardAndDisplay.this.mainFrame.toFront();
                            } else {
                                Fx702pSwingKeyboardAndDisplay.this.emulator.runActiveProgram();
                            }
                        }
                        catch (Throwable throwable) {
                            Fx702pSwingKeyboardAndDisplay.this.reportError("Cannot start autorun program file " + Fx702pSwingKeyboardAndDisplay.this.autoRun, null, throwable);
                            throwable.printStackTrace(System.err);
                        }
                    }
                });
            }
        }
        catch (Throwable throwable) {
            this.reportError("Cannot start ", null, throwable);
        }
    }

    public boolean isEmpty() {
        return this.fx702pPanel.isEmpty();
    }

    public void setConsolePosition(SwingConsole aConsole) {
        Rectangle mainFrameBounds = this.mainFrame.getBounds();
        Dimension consoleSize = aConsole.getSize();
        Rectangle maximumWindowBounds = this.getMaximumWindowBounds(this.mainFrame);
        int spaceBelow = maximumWindowBounds.height - maximumWindowBounds.y - mainFrameBounds.y - mainFrameBounds.height;
        if (consoleSize.height + 10 < spaceBelow) {
            aConsole.setLocation(mainFrameBounds.x, mainFrameBounds.y + mainFrameBounds.height + 10);
        } else {
            int spaceAbove = mainFrameBounds.y - maximumWindowBounds.y;
            if (spaceAbove - consoleSize.height - 10 >= 0) {
                aConsole.setLocation(mainFrameBounds.x, mainFrameBounds.y - consoleSize.height - 10);
            } else {
                if (spaceBelow > spaceAbove) {
                    aConsole.setLocation(mainFrameBounds.x, mainFrameBounds.y + mainFrameBounds.height + 10);
                } else {
                    aConsole.setLocation(mainFrameBounds.x, mainFrameBounds.y - consoleSize.height - 10);
                }
                aConsole.setSize(aConsole.getPreferredSize().width, Math.max(spaceBelow, spaceAbove) - 10);
            }
        }
    }

    public void setDebugWindowPosition(JFrame aDebugWindow) {
        int x;
        Rectangle mainFrameBounds = this.mainFrame.getBounds();
        Dimension basicSourceCodeWindowSize = aDebugWindow.getSize();
        Rectangle maximumWindowBounds = this.getMaximumWindowBounds(this.mainFrame);
        int spaceLeft = mainFrameBounds.x - maximumWindowBounds.x;
        int spaceRight = maximumWindowBounds.width - maximumWindowBounds.x - mainFrameBounds.x - mainFrameBounds.width;
        int y = Math.max(maximumWindowBounds.y, mainFrameBounds.y - Math.max(0, mainFrameBounds.y + basicSourceCodeWindowSize.height - maximumWindowBounds.height));
        int width = basicSourceCodeWindowSize.width;
        int height = basicSourceCodeWindowSize.height;
        if (spaceRight > spaceLeft) {
            if (spaceRight < basicSourceCodeWindowSize.width + 10) {
                width = spaceRight - 10;
            }
            x = mainFrameBounds.x + mainFrameBounds.width + 10;
        } else {
            if (spaceLeft < basicSourceCodeWindowSize.width + 10) {
                width = spaceLeft - 10;
            }
            x = mainFrameBounds.x - basicSourceCodeWindowSize.width - 10;
        }
        if (x + width > maximumWindowBounds.width) {
            width = maximumWindowBounds.width - x;
        }
        if (y + height > maximumWindowBounds.height) {
            height = maximumWindowBounds.height - y;
        }
        aDebugWindow.setBounds(x, y, width, height);
    }

    protected Rectangle getMaximumWindowBounds(JFrame aFrame) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle maximumWindowBounds = graphicsEnvironment.getMaximumWindowBounds();
        return maximumWindowBounds;
    }

    protected void buildMenuBar(JFrame aFrame) {
        int acceleratorMask = SwingUtils.getAcceleratorMaskForCurrentPlatform();
        JMenuBar menuBar = new JMenuBar();
        IntelligentMenu fileMenu = new IntelligentMenu(FILE_MENU);
        menuBar.add(fileMenu);
        IntelligentMenuItem openMenuItem = this.buildOpenMenuItem();
        openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, acceleratorMask));
        fileMenu.add(openMenuItem);
        IntelligentMenuItem reloadMenuItem = this.buildReloadMenuItem();
        reloadMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, acceleratorMask));
        fileMenu.add(reloadMenuItem);
        IntelligentMenuItem reloadAllMenuItem = this.buildReloadAllMenuItem();
        fileMenu.add(reloadAllMenuItem);
        IntelligentMenuItem saveMenuItem = this.buildSaveMenuItem();
        saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, acceleratorMask));
        fileMenu.add(saveMenuItem);
        IntelligentMenuItem saveAsMenuItem = this.buildSaveAsMenuItem();
        fileMenu.add(saveAsMenuItem);
        IntelligentMenuItem saveAllMenuItem = this.buildSaveAllMenuItem();
        fileMenu.add(saveAllMenuItem);
        IntelligentMenuItem saveAllAsMenuItem = this.buildSaveAllAsMenuItem();
        fileMenu.add(saveAllAsMenuItem);
        fileMenu.addSeparator();
        IntelligentMenuItem quitMenuItem = this.buildQuitMenuItem();
        quitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, acceleratorMask));
        fileMenu.add(quitMenuItem);
        fileMenu.addMenuListener(new MenuEnablingListener());
        IntelligentMenu programMenu = new IntelligentMenu(PROGRAM_MENU);
        menuBar.add(programMenu);
        IntelligentMenuItem runMenuItem = this.buildRunMenuItem();
        runMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, acceleratorMask));
        programMenu.add(runMenuItem);
        IntelligentMenuItem debugMenuItem = this.buildDebugMenuItem();
        debugMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, acceleratorMask));
        programMenu.add(debugMenuItem);
        programMenu.addMenuListener(new MenuEnablingListener());
        aFrame.setJMenuBar(menuBar);
    }

    protected void buildPopupMenu() {
        this.popupMenu = SwingUtils.buildPopupMenu(this.mainFrame, this.fx702pPanel, new MouseAdapter(){

            public void mousePressed(MouseEvent aMouseEvent) {
                Fx702pSwingKeyboardAndDisplay.this.processMousePressed(aMouseEvent);
            }

            public void mouseReleased(MouseEvent aMouseEvent) {
                Fx702pSwingKeyboardAndDisplay.this.processMouseReleased(aMouseEvent);
            }
        });
        this.popupMenu.add(this.buildOpenMenuItem());
        this.popupMenu.add(this.buildReloadMenuItem());
        this.popupMenu.add(this.buildReloadAllMenuItem());
        this.popupMenu.add(this.buildSaveMenuItem());
        this.popupMenu.add(this.buildSaveAsMenuItem());
        this.popupMenu.add(this.buildSaveAllMenuItem());
        this.popupMenu.add(this.buildSaveAllAsMenuItem());
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.buildRunMenuItem());
        this.popupMenu.add(this.buildDebugMenuItem());
    }

    protected void processMousePressed(MouseEvent aMouseEvent) {
        Point keyCoordinates = this.fx702pPanel.getKeyCoordinates(aMouseEvent.getX(), aMouseEvent.getY());
        if (keyCoordinates != null) {
            this.keyPressed = Fx702pKeyboardLayout.getKey(keyCoordinates.x, keyCoordinates.y);
            this.fx702pPanel.keyPressed(this.keyPressed, keyCoordinates);
            this.emulator.keyPressed(this.keyPressed);
            this.startAutorepeat();
        } else {
            this.keyPressed = null;
        }
    }

    protected void processMouseReleased(MouseEvent aMouseEvent) {
        this.cancelAutorepeat();
        if (this.keyPressed != null) {
            Point keyCoordinates = this.fx702pPanel.getKeyCoordinates(aMouseEvent.getX(), aMouseEvent.getY());
            this.fx702pPanel.keyReleased(this.keyPressed, keyCoordinates);
            if (keyCoordinates != null) {
                this.emulator.keyReleased(this.keyPressed);
            }
            this.keyPressed = null;
        }
    }

    protected void startAutorepeat() {
        if (this.keyPressed == Fx702pKey.LEFT_ARROW || this.keyPressed == Fx702pKey.RIGHT_ARROW) {
            this.autorepeatTimer = new Timer("Autorepeat keypressed on mouse event");
            this.autorepeatTimer.schedule((TimerTask)new AutoRepeatTask(), 1000L, 100L);
        }
    }

    protected void cancelAutorepeat() {
        if (this.autorepeatTimer != null) {
            this.autorepeatTimer.cancel();
        }
    }

    public IntelligentMenuItem buildOpenMenuItem() {
        IntelligentMenuItem openMenuItem = new IntelligentMenuItem(OPEN_MENU_ITEM){

            public boolean isReallyEnabled(Point aClickPoint) {
                return !Fx702pSwingKeyboardAndDisplay.this.isProgramRunning() && !Fx702pSwingKeyboardAndDisplay.this.isErrorMode();
            }
        };
        openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anActionEvent) {
                Fx702pSwingKeyboardAndDisplay.this.loadProgram();
            }
        });
        return openMenuItem;
    }

    public IntelligentMenuItem buildReloadMenuItem() {
        IntelligentMenuItem reloadMenuItem = new IntelligentMenuItem(RELOAD_MENU_ITEM){

            public boolean isReallyEnabled(Point aClickPoint) {
                return !Fx702pSwingKeyboardAndDisplay.this.isProgramRunning() && !Fx702pSwingKeyboardAndDisplay.this.isErrorMode() && Fx702pSwingKeyboardAndDisplay.this.emulator.getActiveProgram().canBeLoaded();
            }
        };
        reloadMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anActionEvent) {
                Fx702pSwingKeyboardAndDisplay.this.reloadProgram();
            }
        });
        return reloadMenuItem;
    }

    public IntelligentMenuItem buildReloadAllMenuItem() {
        IntelligentMenuItem reloadAllMenuItem = new IntelligentMenuItem(RELOAD_ALL_MENU_ITEM){

            public boolean isReallyEnabled(Point aClickPoint) {
                return !Fx702pSwingKeyboardAndDisplay.this.isProgramRunning() && !Fx702pSwingKeyboardAndDisplay.this.isErrorMode() && Fx702pSwingKeyboardAndDisplay.this.emulator.getMemory().canBeLoaded();
            }
        };
        reloadAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anActionEvent) {
                Fx702pSwingKeyboardAndDisplay.this.reloadAll();
            }
        });
        return reloadAllMenuItem;
    }

    public IntelligentMenuItem buildSaveMenuItem() {
        IntelligentMenuItem saveMenuItem = new IntelligentMenuItem(SAVE_MENU_ITEM){

            public boolean isReallyEnabled(Point aClickPoint) {
                return !Fx702pSwingKeyboardAndDisplay.this.isProgramRunning() && !Fx702pSwingKeyboardAndDisplay.this.isErrorMode() && Fx702pSwingKeyboardAndDisplay.this.emulator.getActiveProgram().canBeSaved(Fx702pSwingKeyboardAndDisplay.this.emulator.getMemory());
            }
        };
        saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anActionEvent) {
                Fx702pSwingKeyboardAndDisplay.this.saveProgram();
            }
        });
        return saveMenuItem;
    }

    public IntelligentMenuItem buildSaveAsMenuItem() {
        IntelligentMenuItem saveMenuItem = new IntelligentMenuItem(SAVE_AS_MENU_ITEM){

            public boolean isReallyEnabled(Point aClickPoint) {
                return !Fx702pSwingKeyboardAndDisplay.this.isProgramRunning() && !Fx702pSwingKeyboardAndDisplay.this.isErrorMode();
            }
        };
        saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anActionEvent) {
                Fx702pSwingKeyboardAndDisplay.this.saveAsProgram();
            }
        });
        return saveMenuItem;
    }

    public IntelligentMenuItem buildSaveAllMenuItem() {
        IntelligentMenuItem saveMenuItem = new IntelligentMenuItem(SAVE_ALL_MENU_ITEM){

            public boolean isReallyEnabled(Point aClickPoint) {
                return !Fx702pSwingKeyboardAndDisplay.this.isProgramRunning() && !Fx702pSwingKeyboardAndDisplay.this.isErrorMode() && Fx702pSwingKeyboardAndDisplay.this.emulator.getMemory().canBeSaved();
            }
        };
        saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anActionEvent) {
                Fx702pSwingKeyboardAndDisplay.this.saveAll();
            }
        });
        return saveMenuItem;
    }

    public IntelligentMenuItem buildSaveAllAsMenuItem() {
        IntelligentMenuItem saveMenuItem = new IntelligentMenuItem(SAVE_ALL_AS_MENU_ITEM){

            public boolean isReallyEnabled(Point aClickPoint) {
                return !Fx702pSwingKeyboardAndDisplay.this.isProgramRunning() && !Fx702pSwingKeyboardAndDisplay.this.isErrorMode();
            }
        };
        saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anActionEvent) {
                Fx702pSwingKeyboardAndDisplay.this.saveAllAs();
            }
        });
        return saveMenuItem;
    }

    public IntelligentMenuItem buildQuitMenuItem() {
        IntelligentMenuItem quitMenuItem = new IntelligentMenuItem(QUIT_MENU_ITEM){

            public boolean isReallyEnabled(Point aClickPoint) {
                return true;
            }
        };
        quitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anActionEvent) {
                Fx702pSwingKeyboardAndDisplay.this.quit();
            }
        });
        return quitMenuItem;
    }

    protected IntelligentMenuItem buildRunMenuItem() {
        IntelligentMenuItem runMenuItem = new IntelligentMenuItem(RUN_MENU_ITEM){

            public boolean isReallyEnabled(Point aClickPoint) {
                return Fx702pSwingKeyboardAndDisplay.this.isProgramLoaded() && !Fx702pSwingKeyboardAndDisplay.this.isProgramRunning() && !Fx702pSwingKeyboardAndDisplay.this.isErrorMode();
            }
        };
        runMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anActionEvent) {
                Fx702pSwingKeyboardAndDisplay.this.emulator.runActiveProgram();
            }
        });
        return runMenuItem;
    }

    protected IntelligentMenuItem buildDebugMenuItem() {
        IntelligentMenuItem debugMenuItem = new IntelligentMenuItem(DEBUG_MENU_ITEM){

            public boolean isReallyEnabled(Point aClickPoint) {
                return Fx702pSwingKeyboardAndDisplay.this.isProgramLoaded() && !Fx702pSwingKeyboardAndDisplay.this.isProgramRunning() && !Fx702pSwingKeyboardAndDisplay.this.isErrorMode();
            }
        };
        debugMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anActionEvent) {
                Fx702pSwingKeyboardAndDisplay.this.debugActiveProgram();
            }
        });
        return debugMenuItem;
    }

    protected void debugActiveProgram() {
        this.showProgram(this.emulator.getActiveProgram(), this.emulator.getActiveProgramIndex());
    }

    protected boolean isProgramLoaded() {
        return this.emulator.getActiveProgram().getParsedProgram() != null;
    }

    protected boolean isProgramRunning() {
        return this.behavior.isProgramRunning();
    }

    protected boolean isErrorMode() {
        return this.behavior.isErrorMode();
    }

    protected void loadProgram() {
        File programFile = this.getLoadFile();
        if (programFile != null) {
            try {
                this.emulator.loadProgram(programFile);
            }
            catch (Throwable throwable) {
                this.reportFileError(throwable);
            }
        }
    }

    public void reloadProgram() {
        try {
            this.emulator.reloadProgram();
        }
        catch (Throwable aThrowable) {
            this.reportFileError(aThrowable);
        }
    }

    public void reloadAll() {
        try {
            this.emulator.reloadAll();
        }
        catch (Throwable aThrowable) {
            this.reportFileError(aThrowable);
        }
    }

    public void saveProgram() {
        try {
            this.emulator.saveProgram();
        }
        catch (Throwable aThrowable) {
            this.reportFileError(aThrowable);
        }
    }

    public void saveAsProgram() {
        FileSaveInfos fileSaveInfos = this.getSaveFile(this.emulator.getActiveProgram().isSavingVariables(), this.emulator.getActiveProgram().isSavingBreakpoints());
        if (fileSaveInfos != null && fileSaveInfos.programFile != null && this.confirmOverwrite(fileSaveInfos.programFile)) {
            try {
                this.emulator.saveProgramAs(fileSaveInfos.programFile, fileSaveInfos.saveVariables, fileSaveInfos.saveBreakpoints);
            }
            catch (Throwable aThrowable) {
                this.reportFileError(aThrowable);
            }
        }
    }

    public void saveAll() {
        try {
            this.emulator.saveAll();
        }
        catch (Throwable aThrowable) {
            this.reportFileError(aThrowable);
        }
    }

    public void saveAllAs() {
        FileSaveInfos fileSaveInfos = this.getSaveFile(this.emulator.getMemory().isSavingVariables(), this.emulator.getMemory().isSavingBreakpoints());
        if (fileSaveInfos != null && fileSaveInfos.programFile != null && this.confirmOverwrite(fileSaveInfos.programFile)) {
            try {
                this.emulator.saveAllAs(fileSaveInfos.programFile, fileSaveInfos.saveVariables, fileSaveInfos.saveBreakpoints);
            }
            catch (Throwable aThrowable) {
                this.reportFileError(aThrowable);
            }
        }
    }

    protected boolean confirmOverwrite(File aFile) {
        return this.askConfirmation("Confirm Overwrite?", "File " + aFile.getName() + " already exists\nOverwrite?");
    }

    public void quit() {
        System.exit(0);
    }

    public File getLoadFile() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(2);
        fileChooser.setCurrentDirectory(this.getDefaultDirectory());
        fileChooser.setFileFilter(FX702P_FILE_FILTER);
        int chooserResult = fileChooser.showOpenDialog(this.mainFrame);
        if (chooserResult == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    public FileSaveInfos getSaveFile(boolean aSaveVariables, boolean aSaveBreakpoints) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(2);
        fileChooser.setCurrentDirectory(this.getDefaultDirectory());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JCheckBox saveVariablesCheckbox = new JCheckBox("Save Variables");
        saveVariablesCheckbox.setSelected(aSaveVariables);
        panel.add(saveVariablesCheckbox);
        JCheckBox saveBreakpointsCheckbox = new JCheckBox("Save Breakpoints");
        saveBreakpointsCheckbox.setSelected(aSaveBreakpoints);
        panel.add(saveBreakpointsCheckbox);
        fileChooser.setAccessory(panel);
        int chooserResult = fileChooser.showSaveDialog(this.mainFrame);
        if (chooserResult == 0) {
            File file = fileChooser.getSelectedFile();
            if (!file.getName().endsWith(".702")) {
                file = new File(file.getPath() + ".702");
            }
            return new FileSaveInfos(file, saveVariablesCheckbox.isSelected(), saveBreakpointsCheckbox.isSelected());
        }
        return null;
    }

    protected File getDefaultDirectory() {
        if (this.defaultDirectory == null) {
            String home = System.getProperty("os.name").startsWith("Windows") ? System.getProperty("HOMEPATH") : System.getProperty("HOME");
            if (home == null || home.length() == 0) {
                home = ".";
            }
            this.defaultDirectory = new File(home);
        }
        return this.defaultDirectory;
    }

    public void print(final char[] theCharactersToDisplay) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.fx702pPanel.print(theCharactersToDisplay);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        Fx702pSwingKeyboardAndDisplay.this.fx702pPanel.print(theCharactersToDisplay);
                    }
                });
            }
        }
        catch (Exception exception) {
            this.reportError("Internal error", "Unable to print", exception);
        }
    }

    public void setCursorVisible(boolean aVisibleFlag) {
        this.fx702pPanel.setCursorVisible(aVisibleFlag);
    }

    public int getCursorPosition() {
        return this.fx702pPanel.getCursorPosition();
    }

    public void setCursorPosition(int aCursorPosition) {
        this.fx702pPanel.setCursorPosition(aCursorPosition);
    }

    public void moveCursorRight() {
        this.fx702pPanel.moveCursorRight();
    }

    public void moveCursorRight(int aCount) {
        this.fx702pPanel.moveCursorRight(aCount);
    }

    public void moveCursorLeft() {
        this.fx702pPanel.moveCursorLeft();
    }

    public void moveCursorLeft(int aCount) {
        this.fx702pPanel.moveCursorLeft(aCount);
    }

    public void reportFx702pError(Fx702pException anError) {
        this.fx702pPanel.clearDisplay();
        this.fx702pPanel.setCursorVisible(false);
        this.fx702pPanel.showBusy(false);
        this.fx702pPanel.print(anError.getMessage().toCharArray());
        this.behavior.reportFx702pError(anError);
    }

    public void reportError(String aTitle, String aMessage, Throwable anError) {
        StringBuilder errorMessage = new StringBuilder();
        if (aMessage != null) {
            errorMessage.append(aMessage);
            errorMessage.append(": ");
        }
        if (anError != null) {
            if (anError.getMessage() != null) {
                errorMessage.append(anError.getMessage());
            } else {
                errorMessage.append(anError.getClass().getSimpleName());
            }
        }
        int lines = 0;
        String shortMessage = null;
        for (int i = 0; i < errorMessage.length(); ++i) {
            if (errorMessage.charAt(i) != '\n' || ++lines < 10) continue;
            shortMessage = errorMessage.substring(0, i + 1) + "...";
            break;
        }
        if (shortMessage == null) {
            shortMessage = errorMessage.toString();
        }
        JOptionPane.showMessageDialog(this.mainFrame, shortMessage, aTitle, 0);
    }

    protected void reportFileError(Throwable aThrowable) {
        if (aThrowable instanceof FileNotFoundException) {
            this.reportError("Unable to load selected file", null, aThrowable);
        } else if (aThrowable instanceof Fx702pLoadingException) {
            this.reportError("Error in selected file", null, aThrowable);
        } else if (aThrowable instanceof Fx702pException) {
            this.reportError("Syntax Error in selected file", null, aThrowable);
        } else if (aThrowable instanceof RuntimeException) {
            this.reportError("Unknown Error in selected file", null, aThrowable);
        }
    }

    public boolean askConfirmation(String aQuestion, String aDetailedQuestion) {
        return JOptionPane.showConfirmDialog(this.mainFrame, aDetailedQuestion, aQuestion, 0) == 0;
    }

    public void showPrefixes(boolean aF1Prefix, boolean aF2Prefix, boolean anArcPrefix, boolean anHypPrefix, boolean aModePrefix) {
        this.fx702pPanel.showPrefixes(aF1Prefix, aF2Prefix, anArcPrefix, anHypPrefix, aModePrefix);
    }

    public void showDeg(boolean aFlag) {
        this.fx702pPanel.showDeg(aFlag);
    }

    public void showRad(boolean aFlag) {
        this.fx702pPanel.showRad(aFlag);
    }

    public void showGrd(boolean aFlag) {
        this.fx702pPanel.showGrd(aFlag);
    }

    public void showTrace(boolean aFlag) {
        this.fx702pPanel.showTrace(aFlag);
    }

    public void showPrt(boolean aFlag) {
        this.fx702pPanel.showPrt(aFlag);
    }

    public void showRun(boolean aFlag) {
        this.fx702pPanel.showRun(aFlag);
    }

    public void showStop(boolean aFlag) {
        this.fx702pPanel.showStop(aFlag);
    }

    public void showBusy(boolean aShowBusy) {
        this.fx702pPanel.showBusy(aShowBusy);
    }

    public void showSteps(boolean aShowSteps) {
        this.fx702pPanel.showSteps(aShowSteps);
    }

    public void stop() {
        this.behavior.stop();
    }

    public void cont() {
        this.behavior.cont();
    }

    public void contProgram() {
        this.behavior.contProgram();
    }

    public void stopProgram() {
        this.behavior.stopProgram();
    }

    public void stepInProgram() {
        this.behavior.stepInProgram();
    }

    public void setRunMode() {
        this.behavior.setRunMode();
    }

    public void runProgram() {
        this.behavior.runProgram();
    }

    public void endProgram() {
        this.behavior.endProgram();
    }

    public void startScroll() {
        this.behavior.startScroll();
    }

    public void endScroll() {
        this.behavior.endScroll();
    }

    public void allClear() {
        this.behavior.allClear();
    }

    public void home() {
        this.behavior.home();
    }

    public void input(String anInputPrompt) {
        this.behavior.input(anInputPrompt);
    }

    public void showProgram(Fx702pBasicProgram aBasicProgram, int aProgramIndex) {
        if (this.debugWindow != null) {
            this.debugWindow.dispose();
        }
        this.debugWindow = new DebugWindow(aBasicProgram, this, aProgramIndex);
        this.buildMenuBar(this.debugWindow);
        this.debugWindow.setIconImage(this.fx702pPanel.getIcon());
        this.debugWindow.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent aWindowEvent) {
                if (Fx702pSwingKeyboardAndDisplay.this.moveToFront == 0) {
                    if (Fx702pSwingKeyboardAndDisplay.this.mainFrame != null && Fx702pSwingKeyboardAndDisplay.this.mainFrame.isVisible() && !Fx702pSwingKeyboardAndDisplay.this.mainFrame.isActive()) {
                        Fx702pSwingKeyboardAndDisplay.this.mainFrame.toFront();
                        Fx702pSwingKeyboardAndDisplay.this.debugWindow.toFront();
                        Fx702pSwingKeyboardAndDisplay.this.moveToFront = 2;
                    }
                } else {
                    --Fx702pSwingKeyboardAndDisplay.this.moveToFront;
                }
            }
        });
        this.debugWindow.setVisible(true);
    }

    public void select(Fx702pBasicLine aBasicLine, int aSelectionStart, int aSelectionEnd) {
        if (this.debugWindow != null) {
            this.debugWindow.select(aBasicLine, aSelectionStart, aSelectionEnd);
        }
    }

    public void clearSelection() {
        if (this.debugWindow != null) {
            this.debugWindow.clearSelection();
        }
    }

    public boolean processKey(KeyEvent aKeyEvent) {
        if (aKeyEvent.getModifiers() == SwingUtils.getDefaultModifierForCurrentPlatform()) {
            return false;
        }
        Object fx702pKey = null;
        fx702pKey = aKeyEvent.getKeyCode() == 112 ? Fx702pKey.F1 : (aKeyEvent.getKeyCode() == 113 ? Fx702pKey.F2 : (aKeyEvent.getKeyCode() == 10 ? Fx702pKey.EXE : (aKeyEvent.getKeyCode() == 37 ? Fx702pKey.LEFT_ARROW : (aKeyEvent.getKeyCode() == 39 ? Fx702pKey.RIGHT_ARROW : (aKeyEvent.getKeyCode() == 130 ? null : Fx702pKey.convertCharToFx702pKey(this.getFixedKeyEvent(aKeyEvent).getKeyChar()))))));
        if (fx702pKey != null) {
            if (aKeyEvent.getID() == 401) {
                if (this.lastKeyPressed == null || this.lastKeyPressed != fx702pKey) {
                    this.emulator.keyPressed((Fx702pKey)((Object)fx702pKey));
                    this.lastKeyPressed = fx702pKey;
                } else {
                    this.emulator.keyRepeated((Fx702pKey)((Object)fx702pKey));
                }
            } else if (aKeyEvent.getID() == 402) {
                this.emulator.keyReleased((Fx702pKey)((Object)fx702pKey));
                this.lastKeyPressed = null;
            }
            return true;
        }
        return false;
    }

    protected KeyEvent getFixedKeyEvent(KeyEvent aKeyEvent) {
        if (aKeyEvent.getModifiers() == SwingUtils.getFx702pKeyboardModifierForCurrentPlatform()) {
            int keyCode = aKeyEvent.getKeyCode();
            if (keyCode >= 65 && keyCode <= 90) {
                return new KeyEvent((Component)aKeyEvent.getSource(), aKeyEvent.getID(), aKeyEvent.getWhen(), aKeyEvent.getModifiers(), keyCode, (char)(keyCode - 65 + 1));
            }
            return aKeyEvent;
        }
        return aKeyEvent;
    }

    protected static class FileSaveInfos {
        public File programFile = null;
        public boolean saveVariables = true;
        public boolean saveBreakpoints = true;

        public FileSaveInfos(File aProgramFile, boolean aSaveVariables, boolean aSaveBreakpoints) {
            this.programFile = aProgramFile;
            this.saveVariables = aSaveVariables;
            this.saveBreakpoints = aSaveBreakpoints;
        }
    }

    public static class Fx702pFileFilter
    extends FileFilter {
        public boolean accept(File aFile) {
            if (aFile.isDirectory()) {
                return true;
            }
            return aFile.getName().endsWith(".702");
        }

        public String getDescription() {
            return "Fx702p Program Files";
        }
    }

    public class AutoRepeatTask
    extends TimerTask {
        public void run() {
            Point currentPosition = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(currentPosition, Fx702pSwingKeyboardAndDisplay.this.fx702pPanel);
            Point keyCoordinates = Fx702pSwingKeyboardAndDisplay.this.fx702pPanel.getKeyCoordinates(currentPosition.x, currentPosition.y);
            if (keyCoordinates != null) {
                Fx702pKey currentKeyPressed = Fx702pKeyboardLayout.getKey(keyCoordinates.x, keyCoordinates.y);
                if (currentKeyPressed == Fx702pSwingKeyboardAndDisplay.this.keyPressed) {
                    Fx702pSwingKeyboardAndDisplay.this.emulator.keyRepeated(Fx702pSwingKeyboardAndDisplay.this.keyPressed);
                } else {
                    Fx702pSwingKeyboardAndDisplay.this.cancelAutorepeat();
                }
            } else {
                Fx702pSwingKeyboardAndDisplay.this.cancelAutorepeat();
            }
        }
    }

    public class ErrorBehavior
    extends AbstractKeyboardAndDisplayBehavior {
        public void runProgram() {
        }

        public void endProgram() {
        }

        public void startScroll() {
            Fx702pSwingKeyboardAndDisplay.this.showBusy(true);
        }

        public void allClear() {
            Fx702pSwingKeyboardAndDisplay.this.setBehavior(Fx702pSwingKeyboardAndDisplay.this.RUN_MODE_BEHAVIOR);
        }

        public boolean isErrorMode() {
            return true;
        }
    }

    public class ScrollBehavior
    extends AbstractKeyboardAndDisplayBehavior {
        protected KeyboardAndDisplayBehavior previousBehavior;

        public ScrollBehavior(KeyboardAndDisplayBehavior aPreviousBehavior) {
            this.previousBehavior = aPreviousBehavior;
        }

        public void endScroll() {
            Fx702pSwingKeyboardAndDisplay.this.setBehavior(this.previousBehavior);
        }
    }

    public class ProgramStoppedBehavior
    extends AbstractKeyboardAndDisplayBehavior {
        public void contProgram() {
            Fx702pSwingKeyboardAndDisplay.this.showStop(false);
            Fx702pSwingKeyboardAndDisplay.this.showBusy(true);
            Fx702pSwingKeyboardAndDisplay.this.setBehavior(Fx702pSwingKeyboardAndDisplay.this.PROGRAM_RUNNING_BEHAVIOR);
        }

        public void stepInProgram() {
            this.contProgram();
        }

        public void home() {
            Fx702pSwingKeyboardAndDisplay.this.setCursorPosition(0);
        }

        public void setRunMode() {
            super.setRunMode();
            Fx702pSwingKeyboardAndDisplay.this.showStop(false);
        }
    }

    public class ProgramRunningBehavior
    extends AbstractKeyboardAndDisplayBehavior {
        public void stopProgram() {
            Fx702pSwingKeyboardAndDisplay.this.showStop(true);
            Fx702pSwingKeyboardAndDisplay.this.showBusy(false);
            Fx702pSwingKeyboardAndDisplay.this.setBehavior(Fx702pSwingKeyboardAndDisplay.this.PROGRAM_STOPPED_BEHAVIOR);
        }

        public boolean isProgramRunning() {
            return true;
        }
    }

    public class RunModeBehavior
    extends AbstractKeyboardAndDisplayBehavior {
        public void home() {
            Fx702pSwingKeyboardAndDisplay.this.setCursorPosition(0);
        }
    }

    public class AbstractKeyboardAndDisplayBehavior
    extends Fx702pAbstractEmulatorComponent
    implements KeyboardAndDisplayBehavior {
        public void runProgram() {
            Fx702pSwingKeyboardAndDisplay.this.showStop(false);
            Fx702pSwingKeyboardAndDisplay.this.showBusy(true);
            Fx702pSwingKeyboardAndDisplay.this.setBehavior(Fx702pSwingKeyboardAndDisplay.this.PROGRAM_RUNNING_BEHAVIOR);
        }

        public void endProgram() {
            Fx702pSwingKeyboardAndDisplay.this.showStop(false);
            Fx702pSwingKeyboardAndDisplay.this.showBusy(false);
            Fx702pSwingKeyboardAndDisplay.this.setBehavior(Fx702pSwingKeyboardAndDisplay.this.RUN_MODE_BEHAVIOR);
        }

        public void contProgram() {
            Fx702pSwingKeyboardAndDisplay.this.showBusy(true);
        }

        public void stopProgram() {
            Fx702pSwingKeyboardAndDisplay.this.showBusy(false);
        }

        public void startScroll() {
            Fx702pSwingKeyboardAndDisplay.this.setBehavior(new ScrollBehavior(this));
        }

        public void endScroll() {
            Fx702pSwingKeyboardAndDisplay.this.showBusy(false);
        }

        public void reportFx702pError(Fx702pException anError) {
            Fx702pSwingKeyboardAndDisplay.this.setBehavior(Fx702pSwingKeyboardAndDisplay.this.ERROR_BEHAVIOR);
        }

        public boolean isProgramRunning() {
            return false;
        }

        public boolean isErrorMode() {
            return false;
        }

        public void input(String anInputPrompt) {
            Fx702pSwingKeyboardAndDisplay.this.showBusy(false);
            Fx702pSwingKeyboardAndDisplay.this.mainFrame.toFront();
        }

        public void setRunMode() {
            Fx702pSwingKeyboardAndDisplay.this.showBusy(false);
        }
    }

    public static interface KeyboardAndDisplayBehavior
    extends Fx702pEmulatorComponent {
        public boolean isProgramRunning();

        public boolean isErrorMode();
    }

    protected static class MenuEnablingListener
    implements MenuListener {
        protected MenuEnablingListener() {
        }

        public void menuCanceled(MenuEvent aMenuEvent) {
        }

        public void menuDeselected(MenuEvent aMenuEvent) {
        }

        public void menuSelected(MenuEvent aMenuEvent) {
            SwingUtils.enableMenuItems(((JMenu)aMenuEvent.getSource()).getPopupMenu().getComponents());
        }
    }
}

