/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.swing;

import com.fx702p.swing.IntelligentMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.EventObject;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingUtils {
    public static final Color DEFAULT_SELECTION_COLOR = new Color(165, 195, 233);
    public static final Color DEFAULT_SUBSELECTION_COLOR = new Color(206, 131, 246);

    static int getAcceleratorMaskForCurrentPlatform() {
        if (SwingUtils.isMacOSX()) {
            return 256;
        }
        return 128;
    }

    static int getDefaultModifierForCurrentPlatform() {
        if (SwingUtils.isMacOSX()) {
            return 4;
        }
        return 2;
    }

    static int getFx702pKeyboardModifierForCurrentPlatform() {
        if (SwingUtils.isMacOSX()) {
            return 5;
        }
        return 3;
    }

    public static boolean isMacOSX() {
        String osName = System.getProperty("os.name");
        return osName.equals("Mac OS X");
    }

    public static ImageIcon createImageIcon(Class<?> aClass, String aPath, String aDescription) {
        URL url = aClass.getResource(aPath);
        if (url != null) {
            return new ImageIcon(url, aDescription);
        }
        System.err.println("Couldn't find file: " + aPath);
        return null;
    }

    public static Point getPopupClickPoint(EventObject anEvent) {
        if (anEvent.getSource() instanceof ExtendedPopupMenu) {
            return ((ExtendedPopupMenu)anEvent.getSource()).getClickPoint();
        }
        if (anEvent.getSource() instanceof JComponent && ((JComponent)anEvent.getSource()).getParent() instanceof ExtendedPopupMenu) {
            return ((ExtendedPopupMenu)((JComponent)anEvent.getSource()).getParent()).getClickPoint();
        }
        return null;
    }

    public static JPopupMenu buildPopupMenu(JFrame aFrame, Component aComponent) {
        return SwingUtils.buildPopupMenu(aFrame, aComponent, null);
    }

    public static ExtendedPopupMenu buildPopupMenu(Window aWindow, Component aComponent, MouseListener anExtraMouseListener) {
        ExtendedPopupMenu popupMenu = new ExtendedPopupMenu();
        SwingUtils.addPopupMenuListener(popupMenu);
        aComponent.addMouseListener(new ClickListener(popupMenu, anExtraMouseListener));
        return popupMenu;
    }

    public static void enableMenuItems(Component[] theComponents) {
        SwingUtils.enableMenuItems(theComponents, null);
    }

    public static void enableMenuItems(Component[] theComponents, Point aClickPoint) {
        for (Component component : theComponents) {
            if (!(component instanceof IntelligentMenuItem)) continue;
            component.setEnabled(((IntelligentMenuItem)component).isReallyEnabled(aClickPoint));
        }
    }

    public static void addPopupMenuListener(final JPopupMenu aPopupMenu) {
        aPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent aPopupMenuEvent) {
                if (aPopupMenu instanceof ExtendedPopupMenu) {
                    ((ExtendedPopupMenu)aPopupMenu).setPopupMenuJustClosed(true);
                }
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent aPopupMenuEvent) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent aPopupMenuEvent) {
                SwingUtils.enableMenuItems(aPopupMenu.getComponents(), SwingUtils.getPopupClickPoint(aPopupMenuEvent));
            }
        });
    }

    protected static class ExtendedPopupMenu
    extends JPopupMenu {
        protected boolean popupMenuJustClosed = false;
        protected Point clickPoint;

        protected ExtendedPopupMenu() {
        }

        public boolean isPopupMenuJustClosed() {
            return this.popupMenuJustClosed;
        }

        public void setPopupMenuJustClosed(boolean aPopupMenuJustClosed) {
            this.popupMenuJustClosed = aPopupMenuJustClosed;
        }

        public Point getClickPoint() {
            return this.clickPoint;
        }

        protected void setClickPoint(Point aClickPoint) {
            this.clickPoint = aClickPoint;
        }
    }

    protected static class ClickListener
    extends MouseAdapter {
        protected ExtendedPopupMenu popupMenu;
        protected MouseListener extraMouseListener;

        public ClickListener(ExtendedPopupMenu aPopupMenu, MouseListener anExtraMouseListener) {
            this.popupMenu = aPopupMenu;
            this.extraMouseListener = anExtraMouseListener;
        }

        public void mousePressed(MouseEvent aMouseEvent) {
            if (aMouseEvent.isPopupTrigger()) {
                this.popupMenu.setClickPoint(aMouseEvent.getPoint());
                this.popupMenu.show(aMouseEvent.getComponent(), aMouseEvent.getX(), aMouseEvent.getY());
            } else if (!this.popupMenu.isPopupMenuJustClosed() && this.extraMouseListener != null) {
                this.extraMouseListener.mousePressed(aMouseEvent);
            }
            this.popupMenu.setPopupMenuJustClosed(false);
        }

        public void mouseReleased(MouseEvent aMouseEvent) {
            if (aMouseEvent.isPopupTrigger()) {
                this.popupMenu.show(aMouseEvent.getComponent(), aMouseEvent.getX(), aMouseEvent.getY());
            } else if (this.extraMouseListener != null) {
                this.extraMouseListener.mouseReleased(aMouseEvent);
            }
        }
    }
}

