/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.Resources;
import java.util.Arrays;

public final class CalendarFromString {
    private static final String[] calendar = new String[]{"ArmenianCalendar", "BahaiCalendar", "BohemianMoravianCalendar", "BritishCalendar", "BulgarianCalendar", "ChineseCalendar", "CopticCalendar", "DanishCalendar", "EgyptianCalendar", "EthiopicCalendar", "FinnishCalendar", "FrenchRevolutionaryCalendar", "GregorianCalendar", "HebrewCalendar", "HinduLunarCalendar", "HinduSolarCalendar", "HungarianCalendar", "IslamicCalendar", "JalaliCalendar", "JulianCalendar", "LuxemburgianCalendar", "MayanCalendar", "NepaliCalendar", "PersianCalendar", "PrussianCalendar", "RomanianCalendar", "RussianCalendar", "SwissProtestantCalendar", "WorldCalendar"};
    private static final String[] localizedCalendar = CalendarFromString.initLocalizedCalendarNames();

    public static final Calendar getInstance(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException {
        if (!(string = CalendarFromString.getDepackagedCalendarName(string)).endsWith("Calendar")) {
            string = string + "Calendar";
        }
        if (Arrays.binarySearch(calendar, string) < 0) {
            throw new IllegalArgumentException(string);
        }
        string = "fi.joensuu.joyds1.calendar." + string;
        return (Calendar)Class.forName(string).newInstance();
    }

    public static final Calendar getCalendar(String string) {
        try {
            return CalendarFromString.getInstance(string);
        }
        catch (Throwable throwable) {
            System.out.println("Hupsis " + string + ": " + throwable.toString());
            return null;
        }
    }

    public static final Calendar getCalendarFromLocalizedName(String string) {
        for (int i = 0; i < calendar.length; ++i) {
            if (localizedCalendar[i].compareTo(string) != 0) continue;
            return CalendarFromString.getCalendar(calendar[i]);
        }
        return null;
    }

    public static final String[] getCalendarNames() {
        return calendar;
    }

    public static final String[] getLocalizedCalendarNames() {
        return localizedCalendar;
    }

    private CalendarFromString() {
    }

    private static final String[] initLocalizedCalendarNames() {
        String[] stringArray = new String[calendar.length];
        for (int i = 0; i < calendar.length; ++i) {
            stringArray[i] = Resources.getString(calendar[i]);
        }
        return stringArray;
    }

    public static final String getDepackagedCalendarName(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static final String getDepackagedCalendarName(Calendar calendar) {
        return CalendarFromString.getDepackagedCalendarName(calendar.getClass().getName());
    }
}

