/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar.chinese;

import java.util.Locale;
import java.util.Vector;

public final class MoonPhase {
    public static final Vector<Double> moonPhases(double d, double d2, int n) {
        Vector<Double> vector = new Vector<Double>();
        double d3 = d < 2425245.0 ? 0.32337962962962963 : 0.3333333333333333;
        double d4 = 29.53058853;
        int n2 = (int)((d - d3 - 2451550.09765 - (double)n * 7.375) / d4);
        double d5 = MoonPhase.moonPhaseByLunation(n2, n) + d3;
        while (d5 - d > 29.0) {
            d5 = MoonPhase.moonPhaseByLunation(--n2, n) + d3;
        }
        while (d > d5) {
            d5 = MoonPhase.moonPhaseByLunation(++n2, n) + d3;
        }
        vector.add(d5);
        while (d5 < d2 - 29.0) {
            if (!((d5 = MoonPhase.moonPhaseByLunation(++n2, n) + d3) < d2)) continue;
            vector.add(d5);
        }
        return vector;
    }

    private static final double moonPhaseByLunation(int n, int n2) {
        return MoonPhase.moonPhase((double)n + (double)n2 / 4.0, n2);
    }

    private static final double moonPhase(double d, int n) {
        double[] dArray = new double[15];
        double d2 = d / 1236.85;
        double d3 = 2451550.09765 + 29.530588853 * d + d2 * d2 * (1.337E-4 + d2 * (-1.5E-7 + 7.3E-10 * d2));
        double d4 = 1.0 + d2 * (-0.002516 + -7.4E-6 * d2);
        double d5 = 2.5534 + 29.10535669 * d + d2 * d2 * (-2.18E-5 + -1.1E-7 * d2);
        double d6 = 201.5643 + 385.81693528 * d + d2 * d2 * (0.0107438 + d2 * (1.239E-5 + -5.8E-8 * d2));
        double d7 = 160.7108 + 390.67050274 * d + d2 * d2 * (-0.0016341 * d2 * (-2.27E-6 + 1.1E-8 * d2));
        double d8 = 124.7746 - 1.5637558 * d + d2 * d2 * (0.0020691 + 2.15E-6 * d2);
        dArray[0] = 0.0;
        dArray[1] = 299.77 + 0.107408 * d - 0.009173 * d2 * d2;
        dArray[2] = 251.88 + 0.016321 * d;
        dArray[3] = 251.83 + 26.651886 * d;
        dArray[4] = 349.42 + 36.412478 * d;
        dArray[5] = 84.66 + 18.206239 * d;
        dArray[6] = 141.74 + 53.303771 * d;
        dArray[7] = 207.14 + 2.453732 * d;
        dArray[8] = 154.84 + 7.30686 * d;
        dArray[9] = 34.52 + 27.261239 * d;
        dArray[10] = 207.19 + 0.121824 * d;
        dArray[11] = 291.34 + 1.844379 * d;
        dArray[12] = 161.72 + 24.198154 * d;
        dArray[13] = 239.56 + 25.513099 * d;
        dArray[14] = 331.55 + 3.592518 * d;
        d5 = MoonPhase.torad(d5);
        d6 = MoonPhase.torad(d6);
        d7 = MoonPhase.torad(d7);
        d8 = MoonPhase.torad(d8);
        for (int i = 1; i <= 14; ++i) {
            dArray[i] = MoonPhase.torad(dArray[i]);
        }
        switch (n) {
            case 0: {
                d3 = d3 - 0.4072 * Math.sin(d6) + 0.17241 * d4 * Math.sin(d5) + 0.01608 * Math.sin(2.0 * d6) + 0.01039 * Math.sin(2.0 * d7) + 0.00739 * d4 * Math.sin(d6 - d5) - 0.00514 * d4 * Math.sin(d6 + d5) + 0.00208 * d4 * d4 * Math.sin(2.0 * d5) - 0.00111 * Math.sin(d6 - 2.0 * d7) - 5.7E-4 * Math.sin(d6 + 2.0 * d7) + 5.6E-4 * d4 * Math.sin(2.0 * d6 + d5) - 4.2E-4 * Math.sin(3.0 * d6) + 4.2E-4 * d4 * Math.sin(d5 + 2.0 * d7) + 3.8E-4 * d4 * Math.sin(d5 - 2.0 * d7) - 2.4E-4 * d4 * Math.sin(2.0 * d6 - d5) - 1.7E-4 * Math.sin(d8) - 7.0E-5 * Math.sin(d6 + 2.0 * d5) + 4.0E-5 * Math.sin(2.0 * d6 - 2.0 * d7) + 4.0E-5 * Math.sin(3.0 * d5) + 3.0E-5 * Math.sin(d6 + d5 - 2.0 * d7) + 3.0E-5 * Math.sin(2.0 * d6 + 2.0 * d7) - 3.0E-5 * Math.sin(d6 + d5 + 2.0 * d7) + 3.0E-5 * Math.sin(d6 - d5 + 2.0 * d7) - 2.0E-5 * Math.sin(d6 - d5 - 2.0 * d7) - 2.0E-5 * Math.sin(3.0 * d6 + d5) + 2.0E-5 * Math.sin(4.0 * d6);
                break;
            }
            case 2: {
                d3 = d3 - 0.40614 * Math.sin(d6) + 0.17302 * d4 * Math.sin(d5) + 0.01614 * Math.sin(2.0 * d6) + 0.01043 * Math.sin(2.0 * d7) + 0.00734 * d4 * Math.sin(d6 - d5) - 0.00515 * d4 * Math.sin(d6 + d5) + 0.00209 * d4 * d4 * Math.sin(2.0 * d5) - 0.00111 * Math.sin(d6 - 2.0 * d7) - 5.7E-4 * Math.sin(d6 + 2.0 * d7) + 5.6E-4 * d4 * Math.sin(2.0 * d6 + d5) - 4.2E-4 * Math.sin(3.0 * d6) + 4.2E-4 * d4 * Math.sin(d5 + 2.0 * d7) + 3.8E-4 * d4 * Math.sin(d5 - 2.0 * d7) - 2.4E-4 * d4 * Math.sin(2.0 * d6 - d5) - 1.7E-4 * Math.sin(d8) - 7.0E-5 * Math.sin(d6 + 2.0 * d5) + 4.0E-5 * Math.sin(2.0 * d6 - 2.0 * d7) + 4.0E-5 * Math.sin(3.0 * d5) + 3.0E-5 * Math.sin(d6 + d5 - 2.0 * d7) + 3.0E-5 * Math.sin(2.0 * d6 + 2.0 * d7) - 3.0E-5 * Math.sin(d6 + d5 + 2.0 * d7) + 3.0E-5 * Math.sin(d6 - d5 + 2.0 * d7) - 2.0E-5 * Math.sin(d6 - d5 - 2.0 * d7) - 2.0E-5 * Math.sin(3.0 * d6 + d5) + 2.0E-5 * Math.sin(4.0 * d6);
                break;
            }
            case 1: 
            case 3: {
                d3 = d3 - 0.62801 * Math.sin(d6) + 0.17172 * d4 * Math.sin(d5) - 0.01183 * d4 * Math.sin(d6 + d5) + 0.00862 * Math.sin(2.0 * d6) + 0.00804 * Math.sin(2.0 * d7) + 0.00454 * d4 * Math.sin(d6 - d5) + 0.00204 * d4 * d4 * Math.sin(2.0 * d5) - 0.0018 * Math.sin(d6 - 2.0 * d7) - 7.0E-4 * Math.sin(d6 + 2.0 * d7) - 4.0E-4 * Math.sin(3.0 * d6) - 3.4E-4 * d4 * Math.sin(2.0 * d6 - d5) + 3.2E-4 * d4 * Math.sin(d5 + 2.0 * d7) + 3.2E-4 * d4 * Math.sin(d5 - 2.0 * d7) - 2.8E-4 * d4 * d4 * Math.sin(d6 + 2.0 * d5) + 2.7E-4 * d4 * Math.sin(2.0 * d6 + d5) - 1.7E-4 * Math.sin(d8) - 5.0E-5 * Math.sin(d6 - d5 - 2.0 * d7) + 4.0E-5 * Math.sin(2.0 * d6 + 2.0 * d7) - 4.0E-5 * Math.sin(d6 + d5 + 2.0 * d7) + 4.0E-5 * Math.sin(d6 - 2.0 * d5) + 3.0E-5 * Math.sin(d6 + d5 - 2.0 * d7) + 3.0E-5 * Math.sin(3.0 * d5) + 2.0E-5 * Math.sin(2.0 * d6 - 2.0 * d7) + 2.0E-5 * Math.sin(d6 - d5 + 2.0 * d7) - 2.0E-5 * Math.sin(3.0 * d6 + d5);
                double d9 = 0.00306 - 3.8E-4 * d4 * Math.cos(d5) + 2.6E-4 * Math.cos(d6) - 2.0E-5 * Math.cos(d6 - d5) + 2.0E-5 * Math.cos(d6 + d5) + 2.0E-5 * Math.cos(2.0 * d7);
                if (n == 3) {
                    d9 = -d9;
                }
                d3 += d9;
                break;
            }
            default: {
                throw new IllegalArgumentException("The Moon has exploded!");
            }
        }
        d3 = d3 + 3.25E-4 * Math.sin(dArray[1]) + 1.65E-4 * Math.sin(dArray[2]) + 1.64E-4 * Math.sin(dArray[3]) + 1.26E-4 * Math.sin(dArray[4]) + 1.1E-4 * Math.sin(dArray[5]) + 6.2E-5 * Math.sin(dArray[6]) + 6.0E-5 * Math.sin(dArray[7]) + 5.6E-5 * Math.sin(dArray[8]) + 4.7E-5 * Math.sin(dArray[9]) + 4.2E-5 * Math.sin(dArray[10]) + 4.0E-5 * Math.sin(dArray[11]) + 3.7E-5 * Math.sin(dArray[12]) + 3.5E-5 * Math.sin(dArray[13]) + 2.3E-5 * Math.sin(dArray[14]);
        return d3;
    }

    private static final double torad(double d) {
        d = MoonPhase.fmod(d, 360.0);
        return d * (Math.PI / 180);
    }

    static final double fmod(double d, double d2) {
        return d - d2 * Math.floor(d / d2);
    }

    public static void main(String[] stringArray) {
        Locale.setDefault(Locale.UK);
        double d = 0.0;
        double d2 = 3000000.0;
        for (int i = 0; i < 4; ++i) {
            System.out.println("phase=" + i);
            Vector<Double> vector = MoonPhase.moonPhases(d, d2, i);
            for (int j = 0; j < vector.size(); ++j) {
                System.out.println(String.format("%10.2f", vector.get(j)));
            }
        }
    }
}

