/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar.format;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.Resources;
import fi.joensuu.joyds1.calendar.format.DateFormat;
import fi.joensuu.joyds1.calendar.format.DateFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public class SimpleDateFormat
extends DateFormat {
    private transient Vector tokens;
    private String pattern;
    private NumberFormat numberFormat;
    private DateFormatSymbols symbols;
    private Locale locale;
    private static final String patternChars = "CDdEiJLMswyYBKTUNhHzZA";

    public SimpleDateFormat(String string) {
        this(string, Locale.getDefault());
    }

    public SimpleDateFormat(String string, Locale locale) {
        this(string, Calendar.getInstance(locale), locale);
    }

    public SimpleDateFormat(String string, Calendar calendar) {
        this(string, calendar, Locale.getDefault());
    }

    public SimpleDateFormat(String string, Calendar calendar, Locale locale) {
        this.symbols = new DateFormatSymbols(calendar, locale);
        this.pattern = string;
        this.locale = locale;
        this.tokens = new Vector();
        this.compileFormat(string);
        this.numberFormat = NumberFormat.getInstance(locale);
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setParseIntegerOnly(true);
    }

    @Override
    public String format(Calendar calendar) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.tokens.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof FieldSizePair) {
                FieldSizePair fieldSizePair = (FieldSizePair)e;
                if (fieldSizePair.field == -1) {
                    throw new IllegalArgumentException(Resources.getString("format.illegal.pattern"));
                }
                switch (patternChars.charAt(fieldSizePair.field)) {
                    case 'C': {
                        this.append(stringBuffer, fieldSizePair.size, calendar.getCycle());
                        break;
                    }
                    case 'D': {
                        this.append(stringBuffer, fieldSizePair.size, calendar.getDayOfYear());
                        break;
                    }
                    case 'd': {
                        this.append(stringBuffer, fieldSizePair.size, calendar.getDay());
                        break;
                    }
                    case 'E': {
                        if (fieldSizePair.size < 3) {
                            this.append(stringBuffer, fieldSizePair.size, calendar.getDayOfWeek());
                            break;
                        }
                        if (fieldSizePair.size == 3) {
                            stringBuffer.append(this.symbols.getShortWeekdayName(calendar.getDayOfWeek()));
                            break;
                        }
                        stringBuffer.append(this.symbols.getWeekdayName(calendar.getDayOfWeek()));
                        break;
                    }
                    case 'i': {
                        this.append(stringBuffer, fieldSizePair.size, calendar.getISOYear());
                        break;
                    }
                    case 'J': {
                        this.append(stringBuffer, fieldSizePair.size, calendar.getJulianDayNumber());
                        break;
                    }
                    case 'L': {
                        stringBuffer.append(calendar.isLeapMonth());
                        break;
                    }
                    case 'M': {
                        if (fieldSizePair.size < 3) {
                            this.append(stringBuffer, fieldSizePair.size, calendar.getMonth());
                            break;
                        }
                        if (fieldSizePair.size == 3) {
                            stringBuffer.append(this.symbols.getShortMonthName(calendar.isLeapYear(), calendar.getMonth()));
                            break;
                        }
                        stringBuffer.append(this.symbols.getMonthName(calendar.isLeapYear(), calendar.getMonth()));
                        break;
                    }
                    case 's': {
                        stringBuffer.append(calendar.toString());
                        break;
                    }
                    case 'w': {
                        this.append(stringBuffer, fieldSizePair.size, calendar.getISOWeekNumber());
                        break;
                    }
                    case 'y': {
                        this.append(stringBuffer, fieldSizePair.size, calendar.getYear());
                        break;
                    }
                    case 'Y': {
                        stringBuffer.append(this.symbols.getYearName(calendar.getYear()));
                        break;
                    }
                    case 'B': {
                        this.append(stringBuffer, fieldSizePair.size, calendar.getBaktun());
                        break;
                    }
                    case 'K': {
                        this.append(stringBuffer, fieldSizePair.size, calendar.getKatun());
                        break;
                    }
                    case 'T': {
                        this.append(stringBuffer, fieldSizePair.size, calendar.getTun());
                        break;
                    }
                    case 'U': {
                        this.append(stringBuffer, fieldSizePair.size, calendar.getUinal());
                        break;
                    }
                    case 'N': {
                        this.append(stringBuffer, fieldSizePair.size, calendar.getKin());
                        break;
                    }
                    case 'h': {
                        this.append(stringBuffer, fieldSizePair.size, calendar.getHaabDay());
                        break;
                    }
                    case 'H': {
                        if (fieldSizePair.size < 3) {
                            this.append(stringBuffer, fieldSizePair.size, calendar.getHaabMonth());
                            break;
                        }
                        stringBuffer.append(this.symbols.getHaabMonthName(calendar.getHaabMonth()));
                        break;
                    }
                    case 'z': {
                        this.append(stringBuffer, fieldSizePair.size, calendar.getTzolkinDay());
                        break;
                    }
                    case 'Z': {
                        if (fieldSizePair.size < 3) {
                            this.append(stringBuffer, fieldSizePair.size, calendar.getTzolkinMonth());
                            break;
                        }
                        stringBuffer.append(this.symbols.getTzolkinMonthName(calendar.getTzolkinMonth()));
                        break;
                    }
                    case 'A': {
                        stringBuffer.append(calendar.getBaktun() + "." + calendar.getKatun() + "." + calendar.getTun() + "." + calendar.getUinal() + "." + calendar.getKin());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(Resources.getString("format.illegal.char", patternChars.charAt(fieldSizePair.field)));
                    }
                }
                continue;
            }
            stringBuffer.append(e.toString());
        }
        return stringBuffer.toString();
    }

    @Override
    public Calendar parse(String string, Calendar calendar, ParsePosition parsePosition) {
        int n = this.pattern.length();
        int n2 = -1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl9 = false;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        block12: for (int i = 0; i < n; ++i) {
            char c = this.pattern.charAt(i);
            if (c == '\'') {
                if (i < n - 1 && this.pattern.charAt(i + 1) == '\'') {
                    if (!this.expect(string, parsePosition, c)) {
                        return null;
                    }
                    ++i;
                    continue;
                }
                n2 = n2 < 0 ? i : -1;
                continue;
            }
            if (n2 != -1 || (c < 'a' || c > 'z') && (c < 'A' || c > 'Z')) {
                if (this.expect(string, parsePosition, c)) continue;
                return null;
            }
            int n14 = i;
            while (++i < n && this.pattern.charAt(i) == c) {
            }
            int n15 = i - n14;
            --i;
            this.numberFormat.setMinimumIntegerDigits(n15);
            switch (c) {
                case 'C': {
                    n3 = this.parseInteger(string, parsePosition);
                    bl = true;
                    continue block12;
                }
                case 'D': {
                    n4 = this.parseInteger(string, parsePosition);
                    bl2 = true;
                    continue block12;
                }
                case 'd': {
                    n5 = this.parseInteger(string, parsePosition);
                    bl3 = true;
                    continue block12;
                }
                case 'J': {
                    n6 = this.parseInteger(string, parsePosition);
                    bl4 = true;
                    continue block12;
                }
                case 'L': {
                    bl9 = this.parseBoolean(string, parsePosition, i);
                    bl8 = true;
                    continue block12;
                }
                case 'M': {
                    n7 = this.parseMonth(string, parsePosition, i);
                    bl5 = true;
                    continue block12;
                }
                case 'y': {
                    n8 = this.parseInteger(string, parsePosition);
                    bl6 = true;
                    continue block12;
                }
                case 'A': {
                    n9 = this.parseInteger(string, parsePosition);
                    if (!this.expect(string, parsePosition, '.')) {
                        return null;
                    }
                    n10 = this.parseInteger(string, parsePosition);
                    if (!this.expect(string, parsePosition, '.')) {
                        return null;
                    }
                    n11 = this.parseInteger(string, parsePosition);
                    if (!this.expect(string, parsePosition, '.')) {
                        return null;
                    }
                    n12 = this.parseInteger(string, parsePosition);
                    if (!this.expect(string, parsePosition, '.')) {
                        return null;
                    }
                    n13 = this.parseInteger(string, parsePosition);
                    bl7 = true;
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException(Resources.getString("format.illegal.char", c));
                }
            }
        }
        if (bl6 && bl5 && bl3 && !bl && !bl2 && !bl4 && !bl7 && !bl8) {
            calendar.set(n8, n7, n5);
            return calendar;
        }
        if (!(!bl6 || !bl2 || bl || bl3 || bl4 || bl5 || bl7 || bl8)) {
            calendar.set(n8, n4);
            return calendar;
        }
        if (!(!bl4 || bl || bl2 || bl3 || bl5 || bl6 || bl7 || bl8)) {
            calendar.set(n6);
            return calendar;
        }
        if (!(!bl7 || bl || bl2 || bl3 || bl4 || bl5 || bl6 || bl8)) {
            calendar.set(n9, n10, n11, n12, n13);
            return calendar;
        }
        if (bl && bl6 && bl5 && bl3 && bl8 && !bl2 && !bl4 && !bl7) {
            calendar.set(n3, n8, n7, n5, bl9);
            return calendar;
        }
        if (bl6 && bl5 && bl3 && bl8 && !bl && !bl2 && !bl4 && !bl7) {
            calendar.set(n8, n7, n5, bl9);
            return calendar;
        }
        return null;
    }

    private final int parseInteger(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        Number number = this.numberFormat.parse(string, parsePosition);
        if (n == parsePosition.getIndex()) {
            throw new IllegalArgumentException(Resources.getString("format.no.date", string));
        }
        return number.intValue();
    }

    private void compileFormat(String string) {
        FieldSizePair fieldSizePair = null;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n = patternChars.indexOf(c);
            if (n == -1) {
                fieldSizePair = null;
                if (Character.isLetter(c)) {
                    this.tokens.addElement(new FieldSizePair(-1, 0));
                    continue;
                }
                if (c == '\'') {
                    int n2 = string.indexOf(39, i + 1);
                    if (n2 == -1) {
                        throw new IllegalArgumentException(Resources.getString("format.no.single.quote"));
                    }
                    if (n2 + 1 < string.length() && string.charAt(n2 + 1) == '\'') {
                        this.tokens.addElement(string.substring(i + 1, n2 + 1));
                    } else {
                        this.tokens.addElement(string.substring(i + 1, n2));
                    }
                    i = n2;
                    continue;
                }
                this.tokens.addElement(new Character(c));
                continue;
            }
            if (fieldSizePair != null && n == fieldSizePair.field) {
                ++fieldSizePair.size;
                continue;
            }
            fieldSizePair = new FieldSizePair(n, 1);
            this.tokens.addElement(fieldSizePair);
        }
    }

    private void append(StringBuffer stringBuffer, int n, int n2) {
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(n2);
        for (int i = stringBuffer2.length(); i < n; ++i) {
            stringBuffer.append("0");
        }
        stringBuffer.append(stringBuffer2);
    }

    private final boolean expect(String string, ParsePosition parsePosition, char c) {
        boolean bl;
        int n = parsePosition.getIndex();
        boolean bl2 = bl = n < string.length() && string.charAt(n) == c;
        if (bl) {
            parsePosition.setIndex(n + 1);
        } else {
            parsePosition.setErrorIndex(n);
        }
        return bl;
    }

    private final boolean parseBoolean(String string, ParsePosition parsePosition, int n) {
        String string2 = this.parseString(string, parsePosition, n);
        if (string2.compareTo("true") == 0) {
            return true;
        }
        if (string2.compareTo("false") == 0) {
            return false;
        }
        throw new IllegalArgumentException(Resources.getString("format.not.boolean", string2));
    }

    private final int parseMonth(String string, ParsePosition parsePosition, int n) {
        if (this.isDigit(string, parsePosition)) {
            return this.parseInteger(string, parsePosition);
        }
        String string2 = this.parseString(string, parsePosition, n);
        return this.findMonthNumber(string2);
    }

    private final String parseString(String string, ParsePosition parsePosition, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = parsePosition.getIndex(); n2 < string.length() && (this.pattern.length() == n + 1 || string.charAt(n2) != this.pattern.charAt(n + 1)); ++n2) {
            stringBuffer.append(string.charAt(n2));
        }
        parsePosition.setIndex(n2);
        return stringBuffer.toString();
    }

    private final int findMonthNumber(String string) {
        if (this.locale.getLanguage().compareTo("fi") == 0 && this.locale.getCountry().compareTo("FI") == 0 && string.endsWith("ta")) {
            string = string.substring(0, string.length() - 2);
        }
        String[] stringArray = this.symbols.getMonthNamesForLeapYears();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].compareTo(string) != 0) continue;
            return i + 1;
        }
        throw new IllegalArgumentException(Resources.getString("format.incorrect.month.name", string));
    }

    private final boolean isDigit(String string, ParsePosition parsePosition) {
        switch (string.charAt(parsePosition.getIndex())) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    private class FieldSizePair {
        public int field;
        public int size;

        public FieldSizePair(int n, int n2) {
            this.field = n;
            this.size = n2;
        }
    }
}

