/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar.test;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.GregorianCalendar;
import fi.joensuu.joyds1.calendar.format.DateFormat;
import fi.joensuu.joyds1.calendar.format.SimpleDateFormat;

public class TestCalendar {
    private static final DateFormat f = new SimpleDateFormat("yyyy-MM-dd DDD J");

    public static void test1(Calendar calendar, Calendar calendar2, int n) {
        try {
            for (int i = 0; i < n; ++i) {
                calendar2.set(calendar.getYear(), calendar.getDayOfYear());
                TestCalendar.compare(calendar, calendar2);
                calendar2.set(calendar.getJulianDayNumber());
                TestCalendar.compare(calendar, calendar2);
                calendar2.set(new GregorianCalendar(calendar));
                TestCalendar.compare(calendar, calendar2);
                calendar.addDays(1);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void test2(Calendar calendar, Calendar calendar2, int n, int n2) {
        try {
            int n3 = n2 + n;
            for (int i = n2; i <= n3; ++i) {
                for (int j = 1; j <= calendar.getLastMonthOfYear(i); ++j) {
                    for (int k = 1; k <= calendar.getLengthOfMonth(i, j); ++k) {
                        if (!calendar.isDate(i, j, k)) continue;
                        calendar.set(i, j, k);
                        calendar2.set(calendar.getYear(), calendar.getMonth(), calendar.getDay());
                        TestCalendar.compare(calendar, calendar2);
                        calendar2.set(calendar.getYear(), calendar.getDayOfYear());
                        TestCalendar.compare(calendar, calendar2);
                        calendar2.set(calendar.getJulianDayNumber());
                        TestCalendar.compare(calendar, calendar2);
                        calendar2.set(new GregorianCalendar(calendar));
                        TestCalendar.compare(calendar, calendar2);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void test3(Calendar calendar, Calendar calendar2) {
        try {
            calendar2.set(calendar.getYear(), calendar.getMonth(), calendar.getDay());
            TestCalendar.compare(calendar, calendar2);
            calendar2.set(calendar.getYear(), calendar.getDayOfYear());
            TestCalendar.compare(calendar, calendar2);
            calendar2.set(new GregorianCalendar(calendar));
            TestCalendar.compare(calendar, calendar2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void compare(Calendar calendar, Calendar calendar2) {
        if (calendar.getYear() != calendar2.getYear() || calendar.getMonth() != calendar2.getMonth() || calendar.getDay() != calendar2.getDay() || calendar.getDayOfYear() != calendar2.getDayOfYear() || calendar.getJulianDayNumber() != calendar2.getJulianDayNumber()) {
            System.out.println("Hups " + f.format(calendar) + " " + f.format(calendar2));
            throw new IllegalArgumentException();
        }
    }

    private TestCalendar() {
    }

    public static void main(String[] stringArray) {
    }
}

