/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar.test;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.GregorianCalendar;
import fi.joensuu.joyds1.calendar.HinduLunarCalendar;
import fi.joensuu.joyds1.calendar.format.DateFormat;
import fi.joensuu.joyds1.calendar.format.SimpleDateFormat;

public class TestHinduLunarCalendar {
    private static final DateFormat f = new SimpleDateFormat("yyyy-MM-dd DDD J L");

    public static void main(String[] stringArray) {
        try {
            TestHinduLunarCalendar.testMonthCalculations();
            System.exit(0);
            HinduLunarCalendar hinduLunarCalendar = new HinduLunarCalendar(HinduLunarCalendar.FIRST_JULIAN_DAY);
            HinduLunarCalendar hinduLunarCalendar2 = new HinduLunarCalendar(HinduLunarCalendar.FIRST_JULIAN_DAY);
            System.out.println("test1");
            TestHinduLunarCalendar.test1(hinduLunarCalendar, hinduLunarCalendar2, 36525);
            hinduLunarCalendar = new HinduLunarCalendar(HinduLunarCalendar.FIRST_JULIAN_DAY);
            hinduLunarCalendar2 = new HinduLunarCalendar(HinduLunarCalendar.FIRST_JULIAN_DAY);
            System.out.println("test2");
            TestHinduLunarCalendar.test2(hinduLunarCalendar, hinduLunarCalendar2, 100, 0);
            int n = HinduLunarCalendar.FIRST_JULIAN_DAY;
            int n2 = n + 36525;
            System.out.println("test3");
            for (int i = n; i < n2; ++i) {
                hinduLunarCalendar = new HinduLunarCalendar(i);
                hinduLunarCalendar2 = new HinduLunarCalendar(i);
                TestHinduLunarCalendar.test3(hinduLunarCalendar, hinduLunarCalendar2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    private TestHinduLunarCalendar() {
        this.testJdn();
    }

    private static void test1(Calendar calendar, Calendar calendar2, int n) {
        try {
            for (int i = 0; i < n; ++i) {
                calendar2.set(calendar.getYear(), calendar.getDayOfYear());
                TestHinduLunarCalendar.compare(calendar, calendar2);
                calendar2.set(calendar.getJulianDayNumber());
                TestHinduLunarCalendar.compare(calendar, calendar2);
                calendar2.set(new GregorianCalendar(calendar));
                TestHinduLunarCalendar.compare(calendar, calendar2);
                calendar.addDays(1);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    private static void test2(Calendar calendar, Calendar calendar2, int n, int n2) {
        try {
            int n3 = n2 + n;
            for (int i = n2; i <= n3; ++i) {
                for (int j = 1; j <= 12; ++j) {
                    for (int k = 0; k <= 1; ++k) {
                        boolean bl = k == 1;
                        for (int i2 = 1; i2 <= 30; ++i2) {
                            if (!calendar.isDate(i, j, i2, bl)) continue;
                            calendar.set(i, j, i2, bl);
                            calendar2.set(calendar.getYear(), calendar.getMonth(), calendar.getDay(), calendar.isLeapMonth());
                            TestHinduLunarCalendar.compare(calendar, calendar2);
                            calendar2.set(calendar.getYear(), calendar.getDayOfYear());
                            TestHinduLunarCalendar.compare(calendar, calendar2);
                            calendar2.set(calendar.getJulianDayNumber());
                            TestHinduLunarCalendar.compare(calendar, calendar2);
                            calendar2.set(new GregorianCalendar(calendar));
                            TestHinduLunarCalendar.compare(calendar, calendar2);
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    private static void test3(Calendar calendar, Calendar calendar2) {
        try {
            calendar2.set(calendar.getYear(), calendar.getMonth(), calendar.getDay(), calendar.isLeapMonth());
            TestHinduLunarCalendar.compare(calendar, calendar2);
            calendar2.set(calendar.getYear(), calendar.getDayOfYear());
            TestHinduLunarCalendar.compare(calendar, calendar2);
            calendar2.set(new GregorianCalendar(calendar));
            TestHinduLunarCalendar.compare(calendar, calendar2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    private void testLengthOfYear() {
        HinduLunarCalendar hinduLunarCalendar = new HinduLunarCalendar();
        System.out.println(hinduLunarCalendar.toString());
        for (int i = 0; i <= 20000; ++i) {
            System.out.println(i + " " + hinduLunarCalendar.getLengthOfYear(i));
        }
    }

    private static void testMonthCalculations() {
        HinduLunarCalendar hinduLunarCalendar = new HinduLunarCalendar();
        for (int i = 0; i <= 1000000; ++i) {
            if (i % 5000 == 0) {
                System.out.println(i);
            }
            for (int j = 1; j <= 12; ++j) {
                for (int k = 1; k >= 0; --k) {
                    boolean bl = k == 1;
                    try {
                        int n = hinduLunarCalendar.getFirstDayOfMonth(i, j, bl);
                        int n2 = hinduLunarCalendar.getLastDayOfMonth(i, j, bl);
                        int n3 = hinduLunarCalendar.getLengthOfMonth(i, j, bl);
                        if (n <= 2 && n2 >= 29 && n3 >= 29) continue;
                        System.out.println("year=" + i + " month=" + j + " leap=" + bl + " " + n + " " + n2 + " " + n3);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void testIsDate() {
        HinduLunarCalendar hinduLunarCalendar = new HinduLunarCalendar();
        for (int i = 0; i <= 100; ++i) {
            for (int j = 1; j <= 12; ++j) {
                for (int k = 1; k >= 0; --k) {
                    boolean bl = k == 1;
                    for (int i2 = 1; i2 <= 30; ++i2) {
                        if (!((Calendar)hinduLunarCalendar).isDate(i, j, i2, bl)) continue;
                        System.out.println(i + "-" + j + "-" + i2 + " " + bl);
                    }
                }
            }
        }
    }

    private void testDoy() {
        HinduLunarCalendar hinduLunarCalendar = new HinduLunarCalendar();
        for (int i = 0; i <= 10; ++i) {
            System.out.println(i);
            for (int j = 1; j <= ((Calendar)hinduLunarCalendar).getLengthOfYear(i); ++j) {
                HinduLunarCalendar hinduLunarCalendar2 = new HinduLunarCalendar(i, j);
                HinduLunarCalendar hinduLunarCalendar3 = new HinduLunarCalendar(((Calendar)hinduLunarCalendar2).getYear(), hinduLunarCalendar2.getDayOfYear());
                TestHinduLunarCalendar.compare(hinduLunarCalendar2, hinduLunarCalendar3);
            }
        }
    }

    private void testJdn() {
        int n = HinduLunarCalendar.FIRST_JULIAN_DAY;
        int n2 = n + 3652500;
        for (int i = n; i <= n2; ++i) {
            if (i % 10000 == 0) {
                System.out.println(i);
            }
            HinduLunarCalendar hinduLunarCalendar = new HinduLunarCalendar(i);
            HinduLunarCalendar hinduLunarCalendar2 = new HinduLunarCalendar(((Calendar)hinduLunarCalendar).getYear(), ((Calendar)hinduLunarCalendar).getMonth(), ((Calendar)hinduLunarCalendar).getDay(), ((Calendar)hinduLunarCalendar).isLeapMonth());
            TestHinduLunarCalendar.compare(hinduLunarCalendar, hinduLunarCalendar2);
        }
    }

    private void test() {
        HinduLunarCalendar hinduLunarCalendar = new HinduLunarCalendar(HinduLunarCalendar.FIRST_JULIAN_DAY);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(hinduLunarCalendar);
        for (int i = 0; i <= 366000; ++i) {
            System.out.println(((Calendar)hinduLunarCalendar).toString() + " " + ((Calendar)gregorianCalendar).toString());
            hinduLunarCalendar.addDays(1);
            gregorianCalendar.set(hinduLunarCalendar);
        }
    }

    private static void compare(Calendar calendar, Calendar calendar2) {
        if (calendar.getYear() != calendar2.getYear() || calendar.getMonth() != calendar2.getMonth() || calendar.getDay() != calendar2.getDay() || calendar.getDayOfYear() != calendar2.getDayOfYear() || calendar.getJulianDayNumber() != calendar2.getJulianDayNumber() || calendar.isLeapMonth() != calendar.isLeapMonth()) {
            System.out.println("Hups " + f.format(calendar) + " " + calendar.isLeapMonth() + " " + f.format(calendar2) + " " + calendar2.isLeapMonth());
            throw new IllegalArgumentException();
        }
    }
}

