/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar.util;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.GregorianCalendar;
import fi.joensuu.joyds1.calendar.format.DateFormat;
import fi.joensuu.joyds1.calendar.format.DateFormatSymbols;
import fi.joensuu.joyds1.calendar.format.SimpleDateFormat;
import fi.joensuu.joyds1.calendar.jcalendar.JCalendarPanel;
import java.awt.Component;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.JApplet;

public class CalendarApplet
extends JApplet {
    private JCalendarPanel panel;
    private Calendar calendar;
    private DateFormatSymbols format;
    private Locale locale;
    private int spinner;
    private final String PACKAGE = "fi.joensuu.joyds1.calendar.";
    private static final long serialVersionUID = 1L;

    @Override
    public void init() {
        Object object;
        String string = this.getParameter("locale");
        if (string != null) {
            int n;
            object = new String[3];
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            for (n = 0; stringTokenizer.hasMoreTokens() && n < 3; ++n) {
                object[n] = stringTokenizer.nextToken();
            }
            switch (n) {
                case 1: {
                    this.locale = new Locale(object[0]);
                    break;
                }
                case 2: {
                    this.locale = new Locale(object[0], object[1]);
                    break;
                }
                case 3: {
                    this.locale = new Locale(object[0], object[1], object[2]);
                }
            }
        }
        string = this.getParameter("calendar");
        try {
            this.calendar = (Calendar)Class.forName("fi.joensuu.joyds1.calendar." + string).newInstance();
        }
        catch (Exception exception) {
            this.calendar = new GregorianCalendar();
        }
        string = this.getParameter("date");
        if (string != null) {
            object = new SimpleDateFormat("yyyy-MM-dd");
            this.calendar = ((DateFormat)object).parse(string, this.calendar);
        }
        this.format = this.locale == null ? new DateFormatSymbols(this.calendar) : new DateFormatSymbols(this.calendar, this.locale);
        string = this.getParameter("spinner");
        try {
            this.spinner = string.compareTo("RIGHT_SPINNER") == 0 ? 0 : (string.compareTo("LEFT_SPINNER") == 0 ? 1 : (string.compareTo("NO_SPINNER") == 0 ? 2 : 0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.panel = new JCalendarPanel(this.calendar, this.format, this.spinner);
        this.panel.setVisible(true);
        this.getContentPane().add((Component)this.panel, "Center");
    }

    public JCalendarPanel getJCalendarPanel() {
        return this.panel;
    }

    @Override
    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"calendar", "string", "Calendar class. Default is GregorianCalendar"}, {"date", "string", "Date in ISO format, e.g. 2004-12-31. Default is current date."}, {"fromat", "string", "Date format symbols class. Default depends on calendar."}, {"spinner", "string", "One of RIGHT_SPINNER, LEFT_SPINNER or NO_SPINNER. Default is RIGHT_SPINNER."}};
        return stringArray;
    }
}

