/*
 * Decompiled with CFR 0.152.
 */
package jonelo.sugar.util;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class ExtendedGregorianCalendar
extends GregorianCalendar {
    public static final int LAST = -1;
    public static final int FIRST = 1;
    public static final int SECOND = 2;
    public static final int THIRD = 3;
    public static final int FOURTH = 4;
    public static String ERROR_1583 = "Year must be 1583 or later";
    public static final int[][] nearestWeekdayMatrix = new int[][]{{0, 1, 2, 3, -3, -2, -1}, {-1, 0, 1, 2, 3, -3, -2}, {-2, -1, 0, 1, 2, 3, -3}, {-3, -2, -1, 0, 1, 2, 3}, {3, -3, -2, -1, 0, 1, 2}, {2, 3, -3, -2, -1, 0, 1}, {1, 2, 3, -3, -2, -1, 0}};
    public static final int[][] nextWeekdayMatrix = new int[][]{{7, 1, 2, 3, 4, 5, 6}, {6, 7, 1, 2, 3, 4, 5}, {5, 6, 7, 1, 2, 3, 4}, {4, 5, 6, 7, 1, 2, 3}, {3, 4, 5, 6, 7, 1, 2}, {2, 3, 4, 5, 6, 7, 1}, {1, 2, 3, 4, 5, 6, 7}};
    private static final int[][] previousWeekdayMatrix = new int[][]{{-7, -6, -5, -4, -3, -2, -1}, {-1, -7, -6, -5, -4, -3, -2}, {-2, -1, -7, -6, -5, -4, -3}, {-3, -2, -1, -7, -6, -5, -4}, {-4, -3, -2, -1, -7, -6, -5}, {-5, -4, -3, -2, -1, -7, -6}, {-6, -5, -4, -3, -2, -1, -7}};
    public static final int EQUINOX_MARCH = 2;
    public static final int EQUINOX_SEPTEMBER = 8;
    public static final int SOLSTICE_JUNE = 5;
    public static final int SOLSTICE_DECEMBER = 11;
    private static final int J2000 = 2000;

    public ExtendedGregorianCalendar() {
    }

    public ExtendedGregorianCalendar(TimeZone timezone) {
        super(timezone);
    }

    public ExtendedGregorianCalendar(GregorianCalendar gc) {
        this.setTimeInMillis(gc.getTimeInMillis());
        this.setTimeZone(gc.getTimeZone());
    }

    public static int weekday2index(int weekday) {
        switch (weekday) {
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 1: {
                return 6;
            }
        }
        throw new IllegalArgumentException("weekday value " + weekday + " is invalid");
    }

    public void setNextWeekday(int weekday) {
        this.setNextWeekday(weekday, true);
    }

    public void setNextWeekday(int weekday, boolean moveDefinitely) {
        this.add(5, ExtendedGregorianCalendar.nextWeekday(this.get(7), weekday, moveDefinitely));
    }

    private static int nextWeekday(int weekdayFrom, int weekdayTo, boolean moveDefinitely) {
        return ExtendedGregorianCalendar.getXWay(nextWeekdayMatrix, weekdayFrom, weekdayTo, moveDefinitely);
    }

    public void setPreviousWeekday(int weekday) {
        this.setPreviousWeekday(weekday, true);
    }

    public void setPreviousWeekday(int weekday, boolean moveDefinetely) {
        this.add(5, ExtendedGregorianCalendar.previousWeekday(this.get(7), weekday, moveDefinetely));
    }

    private static int previousWeekday(int weekdayFrom, int weekdayTo, boolean moveDefinitely) {
        return ExtendedGregorianCalendar.getXWay(previousWeekdayMatrix, weekdayFrom, weekdayTo, moveDefinitely);
    }

    public void setNearestWeekday(int weekday) {
        this.add(5, ExtendedGregorianCalendar.nearestWeekday(this.get(7), weekday));
    }

    private static int nearestWeekday(int weekdayFrom, int weekdayTo) {
        return ExtendedGregorianCalendar.getXWay(nearestWeekdayMatrix, weekdayFrom, weekdayTo, false);
    }

    private static int getXWay(int[][] lookuptable, int weekdayFrom, int weekdayTo, boolean moveDefinitely) {
        if (weekdayFrom == weekdayTo && !moveDefinitely) {
            return 0;
        }
        return lookuptable[ExtendedGregorianCalendar.weekday2index(weekdayFrom)][ExtendedGregorianCalendar.weekday2index(weekdayTo)];
    }

    private int adjustment(int year, double value, double delta) {
        if (year == 2000) {
            return 0;
        }
        double a = year - 2000;
        double days = value + delta * a;
        int seconds = (int)(days * 86400.0);
        if (year < 2000) {
            seconds *= -1;
        }
        return seconds;
    }

    public void setEquinox(int type, int year) throws IllegalArgumentException {
        switch (type) {
            case 2: {
                this.setEquinoxSolstice(year, 2, 20, 7, 26, 0, 365.24237404, 1.0338E-7);
                break;
            }
            case 8: {
                this.setEquinoxSolstice(year, 8, 22, 17, 12, 0, 365.24201767, 2.315E-7);
                break;
            }
            default: {
                throw new IllegalArgumentException("EQUINOX_MARCH or EQUINOX_SEPTEMBER expected.");
            }
        }
    }

    public void setSolstice(int type, int year) throws IllegalArgumentException {
        switch (type) {
            case 5: {
                this.setEquinoxSolstice(year, 5, 21, 1, 37, 0, 365.24162603, 6.5E-9);
                break;
            }
            case 11: {
                this.setEquinoxSolstice(year, 11, 21, 13, 25, 0, 365.24274049, 1.2446E-7);
                break;
            }
            default: {
                throw new IllegalArgumentException("SOLSTICE_JUNE or SOLSTICE_DECEMBER expected.");
            }
        }
    }

    private void setEquinoxSolstice(int year, int month, int date, int hour_of_day, int minute, int second, double value, double delta) {
        int i;
        ExtendedGregorianCalendar utccal = new ExtendedGregorianCalendar();
        utccal.setTimeZone(TimeZone.getTimeZone("UTC"));
        utccal.set(1, 2000);
        utccal.set(2, month);
        utccal.set(5, date);
        utccal.set(11, hour_of_day);
        utccal.set(12, minute);
        utccal.set(13, second);
        int adjustment = this.adjustment(year, value, delta);
        for (i = 2000; i < year; ++i) {
            utccal.add(13, adjustment);
        }
        for (i = 2000; i > year; --i) {
            utccal.add(13, adjustment);
        }
        this.setTimeInMillis(utccal.getTimeInMillis());
    }

    public void setEaster(int year) throws Exception {
        if (year < 1583 || year < 0) {
            throw new Exception(ERROR_1583);
        }
        int a = year % 19;
        int b = year / 100;
        int c = year % 100;
        int d = b / 4;
        int e = b % 4;
        int f = (b + 8) / 25;
        int g = (b - f + 1) / 3;
        int h = (19 * a + b - d - g + 15) % 30;
        int i = c / 4;
        int k = c % 4;
        int l = (32 + 2 * e + 2 * i - h - k) % 7;
        int m = (a + 11 * h + 22 * l) / 451;
        int p = h + l - 7 * m + 114;
        int n = p / 31;
        p = p % 31 + 1;
        this.set(5, p);
        this.set(2, n - 1);
        this.set(1, year);
        this.setTime(this.getTime());
    }

    private void setEasterJulian(int year) throws Exception {
        int a = year % 4;
        int b = year % 7;
        int c = year % 19;
        int d = (19 * c + 15) % 30;
        int e = (2 * a + 4 * b - d + 34) % 7;
        int p = d + e + 114;
        int month = p / 31;
        int day = p % 31 + 1;
        this.set(5, day);
        this.set(2, month - 1);
        this.set(1, year);
        this.setTime(this.getTime());
    }

    public void setEaster(int year, boolean julian) throws Exception {
        if (julian) {
            this.setEasterJulian(year);
        } else {
            this.setEaster(year);
        }
    }

    public void setNthDow(int n, int dow) {
        this.set(7, dow);
        this.set(8, n);
    }

    public void setNthDow(int n, int dow, int month) {
        this.set(2, month);
        this.setNthDow(n, dow);
    }

    public void setNthDow(int n, int dow, int month, int year) {
        this.set(1, year);
        this.setNthDow(n, dow, month);
    }

    public void setPrevDow(int dow) {
        while (this.get(7) != dow) {
            this.add(5, -1);
        }
    }

    public void setNextDow(int dow) {
        while (this.get(7) != dow) {
            this.add(5, 1);
        }
    }

    public void setAdvent(int year) {
        this.set(year, 11, 24);
        this.setPrevDow(1);
        this.add(5, -21);
    }

    public static int getDaysBetween(Calendar d1, Calendar d2) {
        int factor = 1;
        if (d1.after(d2)) {
            Calendar swap = d1;
            d1 = d2;
            d2 = swap;
            factor = -1;
        }
        int days = d2.get(6) - d1.get(6);
        int y2 = d2.get(1);
        if (d1.get(1) != y2) {
            d1 = (Calendar)d1.clone();
            do {
                days += d1.getActualMaximum(6);
                d1.add(1, 1);
            } while (d1.get(1) != y2);
        }
        return factor * days;
    }

    public void setChineseNewYear(int year) throws Exception {
        int firstYearKnown = 1900;
        byte[] chineseYearDayOffset = new byte[]{0, 19, 8, -2, 16, 4, -6, 13, 2, -9, 10, -1, 18, 6, -5, 14, 3, -8, 11, 1, 20, 8, -3, 16, 5, -7, 13, 2, -8, 10, -1, 17, 6, -5, 14, 4, -7, 11, 0, 19, 8, -4, 15, 5, -6, 13, 2, -9, 10, -2, 17, 6, -4, 14, 3, -7, 12, 0, 18, 8, -3, 15, 5, -6, 13, 2, -10, 9, -1, 17, 6, -4, 15, 3, -8, 11, 0, 18, 7, -3, 16, 5, -6, 13, 2, 20, 9, -2, 17, 6, -4, 15, 4, -8, 10, 0, 19, 7, -3, 16, 5, -7, 12, 1, -9, 9, -2, 18, 7, -5, 14, 3, -8, 10, 0, 19, 8, -3, 16, 5, -6, 12, 1, -9, 10, -2, 17, 6, -5, 13, 3, -8, 11, 0, 19, 8, -3, 15, 4, -7, 12, 1, -9, 10, -1, 17, 6, -5, 14, 2, -8, 11, 1, 19, 8, -3, 15, 4, -7, 12, 2, -10, 9, -2, 17, 5, -5, 14, 3, -8, 11, 0, 19, 7, -4, 15, 5, -7, 12, 2, -9, 9, -2, 17, 6, -5, 14, 3, -7, 10, -1, 18, 7, -4, 15, 5, -6, 12, 1, -10, 9};
        if (year < 1900 || year - 1900 > chineseYearDayOffset.length - 1) {
            throw new Exception("unknown");
        }
        this.set(year, 0, 31);
        this.add(5, chineseYearDayOffset[year - 1900]);
    }

    public void setDSTstart(int year, TimeZone tz) throws Exception {
        TimeZone tzBackup = this.getTimeZone();
        this.setTimeZone(tz);
        this.set(year, 0, 1, 23, 59, 59);
        if (tz.inDaylightTime(this.getTime())) {
            while (tz.inDaylightTime(this.getTime()) && this.get(1) == year) {
                this.add(5, 1);
            }
        }
        while (!tz.inDaylightTime(this.getTime()) && this.get(1) == year) {
            this.add(5, 1);
        }
        if (this.get(5) == 1 && this.get(2) == 0) {
            throw new Exception("not defined");
        }
        int y = this.get(1);
        int m = this.get(2);
        int d = this.get(5);
        this.setTimeZone(tzBackup);
        this.set(y, m, d, 0, 0, 0);
    }

    public void setDSTend(int year, TimeZone tz) throws Exception {
        TimeZone tzBackup = this.getTimeZone();
        this.setTimeZone(tz);
        this.set(year, 0, 1, 23, 59, 59);
        if (!tz.inDaylightTime(this.getTime())) {
            while (!tz.inDaylightTime(this.getTime()) && this.get(1) == year) {
                this.add(5, 1);
            }
        }
        while (tz.inDaylightTime(this.getTime()) && this.get(1) == year) {
            this.add(5, 1);
        }
        if (this.get(5) == 1 && this.get(2) == 0) {
            throw new Exception("not defined");
        }
        int y = this.get(1);
        int m = this.get(2);
        int d = this.get(5);
        this.setTimeZone(tzBackup);
        this.set(y, m, d, 0, 0, 0);
    }

    public boolean isLeapYear() {
        return this.isLeapYear(this.get(1));
    }
}

