/*
 * Decompiled with CFR 0.152.
 */
package net.beeger.squareness;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.beeger.squareness.theme.DefaultSquarenessTheme;
import net.beeger.squareness.theme.PropertiesSquarenessTheme;
import net.beeger.squareness.theme.SquarenessTheme;
import net.beeger.squareness.util.SquarenessBorderFactory;
import net.beeger.squareness.util.SquarenessIconFactory;
import org.jvnet.lafplugin.ComponentPluginManager;

public class SquarenessLookAndFeel
extends MetalLookAndFeel {
    private static final String PLUGIN_FILE_NAME = "META-INF/squareness-plugin.xml";
    private static final ComponentPluginManager _plugins = new ComponentPluginManager("META-INF/squareness-plugin.xml");
    private static final String DESCRIPTION = "Squareness Look And Feel";
    private static final String ID = "Squareness";
    private static final String NAME = "Squareness";
    private static SquarenessTheme _currentSquarenessTheme;

    public static void setCurrentSquarenessTheme(SquarenessTheme squarenessTheme) {
        _currentSquarenessTheme = squarenessTheme;
        MetalLookAndFeel.setCurrentTheme(squarenessTheme);
    }

    public static SquarenessTheme getCurrentSquarenessTheme() {
        if (_currentSquarenessTheme == null) {
            SquarenessLookAndFeel.loadThemePackageTheme();
        }
        if (_currentSquarenessTheme == null) {
            SquarenessLookAndFeel.setCurrentSquarenessTheme(new DefaultSquarenessTheme());
        }
        return _currentSquarenessTheme;
    }

    public static void loadThemePackageTheme() {
        InputStream inputStream = SquarenessLookAndFeel.class.getResourceAsStream("/themeselector.slfts");
        if (inputStream != null) {
            Properties properties = new Properties();
            try {
                properties.load(inputStream);
                String string = properties.getProperty("currentTheme");
                if (string != null && string.trim().length() > 0) {
                    Properties properties2 = new Properties();
                    properties2.load(SquarenessLookAndFeel.class.getResourceAsStream("/" + string));
                    SquarenessLookAndFeel.setCurrentSquarenessTheme(new PropertiesSquarenessTheme(properties2));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (PropertiesSquarenessTheme.LoadException loadException) {
                loadException.printStackTrace();
            }
        }
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getID() {
        return "Squareness";
    }

    public String getName() {
        return "Squareness";
    }

    public void initialize() {
        super.initialize();
        _plugins.initializeAll();
    }

    public void uninitialize() {
        super.uninitialize();
        _plugins.uninitializeAll();
    }

    protected void initClassDefaults(UIDefaults uIDefaults) {
        super.initClassDefaults(uIDefaults);
        String string = "net.beeger.squareness.delegate.";
        uIDefaults.put("ButtonUI", string + "SquarenessButtonUI");
        uIDefaults.put("RadioButtonUI", string + "SquarenessRadioButtonUI");
        uIDefaults.put("CheckBoxUI", string + "SquarenessCheckBoxUI");
        uIDefaults.put("ToolBarUI", string + "SquarenessToolBarUI");
        uIDefaults.put("ToggleButtonUI", string + "SquarenessToggleButtonUI");
        uIDefaults.put("ScrollBarUI", string + "SquarenessScrollBarUI");
        uIDefaults.put("TabbedPaneUI", string + "SquarenessTabbedPaneUI");
        uIDefaults.put("ComboBoxUI", string + "SquarenessComboBoxUI");
        uIDefaults.put("SliderUI", string + "SquarenessSliderUI");
        uIDefaults.put("InternalFrameUI", string + "SquarenessInternalFrameUI");
        uIDefaults.put("SpinnerUI", string + "SquarenessSpinnerUI");
        uIDefaults.put("RootPaneUI", string + "SquarenessRootPaneUI");
        uIDefaults.put("ProgressBarUI", "javax.swing.plaf.basic.BasicProgressBarUI");
        uIDefaults.put("SplitPaneUI", "javax.swing.plaf.basic.BasicSplitPaneUI");
    }

    protected void initComponentDefaults(UIDefaults uIDefaults) {
        SquarenessLookAndFeel.setCurrentTheme(new DefaultSquarenessTheme());
        super.initComponentDefaults(uIDefaults);
        uIDefaults.put("scrollArrowLeft", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SquarenessIconFactory.getLeftIcon();
            }
        });
        uIDefaults.put("scrollArrowRight", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SquarenessIconFactory.getRightIcon();
            }
        });
        uIDefaults.put("scrollArrowUp", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SquarenessIconFactory.getUpIcon();
            }
        });
        uIDefaults.put("scrollArrowDown", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SquarenessIconFactory.getDownIcon();
            }
        });
        uIDefaults.put("spinUp", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SquarenessIconFactory.getSpinUpIcon();
            }
        });
        uIDefaults.put("spinDown", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SquarenessIconFactory.getSpinDownIcon();
            }
        });
        UIDefaults.LazyValue lazyValue = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SquarenessBorderFactory.getControlBorderWithMargin();
            }
        };
        UIDefaults.LazyValue lazyValue2 = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SquarenessBorderFactory.getControlBorderWithoutMargin();
            }
        };
        UIDefaults.LazyValue lazyValue3 = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SquarenessBorderFactory.getProgressBarBorder();
            }
        };
        UIDefaults.LazyValue lazyValue4 = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SquarenessBorderFactory.getTableHeaderCellBorder();
            }
        };
        uIDefaults.put("Button.background", SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalControlBackgroundColor());
        uIDefaults.put("Button.border", lazyValue);
        uIDefaults.put("ToggleButton.background", SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalControlBackgroundColor());
        uIDefaults.put("ToggleButton.border", lazyValue);
        uIDefaults.put("RadioButton.icon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SquarenessIconFactory.getRadioButtonIcon();
            }
        });
        uIDefaults.put("CheckBox.icon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SquarenessIconFactory.getCheckBoxIcon();
            }
        });
        UIDefaults.LazyValue lazyValue5 = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return new BorderUIResource.EmptyBorderUIResource(0, 0, 0, 0);
            }
        };
        UIDefaults.LazyValue lazyValue6 = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SquarenessBorderFactory.getMenuItemBorder();
            }
        };
        UIDefaults.LazyValue lazyValue7 = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SquarenessIconFactory.getMenuItemCheckIcon();
            }
        };
        UIDefaults.LazyValue lazyValue8 = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SquarenessIconFactory.getMenuItemArrowIcon();
            }
        };
        uIDefaults.put("TextField.border", lazyValue2);
        uIDefaults.put("FormattedTextField.border", lazyValue2);
        uIDefaults.put("PasswordField.border", lazyValue2);
        uIDefaults.put("MenuBar.background", SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
        uIDefaults.put("MenuBar.border", lazyValue5);
        uIDefaults.put("Menu.background", (Object)null);
        uIDefaults.put("Menu.border", lazyValue6);
        uIDefaults.put("Menu.borderPainted", Boolean.TRUE);
        uIDefaults.put("Menu.selectionForeground", uIDefaults.get("textHighlightText"));
        uIDefaults.put("Menu.selectionBackground", uIDefaults.get("textHighlight"));
        uIDefaults.put("Menu.arrowIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SquarenessIconFactory.getMenuArrowIcon();
            }
        });
        uIDefaults.put("Menu.checkIcon", lazyValue7);
        uIDefaults.put("MenuItem.background", (Object)null);
        uIDefaults.put("MenuItem.border", lazyValue6);
        uIDefaults.put("MenuItem.borderPainted", Boolean.TRUE);
        uIDefaults.put("MenuItem.selectionForeground", uIDefaults.get("textHighlightText"));
        uIDefaults.put("MenuItem.selectionBackground", uIDefaults.get("textHighlight"));
        uIDefaults.put("MenuItem.checkIcon", lazyValue7);
        uIDefaults.put("RadioButtonMenuItem.background", (Object)null);
        uIDefaults.put("RadioButtonMenuItem.border", lazyValue6);
        uIDefaults.put("RadioButtonMenuItem.borderPainted", Boolean.TRUE);
        uIDefaults.put("RadioButtonMenuItem.selectionForeground", uIDefaults.get("textHighlightText"));
        uIDefaults.put("RadioButtonMenuItem.selectionBackground", uIDefaults.get("textHighlight"));
        uIDefaults.put("RadioButtonMenuItem.checkIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SquarenessIconFactory.getRadioButtonMenuItemCheckIcon();
            }
        });
        uIDefaults.put("RadioButtonMenuItem.arrowIcon", lazyValue8);
        uIDefaults.put("CheckBoxMenuItem.background", (Object)null);
        uIDefaults.put("CheckBoxMenuItem.border", lazyValue6);
        uIDefaults.put("CheckBoxMenuItem.borderPainted", Boolean.TRUE);
        uIDefaults.put("CheckBoxMenuItem.selectionForeground", uIDefaults.get("textHighlightText"));
        uIDefaults.put("CheckBoxMenuItem.selectionBackground", uIDefaults.get("textHighlight"));
        uIDefaults.put("CheckBoxMenuItem.checkIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SquarenessIconFactory.getCheckBoxMenuItemCheckIcon();
            }
        });
        uIDefaults.put("CheckBoxMenuItem.arrowIcon", lazyValue8);
        uIDefaults.put("Separator.foreground", SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
        uIDefaults.put("Separator.background", (Object)null);
        uIDefaults.put("PopupMenu.border", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SquarenessBorderFactory.getNonSpacingControlBorderWithoutMargin();
            }
        });
        UIDefaults.LazyValue lazyValue9 = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SquarenessBorderFactory.getInternalFrameBorder();
            }
        };
        uIDefaults.put("InternalFrame.border", lazyValue9);
        uIDefaults.put("InternalFrame.icon", (Object)null);
        uIDefaults.put("InternalFrame.maximizeIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SquarenessIconFactory.getMaximizeFrameIcon();
            }
        });
        uIDefaults.put("InternalFrame.minimizeIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SquarenessIconFactory.getMinimizeFrameIcon();
            }
        });
        uIDefaults.put("InternalFrame.iconifyIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SquarenessIconFactory.getIconifyFrameIcon();
            }
        });
        uIDefaults.put("InternalFrame.closeIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SquarenessIconFactory.getCloseFrameIcon();
            }
        });
        uIDefaults.put("RootPane.frameBorder", lazyValue9);
        uIDefaults.put("RootPane.plainDialogBorder", lazyValue9);
        uIDefaults.put("RootPane.informationDialogBorder", lazyValue9);
        uIDefaults.put("RootPane.errorDialogBorder", lazyValue9);
        uIDefaults.put("RootPane.colorChooserDialogBorder", lazyValue9);
        uIDefaults.put("RootPane.fileChooserDialogBorder", lazyValue9);
        uIDefaults.put("RootPane.questionDialogBorder", lazyValue9);
        uIDefaults.put("RootPane.warningDialogBorder", lazyValue9);
        uIDefaults.put("ScrollBar.thumb", SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalControlBackgroundColor());
        uIDefaults.put("ScrollBar.background", SquarenessLookAndFeel.getCurrentSquarenessTheme().getProgressBarBackgroundColor());
        uIDefaults.put("ScrollBar.width", new Integer(17));
        uIDefaults.put("ScrollPane.border", lazyValue2);
        uIDefaults.put("TableHeader.background", SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalControlBackgroundColor());
        uIDefaults.put("ToolBar.border", lazyValue5);
        uIDefaults.put("ToolBar.background", SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
        uIDefaults.put("ComboBox.border", lazyValue2);
        uIDefaults.put("ComboBox.background", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextInputBackgroundColor());
        uIDefaults.put("ComboBox.selectionBackground", uIDefaults.get("textHighlight"));
        uIDefaults.put("ComboBox.selectionForeground", uIDefaults.get("textHighlightText"));
        uIDefaults.put("ProgressBar.border", lazyValue3);
        uIDefaults.put("ProgressBar.cellLength", new Integer(1));
        uIDefaults.put("ProgressBar.cellSpacing", new Integer(1));
        uIDefaults.put("ProgressBar.selectionForeground", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextColor());
        uIDefaults.put("ProgressBar.selectionBackground", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextColor());
        uIDefaults.put("ProgressBar.foreground", SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundColor());
        uIDefaults.put("ProgressBar.background", SquarenessLookAndFeel.getCurrentSquarenessTheme().getProgressBarBackgroundColor());
        uIDefaults.put("SplitPane.highlight", SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
        uIDefaults.put("SplitPane.shadow", SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
        uIDefaults.put("SplitPane.darkShadow", SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
        uIDefaults.put("SplitPane.border", (Object)null);
        uIDefaults.put("SplitPaneDivider.border", (Object)null);
        uIDefaults.put("TabbedPane.selected", SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
        uIDefaults.put("TabbedPane.shadow", SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor().brighter().brighter());
        uIDefaults.put("TabbedPane.darkShadow", SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
        uIDefaults.put("TabbedPane.highlight", SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor().brighter().brighter());
        uIDefaults.put("TabbedPane.background", SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
        uIDefaults.put("TabbedPane.selected", (Object)null);
        uIDefaults.put("Viewport.background", SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
        uIDefaults.put("Table.scrollPaneBorder", lazyValue2);
        uIDefaults.put("TableHeader.cellBorder", lazyValue4);
        uIDefaults.put("Panel.background", SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
        uIDefaults.put("Panel.foreground", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextColor());
        uIDefaults.put("Tree.collapsedIcon", LookAndFeel.makeIcon(this.getClass(), "icons/treecollapsed.gif"));
        uIDefaults.put("Tree.expandedIcon", LookAndFeel.makeIcon(this.getClass(), "icons/treeexpanded.gif"));
        uIDefaults.put("Tree.openIcon", LookAndFeel.makeIcon(this.getClass(), "icons/folderopened.gif"));
        uIDefaults.put("Tree.closedIcon", LookAndFeel.makeIcon(this.getClass(), "icons/folderclosed.gif"));
        uIDefaults.put("Tree.leafIcon", LookAndFeel.makeIcon(this.getClass(), "icons/document.gif"));
        uIDefaults.put("FileView.directoryIcon", LookAndFeel.makeIcon(this.getClass(), "icons/folderclosed.gif"));
        uIDefaults.put("FileView.fileIcon", LookAndFeel.makeIcon(this.getClass(), "icons/document.gif"));
        uIDefaults.put("FileView.computerIcon", LookAndFeel.makeIcon(this.getClass(), "icons/computer.gif"));
        uIDefaults.put("FileView.hardDriveIcon", LookAndFeel.makeIcon(this.getClass(), "icons/hd.gif"));
        uIDefaults.put("FileView.floppyDriveIcon", LookAndFeel.makeIcon(this.getClass(), "icons/floppy.gif"));
        uIDefaults.put("FileChooser.detailsViewIcon", LookAndFeel.makeIcon(this.getClass(), "icons/detail.gif"));
        uIDefaults.put("FileChooser.homeFolderIcon", LookAndFeel.makeIcon(this.getClass(), "icons/home.gif"));
        uIDefaults.put("FileChooser.listViewIcon", LookAndFeel.makeIcon(this.getClass(), "icons/list.gif"));
        uIDefaults.put("FileChooser.newFolderIcon", LookAndFeel.makeIcon(this.getClass(), "icons/folderclosed.gif"));
        uIDefaults.put("FileChooser.upFolderIcon", LookAndFeel.makeIcon(this.getClass(), "icons/folderup.gif"));
        Iterator iterator = uIDefaults.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!(entry.getValue() instanceof String) || !((String)entry.getValue()).startsWith("sounds/")) continue;
            entry.setValue("/javax/swing/plaf/metal/" + entry.getValue());
        }
        _plugins.processAllDefaultsEntries(UIManager.getDefaults(), _currentSquarenessTheme);
    }

    protected void initSystemColorDefaults(UIDefaults uIDefaults) {
        uIDefaults.put("desktop", SquarenessLookAndFeel.getCurrentSquarenessTheme().getDesktopColor());
        uIDefaults.put("activeCaption", SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
        uIDefaults.put("activeCaptionText", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextColor());
        uIDefaults.put("activeCaptionBorder", SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
        uIDefaults.put("inactiveCaption", SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
        uIDefaults.put("inactiveCaptionText", SquarenessLookAndFeel.getCurrentSquarenessTheme().getDisabledBorderColor());
        uIDefaults.put("inactiveCaptionBorder", SquarenessLookAndFeel.getCurrentSquarenessTheme().getInactiveWindowBorderColor());
        uIDefaults.put("window", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextInputBackgroundColor());
        uIDefaults.put("windowBorder", SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
        uIDefaults.put("windowText", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextColor());
        uIDefaults.put("menu", SquarenessLookAndFeel.getCurrentSquarenessTheme().getProgressBarBackgroundColor());
        uIDefaults.put("menuText", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextColor());
        uIDefaults.put("text", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextInputBackgroundColor());
        uIDefaults.put("textText", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextColor());
        uIDefaults.put("textHighlight", SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundColor());
        uIDefaults.put("textHighlightText", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextColor());
        uIDefaults.put("textInactiveText", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextColor());
        uIDefaults.put("control", SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
        uIDefaults.put("controlText", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextColor());
        uIDefaults.put("controlHighlight", SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundColor());
        uIDefaults.put("controlLtHighlight", SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundColor());
        uIDefaults.put("controlShadow", SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundShadowColor());
        uIDefaults.put("controlDkShadow", SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundShadowColor());
        uIDefaults.put("scrollbar", SquarenessLookAndFeel.getCurrentSquarenessTheme().getProgressBarBackgroundColor());
        uIDefaults.put("info", SquarenessLookAndFeel.getCurrentSquarenessTheme().getProgressBarBackgroundColor());
        uIDefaults.put("infoText", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextColor());
    }
}

