/*
 * Decompiled with CFR 0.152.
 */
package net.beeger.squareness.delegate;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import net.beeger.squareness.SquarenessLookAndFeel;

public class SquarenessTabbedPaneUI
extends BasicTabbedPaneUI {
    private TabbedPaneMouseMotionListener _tabbedBarMouseMotionListener;
    private TabbedPaneMouseListener _tabbedBarMouseListener;
    private int _mouseOverTab = -1;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SquarenessTabbedPaneUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this._tabbedBarMouseListener = new TabbedPaneMouseListener();
        this._tabbedBarMouseMotionListener = new TabbedPaneMouseMotionListener();
        this.tabPane.addMouseListener(this._tabbedBarMouseListener);
        this.tabPane.addMouseMotionListener(this._tabbedBarMouseMotionListener);
    }

    public void uninstallUI(JComponent jComponent) {
        this.tabPane.removeMouseListener(this._tabbedBarMouseListener);
        this.tabPane.removeMouseMotionListener(this._tabbedBarMouseMotionListener);
        super.uninstallUI(jComponent);
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Color color = graphics.getColor();
        ColorUIResource colorUIResource = !bl && this._mouseOverTab == n2 ? SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundColor() : SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor();
        graphics.setColor(colorUIResource);
        graphics.fillRect(n3, n4, n5, n6);
        graphics.setColor(color);
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Color color = graphics.getColor();
        Color color2 = !bl && this._mouseOverTab == n2 ? SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundColor().darker() : SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor();
        graphics.setColor(color2);
        graphics.translate(n3, n4);
        if (bl || this._mouseOverTab == n2) {
            switch (n) {
                case 1: {
                    this.paintHorizontalTabBorder(graphics, n6, n5, true);
                    break;
                }
                case 3: {
                    this.paintHorizontalTabBorder(graphics, n6, n5, false);
                    break;
                }
                case 2: {
                    this.paintVerticalTabBorder(graphics, n6, n5, true);
                    break;
                }
                case 4: {
                    this.paintVerticalTabBorder(graphics, n6, n5, false);
                }
            }
        } else {
            int n7 = this.tabPane.getTabCount();
            if (this.lastTabInRun(n7, this.getRunForTab(n7, n2)) != n2 && this.tabPane.getSelectedIndex() - n2 != 1) {
                switch (n) {
                    case 1: 
                    case 3: {
                        graphics.drawLine(n5 - 1, 3, n5 - 1, n6 - 1 - 3);
                        break;
                    }
                    case 2: 
                    case 4: {
                        graphics.drawLine(4, n6 - 1, n5 - 1 - 4, n6 - 1);
                    }
                }
            }
        }
        graphics.translate(-n3, -n4);
        graphics.setColor(color);
    }

    private void paintVerticalTabBorder(Graphics graphics, int n, int n2, boolean bl) {
        graphics.drawLine(0, 0, n2 - 1, 0);
        if (bl) {
            graphics.drawLine(0, 0, 0, n - 1);
            graphics.drawLine(0, n - 1, n2 - 1, n - 1);
        } else {
            graphics.drawLine(n2 - 1, 0, n2 - 1, n - 1);
            graphics.drawLine(0, n - 1, n2 - 1, n - 1);
        }
    }

    private void paintHorizontalTabBorder(Graphics graphics, int n, int n2, boolean bl) {
        graphics.drawLine(0, 0, 0, n - 1);
        graphics.drawLine(n2 - 1, 0, n2 - 1, n - 1);
        if (bl) {
            graphics.drawLine(0, 0, n2 - 1, 0);
        } else {
            graphics.drawLine(0, n - 1, n2 - 1, n - 1);
        }
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle;
        Color color = graphics.getColor();
        ColorUIResource colorUIResource = SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor();
        graphics.setColor(colorUIResource);
        Rectangle rectangle2 = rectangle = n2 < 0 ? null : this.getTabBoundsNoCheckLayout(n2);
        if (n != 1 || n2 < 0 || rectangle.y + rectangle.height + 1 < n4 || rectangle.x < n3 || rectangle.x > n3 + n5) {
            graphics.drawLine(n3, n4, n3 + n5 - 1, n4);
        } else {
            graphics.drawLine(n3, n4, rectangle.x, n4);
            if (rectangle.x + rectangle.width < n3 + n5 - 1) {
                graphics.drawLine(rectangle.x + rectangle.width - 1, n4, n3 + n5 - 1, n4);
            }
        }
        graphics.setColor(color);
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle;
        Color color = graphics.getColor();
        ColorUIResource colorUIResource = SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor();
        graphics.setColor(colorUIResource);
        Rectangle rectangle2 = rectangle = n2 < 0 ? null : this.getTabBoundsNoCheckLayout(n2);
        if (n != 4 || n2 < 0 || rectangle.x - 1 > n5 || rectangle.y < n4 || rectangle.y > n4 + n6) {
            graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 1);
        } else {
            graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, rectangle.y);
            if (rectangle.y + rectangle.height < n4 + n6 - 1) {
                graphics.drawLine(n3 + n5 - 1, rectangle.y + rectangle.height - 1, n3 + n5 - 1, n4 + n6 - 1);
            }
        }
        graphics.setColor(color);
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle;
        Color color = graphics.getColor();
        ColorUIResource colorUIResource = SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor();
        graphics.setColor(colorUIResource);
        Rectangle rectangle2 = rectangle = n2 < 0 ? null : this.getTabBoundsNoCheckLayout(n2);
        if (n != 2 || n2 < 0 || rectangle.x + rectangle.width + 1 < n3 || rectangle.y < n4 || rectangle.y > n4 + n6) {
            graphics.drawLine(n3, n4, n3, n4 + n6 - 1);
        } else {
            graphics.drawLine(n3, n4, n3, rectangle.y);
            if (rectangle.y + rectangle.height < n4 + n6 - 1) {
                graphics.drawLine(n3, rectangle.y + rectangle.height - 1, n3, n4 + n6 - 1);
            }
        }
        graphics.setColor(color);
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle;
        Color color = graphics.getColor();
        ColorUIResource colorUIResource = SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor();
        graphics.setColor(colorUIResource);
        Rectangle rectangle2 = rectangle = n2 < 0 ? null : this.getTabBoundsNoCheckLayout(n2);
        if (n != 3 || n2 < 0 || rectangle.y - 1 > n6 || rectangle.x < n3 || rectangle.x > n3 + n5) {
            graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
        } else {
            graphics.drawLine(n3, n4 + n6 - 1, rectangle.x, n4 + n6 - 1);
            if (rectangle.x + rectangle.width < n3 + n5 - 1) {
                graphics.drawLine(rectangle.x + rectangle.width - 1, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
            }
        }
        graphics.setColor(color);
    }

    protected boolean isTabVisible(int n) {
        return n < this.rects.length && this.rects[n] != null;
    }

    protected Rectangle getTabBoundsNoCheckLayout(int n) {
        Rectangle rectangle = new Rectangle();
        this.getTabBounds(n, rectangle);
        return rectangle;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = null;
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            if (!this.isTabVisible(i)) continue;
            Rectangle rectangle2 = this.getTabBoundsNoCheckLayout(i);
            if (rectangle == null) {
                rectangle = rectangle2;
                continue;
            }
            rectangle.add(rectangle2);
        }
        if (rectangle != null && rectangle.contains(graphics.getClipBounds())) {
            if (this.tabPane.getTabLayoutPolicy() != 1) {
                this.paintTabArea(graphics, this.tabPane.getTabPlacement(), this.tabPane.getSelectedIndex());
            }
        } else {
            super.paint(graphics, jComponent);
        }
    }

    private class TabbedPaneMouseListener
    extends MouseAdapter {
        private TabbedPaneMouseListener() {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (SquarenessTabbedPaneUI.this._mouseOverTab >= 0) {
                if (SquarenessTabbedPaneUI.this._mouseOverTab < SquarenessTabbedPaneUI.this.tabPane.getTabCount() && SquarenessTabbedPaneUI.this.isTabVisible(SquarenessTabbedPaneUI.this._mouseOverTab) && SquarenessTabbedPaneUI.this.tabPane.getSelectedIndex() != SquarenessTabbedPaneUI.this._mouseOverTab) {
                    SquarenessTabbedPaneUI.this.tabPane.repaint(SquarenessTabbedPaneUI.this.getTabBoundsNoCheckLayout(SquarenessTabbedPaneUI.this._mouseOverTab));
                }
                SquarenessTabbedPaneUI.this._mouseOverTab = -1;
            }
        }
    }

    private class TabbedPaneMouseMotionListener
    extends MouseMotionAdapter {
        private TabbedPaneMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            boolean bl = false;
            for (int i = 0; !bl && i < SquarenessTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                Rectangle rectangle;
                if (!SquarenessTabbedPaneUI.this.isTabVisible(i) || !(rectangle = SquarenessTabbedPaneUI.this.getTabBoundsNoCheckLayout(i)).contains(mouseEvent.getPoint())) continue;
                bl = true;
                if (SquarenessTabbedPaneUI.this._mouseOverTab == i) continue;
                if (SquarenessTabbedPaneUI.this._mouseOverTab >= 0 && SquarenessTabbedPaneUI.this.isTabVisible(SquarenessTabbedPaneUI.this._mouseOverTab) && SquarenessTabbedPaneUI.this.tabPane.getSelectedIndex() != SquarenessTabbedPaneUI.this._mouseOverTab) {
                    SquarenessTabbedPaneUI.this.tabPane.repaint(SquarenessTabbedPaneUI.this.getTabBoundsNoCheckLayout(SquarenessTabbedPaneUI.this._mouseOverTab));
                }
                if (SquarenessTabbedPaneUI.this.tabPane.getSelectedIndex() != i) {
                    SquarenessTabbedPaneUI.this.tabPane.repaint(rectangle);
                }
                SquarenessTabbedPaneUI.this._mouseOverTab = i;
            }
            if (!bl && SquarenessTabbedPaneUI.this._mouseOverTab >= 0) {
                if (SquarenessTabbedPaneUI.this._mouseOverTab < SquarenessTabbedPaneUI.this.tabPane.getTabCount() && SquarenessTabbedPaneUI.this.isTabVisible(SquarenessTabbedPaneUI.this._mouseOverTab) && SquarenessTabbedPaneUI.this.tabPane.getSelectedIndex() != SquarenessTabbedPaneUI.this._mouseOverTab) {
                    SquarenessTabbedPaneUI.this.tabPane.repaint(SquarenessTabbedPaneUI.this.getTabBoundsNoCheckLayout(SquarenessTabbedPaneUI.this._mouseOverTab));
                }
                SquarenessTabbedPaneUI.this._mouseOverTab = -1;
            }
        }
    }
}

