/*
 * Decompiled with CFR 0.152.
 */
package net.beeger.squareness.theme;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.plaf.ColorUIResource;
import net.beeger.squareness.theme.DefaultSquarenessTheme;
import net.beeger.squareness.theme.SquarenessTheme;

public class PropertiesSquarenessTheme
extends SquarenessTheme {
    private ColorUIResource _desktopColor;
    private ColorUIResource _windowBackgroundColor;
    private ColorUIResource _inactiveWindowBorderColor;
    private ColorUIResource _normalBorderColor;
    private ColorUIResource _disabledBorderColor;
    private ColorUIResource _defaultButtonBorderColor;
    private ColorUIResource _normalControlBackgroundColor;
    private ColorUIResource _selectedControlBackgroundColor;
    private ColorUIResource _selectedControlBackgroundShadowColor;
    private ColorUIResource _progressBarBackgroundColor;
    private ColorUIResource _pressedScrollBarTrackBackgroundColor;
    private ColorUIResource _textInputBackgroundColor;
    private ColorUIResource _textColor;
    private String _themeName;
    private boolean _isDark;

    public PropertiesSquarenessTheme(File file) throws LoadException {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(file));
            this.processProperties(properties);
            if (this._themeName == null) {
                this._themeName = file.getName();
                if (this._themeName.indexOf(46) > -1) {
                    this._themeName = this._themeName.substring(0, this._themeName.indexOf(46));
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public PropertiesSquarenessTheme(Properties properties) throws LoadException {
        this.processProperties(properties);
    }

    public PropertiesSquarenessTheme(ResourceBundle resourceBundle) throws LoadException {
        Properties properties = new Properties();
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = resourceBundle.getKeys().nextElement();
            properties.put(string, resourceBundle.getString(string));
        }
        this.processProperties(properties);
    }

    public String getName() {
        return this._themeName;
    }

    public ColorUIResource getDesktopColor() {
        return this._desktopColor;
    }

    public ColorUIResource getWindowBackgroundColor() {
        return this._windowBackgroundColor;
    }

    public ColorUIResource getInactiveWindowBorderColor() {
        return this._inactiveWindowBorderColor;
    }

    public ColorUIResource getNormalBorderColor() {
        return this._normalBorderColor;
    }

    public ColorUIResource getDisabledBorderColor() {
        return this._disabledBorderColor;
    }

    public ColorUIResource getDefaultButtonBorderColor() {
        return this._defaultButtonBorderColor;
    }

    public ColorUIResource getNormalControlBackgroundColor() {
        return this._normalControlBackgroundColor;
    }

    public ColorUIResource getSelectedControlBackgroundColor() {
        return this._selectedControlBackgroundColor;
    }

    public ColorUIResource getSelectedControlBackgroundShadowColor() {
        return this._selectedControlBackgroundShadowColor;
    }

    public ColorUIResource getProgressBarBackgroundColor() {
        return this._progressBarBackgroundColor;
    }

    public ColorUIResource getPressedScrollBarTrackBackgroundColor() {
        return this._pressedScrollBarTrackBackgroundColor;
    }

    public ColorUIResource getTextInputBackgroundColor() {
        return this._textInputBackgroundColor;
    }

    public ColorUIResource getTextColor() {
        return this._textColor;
    }

    public boolean isDark() {
        return this._isDark;
    }

    private void processProperties(Properties properties) throws LoadException {
        DefaultSquarenessTheme defaultSquarenessTheme = new DefaultSquarenessTheme();
        this._desktopColor = this.getColor("desktopColor", defaultSquarenessTheme.getDesktopColor(), properties);
        this._windowBackgroundColor = this.getColor("windowBackgroundColor", defaultSquarenessTheme.getWindowBackgroundColor(), properties);
        this._inactiveWindowBorderColor = this.getColor("inactiveWindowBorderColor", defaultSquarenessTheme.getInactiveWindowBorderColor(), properties);
        this._normalBorderColor = this.getColor("normalBorderColor", defaultSquarenessTheme.getNormalBorderColor(), properties);
        this._disabledBorderColor = this.getColor("disabledBorderColor", defaultSquarenessTheme.getDisabledBorderColor(), properties);
        this._defaultButtonBorderColor = this.getColor("defaultButtonBorderColor", defaultSquarenessTheme.getDefaultButtonBorderColor(), properties);
        this._normalControlBackgroundColor = this.getColor("normalControlBackgroundColor", defaultSquarenessTheme.getNormalControlBackgroundColor(), properties);
        this._selectedControlBackgroundColor = this.getColor("selectedControlBackgroundColor", defaultSquarenessTheme.getSelectedControlBackgroundColor(), properties);
        this._selectedControlBackgroundShadowColor = this.getColor("selectedControlBackgroundShadowColor", defaultSquarenessTheme.getSelectedControlBackgroundShadowColor(), properties);
        this._progressBarBackgroundColor = this.getColor("progressBarBackgroundColor", defaultSquarenessTheme.getProgressBarBackgroundColor(), properties);
        this._pressedScrollBarTrackBackgroundColor = this.getColor("pressedScrollBarTrackBackgroundColor", defaultSquarenessTheme.getPressedScrollBarTrackBackgroundColor(), properties);
        this._textInputBackgroundColor = this.getColor("textInputBackgroundColor", defaultSquarenessTheme.getTextInputBackgroundColor(), properties);
        this._textColor = this.getColor("textColor", defaultSquarenessTheme.getTextColor(), properties);
        this._themeName = properties.getProperty("themeName");
        this._isDark = Boolean.valueOf(properties.getProperty("isDark", "false"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ColorUIResource getColor(String string, ColorUIResource colorUIResource, Properties properties) throws LoadException {
        ColorUIResource colorUIResource2 = null;
        String string2 = properties.getProperty(string);
        if (string2 == null) return colorUIResource;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",", false);
        if (stringTokenizer.countTokens() != 3) throw new LoadException(string, "The colordefinition \"" + string + " = " + string2 + "\" is incorrect. " + "A colordefinition looks like \"colornamw=r,g,b\" where r, g and b " + "define the red, green and blue components of the color. Each of those " + "must be in the range from 0 to 255.");
        try {
            int n = Integer.parseInt((String)stringTokenizer.nextElement());
            int n2 = Integer.parseInt((String)stringTokenizer.nextElement());
            int n3 = Integer.parseInt((String)stringTokenizer.nextElement());
            if (!this.isValidColorComponent(n)) throw new LoadException(string, "The colordefinition contains one or more wrong color components. A colordefinition looks like \"colornamw=r,g,b\" where r, g and b define the red, green and blue components of the color. Each of those must be in the range from 0 to 255.");
            if (!this.isValidColorComponent(n2)) throw new LoadException(string, "The colordefinition contains one or more wrong color components. A colordefinition looks like \"colornamw=r,g,b\" where r, g and b define the red, green and blue components of the color. Each of those must be in the range from 0 to 255.");
            if (!this.isValidColorComponent(n3)) throw new LoadException(string, "The colordefinition contains one or more wrong color components. A colordefinition looks like \"colornamw=r,g,b\" where r, g and b define the red, green and blue components of the color. Each of those must be in the range from 0 to 255.");
            return new ColorUIResource(n, n2, n3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new LoadException(string, "The colordefinition \"" + string + " = " + string2 + "\" is incorrect. " + "A colordefinition looks like \"colornamw=r,g,b\" where r, g and b " + "define the red, green and blue components of the color. Each of those " + "must be in the range from 0 to 255.");
        }
    }

    private boolean isValidColorComponent(int n) {
        return n >= 0 && n <= 255;
    }

    public static class LoadException
    extends Exception {
        public LoadException(String string, String string2) {
            super("Error on loading property " + string + " : " + string2);
        }
    }
}

