/*
 * Decompiled with CFR 0.152.
 */
package net.beeger.squareness.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import net.beeger.squareness.SquarenessLookAndFeel;

public class SquarenessBorderFactory {
    public static Border getControlBorderWithMargin() {
        return new BorderUIResource.CompoundBorderUIResource(new ParentBackgroundBorder(), new BorderUIResource.CompoundBorderUIResource(new ControlBorder(), new BorderUIResource.CompoundBorderUIResource(new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1), new BasicBorders.MarginBorder())));
    }

    public static Border getNonSpacingControlBorderWithMargin() {
        return new BorderUIResource.CompoundBorderUIResource(new ControlBorder(), new BorderUIResource.CompoundBorderUIResource(new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1), new BasicBorders.MarginBorder()));
    }

    public static Border getControlBorderWithoutMargin() {
        return new BorderUIResource.CompoundBorderUIResource(new ParentBackgroundBorder(), new BorderUIResource.CompoundBorderUIResource(new ControlBorder(), new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1)));
    }

    public static Border getProgressBarBorder() {
        return new BorderUIResource.CompoundBorderUIResource(new ParentBackgroundBorder(), new ControlBorder());
    }

    public static Border getNonSpacingControlBorderWithoutMargin() {
        return new BorderUIResource.CompoundBorderUIResource(new ControlBorder(), new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1));
    }

    public static Border getButtonRolloverBorder() {
        return new BorderUIResource.CompoundBorderUIResource(new ParentBackgroundBorder(), new BorderUIResource.CompoundBorderUIResource(new ButtonRolloverBorder(), new RolloverMarginBorder()));
    }

    public static Border getButtonNonRolloverBorder() {
        return new BorderUIResource.CompoundBorderUIResource(new ParentBackgroundBorder(), new BorderUIResource.CompoundBorderUIResource(new ControlBorder(), new RolloverMarginBorder()));
    }

    public static Border getTableHeaderCellBorder() {
        return new BorderUIResource.CompoundBorderUIResource(new TableHeaderCellBorder(), new BorderUIResource.EmptyBorderUIResource(1, 2, 1, 2));
    }

    public static Border getMenuItemBorder() {
        return new MenuItemBorder();
    }

    public static Border getInternalFrameBorder() {
        return new BorderUIResource.CompoundBorderUIResource(new InternalFrameBorder(), new BorderUIResource.LineBorderUIResource(SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor(), 1));
    }

    private static class MenuItemBorder
    extends ControlBorder {
        private MenuItemBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && jMenuItem.isSelected()) {
                super.paintBorder(component, graphics, n, n2, n3, n4);
            }
        }
    }

    private static class RolloverMarginBorder
    extends EmptyBorder {
        public RolloverMarginBorder() {
            super(3, 3, 3, 3);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                insets2 = ((AbstractButton)component).getMargin();
            }
            if (insets2 == null || insets2 instanceof UIResource) {
                insets.left = this.left;
                insets.top = this.top;
                insets.right = this.right;
                insets.bottom = this.bottom;
            } else {
                insets.left = insets2.left;
                insets.top = insets2.top;
                insets.right = insets2.right;
                insets.bottom = insets2.bottom;
            }
            return insets;
        }
    }

    private static class ButtonRolloverBorder
    extends ControlBorder {
        private ButtonRolloverBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            boolean bl = (Boolean)abstractButton.getClientProperty("SquarenessRollover");
            if (abstractButton.isEnabled() && (bl || buttonModel.isArmed() && buttonModel.isPressed() || abstractButton.hasFocus() || abstractButton.isSelected())) {
                super.paintBorder(component, graphics, n, n2, n3, n4);
            }
        }
    }

    private static class TableHeaderCellBorder
    extends AbstractBorder
    implements UIResource {
        private TableHeaderCellBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
            graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalControlBackgroundColor().darker());
            graphics.drawLine(n + n3 - 2, n2 + 3, n + n3 - 2, n2 + n4 - 4);
            graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalControlBackgroundColor().brighter());
            graphics.drawLine(n + n3 - 1, n2 + 3, n + n3 - 1, n2 + n4 - 4);
            graphics.setColor(color);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.right = 1;
            insets.bottom = 1;
            insets.left = 1;
            insets.top = 1;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    private static class InternalFrameBorder
    extends AbstractBorder
    implements UIResource {
        private InternalFrameBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            if (component instanceof JInternalFrame) {
                JInternalFrame jInternalFrame = (JInternalFrame)component;
                if (jInternalFrame.isSelected()) {
                    graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
                } else {
                    graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getInactiveWindowBorderColor());
                }
            } else if (component instanceof JFrame) {
                JFrame jFrame = (JFrame)component;
                if (jFrame.isActive()) {
                    graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
                } else {
                    graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getInactiveWindowBorderColor());
                }
            }
            graphics.translate(n, n2);
            graphics.drawLine(0, 0, n3 - 1, 0);
            graphics.drawLine(0, 0, 0, n4 - 1);
            graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
            graphics.drawLine(n3 - 1, n2, n3 - 1, n4 - 1);
            if (this.getBorderInsets((Component)component).top == 2) {
                graphics.drawLine(1, 1, n3 - 2, 1);
                graphics.drawLine(1, 1, 1, n4 - 2);
                graphics.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
                graphics.drawLine(n3 - 2, n2, n3 - 2, n4 - 2);
            }
            graphics.translate(-n, -n2);
            graphics.setColor(color);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = component instanceof JInternalFrame && ((JInternalFrame)component).getClientProperty("JInternalFrame.isPalette") != null ? 1 : 2;
            insets.bottom = insets.top;
            insets.right = insets.top;
            insets.left = insets.top;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    private static class ParentBackgroundBorder
    extends AbstractBorder
    implements UIResource {
        private ParentBackgroundBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(component.getParent() != null ? component.getParent().getBackground() : SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
            graphics.drawLine(n, n2, n + n3 - 1, n2);
            graphics.drawLine(n, n2, n, n2 + n4 - 1);
            graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
            graphics.setColor(color);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.right = 1;
            insets.bottom = 1;
            insets.left = 1;
            insets.top = 1;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    private static class ControlBorder
    extends AbstractBorder
    implements UIResource {
        private ControlBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            if (!component.isEnabled()) {
                graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getDisabledBorderColor());
            } else if (component instanceof JButton && ((JButton)component).isDefaultButton()) {
                graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getDefaultButtonBorderColor());
            } else {
                graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
            }
            graphics.drawLine(n, n2, n + n3 - 1, n2);
            graphics.drawLine(n, n2, n, n2 + n4 - 1);
            graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
            graphics.setColor(color);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.right = 1;
            insets.bottom = 1;
            insets.left = 1;
            insets.top = 1;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

