/*
 * Decompiled with CFR 0.152.
 */
package uk.me.jstott.jcoord;

import uk.me.jstott.jcoord.CoordinateSystem;
import uk.me.jstott.jcoord.LatLng;
import uk.me.jstott.jcoord.Util;
import uk.me.jstott.jcoord.datum.Datum;
import uk.me.jstott.jcoord.datum.WGS84Datum;
import uk.me.jstott.jcoord.ellipsoid.Ellipsoid;

public class ECEFRef
extends CoordinateSystem {
    private double x;
    private double y;
    private double z;

    public ECEFRef(double d, double d2, double d3) {
        this(d, d2, d3, new WGS84Datum());
    }

    public ECEFRef(double d, double d2, double d3, Datum datum) {
        super(datum);
        this.setX(d);
        this.setY(d2);
        this.setZ(d3);
    }

    public ECEFRef(LatLng latLng) {
        super(latLng.getDatum());
        Ellipsoid ellipsoid = this.getDatum().getReferenceEllipsoid();
        double d = Math.toRadians(latLng.getLatitude());
        double d2 = Math.toRadians(latLng.getLongitude());
        double d3 = latLng.getHeight();
        double d4 = ellipsoid.getSemiMajorAxis();
        double d5 = ellipsoid.getFlattening();
        double d6 = 2.0 * d5 - d5 * d5;
        double d7 = d4 / Math.sqrt(1.0 - d6 * Util.sinSquared(d));
        this.setX((d7 + d3) * Math.cos(d) * Math.cos(d2));
        this.setY((d7 + d3) * Math.cos(d) * Math.sin(d2));
        this.setZ((d7 * (1.0 - d6) + d3) * Math.sin(d));
    }

    @Override
    public LatLng toLatLng() {
        Ellipsoid ellipsoid = this.getDatum().getReferenceEllipsoid();
        double d = ellipsoid.getSemiMajorAxis();
        double d2 = ellipsoid.getSemiMinorAxis();
        double d3 = (d * d - d2 * d2) / (d2 * d2);
        double d4 = ellipsoid.getFlattening();
        double d5 = 2.0 * d4 - d4 * d4;
        double d6 = Math.sqrt(this.x * this.x + this.y * this.y);
        double d7 = Math.atan(this.z * d / (d6 * d2));
        double d8 = Math.atan((this.z + d3 * d2 * Util.sinCubed(d7)) / (d6 - d5 * d * Util.cosCubed(d7)));
        double d9 = Math.atan2(this.y, this.x);
        double d10 = d / Math.sqrt(1.0 - d5 * Util.sinSquared(d8));
        double d11 = d6 / Math.cos(d8) - d10;
        return new LatLng(Math.toDegrees(d8), Math.toDegrees(d9), d11, new WGS84Datum());
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public void setX(double d) {
        this.x = d;
    }

    public void setY(double d) {
        this.y = d;
    }

    public void setZ(double d) {
        this.z = d;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")";
    }
}

