/*
 * Decompiled with CFR 0.152.
 */
package uk.me.jstott.jcoord;

import uk.me.jstott.jcoord.MGRSRef;
import uk.me.jstott.jcoord.NotDefinedOnUTMGridException;
import uk.me.jstott.jcoord.OSRef;
import uk.me.jstott.jcoord.UTMRef;
import uk.me.jstott.jcoord.Util;
import uk.me.jstott.jcoord.datum.Datum;
import uk.me.jstott.jcoord.datum.WGS84Datum;
import uk.me.jstott.jcoord.ellipsoid.Airy1830Ellipsoid;
import uk.me.jstott.jcoord.ellipsoid.WGS84Ellipsoid;

public class LatLng {
    private double latitude;
    private double longitude;
    private double height;
    private Datum datum = new WGS84Datum();
    public static final int NORTH = 1;
    public static final int SOUTH = -1;
    public static final int EAST = 1;
    public static final int WEST = -1;

    public LatLng(double d, double d2) {
        this(d, d2, 0.0, new WGS84Datum());
    }

    public LatLng(double d, double d2, double d3) {
        this(d, d2, d3, new WGS84Datum());
    }

    public LatLng(int n, int n2, double d, int n3, int n4, int n5, double d2, int n6) throws IllegalArgumentException {
        this(n, n2, d, n3, n4, n5, d2, n6, 0.0, new WGS84Datum());
    }

    public LatLng(int n, int n2, double d, int n3, int n4, int n5, double d2, int n6, double d3) throws IllegalArgumentException {
        this(n, n2, d, n3, n4, n5, d2, n6, d3, new WGS84Datum());
    }

    public LatLng(int n, int n2, double d, int n3, int n4, int n5, double d2, int n6, double d3, Datum datum) throws IllegalArgumentException {
        if ((double)n < 0.0 || (double)n > 90.0 || (double)n2 < 0.0 || (double)n2 >= 60.0 || d < 0.0 || d >= 60.0 || n3 != -1 && n3 != 1) {
            throw new IllegalArgumentException("Invalid latitude");
        }
        if ((double)n4 < 0.0 || (double)n4 > 180.0 || (double)n5 < 0.0 || (double)n5 >= 60.0 || d2 < 0.0 || d2 >= 60.0 || n6 != -1 && n6 != 1) {
            throw new IllegalArgumentException("Invalid longitude");
        }
        this.latitude = (double)n3 * ((double)n + (double)n2 / 60.0 + d / 3600.0);
        this.longitude = (double)n6 * ((double)n4 + (double)n5 / 60.0 + d2 / 3600.0);
        this.datum = datum;
    }

    public LatLng(double d, double d2, double d3, Datum datum) throws IllegalArgumentException {
        if (d < -90.0 || d > 90.0) {
            throw new IllegalArgumentException("Latitude (" + d + ") is invalid. Must be between -90.0 and 90.0 inclusive.");
        }
        if (d2 < -180.0 || d2 > 180.0) {
            throw new IllegalArgumentException("Longitude (" + d2 + ") is invalid. Must be between -180.0 and 180.0 inclusive.");
        }
        this.latitude = d;
        this.longitude = d2;
        this.height = d3;
        this.datum = datum;
    }

    public String toString() {
        return this.latitude + ", " + this.longitude;
    }

    public String toDMSString() {
        String string = this.formatLatitude() + ", " + this.formatLongitude();
        return string;
    }

    public String toDMString() {
        String string = this.formatLatitudeDM() + ", " + this.formatLongitudeDM();
        return string;
    }

    private String formatLatitude() {
        String string = this.getLatitude() >= 0.0 ? "N" : "S";
        return Math.abs(this.getLatitudeDegrees()) + "\u00b0 " + this.getLatitudeMinutes() + "' " + this.getLatitudeSeconds() + "\" " + string;
    }

    private String formatLatitudeDM() {
        String string = this.getLatitude() >= 0.0 ? "N" : "S";
        double d = (double)this.getLatitudeMinutes() + this.getLatitudeSeconds() / 60.0;
        return Math.abs(this.getLatitudeDegrees()) + "\u00b0 " + d + "' " + string;
    }

    private String formatLongitude() {
        String string = this.getLongitude() >= 0.0 ? "E" : "W";
        return Math.abs(this.getLongitudeDegrees()) + "\u00b0 " + this.getLongitudeMinutes() + "' " + this.getLongitudeSeconds() + "\" " + string;
    }

    private String formatLongitudeDM() {
        String string = this.getLongitude() >= 0.0 ? "E" : "W";
        double d = (double)this.getLongitudeMinutes() + this.getLongitudeSeconds() / 60.0;
        return Math.abs(this.getLongitudeDegrees()) + "\u00b0 " + d + "' " + string;
    }

    public OSRef toOSRef() {
        Airy1830Ellipsoid airy1830Ellipsoid = Airy1830Ellipsoid.getInstance();
        double d = 0.9996012717;
        double d2 = -100000.0;
        double d3 = 400000.0;
        double d4 = Math.toRadians(49.0);
        double d5 = Math.toRadians(-2.0);
        double d6 = airy1830Ellipsoid.getSemiMajorAxis();
        double d7 = airy1830Ellipsoid.getSemiMinorAxis();
        double d8 = airy1830Ellipsoid.getEccentricitySquared();
        double d9 = Math.toRadians(this.getLat());
        double d10 = Math.toRadians(this.getLng());
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = (d6 - d7) / (d6 + d7);
        double d14 = d6 * d * Math.pow(1.0 - d8 * Util.sinSquared(d9), -0.5);
        double d15 = d6 * d * (1.0 - d8) * Math.pow(1.0 - d8 * Util.sinSquared(d9), -1.5);
        double d16 = d14 / d15 - 1.0;
        double d17 = d7 * d * ((1.0 + d13 + 1.25 * d13 * d13 + 1.25 * d13 * d13 * d13) * (d9 - d4) - (3.0 * d13 + 3.0 * d13 * d13 + 2.625 * d13 * d13 * d13) * Math.sin(d9 - d4) * Math.cos(d9 + d4) + (1.875 * d13 * d13 + 1.875 * d13 * d13 * d13) * Math.sin(2.0 * (d9 - d4)) * Math.cos(2.0 * (d9 + d4)) - 1.4583333333333333 * d13 * d13 * d13 * Math.sin(3.0 * (d9 - d4)) * Math.cos(3.0 * (d9 + d4)));
        double d18 = d17 + d2;
        double d19 = d14 / 2.0 * Math.sin(d9) * Math.cos(d9);
        double d20 = d14 / 24.0 * Math.sin(d9) * Math.pow(Math.cos(d9), 3.0) * (5.0 - Util.tanSquared(d9) + 9.0 * d16);
        double d21 = d14 / 720.0 * Math.sin(d9) * Math.pow(Math.cos(d9), 5.0) * (61.0 - 58.0 * Util.tanSquared(d9) + Math.pow(Math.tan(d9), 4.0));
        double d22 = d14 * Math.cos(d9);
        double d23 = d14 / 6.0 * Math.pow(Math.cos(d9), 3.0) * (d14 / d15 - Util.tanSquared(d9));
        double d24 = d14 / 120.0 * Math.pow(Math.cos(d9), 5.0) * (5.0 - 18.0 * Util.tanSquared(d9) + Math.pow(Math.tan(d9), 4.0) + 14.0 * d16 - 58.0 * Util.tanSquared(d9) * d16);
        d12 = d18 + d19 * Math.pow(d10 - d5, 2.0) + d20 * Math.pow(d10 - d5, 4.0) + d21 * Math.pow(d10 - d5, 6.0);
        d11 = d3 + d22 * (d10 - d5) + d23 * Math.pow(d10 - d5, 3.0) + d24 * Math.pow(d10 - d5, 5.0);
        return new OSRef(d11, d12);
    }

    public UTMRef toUTMRef() throws NotDefinedOnUTMGridException {
        if (this.getLatitude() < -80.0 || this.getLatitude() > 84.0) {
            throw new NotDefinedOnUTMGridException("Latitude (" + this.getLatitude() + ") falls outside the UTM grid.");
        }
        if (this.longitude == 180.0) {
            this.longitude = -180.0;
        }
        double d = 0.9996;
        double d2 = WGS84Ellipsoid.getInstance().getSemiMajorAxis();
        double d3 = WGS84Ellipsoid.getInstance().getEccentricitySquared();
        double d4 = this.longitude;
        double d5 = this.latitude;
        double d6 = d5 * (Math.PI / 180);
        double d7 = d4 * (Math.PI / 180);
        int n = (int)Math.floor((d4 + 180.0) / 6.0) + 1;
        if (d5 >= 56.0 && d5 < 64.0 && d4 >= 3.0 && d4 < 12.0) {
            n = 32;
        }
        if (d5 >= 72.0 && d5 < 84.0) {
            if (d4 >= 0.0 && d4 < 9.0) {
                n = 31;
            } else if (d4 >= 9.0 && d4 < 21.0) {
                n = 33;
            } else if (d4 >= 21.0 && d4 < 33.0) {
                n = 35;
            } else if (d4 >= 33.0 && d4 < 42.0) {
                n = 37;
            }
        }
        double d8 = (n - 1) * 6 - 180 + 3;
        double d9 = d8 * (Math.PI / 180);
        char c = UTMRef.getUTMLatitudeZoneLetter(d5);
        double d10 = d3 / (1.0 - d3);
        double d11 = d2 / Math.sqrt(1.0 - d3 * Math.sin(d6) * Math.sin(d6));
        double d12 = Math.tan(d6) * Math.tan(d6);
        double d13 = d10 * Math.cos(d6) * Math.cos(d6);
        double d14 = Math.cos(d6) * (d7 - d9);
        double d15 = d2 * ((1.0 - d3 / 4.0 - 3.0 * d3 * d3 / 64.0 - 5.0 * d3 * d3 * d3 / 256.0) * d6 - (3.0 * d3 / 8.0 + 3.0 * d3 * d3 / 32.0 + 45.0 * d3 * d3 * d3 / 1024.0) * Math.sin(2.0 * d6) + (15.0 * d3 * d3 / 256.0 + 45.0 * d3 * d3 * d3 / 1024.0) * Math.sin(4.0 * d6) - 35.0 * d3 * d3 * d3 / 3072.0 * Math.sin(6.0 * d6));
        double d16 = d * d11 * (d14 + (1.0 - d12 + d13) * Math.pow(d14, 3.0) / 6.0 + (5.0 - 18.0 * d12 + d12 * d12 + 72.0 * d13 - 58.0 * d10) * Math.pow(d14, 5.0) / 120.0) + 500000.0;
        double d17 = d * (d15 + d11 * Math.tan(d6) * (d14 * d14 / 2.0 + (5.0 - d12 + 9.0 * d13 + 4.0 * d13 * d13) * Math.pow(d14, 4.0) / 24.0 + (61.0 - 58.0 * d12 + d12 * d12 + 600.0 * d13 - 330.0 * d10) * Math.pow(d14, 6.0) / 720.0));
        if (d5 < 0.0) {
            d17 += 1.0E7;
        }
        return new UTMRef(n, c, d16, d17);
    }

    public MGRSRef toMGRSRef() {
        UTMRef uTMRef = this.toUTMRef();
        return new MGRSRef(uTMRef);
    }

    public void toWGS84() {
        double d;
        double d2 = Airy1830Ellipsoid.getInstance().getSemiMajorAxis();
        double d3 = Airy1830Ellipsoid.getInstance().getEccentricitySquared();
        double d4 = Math.toRadians(this.latitude);
        double d5 = Math.toRadians(this.longitude);
        double d6 = d2 / Math.sqrt(1.0 - d3 * Util.sinSquared(d4));
        double d7 = 0.0;
        double d8 = (d6 + d7) * Math.cos(d4) * Math.cos(d5);
        double d9 = (d6 + d7) * Math.cos(d4) * Math.sin(d5);
        double d10 = ((1.0 - d3) * d6 + d7) * Math.sin(d4);
        double d11 = 446.448;
        double d12 = -125.157;
        double d13 = 542.06;
        double d14 = -2.04894E-5;
        double d15 = Math.toRadians(4.172222E-5);
        double d16 = Math.toRadians(6.861111E-5);
        double d17 = Math.toRadians(2.3391666E-4);
        double d18 = d11 + d8 * (1.0 + d14) + -d15 * d9 + d16 * d10;
        double d19 = d12 + d17 * d8 + d9 * (1.0 + d14) + -d15 * d10;
        double d20 = d13 + -d16 * d8 + d15 * d9 + d10 * (1.0 + d14);
        d2 = WGS84Ellipsoid.getInstance().getSemiMajorAxis();
        d3 = WGS84Ellipsoid.getInstance().getEccentricitySquared();
        double d21 = Math.toDegrees(Math.atan(d19 / d18));
        double d22 = Math.sqrt(d18 * d18 + d19 * d19);
        double d23 = Math.atan(d20 / (d22 * (1.0 - d3)));
        for (int i = 1; i < 10; ++i) {
            double d24;
            d6 = d2 / Math.sqrt(1.0 - d3 * Util.sinSquared(d23));
            d23 = d24 = Math.atan((d20 + d3 * d6 * Math.sin(d23)) / d22);
        }
        this.latitude = d = Math.toDegrees(d23);
        this.longitude = d21;
    }

    public void toDatum(Datum datum) {
        double d;
        double d2 = 1.0;
        if (!(this.datum instanceof WGS84Datum) && !(datum instanceof WGS84Datum)) {
            this.toDatum(new WGS84Datum());
        } else {
            if (datum instanceof WGS84Datum) {
                return;
            }
            d2 = -1.0;
        }
        double d3 = this.datum.getReferenceEllipsoid().getSemiMajorAxis();
        double d4 = this.datum.getReferenceEllipsoid().getEccentricitySquared();
        double d5 = Math.toRadians(this.latitude);
        double d6 = Math.toRadians(this.longitude);
        double d7 = d3 / Math.sqrt(1.0 - d4 * Util.sinSquared(d5));
        double d8 = this.height;
        double d9 = (d7 + d8) * Math.cos(d5) * Math.cos(d6);
        double d10 = (d7 + d8) * Math.cos(d5) * Math.sin(d6);
        double d11 = ((1.0 - d4) * d7 + d8) * Math.sin(d5);
        double d12 = d2 * datum.getDx();
        double d13 = d2 * datum.getDy();
        double d14 = d2 * datum.getDz();
        double d15 = d2 * datum.getDs() / 1000000.0;
        double d16 = d2 * Math.toRadians(datum.getRx() / 3600.0);
        double d17 = d2 * Math.toRadians(datum.getRy() / 3600.0);
        double d18 = d2 * Math.toRadians(datum.getRz() / 3600.0);
        double d19 = 1.0 + d15;
        double d20 = d12 + d9 * d19 + -d16 * d10 * d19 + d17 * d11 * d19;
        double d21 = d13 + d18 * d9 * d19 + d10 * d19 + -d16 * d11 * d19;
        double d22 = d14 + -d17 * d9 * d19 + d16 * d10 * d19 + d11 * d19;
        d3 = datum.getReferenceEllipsoid().getSemiMajorAxis();
        d4 = datum.getReferenceEllipsoid().getEccentricitySquared();
        double d23 = Math.toDegrees(Math.atan(d21 / d20));
        double d24 = Math.sqrt(d20 * d20 + d21 * d21);
        double d25 = Math.atan(d22 / (d24 * (1.0 - d4)));
        for (int i = 1; i < 10; ++i) {
            double d26;
            d7 = d3 / Math.sqrt(1.0 - d4 * Util.sinSquared(d25));
            d25 = d26 = Math.atan((d22 + d4 * d7 * Math.sin(d25)) / d24);
        }
        this.latitude = d = Math.toDegrees(d25);
        this.longitude = d23;
    }

    public void toOSGB36() {
        double d;
        WGS84Ellipsoid wGS84Ellipsoid = WGS84Ellipsoid.getInstance();
        double d2 = wGS84Ellipsoid.getSemiMajorAxis();
        double d3 = wGS84Ellipsoid.getEccentricitySquared();
        double d4 = Math.toRadians(this.latitude);
        double d5 = Math.toRadians(this.longitude);
        double d6 = d2 / Math.sqrt(1.0 - d3 * Util.sinSquared(d4));
        double d7 = 0.0;
        double d8 = (d6 + d7) * Math.cos(d4) * Math.cos(d5);
        double d9 = (d6 + d7) * Math.cos(d4) * Math.sin(d5);
        double d10 = ((1.0 - d3) * d6 + d7) * Math.sin(d4);
        double d11 = -446.448;
        double d12 = 125.157;
        double d13 = -542.06;
        double d14 = 2.04894E-5;
        double d15 = Math.toRadians(-4.172222E-5);
        double d16 = Math.toRadians(-6.861111E-5);
        double d17 = Math.toRadians(-2.3391666E-4);
        double d18 = d11 + d8 * (1.0 + d14) + -d15 * d9 + d16 * d10;
        double d19 = d12 + d17 * d8 + d9 * (1.0 + d14) + -d15 * d10;
        double d20 = d13 + -d16 * d8 + d15 * d9 + d10 * (1.0 + d14);
        d2 = Airy1830Ellipsoid.getInstance().getSemiMajorAxis();
        d3 = Airy1830Ellipsoid.getInstance().getEccentricitySquared();
        double d21 = Math.toDegrees(Math.atan(d19 / d18));
        double d22 = Math.sqrt(d18 * d18 + d19 * d19);
        double d23 = Math.atan(d20 / (d22 * (1.0 - d3)));
        for (int i = 1; i < 10; ++i) {
            double d24;
            d6 = d2 / Math.sqrt(1.0 - d3 * Util.sinSquared(d23));
            d23 = d24 = Math.atan((d20 + d3 * d6 * Math.sin(d23)) / d22);
        }
        this.latitude = d = Math.toDegrees(d23);
        this.longitude = d21;
    }

    public double distance(LatLng latLng) {
        double d = 6366.707;
        double d2 = Math.toRadians(this.getLat());
        double d3 = Math.toRadians(latLng.getLat());
        double d4 = Math.toRadians(this.getLng());
        double d5 = Math.toRadians(latLng.getLng());
        double d6 = Math.acos(Math.sin(d2) * Math.sin(d3) + Math.cos(d2) * Math.cos(d3) * Math.cos(d5 - d4)) * d;
        return d6;
    }

    public double distanceMiles(LatLng latLng) {
        return this.distance(latLng) / 1.609344;
    }

    public double getLat() {
        return this.latitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public int getLatitudeDegrees() {
        double d = this.getLatitude();
        int n = (int)Math.floor(d);
        double d2 = d - (double)n;
        if (d < 0.0 && d2 != 0.0) {
            ++n;
        }
        return n;
    }

    public int getLatitudeMinutes() {
        double d = this.getLatitude();
        int n = (int)Math.floor(d);
        double d2 = d - (double)n;
        if (d < 0.0 && d2 != 0.0) {
            d2 = 1.0 - d2;
        }
        int n2 = (int)Math.floor(d2 * 60.0);
        return n2;
    }

    public double getLatitudeSeconds() {
        double d = this.getLatitude();
        int n = (int)Math.floor(d);
        double d2 = d - (double)n;
        if (d < 0.0 && d2 != 0.0) {
            d2 = 1.0 - d2;
        }
        int n2 = (int)Math.floor(d2 * 60.0);
        double d3 = (d2 * 60.0 - (double)n2) * 60.0;
        return d3;
    }

    public double getLatitudeMinutesAndSeconds() {
        return (double)this.getLatitudeMinutes() + this.getLatitudeSeconds() / 60.0;
    }

    public double getLng() {
        return this.longitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public int getLongitudeDegrees() {
        double d = this.getLongitude();
        int n = (int)Math.floor(d);
        double d2 = d - (double)n;
        if (d < 0.0 && d2 != 0.0) {
            ++n;
        }
        return n;
    }

    public int getLongitudeMinutes() {
        double d = this.getLongitude();
        int n = (int)Math.floor(d);
        double d2 = d - (double)n;
        if (d < 0.0 && d2 != 0.0) {
            d2 = 1.0 - d2;
        }
        int n2 = (int)Math.floor(d2 * 60.0);
        return n2;
    }

    public double getLongitudeSeconds() {
        double d = this.getLongitude();
        int n = (int)Math.floor(d);
        double d2 = d - (double)n;
        if (d < 0.0 && d2 != 0.0) {
            d2 = 1.0 - d2;
        }
        int n2 = (int)Math.floor(d2 * 60.0);
        double d3 = (d2 * 60.0 - (double)n2) * 60.0;
        return d3;
    }

    public double getHeight() {
        return this.height;
    }

    public Datum getDatum() {
        return this.datum;
    }
}

