/*
 * Decompiled with CFR 0.152.
 */
package uk.me.jstott.jcoord;

import uk.me.jstott.jcoord.CoordinateSystem;
import uk.me.jstott.jcoord.LatLng;
import uk.me.jstott.jcoord.Util;
import uk.me.jstott.jcoord.datum.OSGB36Datum;
import uk.me.jstott.jcoord.ellipsoid.Airy1830Ellipsoid;

public class OSRef
extends CoordinateSystem {
    private double easting;
    private double northing;

    public OSRef(double d, double d2) throws IllegalArgumentException {
        super(OSGB36Datum.getInstance());
        this.setEasting(d);
        this.setNorthing(d2);
    }

    public OSRef(String string) throws IllegalArgumentException {
        super(OSGB36Datum.getInstance());
        char c = string.charAt(0);
        int n = string.charAt(1);
        int n2 = Integer.parseInt(string.substring(2, 5)) * 100;
        int n3 = Integer.parseInt(string.substring(5, 8)) * 100;
        if (c == 'H') {
            n3 += 1000000;
        } else if (c == 'N') {
            n3 += 500000;
        } else if (c == 'O') {
            n3 += 500000;
            n2 += 500000;
        } else if (c == 'T') {
            n2 += 500000;
        }
        int n4 = n;
        if (n4 > 73) {
            --n4;
        }
        double d = (n4 - 65) % 5 * 100000;
        double d2 = (4.0 - Math.floor((n4 - 65) / 5)) * 100000.0;
        this.setEasting((double)n2 + d);
        this.setNorthing((double)n3 + d2);
    }

    public OSRef(LatLng latLng) {
        super(OSGB36Datum.getInstance());
        Airy1830Ellipsoid airy1830Ellipsoid = Airy1830Ellipsoid.getInstance();
        double d = 0.9996012717;
        double d2 = -100000.0;
        double d3 = 400000.0;
        double d4 = Math.toRadians(49.0);
        double d5 = Math.toRadians(-2.0);
        double d6 = airy1830Ellipsoid.getSemiMajorAxis();
        double d7 = airy1830Ellipsoid.getSemiMinorAxis();
        double d8 = airy1830Ellipsoid.getEccentricitySquared();
        double d9 = Math.toRadians(latLng.getLatitude());
        double d10 = Math.toRadians(latLng.getLongitude());
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = (d6 - d7) / (d6 + d7);
        double d14 = d6 * d * Math.pow(1.0 - d8 * Util.sinSquared(d9), -0.5);
        double d15 = d6 * d * (1.0 - d8) * Math.pow(1.0 - d8 * Util.sinSquared(d9), -1.5);
        double d16 = d14 / d15 - 1.0;
        double d17 = d7 * d * ((1.0 + d13 + 1.25 * d13 * d13 + 1.25 * d13 * d13 * d13) * (d9 - d4) - (3.0 * d13 + 3.0 * d13 * d13 + 2.625 * d13 * d13 * d13) * Math.sin(d9 - d4) * Math.cos(d9 + d4) + (1.875 * d13 * d13 + 1.875 * d13 * d13 * d13) * Math.sin(2.0 * (d9 - d4)) * Math.cos(2.0 * (d9 + d4)) - 1.4583333333333333 * d13 * d13 * d13 * Math.sin(3.0 * (d9 - d4)) * Math.cos(3.0 * (d9 + d4)));
        double d18 = d17 + d2;
        double d19 = d14 / 2.0 * Math.sin(d9) * Math.cos(d9);
        double d20 = d14 / 24.0 * Math.sin(d9) * Math.pow(Math.cos(d9), 3.0) * (5.0 - Util.tanSquared(d9) + 9.0 * d16);
        double d21 = d14 / 720.0 * Math.sin(d9) * Math.pow(Math.cos(d9), 5.0) * (61.0 - 58.0 * Util.tanSquared(d9) + Math.pow(Math.tan(d9), 4.0));
        double d22 = d14 * Math.cos(d9);
        double d23 = d14 / 6.0 * Math.pow(Math.cos(d9), 3.0) * (d14 / d15 - Util.tanSquared(d9));
        double d24 = d14 / 120.0 * Math.pow(Math.cos(d9), 5.0) * (5.0 - 18.0 * Util.tanSquared(d9) + Math.pow(Math.tan(d9), 4.0) + 14.0 * d16 - 58.0 * Util.tanSquared(d9) * d16);
        d12 = d18 + d19 * Math.pow(d10 - d5, 2.0) + d20 * Math.pow(d10 - d5, 4.0) + d21 * Math.pow(d10 - d5, 6.0);
        d11 = d3 + d22 * (d10 - d5) + d23 * Math.pow(d10 - d5, 3.0) + d24 * Math.pow(d10 - d5, 5.0);
        this.setEasting(d11);
        this.setNorthing(d12);
    }

    public String toString() {
        return "(" + this.easting + ", " + this.northing + ")";
    }

    public String toSixFigureString() {
        int n = (int)Math.floor(this.easting / 100000.0);
        int n2 = (int)Math.floor(this.northing / 100000.0);
        String string = n2 < 5 ? (n < 5 ? "S" : "T") : (n2 < 10 ? (n < 5 ? "N" : "O") : "H");
        int n3 = 65 + (4 - n2 % 5) * 5 + n % 5;
        if (n3 >= 73) {
            ++n3;
        }
        String string2 = Character.toString((char)n3);
        int n4 = (int)Math.floor((this.easting - (double)(100000 * n)) / 100.0);
        int n5 = (int)Math.floor((this.northing - (double)(100000 * n2)) / 100.0);
        String string3 = "" + n4;
        if (n4 < 100) {
            string3 = "0" + string3;
        }
        if (n4 < 10) {
            string3 = "0" + string3;
        }
        String string4 = "" + n5;
        if (n5 < 100) {
            string4 = "0" + string4;
        }
        if (n5 < 10) {
            string4 = "0" + string4;
        }
        return string + string2 + string3 + string4;
    }

    @Override
    public LatLng toLatLng() {
        double d = 0.9996012717;
        double d2 = -100000.0;
        double d3 = 400000.0;
        double d4 = Math.toRadians(49.0);
        double d5 = Math.toRadians(-2.0);
        double d6 = this.getDatum().getReferenceEllipsoid().getSemiMajorAxis();
        double d7 = this.getDatum().getReferenceEllipsoid().getSemiMinorAxis();
        double d8 = this.getDatum().getReferenceEllipsoid().getEccentricitySquared();
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = this.easting;
        double d12 = this.northing;
        double d13 = (d6 - d7) / (d6 + d7);
        double d14 = 0.0;
        double d15 = (d12 - d2) / (d6 * d) + d4;
        do {
            d14 = d7 * d * ((1.0 + d13 + 1.25 * d13 * d13 + 1.25 * d13 * d13 * d13) * (d15 - d4) - (3.0 * d13 + 3.0 * d13 * d13 + 2.625 * d13 * d13 * d13) * Math.sin(d15 - d4) * Math.cos(d15 + d4) + (1.875 * d13 * d13 + 1.875 * d13 * d13 * d13) * Math.sin(2.0 * (d15 - d4)) * Math.cos(2.0 * (d15 + d4)) - 1.4583333333333333 * d13 * d13 * d13 * Math.sin(3.0 * (d15 - d4)) * Math.cos(3.0 * (d15 + d4)));
            d15 += (d12 - d2 - d14) / (d6 * d);
        } while (d12 - d2 - d14 >= 0.001);
        double d16 = d6 * d * Math.pow(1.0 - d8 * Util.sinSquared(d15), -0.5);
        double d17 = d6 * d * (1.0 - d8) * Math.pow(1.0 - d8 * Util.sinSquared(d15), -1.5);
        double d18 = d16 / d17 - 1.0;
        double d19 = Math.tan(d15) / (2.0 * d17 * d16);
        double d20 = Math.tan(d15) / (24.0 * d17 * Math.pow(d16, 3.0)) * (5.0 + 3.0 * Util.tanSquared(d15) + d18 - 9.0 * Util.tanSquared(d15) * d18);
        double d21 = Math.tan(d15) / (720.0 * d17 * Math.pow(d16, 5.0)) * (61.0 + 90.0 * Util.tanSquared(d15) + 45.0 * Util.tanSquared(d15) * Util.tanSquared(d15));
        double d22 = Util.sec(d15) / d16;
        double d23 = Util.sec(d15) / (6.0 * d16 * d16 * d16) * (d16 / d17 + 2.0 * Util.tanSquared(d15));
        double d24 = Util.sec(d15) / (120.0 * Math.pow(d16, 5.0)) * (5.0 + 28.0 * Util.tanSquared(d15) + 24.0 * Util.tanSquared(d15) * Util.tanSquared(d15));
        double d25 = Util.sec(d15) / (5040.0 * Math.pow(d16, 7.0)) * (61.0 + 662.0 * Util.tanSquared(d15) + 1320.0 * Util.tanSquared(d15) * Util.tanSquared(d15) + 720.0 * Util.tanSquared(d15) * Util.tanSquared(d15) * Util.tanSquared(d15));
        d9 = d15 - d19 * Math.pow(d11 - d3, 2.0) + d20 * Math.pow(d11 - d3, 4.0) - d21 * Math.pow(d11 - d3, 6.0);
        d10 = d5 + d22 * (d11 - d3) - d23 * Math.pow(d11 - d3, 3.0) + d24 * Math.pow(d11 - d3, 5.0) - d25 * Math.pow(d11 - d3, 7.0);
        return new LatLng(Math.toDegrees(d9), Math.toDegrees(d10));
    }

    public double getEasting() {
        return this.easting;
    }

    public double getNorthing() {
        return this.northing;
    }

    public void setEasting(double d) throws IllegalArgumentException {
        if (d < 0.0 || d >= 800000.0) {
            throw new IllegalArgumentException("Easting (" + d + ") is invalid. Must be greather than or equal to 0.0 and " + "less than 800000.0.");
        }
        this.easting = d;
    }

    public void setNorthing(double d) throws IllegalArgumentException {
        if (d < 0.0 || d >= 1400000.0) {
            throw new IllegalArgumentException("Northing (" + d + ") is invalid. Must be greather than or equal to 0.0 and less " + "than 1400000.0.");
        }
        this.northing = d;
    }
}

