/*
 * Decompiled with CFR 0.152.
 */
package uk.me.jstott.jcoord;

import uk.me.jstott.jcoord.LatLng;
import uk.me.jstott.jcoord.MGRSRef;
import uk.me.jstott.jcoord.OSRef;
import uk.me.jstott.jcoord.UTMRef;

public class Test {
    public static void main(String[] stringArray) {
        System.out.println("Calculate Surface Distance between two Latitudes/Longitudes");
        LatLng latLng = new LatLng(40.718119, -73.995667);
        System.out.println("New York Lat/Long: " + latLng.toString());
        LatLng latLng2 = new LatLng(51.499981, -0.125313);
        System.out.println("London Lat/Long: " + latLng2.toString());
        double d = latLng.distance(latLng2);
        System.out.println("Surface Distance between New York and London: " + d + "km");
        System.out.println();
        System.out.println("Convert OS Grid Reference to Latitude/Longitude");
        System.out.println("Using OSGB36");
        OSRef oSRef = new OSRef(651409.903, 313177.27);
        System.out.println("OS Grid Reference: " + oSRef.toString() + " - " + oSRef.toSixFigureString());
        LatLng latLng3 = oSRef.toLatLng();
        System.out.println("Converted to Lat/Long: " + latLng3.toString());
        System.out.println();
        System.out.println("Using WGS84");
        OSRef oSRef2 = new OSRef(651409.903, 313177.27);
        System.out.println("OS Grid Reference: " + oSRef2.toString() + " - " + oSRef2.toSixFigureString());
        LatLng latLng4 = oSRef2.toLatLng();
        latLng4.toWGS84();
        System.out.println("Converted to Lat/Long: " + latLng4.toString());
        System.out.println();
        System.out.println("Convert Latitude/Longitude to OS Grid Reference");
        System.out.println("Using OSGB36");
        LatLng latLng5 = new LatLng(52.657570301933, 1.7179215806451);
        System.out.println("Latitude/Longitude: " + latLng5.toString());
        OSRef oSRef3 = latLng5.toOSRef();
        System.out.println("Converted to OS Grid Ref: " + oSRef3.toString() + " - " + oSRef3.toSixFigureString());
        System.out.println();
        System.out.println("Using WGS84");
        LatLng latLng6 = new LatLng(52.657570301933, 1.7179215806451);
        System.out.println("Latitude/Longitude: " + latLng5.toString() + " : " + latLng5.toDMSString());
        latLng6.toOSGB36();
        OSRef oSRef4 = latLng6.toOSRef();
        System.out.println("Converted to OS Grid Ref: " + oSRef4.toString() + " - " + oSRef4.toSixFigureString());
        System.out.println();
        System.out.println("Convert Six-Figure OS Grid Reference String to an OSRef Object");
        String string = "TG514131";
        System.out.println("Six figure string: " + string);
        OSRef oSRef5 = new OSRef(string);
        System.out.println("Converted to OS Grid Ref: " + oSRef5.toString() + " - " + oSRef5.toSixFigureString());
        System.out.println();
        System.out.println("Convert UTM Reference to Latitude/Longitude");
        UTMRef uTMRef = new UTMRef(12, 'E', 456463.99, 3335334.05);
        System.out.println("UTM Reference: " + uTMRef.toString());
        LatLng latLng7 = uTMRef.toLatLng();
        System.out.println("Converted to Lat/Long: " + latLng7.toString());
        System.out.println();
        System.out.println("Convert Latitude/Longitude to UTM Reference");
        LatLng latLng8 = new LatLng(-60.1167, -111.7833);
        System.out.println("Latitude/Longitude: " + latLng8.toString());
        UTMRef uTMRef2 = latLng8.toUTMRef();
        System.out.println("Converted to UTM Ref: " + uTMRef2.toString());
        System.out.println();
        Test.mgrsTests();
    }

    public static void mgrsTests() {
        System.out.println("Convert UTM Reference to MGRS Reference");
        UTMRef uTMRef = new UTMRef(13, 'S', 443575.71, 4349755.98);
        System.out.println("UTM Reference: " + uTMRef.toString());
        MGRSRef mGRSRef = new MGRSRef(uTMRef);
        System.out.println("MGRS Reference: " + mGRSRef.toString());
        System.out.println();
        System.out.println("Convert MGRS reference to UTM reference");
        MGRSRef mGRSRef2 = new MGRSRef(10, 'U', 'E', 'U', 0, 16300, 1);
        System.out.println("MGRS Reference: " + mGRSRef2.toString());
        UTMRef uTMRef2 = mGRSRef2.toUTMRef();
        System.out.println("UTM Reference: " + uTMRef2.toString());
        System.out.println();
        System.out.println("Convert MGRS reference to latitude/longitude");
        MGRSRef mGRSRef3 = new MGRSRef(13, 'S', 'D', 'D', 43575, 49756, 1);
        System.out.println("MGRS Reference: " + mGRSRef3.toString());
        UTMRef uTMRef3 = mGRSRef3.toUTMRef();
        System.out.println("UTM Reference: " + uTMRef3.toString());
        LatLng latLng = mGRSRef3.toLatLng();
        System.out.println("Latitude/Longitude: " + latLng.toString());
        System.out.println();
        System.out.println("Convert latitude/longitude to MGRS reference");
        LatLng latLng2 = new LatLng(39.295339, -105.654342);
        System.out.println("Latitude/Longitude: " + latLng2.toString());
        UTMRef uTMRef4 = latLng2.toUTMRef();
        System.out.println("UTM Reference: " + uTMRef4.toString());
        MGRSRef mGRSRef4 = latLng2.toMGRSRef();
        System.out.println("MGRS Reference: " + mGRSRef4.toString());
        System.out.println();
        System.out.println("Create an MGRS reference from a String");
        MGRSRef mGRSRef5 = new MGRSRef("32UMU1078");
        System.out.println(mGRSRef5.toString(1));
        UTMRef uTMRef5 = mGRSRef5.toUTMRef();
        System.out.println("UTM Reference: " + uTMRef5.toString());
        LatLng latLng3 = mGRSRef5.toLatLng();
        System.out.println("Latitude/Longitude: " + latLng3.toString());
        System.out.println();
    }
}

