/*
 * Decompiled with CFR 0.152.
 */
package uk.me.jstott.jcoord.ellipsoid;

public abstract class Ellipsoid {
    protected double semiMajorAxis;
    protected double semiMinorAxis;
    protected double eccentricitySquared;
    protected double flattening;

    public Ellipsoid(double d, double d2) {
        this.semiMajorAxis = d;
        this.semiMinorAxis = d2;
        double d3 = d * d;
        double d4 = d2 * d2;
        this.flattening = (d - d2) / d;
        this.eccentricitySquared = (d3 - d4) / d3;
    }

    public Ellipsoid(double d, double d2, double d3) throws IllegalArgumentException {
        if (Double.isNaN(d2) && Double.isNaN(d3)) {
            throw new IllegalArgumentException("At least one of semiMinorAxis and eccentricitySquared must be defined");
        }
        this.semiMajorAxis = d;
        double d4 = d * d;
        this.semiMinorAxis = Double.isNaN(d2) ? Math.sqrt(d4 * (1.0 - d3)) : d2;
        double d5 = this.semiMinorAxis * this.semiMinorAxis;
        this.flattening = (this.semiMajorAxis - this.semiMinorAxis) / this.semiMajorAxis;
        this.eccentricitySquared = Double.isNaN(d3) ? (d4 - d5) / d4 : d3;
    }

    public String toString() {
        return "[semi-major axis = " + this.getSemiMajorAxis() + ", semi-minor axis = " + this.getSemiMinorAxis() + "]";
    }

    public double getEccentricitySquared() {
        return this.eccentricitySquared;
    }

    public double getFlattening() {
        return this.flattening;
    }

    public double getSemiMajorAxis() {
        return this.semiMajorAxis;
    }

    public double getSemiMinorAxis() {
        return this.semiMinorAxis;
    }
}

