/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.categories;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import net.numericalchameleon.categories.CategoryInterface;
import net.numericalchameleon.categories.CategoryObject;
import net.numericalchameleon.data.Unit;

public class CategoryBases35
extends CategoryObject {
    private static String INVALID;
    private ArrayList<Unit> units;
    private Unit defaultSourceUnit;
    private Unit defaultTargetUnit;
    private Unit transferUnit;

    public CategoryBases35(CategoryInterface categoryInterface) {
        this.rb = categoryInterface.getResourceBundle();
        INVALID = this.localize("Moduls.sourceInvalid", "Source is invalid");
        this.units = new ArrayList();
        for (int i = 2; i < 37; ++i) {
            String brackets;
            switch (i) {
                case 2: {
                    brackets = String.format(" (%s)", this.localize("Radix.dual", "Dual"));
                    break;
                }
                case 8: {
                    brackets = String.format(" (%s)", this.localize("Radix.octal", "Octal"));
                    break;
                }
                case 10: {
                    brackets = String.format(" (%s)", this.localize("Moduls.decimalName", "Decimal"));
                    break;
                }
                case 16: {
                    brackets = String.format(" (%s)", this.localize("Radix.hex", "Hexadecimal"));
                    break;
                }
                default: {
                    brackets = "";
                }
            }
            String name = String.format("%s %d%s", this.localize("Radix.radix", "Radix"), i, brackets);
            Unit unit = new Unit(i, name, "int");
            if (i == 10) {
                this.defaultSourceUnit = unit;
                this.transferUnit = unit;
            } else if (i == 16) {
                this.defaultTargetUnit = unit;
            }
            this.units.add(unit);
        }
    }

    @Override
    public ArrayList<Unit> getSourceUnits() {
        return this.units;
    }

    @Override
    public ArrayList<Unit> getTargetUnits() {
        return this.units;
    }

    @Override
    public int getSourceDefault() {
        return 8;
    }

    public Unit getDefaultSourceUnit() {
        return this.defaultSourceUnit;
    }

    @Override
    public int getTargetDefault() {
        return 14;
    }

    public Unit getDefaultTargetUnit() {
        return this.defaultTargetUnit;
    }

    @Override
    public int getPreferredPrecision() {
        return -1;
    }

    @Override
    public String getOutput(int s, int t) throws Exception {
        Unit sourceUnit = this.units.get(s);
        Unit targetUnit = this.units.get(t);
        return this.getOutput(sourceUnit, targetUnit);
    }

    @Override
    public String getOutput(Unit sourceUnit, Unit targetUnit) throws Exception {
        int sid = sourceUnit.getId();
        int tid = targetUnit.getId();
        BigInteger big = null;
        try {
            big = new BigInteger(this.input, sid);
        }
        catch (Exception e) {
            throw new Exception(INVALID);
        }
        return big.toString(tid).toUpperCase();
    }

    @Override
    public String addValue(BigDecimal plus, int sourceindex) throws Exception {
        Unit sourceUnit = this.units.get(sourceindex);
        return this.addValue(plus, sourceUnit);
    }

    public String addValue(BigDecimal plus, Unit sourceUnit) throws Exception {
        if (this.input == null || this.input.length() == 0) {
            this.input = "0";
        }
        BigDecimal big = new BigDecimal(this.getOutput(sourceUnit, this.transferUnit));
        big = big.add(plus);
        return this.setValue(big, sourceUnit);
    }

    @Override
    public String setValue(BigDecimal big, int sourceIndex) throws Exception {
        Unit sourceUnit = this.units.get(sourceIndex);
        return this.setValue(big, sourceUnit);
    }

    public String setValue(BigDecimal big, Unit sourceUnit) throws Exception {
        this.setInput(big.toPlainString());
        return this.getOutput(this.transferUnit, sourceUnit);
    }

    @Override
    public String getTransferValue(int sourceIndex) throws Exception {
        Unit sourceUnit = this.units.get(sourceIndex);
        return this.getTransferValue(sourceUnit);
    }

    @Override
    public String getTransferValue(Unit sourceUnit) throws Exception {
        return this.getOutput(sourceUnit, this.transferUnit);
    }

    @Override
    public String getCard() {
        return "emptyCard";
    }
}

