/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.categories;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.numericalchameleon.categories.CategoryInterface;
import net.numericalchameleon.categories.CategoryObject;
import net.numericalchameleon.data.Unit;
import uk.me.jstott.jcoord.ECEFRef;
import uk.me.jstott.jcoord.LatLng;
import uk.me.jstott.jcoord.MGRSRef;
import uk.me.jstott.jcoord.UTMRef;

public class CategoryCoordinates
extends CategoryObject {
    public static final int cLATLNGDEC = 0;
    public static final int cLATLNGDMS = 1;
    public static final int cLATLNGDM = 2;
    public static final int cUTM = 3;
    public static final int cMAIDENHEAD = 4;
    public static final int cMGRS = 5;
    public static final int cECEF = 6;
    public static String LATLNGDEC;
    public static String LATLNGDM;
    public static String LATLNGDMS;
    public static String UTM;
    public static String LATITUDE;
    public static String LONGITUDE;
    public static String MAIDENHEAD_LOCATOR;
    public static String MGRS;
    public static String ECEF;
    public static String INVALID;
    private final ArrayList<Unit> units;

    public CategoryCoordinates(CategoryInterface categoryInterface) {
        this.rb = categoryInterface.getResourceBundle();
        INVALID = this.localize("Moduls.sourceInvalid", "Source is invalid");
        LATITUDE = this.localize("GUI.General.Latitude", "Latitude");
        LONGITUDE = this.localize("GUI.General.Longitude", "Longitude");
        LATLNGDEC = LATITUDE + "/" + LONGITUDE + " (WGS 84) [9.9, 9.9]";
        LATLNGDM = LATITUDE + "/" + LONGITUDE + " (WGS 84) [9\u00b0 9.9' N, 9\u00b0 9.9' E]";
        LATLNGDMS = LATITUDE + "/" + LONGITUDE + " (WGS 84) [9\u00b0 9' 9.9\" N, 9\u00b0 9' 9.9\" E]";
        MAIDENHEAD_LOCATOR = "Maidenhead Locator (6 characters)";
        UTM = "Universal Transverse Mercator (UTM) [9U 9.9 9.9]";
        MGRS = "Military Grid Reference System (MGRS)";
        ECEF = "Earth-Centred, Earth-Fixed Cartesian Co-Ordinate (ECEF)";
        this.units = new ArrayList();
        this.units.add(new Unit(0, LATLNGDEC, "int"));
        this.units.add(new Unit(2, LATLNGDM, "int"));
        this.units.add(new Unit(1, LATLNGDMS, "int"));
        this.units.add(new Unit(3, UTM, "int"));
        this.units.add(new Unit(5, MGRS, "int"));
        this.units.add(new Unit(4, MAIDENHEAD_LOCATOR, "int"));
        this.units.add(new Unit(6, ECEF, "int"));
    }

    @Override
    public ArrayList<Unit> getSourceUnits() {
        return this.units;
    }

    @Override
    public ArrayList<Unit> getTargetUnits() {
        return this.units;
    }

    @Override
    public int getSourceDefault() {
        return 0;
    }

    @Override
    public int getTargetDefault() {
        return 1;
    }

    public boolean isSpecialDefaultValue() {
        return false;
    }

    @Override
    public boolean isScientificSupported() {
        return false;
    }

    @Override
    public int getPreferredPrecision() {
        return -1;
    }

    @Override
    public String getOutput(int s, int t) throws Exception {
        Unit sourceUnit = this.units.get(s);
        Unit targetUnit = this.units.get(t);
        return this.getOutput(sourceUnit, targetUnit);
    }

    @Override
    public String getOutput(Unit sourceUnit, Unit targetUnit) throws Exception {
        int sid = sourceUnit.getId();
        int tid = targetUnit.getId();
        LatLng latLng = new LatLng(0.0, 0.0);
        String output = "";
        String ADOUBLE = "([+-]*\\d+[.,]\\d*)";
        String AINT = "([+-]*\\d+)";
        switch (sid) {
            case 0: {
                Pattern pattern = Pattern.compile("([+-]*\\d+[.,]\\d*), ([+-]*\\d+[.,]\\d*)", 2);
                Matcher matcher = pattern.matcher(this.input);
                if (matcher.find()) {
                    double a = Double.parseDouble(matcher.group(1).replace(',', '.'));
                    double b = Double.parseDouble(matcher.group(2).replace(',', '.'));
                    latLng = new LatLng(a, b);
                    break;
                }
                throw new IllegalArgumentException(INVALID);
            }
            case 1: {
                String DMSCOORD = "([+-]*\\d+)\u00b0 ([+-]*\\d+)' ([+-]*\\d+[.,]\\d*)\"";
                Pattern pattern = Pattern.compile("([+-]*\\d+)\u00b0 ([+-]*\\d+)' ([+-]*\\d+[.,]\\d*)\" ([NS]), ([+-]*\\d+)\u00b0 ([+-]*\\d+)' ([+-]*\\d+[.,]\\d*)\" ([EW])", 2);
                Matcher matcher = pattern.matcher(this.input);
                if (matcher.find()) {
                    int a = Integer.parseInt(matcher.group(1));
                    int b = Integer.parseInt(matcher.group(2));
                    double c = Double.parseDouble(matcher.group(3).replace(',', '.'));
                    int ns = matcher.group(4).equals("N") ? 1 : -1;
                    int d = Integer.parseInt(matcher.group(5));
                    int e = Integer.parseInt(matcher.group(6));
                    double f = Double.parseDouble(matcher.group(7).replace(',', '.'));
                    int ew = matcher.group(8).equals("E") ? 1 : -1;
                    latLng = new LatLng(a, b, c, ns, d, e, f, ew);
                    break;
                }
                throw new IllegalArgumentException(INVALID);
            }
            case 2: {
                String DMCOORD = "([+-]*\\d+)\u00b0 ([+-]*\\d+[.,]\\d*)' ";
                Pattern pattern = Pattern.compile("([+-]*\\d+)\u00b0 ([+-]*\\d+[.,]\\d*)' ([NS]), ([+-]*\\d+)\u00b0 ([+-]*\\d+[.,]\\d*)' ([EW])", 2);
                Matcher matcher = pattern.matcher(this.input);
                if (matcher.find()) {
                    int a = Integer.parseInt(matcher.group(1));
                    double b = Double.parseDouble(matcher.group(2).replace(',', '.'));
                    int ns = matcher.group(3).equals("N") ? 1 : -1;
                    int latmin = (int)Math.floor(b);
                    double latsecs = (b - (double)latmin) * 60.0;
                    int d = Integer.parseInt(matcher.group(4));
                    double e = Double.parseDouble(matcher.group(5).replace(',', '.'));
                    int ew = matcher.group(6).equals("E") ? 1 : -1;
                    int lngmin = (int)Math.floor(e);
                    double lngsecs = (e - (double)lngmin) * 60.0;
                    latLng = new LatLng(a, latmin, latsecs, ns, d, lngmin, lngsecs, ew);
                    break;
                }
                throw new IllegalArgumentException(INVALID);
            }
            case 3: {
                Pattern pattern = Pattern.compile("([+-]*\\d+)([A-Z]) ([+-]*\\d+[.,]\\d*) ([+-]*\\d+[.,]\\d*)", 2);
                Matcher matcher = pattern.matcher(this.input);
                if (matcher.find()) {
                    int a = Integer.parseInt(matcher.group(1));
                    char b = matcher.group(2).charAt(0);
                    double c = Double.parseDouble(matcher.group(3).replace(',', '.'));
                    double d = Double.parseDouble(matcher.group(4).replace(',', '.'));
                    UTMRef utm = new UTMRef(a, b, c, d);
                    latLng = utm.toLatLng();
                    break;
                }
                throw new IllegalArgumentException(INVALID);
            }
            case 4: {
                Pattern pattern = Pattern.compile("([A-R]{2})([0-9]{2})([A-X]{2})", 2);
                Matcher matcher = pattern.matcher(this.input);
                if (matcher.find()) {
                    latLng = this.maidenhead6ToLatLng(this.input.toUpperCase(Locale.US));
                    break;
                }
                throw new IllegalArgumentException(INVALID);
            }
            case 5: {
                try {
                    MGRSRef mgrs = new MGRSRef(this.input);
                    latLng = mgrs.toLatLng();
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(INVALID);
                }
            }
            case 6: {
                Pattern pattern = Pattern.compile("\\(\\s*([+-]*\\d+[.,]\\d*)\\s*,\\s*([+-]*\\d+[.,]\\d*)\\s*,\\s*([+-]*\\d+[.,]\\d*)\\s*\\)", 2);
                Matcher matcher = pattern.matcher(this.input);
                if (matcher.find()) {
                    double x = Double.parseDouble(matcher.group(1).replace(',', '.'));
                    double y = Double.parseDouble(matcher.group(2).replace(',', '.'));
                    double z = Double.parseDouble(matcher.group(3).replace(',', '.'));
                    ECEFRef ecef = new ECEFRef(x, y, z);
                    latLng = ecef.toLatLng();
                    break;
                }
                throw new IllegalArgumentException(INVALID);
            }
        }
        switch (tid) {
            case 0: {
                output = latLng.toString();
                break;
            }
            case 1: {
                output = latLng.toDMSString();
                break;
            }
            case 2: {
                output = latLng.toDMString();
                break;
            }
            case 3: {
                output = latLng.toUTMRef().toString();
                break;
            }
            case 4: {
                output = this.toSixCharacterMaidenHeadLocatorString(latLng);
                break;
            }
            case 5: {
                output = latLng.toMGRSRef().toString();
                break;
            }
            case 6: {
                ECEFRef ecef = new ECEFRef(latLng);
                output = ecef.toString();
            }
        }
        return output;
    }

    private String toSixCharacterMaidenHeadLocatorString(LatLng latLng) {
        double longitude = latLng.getLongitude() + 180.0;
        double latitude = latLng.getLatitude() + 90.0;
        StringBuilder sb = new StringBuilder();
        sb.append((char)(65.0 + (longitude /= 2.0) / 10.0));
        sb.append((char)(65.0 + latitude / 10.0));
        sb.append((char)(48.0 + longitude % 10.0));
        sb.append((char)(48.0 + latitude % 10.0));
        sb.append((char)(65.0 + longitude % 1.0 * 24.0));
        sb.append((char)(65.0 + latitude % 1.0 * 24.0));
        return sb.toString();
    }

    private LatLng maidenhead6ToLatLng(String input) {
        double longitude = -180.0 + (double)(input.charAt(0) - 65) * 20.0 + (double)(input.charAt(2) - 48) * 2.0 + (double)(input.charAt(4) - 65) * 0.08333333333333333 + 0.041666666666666664;
        double latitude = (double)(-90 + (input.charAt(1) - 65) * 10) + (double)(input.charAt(3) - 48) * 1.0 + (double)(input.charAt(5) - 65) * 0.041666666666666664 + 0.020833333333333332;
        return new LatLng(latitude, longitude);
    }

    @Override
    public String getInitialValue() {
        return "48.13856021337852, 11.572996973991394";
    }

    @Override
    public String addValue(BigDecimal plus, int sourceindex) throws Exception {
        if (this.input == null || this.input.length() == 0) {
            this.input = "0 0";
        }
        return this.input;
    }

    @Override
    public boolean isPlusMinusSupported() {
        return false;
    }

    @Override
    public String setValue(BigDecimal big, int sourceindex) throws Exception {
        return "";
    }

    public String setValue(BigDecimal big, Unit sourceUnit) throws Exception {
        return "";
    }

    @Override
    public String getTransferValue(int s) throws Exception {
        return "";
    }

    @Override
    public String getTransferValue(Unit sourceUnit) throws Exception {
        return "";
    }

    @Override
    public String getCard() {
        return "coordCard";
    }
}

