/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.categories;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import jonelo.sugar.util.CalendarTools;
import jonelo.sugar.util.ExtendedGregorianCalendar;
import net.numericalchameleon.categories.CategoryInterface;
import net.numericalchameleon.categories.CategoryObject;
import net.numericalchameleon.data.Unit;
import net.numericalchameleon.util.misc.ChineseYearInfo;
import net.numericalchameleon.util.misc.DateQueries;
import net.numericalchameleon.util.misc.DateYMD;

public class CategoryDateQueries
extends CategoryObject {
    private static final int cDATE = 100;
    private static final int cLEAPYEAR = 101;
    private static final int cDECADE = 102;
    private static final int cCENTURY = 103;
    private static final int cMILLENNIUM = 104;
    private static final int cIDENTICALYEARFUTURE = 105;
    private static final int cIDENTICALYEARPAST = 106;
    private static final int cDAY_OF_WEEK = 107;
    private static final int cDAY_OF_YEAR = 108;
    private static final int cWEEK_OF_YEAR = 109;
    private static final int cMONTH = 110;
    private static final int cWEEK_OF_MONTH = 111;
    private static final int cDAYS_IN_MONTH = 112;
    private static final int cAGE = 113;
    private static final int cAGE_IN_DAYS = 114;
    private static final int cZODIACSIGN = 115;
    private static final int cSUNSIGNS = 116;
    private static final int cSEASON_DE = 117;
    private static final int cDAYS_REMAINING_UNTIL_END_OF_YEAR = 118;
    private static final int cDAYS_REMAINING_UNTIL_END_OF_MONTH = 119;
    private static final int cCHINESE_YEAR = 120;
    private static final int _TRANSFER = -1;
    private final String DATE;
    private final String YES;
    private final String NO;
    private final String INVALID;
    private final ArrayList<Unit> sourceUnits;
    private final ArrayList<Unit> targetUnits;
    private final Unit defaultSourceUnit;
    private final Unit defaultTargetUnit;
    private final Unit transferUnit;

    public CategoryDateQueries(CategoryInterface clusterInterface) {
        this.rb = clusterInterface.getResourceBundle();
        this.INVALID = this.localize("Moduls.sourceInvalid", "Source is invalid");
        this.YES = this.localize("GUI.General.Yes", "Yes");
        this.NO = this.localize("GUI.General.No", "No");
        this.DATE = this.localize("Calendar.date", "Date");
        this.sourceUnits = new ArrayList();
        this.sourceUnits.add(new Unit(100, this.DATE, "int"));
        this.targetUnits = new ArrayList();
        this.targetUnits.add(new Unit(107, this.localize("Calendar.dayOfWeek", "Day of week"), "int"));
        this.targetUnits.add(new Unit(108, this.localize("Calendar.dayOfYear", "Day of year"), "int"));
        this.targetUnits.add(new Unit(118, this.localize("Calendar.daysRemainingUntilEndOfYear", "Days remaining until end of year"), "int"));
        this.targetUnits.add(new Unit(119, this.localize("Calendar.daysRemainingUntilEndOfMonth", "Days remaining until end of month"), "int"));
        this.targetUnits.add(new Unit(109, this.localize("Calendar.weekOfYear", "Week of year"), "int"));
        this.targetUnits.add(new Unit(111, this.localize("Calendar.weekOfMonth", "Week of month"), "int"));
        this.targetUnits.add(new Unit(112, this.localize("Calendar.daysInMonth", "Days in month"), "int"));
        this.targetUnits.add(new Unit(110, this.localize("Calendar.month", "Month"), "int"));
        this.targetUnits.add(new Unit(101, this.localize("Calendar.leapyear", "Leapyear"), "int"));
        this.targetUnits.add(new Unit(102, this.localize("Calendar.decade", "Decade"), "int"));
        this.targetUnits.add(new Unit(103, this.localize("Calendar.century", "Century"), "int"));
        this.targetUnits.add(new Unit(104, this.localize("Calendar.millennium", "Millennium"), "int"));
        this.targetUnits.add(new Unit(106, this.localize("Calendar.identicalYearPast", "Identical year in the past (weekdays)"), "int"));
        this.targetUnits.add(new Unit(105, this.localize("Calendar.identicalYearFuture", "Identical year in the future (weekdays)"), "int"));
        this.targetUnits.add(new Unit(113, this.localize("Calendar.age", "Age"), "int"));
        this.targetUnits.add(new Unit(114, this.localize("Calendar.ageInDays", "Age in days"), "int"));
        this.targetUnits.add(new Unit(120, this.localize("Calendar.chineseYear", "Chinese year"), "int"));
        this.targetUnits.add(new Unit(115, this.localize("Calendar.zodiacSign", "Zodiac sign"), "int"));
        this.targetUnits.add(new Unit(117, this.localize("Calendar.season", "Jahreszeit"), "de"));
        this.transferUnit = new Unit(-1);
        this.defaultSourceUnit = this.sourceUnits.get(0);
        this.defaultTargetUnit = this.targetUnits.get(0);
    }

    @Override
    public ArrayList<Unit> getSourceUnits() {
        return this.sourceUnits;
    }

    @Override
    public ArrayList<Unit> getTargetUnits() {
        return this.targetUnits;
    }

    @Override
    public int getSourceDefault() {
        return 0;
    }

    public Unit getDefaultSourceUnit() {
        return this.defaultSourceUnit;
    }

    @Override
    public int getTargetDefault() {
        return 0;
    }

    public Unit getDefaultTargetUnit() {
        return this.defaultTargetUnit;
    }

    @Override
    public boolean isOneway() {
        return true;
    }

    @Override
    public String getOutput(int s, int t) throws Exception {
        Unit sourceUnit = this.sourceUnits.get(s);
        Unit targetUnit = this.targetUnits.get(t);
        return this.getOutput(sourceUnit, targetUnit);
    }

    @Override
    public String getOutput(Unit sourceUnit, Unit targetUnit) throws Exception {
        int sid = sourceUnit.getId();
        int tid = targetUnit.getId();
        GregorianCalendar gc = new GregorianCalendar();
        gc.setLenient(false);
        switch (sid) {
            case -1: {
                try {
                    int value = Integer.parseInt(this.input);
                    int year = value / 10000;
                    int month = value / 100 - year * 100;
                    int day = value % 100;
                    gc.set(year, month - 1, day);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new Exception(this.INVALID);
                }
            }
            case 100: {
                try {
                    DateFormat df = DateFormat.getDateInstance();
                    gc.setTime(df.parse(this.input));
                    break;
                }
                catch (ParseException e) {
                    throw new Exception(this.INVALID);
                }
            }
        }
        switch (tid) {
            case -1: {
                return String.format("%04d%02d%02d", gc.get(1), gc.get(2) + 1, gc.get(5));
            }
            case 100: {
                DateFormat df = DateFormat.getDateInstance();
                return df.format(gc.getTime());
            }
            case 101: {
                return DateQueries.isLeapYear(gc.get(1)) ? this.YES : this.NO;
            }
            case 102: {
                return DateQueries.decade(gc.get(1)) + ".";
            }
            case 103: {
                return DateQueries.century(gc.get(1)) + ".";
            }
            case 104: {
                return DateQueries.millennium(gc.get(1)) + ".";
            }
            case 105: {
                return Integer.toString(DateQueries.identicalYearInTheFuture(gc.get(1)));
            }
            case 106: {
                return Integer.toString(DateQueries.identicalYearInThePast(gc.get(1)));
            }
            case 109: {
                return Integer.toString(gc.get(3));
            }
            case 111: {
                return Integer.toString(gc.get(4));
            }
            case 108: {
                return Integer.toString(gc.get(6));
            }
            case 118: {
                int leapYear = gc.isLeapYear(gc.get(1)) ? 1 : 0;
                return Integer.toString(365 + leapYear - gc.get(6));
            }
            case 119: {
                return Integer.toString(CalendarTools.daysInMonth(gc.get(1), gc.get(2)) - gc.get(5));
            }
            case 112: {
                return Integer.toString(gc.getActualMaximum(5));
            }
            case 107: {
                SimpleDateFormat formatter = new SimpleDateFormat("EEEE");
                return formatter.format(gc.getTime());
            }
            case 110: {
                SimpleDateFormat formatter = new SimpleDateFormat("MMMM");
                return formatter.format(gc.getTime());
            }
            case 113: {
                Calendar today = Calendar.getInstance();
                int age = today.get(1) - gc.get(1);
                gc.add(1, age);
                if (today.before(gc)) {
                    --age;
                }
                return Integer.toString(age);
            }
            case 114: {
                Calendar today = Calendar.getInstance();
                return Integer.toString(ExtendedGregorianCalendar.getDaysBetween(gc, today));
            }
            case 117: {
                String[] seasons = new String[]{this.localize("Calendar.seasons.Spring", "Fr\u00fchling"), this.localize("Calendar.seasons.Summer", "Sommer"), this.localize("Calendar.seasons.Autumn", "Herbst"), this.localize("Calendar.seasons.Winter", "Winter")};
                String timeZone = "Europe/Berlin";
                return DateQueries.season(gc, seasons, timeZone, true);
            }
            case 115: {
                String[] STERNZEICHEN = new String[]{this.localize("Calendar.zodiacSigns.Aries", "Aries"), this.localize("Calendar.zodiacSigns.Taurus", "Taurus"), this.localize("Calendar.zodiacSigns.Gemini", "Gemini"), this.localize("Calendar.zodiacSigns.Cancer", "Cancer"), this.localize("Calendar.zodiacSigns.Leo", "Leo"), this.localize("Calendar.zodiacSigns.Vigro", "Vigro"), this.localize("Calendar.zodiacSigns.Libra", "Libra"), this.localize("Calendar.zodiacSigns.Scorpio", "Scorpio"), this.localize("Calendar.zodiacSigns.Sagittarius", "Sagittarius"), this.localize("Calendar.zodiacSigns.Capricorn", "Capricorn"), this.localize("Calendar.zodiacSigns.Aquarius", "Aquarius"), this.localize("Calendar.zodiacSigns.Pisces", "Pisces")};
                return DateQueries.westernZodiacSign(gc.get(2), gc.get(5), STERNZEICHEN);
            }
            case 120: {
                String[] EARTHLY_BRANCHES = new String[]{this.localize("Calendar.chineseYear.earthlyBranch.Rat", "Rat"), this.localize("Calendar.chineseYear.earthlyBranch.Ox", "Ox"), this.localize("Calendar.chineseYear.earthlyBranch.Tiger", "Tiger"), this.localize("Calendar.chineseYear.earthlyBranch.Rabbit", "Rabbit"), this.localize("Calendar.chineseYear.earthlyBranch.Dragon", "Dragon"), this.localize("Calendar.chineseYear.earthlyBranch.Snake", "Snake"), this.localize("Calendar.chineseYear.earthlyBranch.Horse", "Horse"), this.localize("Calendar.chineseYEar.earthlyBranch.Goat", "Goat"), this.localize("Calendar.chineseYear.earthlyBranch.Monkey", "Monkey"), this.localize("Calendar.chineseYear.earthlyBranch.Rooster", "Rooster"), this.localize("Calendar.chineseYear.earthlyBranch.Dog", "Dog"), this.localize("Calendar.chineseYear.earthlyBranch.Pig", "Pig")};
                String[] ELEMENTS = new String[]{this.localize("Calendar.chineseYear.heavenlyStems.Wood", "Wood"), this.localize("Calendar.chineseYear.heavenlyStems.Fire", "Fire"), this.localize("Calendar.chineseYear.heavenlyStems.Earth", "Earth"), this.localize("Calendar.chineseYear.heavenlyStems.Metal", "Metal"), this.localize("Calendar.chineseYear.heavenlyStems.Water", "Water")};
                String[] YING_AND_YANG = new String[]{this.localize("Calendar.chineseYear.YingYang.Ying", "Ying"), this.localize("Calendar.chineseYear.YingYang.Yang", "Yang")};
                try {
                    ChineseYearInfo cy = new ChineseYearInfo(gc);
                    return String.format("%s (%s, %s)", EARTHLY_BRANCHES[cy.getEarthlyBranch()], ELEMENTS[cy.getHeavenlyStem()], YING_AND_YANG[cy.getYingYang()]);
                }
                catch (IllegalArgumentException e) {
                    System.err.println(e);
                    throw new Exception(this.INVALID);
                }
            }
        }
        return "";
    }

    @Override
    public String getInitialValue() {
        DateFormat df = DateFormat.getDateInstance();
        return df.format(new Date());
    }

    @Override
    public String addValue(BigDecimal plus, int sourceindex) throws Exception {
        Unit sourceUnit = this.sourceUnits.get(sourceindex);
        return this.addValue(plus, sourceUnit);
    }

    public String addValue(BigDecimal plus, Unit sourceUnit) throws Exception {
        if (this.input == null || this.input.length() == 0) {
            this.input = CategoryDateQueries.getDefaultTransferValue();
            this.input = this.getOutput(this.transferUnit, sourceUnit);
        }
        String temp = this.getOutput(sourceUnit, this.transferUnit);
        try {
            DateYMD date = new DateYMD(temp);
            date.addDays(plus.intValue());
            this.input = date.toString();
            return this.getOutput(this.transferUnit, sourceUnit);
        }
        catch (Exception e) {
            throw new Exception(this.INVALID);
        }
    }

    @Override
    public String setValue(BigDecimal big, int sourceIndex) throws Exception {
        Unit sourceUnit = this.sourceUnits.get(sourceIndex);
        return this.setValue(big, sourceUnit);
    }

    public String setValue(BigDecimal big, Unit sourceUnit) throws Exception {
        this.setInput(big.toPlainString());
        return this.getOutput(this.transferUnit, sourceUnit);
    }

    public static String getDefaultTransferValue() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        return formatter.format(new Date());
    }

    @Override
    public String getTransferValue(int sourceIndex) throws Exception {
        Unit sourceUnit = this.sourceUnits.get(sourceIndex);
        return this.getTransferValue(sourceUnit);
    }

    @Override
    public String getTransferValue(Unit source) throws Exception {
        return this.getOutput(source, this.transferUnit);
    }

    @Override
    public String getCard() {
        return "calCard";
    }
}

