/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.categories;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import jonelo.jacksum.JacksumAPI;
import jonelo.jacksum.algorithm.AbstractChecksum;
import jonelo.sugar.util.GeneralString;
import net.numericalchameleon.categories.CategoryInterface;
import net.numericalchameleon.categories.CategoryObject;
import net.numericalchameleon.data.Unit;

public class CategoryDigitalFingerprints
extends CategoryObject {
    private ArrayList<Unit> sourceUnits;
    private ArrayList<Unit> targetUnits;
    private ArrayList<AbstractChecksum> modules;
    public static String INVALID;
    private static final int _TXT = 0;
    private static final int _HEX = 1;
    private static final int _DEC = 2;

    public CategoryDigitalFingerprints(CategoryInterface categoryInterface) {
        this.rb = categoryInterface.getResourceBundle();
        INVALID = this.localize("Moduls.sourceInvalid", "Source is invalid");
        this.setOneway(true);
        this.modules = new ArrayList();
        this.sourceUnits = new ArrayList();
        this.sourceUnits.add(new Unit(0, this.localize("Moduls.Text", "Text"), "int"));
        this.sourceUnits.add(new Unit(1, this.localize("Moduls.hexadecimal", "Hexadecimal"), "int"));
        this.sourceUnits.add(new Unit(2, this.localize("Moduls.decimalName", "Decimal"), "int"));
        this.targetUnits = new ArrayList();
        try {
            Map map = JacksumAPI.getAvailableAlgorithms();
            Iterator iterator = map.entrySet().iterator();
            int index = 0;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.targetUnits.add(new Unit(index++, (String)entry.getValue(), "int"));
                AbstractChecksum checksum = JacksumAPI.getChecksumInstance((String)((String)entry.getKey()));
                this.modules.add(checksum);
            }
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println(e);
        }
    }

    public static Vector<String[]> getEncodings() {
        Vector<String[]> encodings = new Vector<String[]>();
        try {
            Map map = JacksumAPI.getAvailableEncodings();
            for (Map.Entry entry : map.entrySet()) {
                String[] array = new String[]{(String)entry.getKey(), (String)entry.getValue()};
                encodings.add(array);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return encodings;
    }

    public void setNumberType(Object encoding) {
        for (AbstractChecksum module : this.modules) {
            String enc = ((String[])encoding)[0];
            if (enc.length() == 0) {
                enc = null;
            }
            module.setEncoding(enc);
        }
    }

    @Override
    public ArrayList<Unit> getSourceUnits() {
        return this.sourceUnits;
    }

    @Override
    public ArrayList<Unit> getTargetUnits() {
        return this.targetUnits;
    }

    @Override
    public String getInitialValue() {
        return "0123456789";
    }

    @Override
    public boolean acceptEmptyStrings() {
        return true;
    }

    @Override
    public String getOutput(int s, int t) throws Exception {
        Unit sourceUnit = this.sourceUnits.get(s);
        Unit targetUnit = this.targetUnits.get(t);
        return this.getOutput(sourceUnit, targetUnit);
    }

    @Override
    public String getOutput(Unit sourceUnit, Unit targetUnit) throws Exception {
        int sid = sourceUnit.getId();
        int tid = targetUnit.getId();
        byte[] bytearr = null;
        if (sid == 0) {
            bytearr = this.input.getBytes();
        } else if (sid == 2) {
            if (this.input.length() == 0) {
                bytearr = this.input.getBytes();
            } else {
                int count = GeneralString.countChar(this.input, ',');
                bytearr = new byte[count + 1];
                StringTokenizer st = new StringTokenizer(this.input, ",");
                int x = 0;
                while (st.hasMoreTokens()) {
                    int temp = 0;
                    String stemp = null;
                    try {
                        stemp = st.nextToken();
                        temp = Integer.parseInt(stemp);
                    }
                    catch (NumberFormatException nfe) {
                        throw new NumberFormatException(stemp + " is not a decimal number.");
                    }
                    if (temp < 0 || temp > 255) {
                        throw new NumberFormatException("The number " + temp + " is out of range.");
                    }
                    bytearr[x++] = (byte)temp;
                }
            }
        } else if (sid == 1) {
            if (this.input.length() % 2 == 1) {
                throw new NumberFormatException("An even number of nibbles was expected.");
            }
            try {
                bytearr = new byte[this.input.length() / 2];
                int x = 0;
                int i = 0;
                while (i < this.input.length()) {
                    String str = this.input.substring(i, i += 2);
                    bytearr[x++] = (byte)Integer.parseInt(str, 16);
                }
            }
            catch (NumberFormatException nfe) {
                throw new NumberFormatException("Not a hex number. " + nfe.getMessage());
            }
        }
        AbstractChecksum checksum = this.modules.get(tid);
        checksum.reset();
        checksum.update(bytearr);
        return checksum.format("#CHECKSUM");
    }

    @Override
    public String getTransferValue(int s) throws Exception {
        BigInteger big = null;
        BigDecimal bigd = null;
        try {
            bigd = new BigDecimal(this.input);
            big = bigd.toBigInteger();
        }
        catch (Exception e) {
            throw new Exception(INVALID);
        }
        return big.toString();
    }

    @Override
    public String addValue(BigDecimal plus, int sourceindex) throws Exception {
        if (this.input == null || this.input.length() == 0) {
            this.input = "0";
        }
        BigDecimal bigd = null;
        try {
            bigd = new BigDecimal(this.getInput());
        }
        catch (Exception e) {
            throw new Exception(INVALID);
        }
        bigd = bigd.add(plus);
        return bigd.toString();
    }

    @Override
    public String setValue(BigDecimal big, int sourceindex) throws Exception {
        this.setInput(big.toString());
        return this.input;
    }

    @Override
    public String getTransferValue(Unit sourceUnit) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getCard() {
        return "checksumCard";
    }
}

