/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.categories;

import java.math.BigDecimal;
import java.util.ArrayList;
import jonelo.sugar.math.Rational;
import net.numericalchameleon.categories.CategoryInterface;
import net.numericalchameleon.categories.CategoryObject;
import net.numericalchameleon.data.Unit;

public class CategoryRationalNumbers
extends CategoryObject {
    private static final int cTRANSFER = -1;
    private static final int cBRUCH = 0;
    private static final int cBRUCH_GEMISCHT = 1;
    private static final int cDECIMAL_ROUNDED = 2;
    private static final int cDECIMAL_EXACT = 3;
    private static final int cPROZENT = 4;
    private static final int cPROMILLE = 5;
    private static final int cPERMYRIAD = 6;
    private static String INVALID;
    private final ArrayList<Unit> units;
    private final Unit defaultSourceUnit;
    private final Unit defaultTargetUnit;
    private final Unit decimalTransferUnit;
    private final Unit internalCalcUnit;

    public CategoryRationalNumbers(CategoryInterface categoryInterface) {
        this.rb = categoryInterface.getResourceBundle();
        INVALID = this.localize("Moduls.sourceInvalid", "Source is invalid");
        this.units = new ArrayList();
        this.units.add(new Unit(0, this.localize("Fractions.fractionCommon", "Bruch (gemein)"), "int"));
        this.units.add(new Unit(1, this.localize("Fractions.fractionMixed", "Bruch (gemischt)"), "int"));
        this.units.add(new Unit(2, this.localize("Fractions.decimalRounded", "Decimal (rounded)"), "int"));
        this.units.add(new Unit(3, this.localize("Fractions.decimalExact", "Decimal (exact)"), "int"));
        this.units.add(new Unit(4, this.localize("Fractions.decimalPercent", "Prozent %"), "int"));
        this.units.add(new Unit(5, this.localize("Fractions.decimalPromille", "Promille (\u2030)"), "int"));
        this.units.add(new Unit(6, this.localize("Fractions.decimalPermyriad", "Permyriad (\u2031)"), "int"));
        this.decimalTransferUnit = new Unit(-1);
        this.internalCalcUnit = new Unit(0);
        this.defaultSourceUnit = this.units.get(0);
        this.defaultTargetUnit = this.units.get(0);
    }

    @Override
    public ArrayList<Unit> getSourceUnits() {
        return this.units;
    }

    @Override
    public ArrayList<Unit> getTargetUnits() {
        return this.units;
    }

    @Override
    public int getSourceDefault() {
        return 0;
    }

    public Unit getDefaultSourceUnit() {
        return this.defaultSourceUnit;
    }

    @Override
    public int getTargetDefault() {
        return 0;
    }

    public Unit getDefaultTargetUnit() {
        return this.defaultTargetUnit;
    }

    @Override
    public boolean isScientificSupported() {
        return true;
    }

    @Override
    public int getPreferredPrecision() {
        return 12;
    }

    @Override
    public String getOutput(int sourceIndex, int targetIndex) throws Exception {
        Unit sourceUnit = this.units.get(sourceIndex);
        Unit targetUnit = this.units.get(targetIndex);
        return this.getOutput(sourceUnit, targetUnit);
    }

    @Override
    public String getOutput(Unit sourceUnit, Unit targetUnit) throws Exception {
        int sid = sourceUnit.getId();
        int tid = targetUnit.getId();
        Rational rational = null;
        switch (sid) {
            case 0: 
            case 1: {
                try {
                    rational = new Rational(this.input);
                    break;
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException(INVALID);
                }
            }
            case -1: 
            case 2: {
                try {
                    BigDecimal dec = new BigDecimal(this.input.replace(decsep, '.'));
                    rational = new Rational(dec);
                    break;
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException(INVALID);
                }
            }
            case 3: {
                try {
                    rational = new Rational(this.input.replace(decsep, '.'));
                    break;
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException(INVALID);
                }
            }
            case 4: {
                try {
                    BigDecimal dec2 = new BigDecimal(this.input.replace(decsep, '.'));
                    dec2 = dec2.movePointLeft(2);
                    rational = new Rational(dec2);
                    break;
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException(INVALID);
                }
            }
            case 5: {
                try {
                    BigDecimal dec3 = new BigDecimal(this.input.replace(decsep, '.'));
                    dec3 = dec3.movePointLeft(3);
                    rational = new Rational(dec3);
                    break;
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException(INVALID);
                }
            }
            case 6: {
                try {
                    BigDecimal dec4 = new BigDecimal(this.input.replace(decsep, '.'));
                    dec4 = dec4.movePointLeft(4);
                    rational = new Rational(dec4);
                    break;
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException(INVALID);
                }
            }
            default: {
                rational = new Rational();
            }
        }
        switch (tid) {
            case 0: {
                return rational.toString();
            }
            case 1: {
                return rational.toMixedString();
            }
            case 2: {
                return this.decSciFormatted(rational);
            }
            case -1: {
                return rational.toDecStringRounded(this.getPrecision());
            }
            case 3: {
                return rational.toDecStringExact().replace('.', decsep);
            }
            case 4: {
                rational = rational.multiply(new Rational(100, 1));
                return this.decSciFormatted(rational);
            }
            case 5: {
                rational = rational.multiply(new Rational(1000, 1));
                return this.decSciFormatted(rational);
            }
            case 6: {
                rational = rational.multiply(new Rational(10000, 1));
                return this.decSciFormatted(rational);
            }
        }
        return null;
    }

    private String decSciFormatted(Rational rational) {
        String temp = this.getScientific() ? rational.toSciStringRounded(this.getPrecision()) : rational.toDecStringRounded(this.getPrecision());
        return temp.replace('.', decsep);
    }

    @Override
    public String addValue(BigDecimal plus, int sourceIndex) throws Exception {
        Unit sourceUnit = this.units.get(sourceIndex);
        return this.addValue(plus, sourceUnit);
    }

    public String addValue(BigDecimal plus, Unit sourceUnit) throws Exception {
        if (this.input == null || this.input.length() == 0) {
            this.input = "0";
            this.input = this.getOutput(this.internalCalcUnit, sourceUnit);
        }
        Rational rational = new Rational(this.getOutput(sourceUnit, this.internalCalcUnit));
        rational = rational.add(new Rational(plus));
        this.input = rational.toString();
        return this.getOutput(this.internalCalcUnit, sourceUnit);
    }

    @Override
    public String setValue(BigDecimal big, int sourceIndex) throws Exception {
        Unit sourceUnit = this.units.get(sourceIndex);
        return this.setValue(big, sourceUnit);
    }

    public String setValue(BigDecimal big, Unit sourceUnit) throws Exception {
        this.setInput(big.toPlainString());
        return this.getOutput(this.decimalTransferUnit, sourceUnit);
    }

    @Override
    public String getTransferValue(int sourceIndex) throws Exception {
        Unit sourceUnit = this.units.get(sourceIndex);
        return this.getOutput(sourceUnit, this.decimalTransferUnit);
    }

    @Override
    public String getTransferValue(Unit sourceUnit) throws Exception {
        return this.getOutput(sourceUnit, this.decimalTransferUnit);
    }

    @Override
    public String getCard() {
        return "sciCard";
    }
}

