/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.categories;

import java.math.BigDecimal;
import java.util.ArrayList;
import jonelo.sugar.math.GeneralMath;
import net.numericalchameleon.categories.CategoryInterface;
import net.numericalchameleon.categories.CategoryObject;
import net.numericalchameleon.data.Unit;

public class CategoryTemperatures
extends CategoryObject {
    private static final int CKELVIN = 0;
    private static final int CCELSIUS = 1;
    private static final int CPLANCK = 2;
    private static final int CFAHRENHEIT = 3;
    private static final int CRANKINE = 4;
    private static final int CNEWTON = 5;
    private static final int CDELISLE = 6;
    private static final int CREAUMUR = 7;
    private static final int CROMER = 8;
    private static final BigDecimal _5 = BigDecimal.valueOf(5L);
    private static final BigDecimal _4 = BigDecimal.valueOf(4L);
    private static final BigDecimal _9 = BigDecimal.valueOf(9L);
    private static final BigDecimal _32 = BigDecimal.valueOf(32L);
    private static final BigDecimal _273 = new BigDecimal("273.15");
    private static final BigDecimal _PLANCK = new BigDecimal("1.416785e32");
    private static String ABSOLUTEZERO;
    private static String INVALID;
    private final ArrayList<Unit> units;
    private final Unit defaultSourceUnit;
    private final Unit defaultTargetUnit;
    private final Unit transferUnit;

    public CategoryTemperatures(CategoryInterface categoryInterface) {
        this.rb = categoryInterface.getResourceBundle();
        INVALID = this.localize("Moduls.sourceInvalid", "source invalid");
        ABSOLUTEZERO = this.localize("Temperature.CannotBeColderThanAbsoluteZero", "It cannot be colder than Absolute Zero (0 Kelvin)");
        String KELVIN = this.localize("Temperature.kelvin", "Kelvin (K)");
        String CENTIGRADE = this.localize("Temperature.centigrade", "Centigrade (\u00b0C)");
        String FAHRENHEIT = this.localize("Temperature.fahrenheit", "Fahrenheit (\u00b0F)");
        String RANKINE = this.localize("Temperature.rankine", "Rankine (\u00b0Ra, \u00b0R)");
        String REAUMUR = this.localize("Temperature.reaumur", "R\u00e9aumur (\u00b0R\u00e9, \u00b0Re)");
        String DELISLE = this.localize("Temperature.delisle", "Delisle (\u00b0De, \u00b0D)");
        String NEWTON = this.localize("Temperature.newton", "Newton (\u00b0N)");
        String ROMER = this.localize("Temperature.romer", "R\u00f8mer (\u00b0R\u00f8)");
        String PLANCK = this.localize("Temperature.planck", "Planck-Temperatur ?");
        this.units = new ArrayList();
        this.units.add(new Unit(0, KELVIN, "siu"));
        this.units.add(new Unit(1, CENTIGRADE, "int"));
        this.units.add(new Unit(2, PLANCK, "int"));
        this.units.add(new Unit(3, FAHRENHEIT, "us"));
        this.units.add(new Unit(4, RANKINE, "us"));
        this.units.add(new Unit(3, FAHRENHEIT, "ca"));
        this.units.add(new Unit(4, RANKINE, "ca"));
        this.units.add(new Unit(3, FAHRENHEIT, "bz"));
        this.units.add(new Unit(5, NEWTON, "gb", false));
        this.units.add(new Unit(6, DELISLE, "ru", false));
        this.units.add(new Unit(7, REAUMUR, "ru", false));
        this.units.add(new Unit(7, REAUMUR, "fr", false));
        this.units.add(new Unit(7, REAUMUR, "de", false));
        this.units.add(new Unit(8, ROMER, "dk", false));
        this.transferUnit = this.units.get(0);
        this.defaultSourceUnit = this.units.get(1);
        this.defaultTargetUnit = this.units.get(0);
    }

    @Override
    public ArrayList<Unit> getSourceUnits() {
        return this.units;
    }

    @Override
    public ArrayList<Unit> getTargetUnits() {
        return this.units;
    }

    @Override
    public int getSourceDefault() {
        return 0;
    }

    public Unit getDefaultSourceUnit() {
        return this.defaultSourceUnit;
    }

    @Override
    public int getTargetDefault() {
        return 1;
    }

    public Unit getDefaultTargetUnit() {
        return this.defaultTargetUnit;
    }

    public boolean isSpecialDefaultValue() {
        return false;
    }

    @Override
    public boolean isScientificSupported() {
        return true;
    }

    @Override
    public int getPreferredPrecision() {
        return 12;
    }

    @Override
    public String getOutput(int s, int t) throws Exception {
        Unit sourceUnit = this.units.get(s);
        Unit targetUnit = this.units.get(t);
        return this.getOutput(sourceUnit, targetUnit);
    }

    @Override
    public String getOutput(Unit sourceUnit, Unit targetUnit) throws Exception {
        BigDecimal x;
        int sid = sourceUnit.getId();
        int tid = targetUnit.getId();
        try {
            x = new BigDecimal(this.input.replace(decsep, '.'));
        }
        catch (Exception e) {
            throw new Exception(INVALID);
        }
        if (sid != tid) {
            switch (sid) {
                case 0: {
                    break;
                }
                case 1: {
                    x = x.add(_273);
                    break;
                }
                case 2: {
                    x = _PLANCK.multiply(x);
                    break;
                }
                case 3: {
                    x = _5.divide(_9, this.getPrecision() + 1000, 4).multiply(x.subtract(_32)).add(_273);
                    break;
                }
                case 7: {
                    x = _5.divide(_4, this.getPrecision() + 1000, 4).multiply(x).add(_273);
                    break;
                }
                case 4: {
                    x = _5.divide(_9, this.getPrecision() + 1000, 4).multiply(x);
                    break;
                }
                case 8: {
                    x = x.subtract(new BigDecimal("7.5")).multiply(BigDecimal.valueOf(40L).divide(BigDecimal.valueOf(21L), this.getPrecision() + 1000, 4)).add(_273);
                    break;
                }
                case 6: {
                    x = new BigDecimal("373.15").subtract(x.multiply(BigDecimal.valueOf(2L).divide(BigDecimal.valueOf(3L), this.getPrecision() + 1000, 4)));
                    break;
                }
                case 5: {
                    x = x.multiply(BigDecimal.valueOf(100L).divide(BigDecimal.valueOf(33L), this.getPrecision() + 1000, 4)).add(_273);
                }
            }
            if (x.compareTo(BigDecimal.ZERO) < 0) {
                throw new Exception(ABSOLUTEZERO);
            }
            switch (tid) {
                case 0: {
                    break;
                }
                case 1: {
                    x = x.subtract(_273);
                    break;
                }
                case 3: {
                    x = _9.divide(_5, this.getPrecision() + 1000, 4).multiply(x.subtract(_273)).add(_32);
                    break;
                }
                case 2: {
                    x = x.divide(_PLANCK, this.getPrecision() + 1000, 4);
                    break;
                }
                case 7: {
                    x = _4.divide(_5, this.getPrecision() + 1000, 4).multiply(x.subtract(_273));
                    break;
                }
                case 4: {
                    x = _9.divide(_5, this.getPrecision() + 1000, 4).multiply(x);
                    break;
                }
                case 8: {
                    x = x.subtract(_273).multiply(BigDecimal.valueOf(21L).divide(BigDecimal.valueOf(40L), this.getPrecision() + 1000, 4)).add(new BigDecimal("7.5"));
                    break;
                }
                case 6: {
                    x = new BigDecimal("373.15").subtract(x).multiply(new BigDecimal("1.5"));
                    break;
                }
                case 5: {
                    x = x.subtract(_273).multiply(new BigDecimal("0.33"));
                }
            }
        }
        if (this.getScientific()) {
            return GeneralMath.decimal2Scientific(x.toPlainString(), this.getPrecision()).replace('.', decsep);
        }
        return x.setScale(this.getPrecision(), 4).toPlainString().replace('.', decsep);
    }

    @Override
    public String addValue(BigDecimal plus, int sourceindex) throws Exception {
        Unit sourceUnit = this.units.get(sourceindex);
        return this.addValue(plus, sourceUnit);
    }

    public String addValue(BigDecimal plus, Unit sourceUnit) throws Exception {
        if (this.input == null || this.input.length() == 0) {
            this.input = "0";
        }
        BigDecimal big = null;
        try {
            big = new BigDecimal(this.input.replace(decsep, '.'));
        }
        catch (Exception e) {
            throw new Exception(INVALID);
        }
        big = big.add(plus);
        return big.toPlainString().replace('.', decsep);
    }

    @Override
    public String setValue(BigDecimal big, int sourceIndex) throws Exception {
        Unit sourceUnit = this.units.get(sourceIndex);
        return this.setValue(big, sourceUnit);
    }

    public String setValue(BigDecimal big, Unit sourceUnit) throws Exception {
        this.setInput(big.toPlainString());
        return this.input.replace('.', decsep);
    }

    @Override
    public String getTransferValue(int sourceIndex) throws Exception {
        Unit sourceUnit = this.units.get(sourceIndex);
        return this.getTransferValue(sourceUnit);
    }

    @Override
    public String getTransferValue(Unit sourceUnit) throws Exception {
        return this.getOutput(sourceUnit, sourceUnit).replace(decsep, '.');
    }

    @Override
    public String getCard() {
        return "sciCard";
    }
}

