/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.data;

import java.io.Serializable;
import java.math.BigDecimal;
import jonelo.sugar.util.GeneralString;

public class Unit
implements Comparable,
Serializable {
    private String string;
    private BigDecimal factor;
    private String icon;
    private String name;
    private boolean active;
    int id = 0;
    private boolean invert = false;

    public Unit() {
    }

    public Unit(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public Unit(int id, String string, String icon) {
        this(string, icon);
        this.id = id;
    }

    public Unit(String string, String icon) {
        this.string = string;
        this.factor = null;
        this.icon = icon;
        this.name = null;
        this.active = true;
    }

    public Unit(String string, String icon, boolean active) {
        this.string = string;
        this.factor = null;
        this.icon = icon;
        this.name = null;
        this.active = active;
    }

    public Unit(int id, String string, String icon, boolean active) {
        this(string, icon, active);
        this.id = id;
    }

    public Unit(String string, BigDecimal factor) {
        this.string = string;
        this.factor = factor;
        this.icon = null;
        this.name = null;
        this.active = true;
    }

    public Unit(String string, BigDecimal factor, String icon) {
        this.string = string;
        this.factor = factor;
        this.icon = icon;
        this.name = null;
        this.active = true;
    }

    public Unit(int id, String string, BigDecimal factor, String icon) {
        this(string, factor, icon);
        this.id = id;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getString() {
        return this.string;
    }

    public String getText() {
        return this.string;
    }

    public BigDecimal getFactor() {
        return this.factor;
    }

    public String getIcon() {
        return this.icon;
    }

    public String toString() {
        return this.string;
    }

    public String toComparableString() {
        String st = this.string.toLowerCase();
        st = GeneralString.replaceAllStrings(st, "\u00f6", "oe");
        st = GeneralString.replaceAllStrings(st, "\u00e4", "ae");
        st = GeneralString.replaceAllStrings(st, "\u00fc", "ue");
        return st;
    }

    public int compareTo(Object obj) {
        return this.toComparableString().compareTo(((Unit)obj).toComparableString());
    }
}

