/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.gui.dialogs.datediff;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jonelo.sugar.gui.GeneralGUI;
import net.numericalchameleon.categories.CategoryInterface;
import net.numericalchameleon.categories.CategoryObject;
import net.numericalchameleon.categories.CategoryTimezones;
import net.numericalchameleon.data.Unit;
import net.numericalchameleon.gui.dialogs.calendarchooser.CalendarChooserDialog;
import net.numericalchameleon.gui.dialogs.calendarchooser.CalendarChooserPayload;
import net.numericalchameleon.gui.dialogs.datediff.DateDiffDialogInterface;
import net.numericalchameleon.gui.dialogs.timechooser.TimeChooserDialog;
import net.numericalchameleon.gui.dialogs.timechooser.TimeChooserPayload;
import net.numericalchameleon.gui.main.Main;
import net.numericalchameleon.gui.renderer.UnitRecordCellRenderer;
import net.numericalchameleon.util.datediff.ClockThread;
import net.numericalchameleon.util.datediff.Duration;
import net.numericalchameleon.util.datediff.DurationColloquial;
import net.numericalchameleon.util.datediff.DurationControl;
import net.numericalchameleon.util.datediff.zinstage.Zinstage;
import net.numericalchameleon.util.datediff.zinstage.ZinstageEnglish;
import net.numericalchameleon.util.datediff.zinstage.ZinstageFrench;
import net.numericalchameleon.util.datediff.zinstage.ZinstageGerman;
import net.numericalchameleon.util.datediff.zinstage.ZinstageGerman2;
import net.numericalchameleon.util.datediff.zinstage.ZinstageISMA;
import net.numericalchameleon.util.datediff.zinstage.ZinstageNASD;
import net.numericalchameleon.util.datediff.zinstage.ZinstageUS;
import net.numericalchameleon.util.misc.ModelHelperNC;

public class DateDiffDialog
extends JDialog
implements CategoryInterface {
    private ResourceBundle rb;
    private boolean[] status;
    private long[] secs;
    private DateFormat aFormatter;
    private DateFormat bFormatter;
    private GregorianCalendar aMoment;
    private GregorianCalendar bMoment;
    private UnitRecordCellRenderer renderer = null;
    private CategoryObject clusterObject;
    private Zinstage zt;
    private TimeZone utc;
    private DurationColloquial durationColloquialBackup;
    private DateDiffDialogInterface dialogInterface;
    private static final NumberFormat formatter = new DecimalFormat("0.############");
    private static final int DATE_CHOOSER = 0;
    private static final int TIME_CHOOSER = 1;
    private JLabel aDSTLabel;
    private JButton aDatePickerButton;
    private JLabel aLabel;
    private JTextField aTextField;
    private JButton aTimePickerButton;
    private JComboBox aTimeZoneComboBox;
    private JLabel aTimeZoneLabel;
    private JLabel bDSTLabel;
    private JButton bDatePickerButton;
    private JLabel bLabel;
    private JTextField bTextField;
    private JButton bTimePickerButton;
    private JComboBox bTimeZoneComboBox;
    private JLabel bTimeZoneLabel;
    private JPanel businessPanel;
    private JButton cancelButton;
    private JCheckBox collDaysCheckBox;
    private JTextField collDaysTextField;
    private JCheckBox collMonthsCheckBox;
    private JTextField collMonthsTextField;
    private JCheckBox collQuartersCheckBox;
    private JTextField collQuartersTextField;
    private JCheckBox collWeeksCheckBox;
    private JTextField collWeeksTextField;
    private JCheckBox collYearsCheckBox;
    private JTextField collYearsTextField;
    private JCheckBox daysCheckBox;
    private JTextField daysTextField;
    private JPanel exactPanel;
    private JCheckBox hoursCheckBox;
    private JTextField hoursTextField;
    private JLabel ingoreLabel;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JSeparator jSeparator1;
    private JTabbedPane jTabbedPane1;
    private JPanel jumboPanel;
    private JCheckBox leapSecondsCheckBox;
    private JButton locationSwitchButton;
    private JCheckBox minutesCheckBox;
    private JTextField minutesTextField;
    private JButton okButton;
    private JLabel relationshipLabel;
    private JCheckBox secondsCheckBox;
    private JTextField secondsTextField;
    private JLabel signLabel;
    private JPanel ugsPanel;
    private JCheckBox weeksCheckBox;
    private JTextField weeksTextField;
    private JComboBox zinstageComboBox;
    private JTextField zinstageTextField;

    public DateDiffDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public DateDiffDialog(DateDiffDialogInterface dialogInterface, UnitRecordCellRenderer renderer, long[] secs, boolean[] status) {
        super(dialogInterface.getFrame(), false);
        this.dialogInterface = dialogInterface;
        this.rb = dialogInterface.getResourceBundle();
        this.renderer = renderer;
        this.status = status;
        this.secs = secs;
        this.utc = TimeZone.getTimeZone("UTC");
        this.aMoment = new GregorianCalendar();
        this.bMoment = (GregorianCalendar)this.aMoment.clone();
        this.aFormatter = DateFormat.getDateTimeInstance(2, 2);
        this.aFormatter.setLenient(false);
        this.bFormatter = DateFormat.getDateTimeInstance(2, 2);
        this.bFormatter.setLenient(false);
        this.clusterObject = new CategoryTimezones(this);
        this.initComponents();
        this.setSelectedTimezoneForaMoment();
        this.setSelectedTimezoneForbMoment();
        this.aTextFieldKeyReleased(null);
        this.bTextFieldKeyReleased(null);
        this.updateAllPanels();
        this.setLocationRelativeTo(dialogInterface.getFrame());
        this.pack();
        this.setVisible(true);
    }

    private void initComponents() {
        this.jumboPanel = new JPanel();
        this.aLabel = new JLabel();
        this.aTextField = new JTextField();
        this.aDatePickerButton = new JButton();
        this.aTimePickerButton = new JButton();
        this.aDSTLabel = new JLabel();
        this.aTimeZoneComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.bLabel = new JLabel();
        this.bTextField = new JTextField();
        this.bTimeZoneComboBox = new JComboBox();
        this.bTimePickerButton = new JButton();
        this.bDSTLabel = new JLabel();
        this.jLabel2 = new JLabel();
        this.bDatePickerButton = new JButton();
        this.locationSwitchButton = new JButton();
        this.aTimeZoneLabel = new JLabel();
        this.bTimeZoneLabel = new JLabel();
        this.signLabel = new JLabel();
        this.relationshipLabel = new JLabel();
        this.jTabbedPane1 = new JTabbedPane();
        this.exactPanel = new JPanel();
        this.daysTextField = new JTextField();
        this.hoursTextField = new JTextField();
        this.minutesTextField = new JTextField();
        this.secondsTextField = new JTextField();
        this.leapSecondsCheckBox = new JCheckBox();
        this.daysCheckBox = new JCheckBox();
        this.hoursCheckBox = new JCheckBox();
        this.minutesCheckBox = new JCheckBox();
        this.secondsCheckBox = new JCheckBox();
        this.weeksCheckBox = new JCheckBox();
        this.weeksTextField = new JTextField();
        this.ugsPanel = new JPanel();
        this.collDaysTextField = new JTextField();
        this.collYearsTextField = new JTextField();
        this.collMonthsTextField = new JTextField();
        this.collWeeksTextField = new JTextField();
        this.collYearsCheckBox = new JCheckBox();
        this.collMonthsCheckBox = new JCheckBox();
        this.collWeeksCheckBox = new JCheckBox();
        this.collQuartersCheckBox = new JCheckBox();
        this.collQuartersTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.collDaysCheckBox = new JCheckBox();
        this.businessPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.zinstageTextField = new JTextField();
        this.zinstageComboBox = new JComboBox();
        this.jLabel4 = new JLabel();
        this.ingoreLabel = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jLabel10 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setTitle(this.rb.getString("DateDiff.CalculateTimeDifference"));
        this.setMinimumSize(new Dimension(666, 676));
        this.jumboPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.aLabel.setText(this.rb.getString("DateDiff.MomentA"));
        this.aTextField.setText(this.aFormatter.format(new Date()));
        this.aTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DateDiffDialog.this.aTextFieldKeyReleased(evt);
            }
        });
        this.aDatePickerButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/calendar.png")));
        this.aDatePickerButton.setText(this.rb.getString("GUI.General.DatePicker"));
        this.aDatePickerButton.setToolTipText(this.rb.getString("GUI.General.DatePicker"));
        this.aDatePickerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateDiffDialog.this.aDatePickerButtonActionPerformed(evt);
            }
        });
        this.aTimePickerButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/time.png")));
        this.aTimePickerButton.setText(this.rb.getString("GUI.General.TimePicker"));
        this.aTimePickerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateDiffDialog.this.aTimePickerButtonActionPerformed(evt);
            }
        });
        this.aDSTLabel.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/dst.png")));
        this.aDSTLabel.setText(this.rb.getString("DateDiff.DST"));
        this.aTimeZoneComboBox.setMaximumRowCount(12);
        this.aTimeZoneComboBox.setModel(ModelHelperNC.getComboBoxModel(this.clusterObject.getSourceUnits()));
        this.aTimeZoneComboBox.setSelectedIndex(this.clusterObject.getSourceDefault());
        this.aTimeZoneComboBox.setRenderer(this.renderer);
        this.aTimeZoneComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateDiffDialog.this.aTimeZoneComboBoxActionPerformed(evt);
            }
        });
        this.aTimeZoneComboBox.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                DateDiffDialog.this.aTimeZoneComboBoxComponentResized(evt);
            }
        });
        this.jLabel1.setText("   ");
        this.bLabel.setText(this.rb.getString("DateDiff.MomentB"));
        this.bTextField.setText(this.aTextField.getText());
        this.bTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DateDiffDialog.this.bTextFieldKeyReleased(evt);
            }
        });
        this.bTimeZoneComboBox.setMaximumRowCount(12);
        this.bTimeZoneComboBox.setModel(ModelHelperNC.getComboBoxModel(this.clusterObject.getSourceUnits()));
        this.bTimeZoneComboBox.setSelectedIndex(this.clusterObject.getSourceDefault());
        this.bTimeZoneComboBox.setRenderer(this.renderer);
        this.bTimeZoneComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateDiffDialog.this.bTimeZoneComboBoxActionPerformed(evt);
            }
        });
        this.bTimeZoneComboBox.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                DateDiffDialog.this.bTimeZoneComboBoxComponentResized(evt);
            }
        });
        this.bTimePickerButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/time.png")));
        this.bTimePickerButton.setText(this.rb.getString("GUI.General.TimePicker"));
        this.bTimePickerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateDiffDialog.this.bTimePickerButtonActionPerformed(evt);
            }
        });
        this.bDSTLabel.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/dst.png")));
        this.bDSTLabel.setText(this.rb.getString("DateDiff.DST"));
        this.jLabel2.setText("   ");
        this.bDatePickerButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/calendar.png")));
        this.bDatePickerButton.setText(this.rb.getString("GUI.General.DatePicker"));
        this.bDatePickerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateDiffDialog.this.bDatePickerButtonActionPerformed(evt);
            }
        });
        this.locationSwitchButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/swap.png")));
        this.locationSwitchButton.setText(this.rb.getString("DateDiff.SwapAB"));
        this.locationSwitchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateDiffDialog.this.locationSwitchButtonActionPerformed(evt);
            }
        });
        this.aTimeZoneLabel.setText(this.rb.getString("DateDiff.Timezone"));
        this.bTimeZoneLabel.setText(this.rb.getString("DateDiff.Timezone"));
        this.signLabel.setText("sign");
        this.relationshipLabel.setText(this.rb.getString("DateDiff.Relationship"));
        GroupLayout jumboPanelLayout = new GroupLayout(this.jumboPanel);
        this.jumboPanel.setLayout(jumboPanelLayout);
        jumboPanelLayout.setHorizontalGroup(jumboPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jumboPanelLayout.createSequentialGroup().addGroup(jumboPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jumboPanelLayout.createSequentialGroup().addGroup(jumboPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bLabel).addComponent(this.bTimeZoneLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jumboPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jumboPanelLayout.createSequentialGroup().addComponent(this.bDatePickerButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bTimePickerButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bDSTLabel)).addComponent(this.bTextField).addComponent(this.bTimeZoneComboBox, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE))).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(jumboPanelLayout.createSequentialGroup().addGroup(jumboPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.aLabel).addComponent(this.aTimeZoneLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jumboPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jumboPanelLayout.createSequentialGroup().addComponent(this.aDatePickerButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.aTimePickerButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.aDSTLabel)).addComponent(this.aTimeZoneComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.aTextField))).addGroup(jumboPanelLayout.createSequentialGroup().addComponent(this.relationshipLabel, -2, 62, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.signLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.locationSwitchButton))).addContainerGap()));
        jumboPanelLayout.setVerticalGroup(jumboPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jumboPanelLayout.createSequentialGroup().addGroup(jumboPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.aLabel).addComponent(this.aTextField, -2, -1, -2)).addGap(5, 5, 5).addGroup(jumboPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.aDatePickerButton).addComponent(this.aTimePickerButton).addComponent(this.aDSTLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jumboPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.aTimeZoneComboBox, -2, -1, -2).addComponent(this.aTimeZoneLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jumboPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bLabel).addComponent(this.bTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jumboPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bDatePickerButton).addComponent(this.bTimePickerButton).addComponent(this.bDSTLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jumboPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bTimeZoneLabel).addComponent(this.bTimeZoneComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jumboPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationSwitchButton).addComponent(this.signLabel).addComponent(this.relationshipLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.exactPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.daysTextField.setEditable(false);
        this.hoursTextField.setEditable(false);
        this.minutesTextField.setEditable(false);
        this.secondsTextField.setEditable(false);
        this.leapSecondsCheckBox.setSelected(true);
        this.leapSecondsCheckBox.setText(this.rb.getString("DateDiff.TakeLeapSecondsIntoAccount"));
        this.leapSecondsCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.leapSecondsCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.leapSecondsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DateDiffDialog.this.leapSecondsCheckBoxItemStateChanged(evt);
            }
        });
        this.daysCheckBox.setSelected(true);
        this.daysCheckBox.setText(this.rb.getString("DateDiff.Days"));
        this.daysCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.daysCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.daysCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DateDiffDialog.this.daysCheckBoxItemStateChanged(evt);
            }
        });
        this.hoursCheckBox.setSelected(true);
        this.hoursCheckBox.setText(this.rb.getString("DateDiff.Hours"));
        this.hoursCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.hoursCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.hoursCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DateDiffDialog.this.hoursCheckBoxItemStateChanged(evt);
            }
        });
        this.minutesCheckBox.setSelected(true);
        this.minutesCheckBox.setText(this.rb.getString("DateDiff.Minutes"));
        this.minutesCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.minutesCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.minutesCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DateDiffDialog.this.minutesCheckBoxItemStateChanged(evt);
            }
        });
        this.secondsCheckBox.setSelected(true);
        this.secondsCheckBox.setText(this.rb.getString("DateDiff.Seconds"));
        this.secondsCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.secondsCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.secondsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DateDiffDialog.this.secondsCheckBoxItemStateChanged(evt);
            }
        });
        this.weeksCheckBox.setSelected(true);
        this.weeksCheckBox.setText(this.rb.getString("DateDiff.Weeks"));
        this.weeksCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.weeksCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.weeksCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DateDiffDialog.this.weeksCheckBoxItemStateChanged(evt);
            }
        });
        this.weeksTextField.setEditable(false);
        GroupLayout exactPanelLayout = new GroupLayout(this.exactPanel);
        this.exactPanel.setLayout(exactPanelLayout);
        exactPanelLayout.setHorizontalGroup(exactPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(exactPanelLayout.createSequentialGroup().addContainerGap().addGroup(exactPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.daysCheckBox).addComponent(this.hoursCheckBox).addComponent(this.minutesCheckBox).addComponent(this.secondsCheckBox).addComponent(this.weeksCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(exactPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.leapSecondsCheckBox).addComponent(this.minutesTextField, -1, 335, Short.MAX_VALUE).addComponent(this.hoursTextField, -1, 335, Short.MAX_VALUE).addComponent(this.daysTextField, GroupLayout.Alignment.TRAILING, -1, 335, Short.MAX_VALUE).addComponent(this.secondsTextField, GroupLayout.Alignment.TRAILING, -1, 335, Short.MAX_VALUE).addComponent(this.weeksTextField, -1, 335, Short.MAX_VALUE)).addContainerGap()));
        exactPanelLayout.setVerticalGroup(exactPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(exactPanelLayout.createSequentialGroup().addContainerGap().addGroup(exactPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.weeksCheckBox).addComponent(this.weeksTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(exactPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.daysCheckBox).addComponent(this.daysTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(exactPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hoursTextField, -2, -1, -2).addComponent(this.hoursCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(exactPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minutesTextField, -2, -1, -2).addComponent(this.minutesCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(exactPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.secondsCheckBox).addComponent(this.secondsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.leapSecondsCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        exactPanelLayout.linkSize(1, this.daysTextField, this.hoursTextField, this.minutesTextField, this.secondsTextField);
        this.jTabbedPane1.addTab(this.rb.getString("DateDiff.exact"), new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/diamond.png")), this.exactPanel);
        this.collDaysTextField.setEditable(false);
        this.collYearsTextField.setEditable(false);
        this.collMonthsTextField.setEditable(false);
        this.collWeeksTextField.setEditable(false);
        this.collYearsCheckBox.setSelected(true);
        this.collYearsCheckBox.setText(this.rb.getString("DateDiff.Years"));
        this.collYearsCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.collYearsCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.collYearsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DateDiffDialog.this.collYearsCheckBoxItemStateChanged(evt);
            }
        });
        this.collMonthsCheckBox.setSelected(true);
        this.collMonthsCheckBox.setText(this.rb.getString("DateDiff.Months"));
        this.collMonthsCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.collMonthsCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.collMonthsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DateDiffDialog.this.collMonthsCheckBoxItemStateChanged(evt);
            }
        });
        this.collWeeksCheckBox.setSelected(true);
        this.collWeeksCheckBox.setText(this.rb.getString("DateDiff.Weeks"));
        this.collWeeksCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.collWeeksCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.collWeeksCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DateDiffDialog.this.collWeeksCheckBoxItemStateChanged(evt);
            }
        });
        this.collQuartersCheckBox.setSelected(true);
        this.collQuartersCheckBox.setText(this.rb.getString("DateDiff.Quarters"));
        this.collQuartersCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.collQuartersCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.collQuartersCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DateDiffDialog.this.collQuartersCheckBoxItemStateChanged(evt);
            }
        });
        this.collQuartersTextField.setEditable(false);
        this.jLabel5.setText(this.rb.getString("DateDiff.HHmmssAreIgnored"));
        this.collDaysCheckBox.setSelected(true);
        this.collDaysCheckBox.setText(this.rb.getString("DateDiff.Days"));
        this.collDaysCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.collDaysCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.collDaysCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DateDiffDialog.this.collDaysCheckBoxItemStateChanged(evt);
            }
        });
        GroupLayout ugsPanelLayout = new GroupLayout(this.ugsPanel);
        this.ugsPanel.setLayout(ugsPanelLayout);
        ugsPanelLayout.setHorizontalGroup(ugsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ugsPanelLayout.createSequentialGroup().addContainerGap().addGroup(ugsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ugsPanelLayout.createSequentialGroup().addGroup(ugsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.collYearsCheckBox).addComponent(this.collQuartersCheckBox).addComponent(this.collMonthsCheckBox).addComponent(this.collWeeksCheckBox).addComponent(this.collDaysCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ugsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.collMonthsTextField, -1, 333, Short.MAX_VALUE).addComponent(this.collQuartersTextField, -1, 333, Short.MAX_VALUE).addComponent(this.collYearsTextField, GroupLayout.Alignment.LEADING, -1, 333, Short.MAX_VALUE).addComponent(this.collWeeksTextField, -1, 333, Short.MAX_VALUE).addComponent(this.collDaysTextField, -1, 333, Short.MAX_VALUE))).addComponent(this.jLabel5)).addContainerGap()));
        ugsPanelLayout.setVerticalGroup(ugsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ugsPanelLayout.createSequentialGroup().addContainerGap().addGroup(ugsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.collYearsCheckBox).addComponent(this.collYearsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ugsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.collQuartersCheckBox).addComponent(this.collQuartersTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ugsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.collMonthsTextField, -2, -1, -2).addComponent(this.collMonthsCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ugsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.collWeeksCheckBox).addComponent(this.collWeeksTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ugsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.collDaysTextField, -2, -1, -2).addComponent(this.collDaysCheckBox)).addGap(8, 8, 8).addComponent(this.jLabel5).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(this.rb.getString("DateDiff.colloquial"), new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/weather-cloud.png")), this.ugsPanel);
        this.businessPanel.setBorder(BorderFactory.createEmptyBorder(0, 1, 1, 1));
        this.jLabel3.setText(this.rb.getString("DateDiff.DaysBusiness"));
        this.zinstageTextField.setEditable(false);
        this.zinstageComboBox.setModel(this.getZinstageComboBoxModel());
        this.zinstageComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateDiffDialog.this.zinstageComboBoxActionPerformed(evt);
            }
        });
        this.jLabel4.setText(this.rb.getString("DateDiff.Method"));
        this.ingoreLabel.setText(this.rb.getString("DateDiff.HHmmssAreIgnored"));
        GroupLayout businessPanelLayout = new GroupLayout(this.businessPanel);
        this.businessPanel.setLayout(businessPanelLayout);
        businessPanelLayout.setHorizontalGroup(businessPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(businessPanelLayout.createSequentialGroup().addContainerGap().addGroup(businessPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(businessPanelLayout.createSequentialGroup().addGroup(businessPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(businessPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.zinstageComboBox, 0, 329, Short.MAX_VALUE).addComponent(this.zinstageTextField, -1, 329, Short.MAX_VALUE))).addComponent(this.ingoreLabel)).addContainerGap()));
        businessPanelLayout.setVerticalGroup(businessPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(businessPanelLayout.createSequentialGroup().addContainerGap().addGroup(businessPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.zinstageComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(businessPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.zinstageTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ingoreLabel).addContainerGap(88, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(this.rb.getString("DateDiff.business"), new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/bank.png")), this.businessPanel);
        this.okButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/ok.png")));
        this.okButton.setText(this.rb.getString("GUI.General.Apply"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateDiffDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/close.png")));
        this.cancelButton.setText(this.rb.getString("GUI.General.Close"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateDiffDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jLabel10.setText(this.rb.getString("DateDiff.TimeDifference"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTabbedPane1).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jumboPanel, -1, -1, Short.MAX_VALUE).addGap(16, 16, 16)).addGroup(layout.createSequentialGroup().addComponent(this.jSeparator1).addGap(16, 16, 16)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel10).addContainerGap(-1, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jumboPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1, -2, 196, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        this.pack();
    }

    private void leapSecondsCheckBoxItemStateChanged(ItemEvent evt) {
        this.updateExactPanel();
    }

    private void collDaysCheckBoxItemStateChanged(ItemEvent evt) {
        this.refreshColloquialPanel(this.durationColloquialBackup, evt);
    }

    private void collWeeksCheckBoxItemStateChanged(ItemEvent evt) {
        this.refreshColloquialPanel(this.durationColloquialBackup, evt);
    }

    private void collMonthsCheckBoxItemStateChanged(ItemEvent evt) {
        this.refreshColloquialPanel(this.durationColloquialBackup, evt);
    }

    private void collQuartersCheckBoxItemStateChanged(ItemEvent evt) {
        this.refreshColloquialPanel(this.durationColloquialBackup, evt);
    }

    private void collYearsCheckBoxItemStateChanged(ItemEvent evt) {
        this.refreshColloquialPanel(this.durationColloquialBackup, evt);
    }

    private void weeksCheckBoxItemStateChanged(ItemEvent evt) {
        this.refreshExactPanel(this.secs[0]);
    }

    private void secondsCheckBoxItemStateChanged(ItemEvent evt) {
        this.refreshExactPanel(this.secs[0]);
    }

    private void minutesCheckBoxItemStateChanged(ItemEvent evt) {
        this.refreshExactPanel(this.secs[0]);
    }

    private void hoursCheckBoxItemStateChanged(ItemEvent evt) {
        this.refreshExactPanel(this.secs[0]);
    }

    private void daysCheckBoxItemStateChanged(ItemEvent evt) {
        this.refreshExactPanel(this.secs[0]);
    }

    private void bTimePickerButtonActionPerformed(ActionEvent evt) {
        this.pickerButtonActionPerformed(1, this.bTextField, this.bMoment, this.bFormatter);
    }

    private void bDatePickerButtonActionPerformed(ActionEvent evt) {
        this.pickerButtonActionPerformed(0, this.bTextField, this.bMoment, this.bFormatter);
    }

    private void aTimePickerButtonActionPerformed(ActionEvent evt) {
        this.pickerButtonActionPerformed(1, this.aTextField, this.aMoment, this.aFormatter);
    }

    private void aDatePickerButtonActionPerformed(ActionEvent evt) {
        this.pickerButtonActionPerformed(0, this.aTextField, this.aMoment, this.aFormatter);
    }

    private void pickerButtonActionPerformed(int type, JTextField textField, GregorianCalendar gc, DateFormat formatter) {
        GregorianCalendar calendar = new GregorianCalendar(formatter.getTimeZone());
        try {
            calendar.setTime(formatter.parse(textField.getText()));
        }
        catch (ParseException e) {
            System.err.println(e.toString());
        }
        boolean cancelled = true;
        switch (type) {
            case 0: {
                CalendarChooserPayload payloadCal = new CalendarChooserPayload(calendar, formatter.getTimeZone());
                new CalendarChooserDialog(this.dialogInterface, payloadCal);
                cancelled = payloadCal.isCancelled();
                break;
            }
            case 1: {
                TimeChooserPayload payloadTime = new TimeChooserPayload(calendar);
                new TimeChooserDialog(this.dialogInterface, payloadTime);
                cancelled = payloadTime.isCancelled();
            }
        }
        if (!cancelled) {
            try {
                textField.setText(formatter.format(calendar.getTime()));
                this.xTextFieldKeyReleased(textField, gc, formatter);
            }
            catch (Exception e) {
                System.err.println(e.toString());
            }
        }
    }

    private void locationSwitchButtonActionPerformed(ActionEvent evt) {
        int b;
        int a = this.aTimeZoneComboBox.getSelectedIndex();
        if (a != (b = this.bTimeZoneComboBox.getSelectedIndex())) {
            this.aTimeZoneComboBox.setSelectedIndex(b);
            this.bTimeZoneComboBox.setSelectedIndex(a);
        }
        String tmp = this.aTextField.getText();
        this.aTextField.setText(this.bTextField.getText());
        this.bTextField.setText(tmp);
        this.xTextFieldKeyReleased(this.aTextField, this.aMoment, this.aFormatter);
        this.xTextFieldKeyReleased(this.bTextField, this.bMoment, this.bFormatter);
    }

    private void zinstageComboBoxActionPerformed(ActionEvent evt) {
        this.updateBusinessPanel();
    }

    private ComboBoxModel getZinstageComboBoxModel() {
        Vector<Zinstage> v = new Vector<Zinstage>();
        v.add(new ZinstageGerman());
        v.add(new ZinstageGerman2());
        v.add(new ZinstageUS());
        v.add(new ZinstageNASD());
        v.add(new ZinstageEnglish());
        v.add(new ZinstageFrench());
        v.add(new ZinstageISMA());
        return GeneralGUI.getComboBoxModel(v);
    }

    private void bTimeZoneComboBoxActionPerformed(ActionEvent evt) {
        this.setSelectedTimezoneForbMoment();
        this.bTextFieldKeyReleased(null);
        this.updateAllPanels();
    }

    private void aTimeZoneComboBoxActionPerformed(ActionEvent evt) {
        this.setSelectedTimezoneForaMoment();
        this.aTextFieldKeyReleased(null);
        this.updateAllPanels();
    }

    private void setSelectedTimezoneForaMoment() {
        StringTokenizer st = new StringTokenizer(((Unit)this.aTimeZoneComboBox.getSelectedItem()).getString());
        TimeZone tz = TimeZone.getTimeZone(st.nextToken());
        this.convertCalendarToTimeZone(this.aTextField.getText(), tz, this.aMoment, this.utc);
        this.aFormatter.setTimeZone(tz);
    }

    private void setSelectedTimezoneForbMoment() {
        StringTokenizer st = new StringTokenizer(((Unit)this.bTimeZoneComboBox.getSelectedItem()).getString());
        TimeZone tz = TimeZone.getTimeZone(st.nextToken());
        this.convertCalendarToTimeZone(this.bTextField.getText(), tz, this.bMoment, this.utc);
        this.bFormatter.setTimeZone(tz);
    }

    private void setUTCTimezoneForaMoment() {
        this.convertCalendarToTimeZone(this.aTextField.getText(), this.utc, this.aMoment, this.utc);
        this.aFormatter.setTimeZone(this.utc);
    }

    private void setUTCTimezoneForbMoment() {
        this.convertCalendarToTimeZone(this.bTextField.getText(), this.utc, this.bMoment, this.utc);
        this.bFormatter.setTimeZone(this.utc);
    }

    private void bTimeZoneComboBoxComponentResized(ComponentEvent evt) {
        if (this.dialogInterface.isResizeComboBoxPopups()) {
            GeneralGUI.resizeComboBoxPopup(this.bTimeZoneComboBox);
        }
    }

    private void aTimeZoneComboBoxComponentResized(ComponentEvent evt) {
        if (this.dialogInterface.isResizeComboBoxPopups()) {
            GeneralGUI.resizeComboBoxPopup(this.aTimeZoneComboBox);
        }
    }

    private void convertCalendarToTimeZone(String input, TimeZone fromTimeZone, GregorianCalendar toCal, TimeZone toTimeZone) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        GregorianCalendar fromCal = new GregorianCalendar(fromTimeZone);
        dateFormat.setTimeZone(fromTimeZone);
        try {
            fromCal.setTime(dateFormat.parse(input));
        }
        catch (Exception e) {
            System.err.println(e);
        }
        toCal.setTimeZone(toTimeZone);
        toCal.setTimeInMillis(fromCal.getTimeInMillis());
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.status[0] = true;
        this.setVisible(false);
        this.dialogInterface.releaseDateDiffDialog(this.status, this.secs);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.status[0] = false;
        this.setVisible(false);
        this.dispose();
    }

    private void bTextFieldKeyReleased(KeyEvent evt) {
        this.xTextFieldKeyReleased(this.bTextField, this.bMoment, this.bFormatter);
    }

    private void aTextFieldKeyReleased(KeyEvent evt) {
        this.xTextFieldKeyReleased(this.aTextField, this.aMoment, this.aFormatter);
    }

    private void xTextFieldKeyReleased(JTextField textField, GregorianCalendar gc, DateFormat formatter) {
        try {
            gc.setTime(formatter.parse(textField.getText()));
            gc.set(14, 0);
            textField.setBackground(Color.WHITE);
            this.updateAllPanels();
        }
        catch (ParseException e) {
            textField.setBackground(Main.RED);
        }
    }

    private void updateInputPanel() {
        this.aDSTLabel.setEnabled(this.aFormatter.getTimeZone().inDaylightTime(this.aMoment.getTime()));
        this.bDSTLabel.setEnabled(this.bFormatter.getTimeZone().inDaylightTime(this.bMoment.getTime()));
        String label = this.aMoment.after(this.bMoment) ? "B < A" : (this.aMoment.before(this.bMoment) ? "A < B" : "A = B");
        this.signLabel.setText(label);
    }

    private void updateBusinessPanel() {
        this.zt = (Zinstage)this.zinstageComboBox.getSelectedItem();
        this.zt.setStart(this.aMoment);
        this.zt.setEnd(this.bMoment);
        this.zinstageTextField.setText(Integer.toString(this.zt.calc()));
        this.zt = null;
    }

    private void updateExactPanel() {
        Duration durationExact = Duration.getDiff(this.aMoment, this.bMoment, this.leapSecondsCheckBox.isSelected());
        this.refreshExactPanel(durationExact);
        this.secs[0] = durationExact.getSeconds();
    }

    private void updateColloquialPanel() {
        this.durationColloquialBackup = DurationColloquial.getDiff(this.aMoment, this.bMoment);
        this.refreshColloquialPanel(this.durationColloquialBackup, null);
    }

    private void refreshExactPanel(Duration duration) {
        this.refreshExactPanel(duration.getSeconds());
    }

    private DurationControl getExactDurationControl() {
        DurationControl durationControl = new DurationControl();
        durationControl.setAll(false);
        durationControl.setLeapSecondsWanted(this.leapSecondsCheckBox.isSelected());
        durationControl.setSecondsWanted(this.secondsCheckBox.isSelected());
        durationControl.setMinutesWanted(this.minutesCheckBox.isSelected());
        durationControl.setHoursWanted(this.hoursCheckBox.isSelected());
        durationControl.setDaysWanted(this.daysCheckBox.isSelected());
        durationControl.setWeeksWanted(this.weeksCheckBox.isSelected());
        return durationControl;
    }

    private DurationControl getColloquialDurationControl() {
        DurationControl durationControl = new DurationControl();
        durationControl.setAll(false);
        durationControl.setDaysWanted(this.collDaysCheckBox.isSelected());
        durationControl.setWeeksWanted(this.collWeeksCheckBox.isSelected());
        durationControl.setMonthsWanted(this.collMonthsCheckBox.isSelected());
        durationControl.setQuartersWanted(this.collQuartersCheckBox.isSelected());
        durationControl.setYearsWanted(this.collYearsCheckBox.isSelected());
        return durationControl;
    }

    private void refreshExactPanel(long seconds) {
        Duration duration = new Duration();
        duration.setSeconds(seconds);
        DurationControl durationControl = this.getExactDurationControl();
        duration.rearrange(durationControl);
        this.secondsTextField.setText(durationControl.isSecondsWanted() ? Long.toString(duration.getSeconds()) : "0");
        this.minutesTextField.setText(durationControl.isMinutesWanted() ? formatter.format(duration.getMinutes()) : "0");
        this.hoursTextField.setText(durationControl.isHoursWanted() ? formatter.format(duration.getHours()) : "0");
        this.daysTextField.setText(durationControl.isDaysWanted() ? formatter.format(duration.getDays()) : "0");
        this.weeksTextField.setText(durationControl.isWeeksWanted() ? formatter.format(duration.getWeeks()) : "0");
        if (!(this.secondsCheckBox.isSelected() || this.minutesCheckBox.isSelected() || this.hoursCheckBox.isSelected() || this.daysCheckBox.isSelected() || this.weeksCheckBox.isSelected())) {
            this.secondsCheckBox.setSelected(true);
        }
    }

    private void refreshColloquialPanel(DurationColloquial durationColloquial, ItemEvent evt) {
        DurationColloquial dur = (DurationColloquial)durationColloquial.clone();
        DurationControl durationControl = this.getColloquialDurationControl();
        dur.rearrange(durationControl);
        this.collYearsTextField.setText(durationControl.isYearsWanted() ? formatter.format(dur.getYears()) : "0");
        this.collQuartersTextField.setText(durationControl.isQuartersWanted() ? formatter.format(dur.getQuarters()) : "0");
        this.collMonthsTextField.setText(durationControl.isMonthsWanted() ? formatter.format(dur.getMonths()) : "0");
        this.collWeeksTextField.setText(durationControl.isWeeksWanted() ? formatter.format(dur.getWeeks()) : "0");
        this.collDaysTextField.setText(durationControl.isDaysWanted() ? formatter.format(dur.getDays()) : "0");
        if (!(this.collYearsCheckBox.isSelected() || this.collQuartersCheckBox.isSelected() || this.collMonthsCheckBox.isSelected())) {
            if (evt != null && evt.getItem() == this.collMonthsCheckBox) {
                this.collYearsCheckBox.setSelected(true);
            } else {
                this.collMonthsCheckBox.setSelected(true);
            }
        }
        if (!this.collDaysCheckBox.isSelected() && !this.collWeeksCheckBox.isSelected()) {
            if (evt != null && evt.getItem() == this.collDaysCheckBox) {
                this.collWeeksCheckBox.setSelected(true);
            } else {
                this.collDaysCheckBox.setSelected(true);
            }
        }
    }

    private void updateAllPanels() {
        this.updateInputPanel();
        this.updateExactPanel();
        this.updateColloquialPanel();
        this.updateBusinessPanel();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DateDiffDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    private void timerButton() {
        this.aTextField.setEnabled(false);
        ClockThread clockThread = new ClockThread(this.aTextField);
        clockThread.start();
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this.dialogInterface.getResourceBundle();
    }

    @Override
    public ResourceBundle getISO3166ResourceBundle() {
        return this.renderer.getISO3166ResourceBundle();
    }
}

