/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.gui.dialogs.exchangerates;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public class ExchangeRatesFilter {
    private String name;
    private String country;
    private String description;
    private String instruction;
    private String[] websites;
    private String[] filetypes;
    private boolean allowAppend;
    private boolean directDownloadAllowed;
    private boolean enabled;
    private String useragent;

    public ExchangeRatesFilter() {
    }

    public ExchangeRatesFilter(String filename) throws IOException {
        Properties props = new Properties();
        props.load(this.getClass().getResourceAsStream("/data/rates/" + filename));
        this.enabled = props.getProperty("enabled", "true").equals("true");
        if (!this.enabled) {
            return;
        }
        String filetype = props.getProperty("filechooser", "");
        if (!filetype.equals("")) {
            ArrayList<String> v = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(filetype, ",");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                v.add(tok);
            }
            this.filetypes = new String[v.size()];
            for (int i = 0; i < this.filetypes.length; ++i) {
                this.filetypes[i] = (String)v.get(i);
            }
        }
        String langdefault = Locale.getDefault().getLanguage();
        this.description = props.getProperty("description_" + langdefault, props.getProperty("description", ""));
        this.instruction = props.getProperty("instruction_" + langdefault, props.getProperty("instruction", ""));
        this.allowAppend = props.getProperty("allowAppend", "false").equals("true");
        this.directDownloadAllowed = props.getProperty("directDownload", "false").equals("true");
        String visit = props.getProperty("visit", "");
        int visitadditional = Integer.parseInt(props.getProperty("visit.additional", "0"));
        if (visitadditional > 0) {
            this.websites = new String[1 + visitadditional];
            this.websites[0] = visit;
            for (int i = 0; i < visitadditional; ++i) {
                int index = i + 1;
                this.websites[index] = props.getProperty("visit." + index, "");
            }
        } else {
            this.websites = new String[1];
            this.websites[0] = visit;
        }
        this.useragent = props.getProperty("user-agent");
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    public String[] getFiletypes() {
        return this.filetypes;
    }

    public void setFiletypes(String[] filetypes) {
        this.filetypes = filetypes;
    }

    public boolean isAllowAppend() {
        return this.allowAppend;
    }

    public void setAllowAppend(boolean allowAppend) {
        this.allowAppend = allowAppend;
    }

    public boolean isDirectDownloadAllowed() {
        return this.directDownloadAllowed;
    }

    public void setDirectDownloadAllowed(boolean directDownloadAllowed) {
        this.directDownloadAllowed = directDownloadAllowed;
    }

    public String[] getWebsites() {
        return this.websites;
    }

    public void setWebsites(String[] websites) {
        this.websites = websites;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getUseragent() {
        return this.useragent;
    }

    public void setUseragent(String useragent) {
        this.useragent = useragent;
    }
}

