/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.gui.dialogs.exchangerates;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JTextArea;
import jonelo.sugar.gui.SwingWorker;
import jonelo.sugar.util.Counter;
import net.numericalchameleon.util.exchangerates.CurrencyConverter;
import net.numericalchameleon.util.exchangerates.ExchangeRates;

public class ExchangeRatesUpdateTask {
    private int lengthOfTask;
    private String statMessage;
    private String ratesFilename;
    private String includeFilename;
    private Counter counter = null;
    private JTextArea textArea = null;
    private JButton button = null;
    private ExchangeRates exchangeRates;
    private ResourceBundle iso3166;

    ExchangeRatesUpdateTask(ExchangeRates exchangeRates) {
        this.exchangeRates = exchangeRates;
        this.lengthOfTask = 0;
        try {
            String thisLine;
            FileInputStream fin = new FileInputStream("../data/lists/iso4217.list");
            BufferedReader myInput = new BufferedReader(new InputStreamReader(fin));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.startsWith("#") || thisLine.equals("")) continue;
                ++this.lengthOfTask;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.counter = new Counter();
    }

    void setRatesFilename(String filename) {
        this.ratesFilename = filename;
    }

    void setIncludeFilename(String filename) {
        this.includeFilename = filename;
    }

    void setTextArea(JTextArea textArea) {
        this.textArea = textArea;
    }

    void setButton(JButton button) {
        this.button = button;
    }

    void setISO3166ResourceBundle(ResourceBundle iso3166) {
        this.iso3166 = iso3166;
    }

    void go() {
        this.counter.set(0);
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                return new ActualTask();
            }
        };
        worker.start();
    }

    int getLengthOfTask() {
        return this.lengthOfTask;
    }

    int getCurrent() {
        return this.counter.get();
    }

    void stop() {
        this.counter.set(this.lengthOfTask);
    }

    boolean done() {
        return this.counter.get() >= this.lengthOfTask;
    }

    String getMessage() {
        return this.statMessage;
    }

    class ActualTask {
        ActualTask() {
            try {
                CurrencyConverter cc = new CurrencyConverter(ExchangeRatesUpdateTask.this.ratesFilename, ExchangeRatesUpdateTask.this.includeFilename, ExchangeRatesUpdateTask.this.counter, ExchangeRatesUpdateTask.this.textArea, ExchangeRatesUpdateTask.this.exchangeRates, ExchangeRatesUpdateTask.this.iso3166);
                if (ExchangeRatesUpdateTask.this.exchangeRates.success()) {
                    ExchangeRatesUpdateTask.this.button.setEnabled(true);
                }
            }
            catch (Exception e) {
                System.err.println(e.toString());
                System.err.println("ERROR: exchange rate list corrupted.");
                ExchangeRatesUpdateTask.this.textArea.append(e.toString());
            }
        }
    }
}

