/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.gui.dialogs.find;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jonelo.sugar.gui.GeneralGUI;
import net.numericalchameleon.data.Category;
import net.numericalchameleon.data.Unit;
import net.numericalchameleon.gui.dialogs.find.FindDialogInterface;

public class FindDialog
extends JDialog {
    public static final int CATEGORY = 0;
    public static final int SOURCE = 1;
    public static final int TARGET = 2;
    private FindDialogInterface findDialogInterface;
    private int next = 0;
    private JComboBox box;
    private ResourceBundle rb;
    private int[] progressBarValue = new int[3];
    private String[] text = new String[]{"", "", ""};
    private int lastselected;
    private ButtonGroup buttonGroup;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JRadioButton categoryRadioButton;
    private JButton findButton;
    private JLabel findLabel;
    private JPanel findPanel;
    private JProgressBar findProgressBar;
    private JTextField findTextField;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JSeparator jSeparator1;
    private JCheckBox matchUpperLowerCaseCheckBox;
    private JButton resetButton;
    private JRadioButton sourceRadioButton;
    private JRadioButton targetRadioButton;

    public FindDialog(FindDialogInterface findDialogInterface, int initialSelection) {
        super(findDialogInterface.getFrame(), true);
        this.findDialogInterface = findDialogInterface;
        if (findDialogInterface.getFrame().isUndecorated()) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(1);
        }
        this.rb = findDialogInterface.getResourceBundle();
        this.setTitle(this.rb.getString("GUI.Menu.Find"));
        this.initComponents();
        this.buttonGroup.add(this.sourceRadioButton);
        this.buttonGroup.add(this.targetRadioButton);
        this.buttonGroup.add(this.categoryRadioButton);
        this.lastselected = initialSelection;
        switch (initialSelection) {
            case 0: {
                this.categoryRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.sourceRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.targetRadioButton.setSelected(true);
            }
        }
        this.findProgressBar.setMinimum(0);
        this.switchit();
        this.setLocationRelativeTo(findDialogInterface.getFrame());
        ComponentOrientation ce = ComponentOrientation.getOrientation(Locale.getDefault());
        if (!ce.isLeftToRight()) {
            GeneralGUI.applyOrientation(this.findPanel, ce);
        }
        this.findTextField.requestFocus();
        this.setVisible(true);
    }

    private void switchit() {
        this.text[this.lastselected] = this.findTextField.getText();
        this.progressBarValue[this.lastselected] = this.findProgressBar.getValue();
        int selected = 0;
        if (this.sourceRadioButton.isSelected()) {
            selected = 1;
        } else if (this.targetRadioButton.isSelected()) {
            selected = 2;
        }
        this.box = this.findDialogInterface.getComboBox(selected);
        this.findProgressBar.setMaximum(this.box.getItemCount());
        this.findProgressBar.setValue(this.progressBarValue[selected]);
        this.findTextField.setText(this.text[selected]);
        this.next = this.progressBarValue[selected] + 1;
        this.lastselected = selected;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.findPanel = new JPanel();
        this.findLabel = new JLabel();
        this.findTextField = new JTextField();
        this.findProgressBar = new JProgressBar();
        this.jPanel3 = new JPanel();
        this.matchUpperLowerCaseCheckBox = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jPanel4 = new JPanel();
        this.sourceRadioButton = new JRadioButton();
        this.targetRadioButton = new JRadioButton();
        this.categoryRadioButton = new JRadioButton();
        this.buttonPanel = new JPanel();
        this.resetButton = new JButton();
        this.findButton = new JButton();
        this.cancelButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FindDialog.this.closeDialog(evt);
            }
        });
        this.findPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 10, 15));
        this.findPanel.setLayout(new GridBagLayout());
        this.findLabel.setText(this.rb.getString("GUI.Menu.Find"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.findPanel.add((Component)this.findLabel, gridBagConstraints);
        this.findTextField.setBorder(BorderFactory.createEtchedBorder());
        this.findTextField.setPreferredSize(new Dimension(250, 20));
        this.findTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FindDialog.this.findTextFieldKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.findPanel.add((Component)this.findTextField, gridBagConstraints);
        this.findProgressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.findPanel.add((Component)this.findProgressBar, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.matchUpperLowerCaseCheckBox.setText(this.rb.getString("GUI.Find.Match"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.matchUpperLowerCaseCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.jPanel3.add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.sourceRadioButton.setSelected(true);
        this.sourceRadioButton.setText(this.rb.getString("GUI.Menu.Source"));
        this.sourceRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FindDialog.this.sourceRadioButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.sourceRadioButton, gridBagConstraints);
        this.targetRadioButton.setText(this.rb.getString("GUI.Menu.Target"));
        this.targetRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FindDialog.this.targetRadioButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.jPanel4.add((Component)this.targetRadioButton, gridBagConstraints);
        this.categoryRadioButton.setText(this.rb.getString("GUI.Config.Categories"));
        this.categoryRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.categoryRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.categoryRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FindDialog.this.categoryRadioButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.jPanel4.add((Component)this.categoryRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.findPanel.add((Component)this.jPanel3, gridBagConstraints);
        this.getContentPane().add((Component)this.findPanel, "Center");
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 10));
        this.buttonPanel.setLayout(new GridBagLayout());
        this.resetButton.setText(this.rb.getString("GUI.Find.Reset"));
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindDialog.this.resetButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.buttonPanel.add((Component)this.resetButton, gridBagConstraints);
        this.findButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/magnifier-left.png")));
        this.findButton.setText(this.rb.getString("GUI.Menu.Find"));
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindDialog.this.findButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.buttonPanel.add((Component)this.findButton, gridBagConstraints);
        this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/close.png")));
        this.cancelButton.setText(this.rb.getString("GUI.General.Close"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.buttonPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.getContentPane().add((Component)this.buttonPanel, "East");
        this.pack();
    }

    private void categoryRadioButtonItemStateChanged(ItemEvent evt) {
        this.switchit();
    }

    private void targetRadioButtonItemStateChanged(ItemEvent evt) {
        this.switchit();
    }

    private void sourceRadioButtonItemStateChanged(ItemEvent evt) {
        this.switchit();
    }

    private void findTextFieldKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.findButtonActionPerformed(null);
        } else if (evt.getKeyCode() == 27) {
            this.closeDialog(null);
        }
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        this.findTextField.setText("");
        this.next = 0;
        this.findProgressBar.setValue(0);
        this.findTextField.requestFocus();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void findButtonActionPerformed(ActionEvent evt) {
        int found = -1;
        Class myCast = this.categoryRadioButton.isSelected() ? Category.class : Unit.class;
        found = this.findDialogInterface.findEntry(myCast, this.box, this.findTextField.getText(), this.next, this.matchUpperLowerCaseCheckBox.isSelected());
        if (found > -1) {
            this.box.setSelectedIndex(found);
            this.findProgressBar.setValue(found);
            this.next = found + 1;
        } else {
            this.findProgressBar.setValue(this.findProgressBar.getMaximum());
            String entryNotFound = this.categoryRadioButton.isSelected() ? "Message.CategoryNotFound" : "GUI.Find.UnitNotFoundInThisCategory";
            String noFurtherEntry = this.categoryRadioButton.isSelected() ? "GUI.Find.NoFurtherCategories" : "GUI.Find.NoFurtherUnits";
            JOptionPane.showMessageDialog(this, this.rb.getString(this.next == 0 ? entryNotFound : noFurtherEntry));
            this.next = 0;
            this.findProgressBar.setValue(0);
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

