/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.gui.dialogs.phoneticalphabet;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import jonelo.sugar.gui.GeneralGUI;
import jonelo.sugar.io.GeneralIO;
import net.numericalchameleon.data.Unit;
import net.numericalchameleon.gui.dialogs.phoneticalphabet.PhoneticAlphabetDialogInterface;
import net.numericalchameleon.gui.renderer.UnitRecordCellRenderer;
import net.numericalchameleon.util.phoneticalphabets.PhoneticAlphabet;

public class PhoneticAlphabetDialog
extends JDialog {
    private ResourceBundle rb;
    private Vector data;
    private PhoneticAlphabet phoneticAlphabet;
    private JComboBox alphabetComboBox;
    private JLabel alphabetLabel;
    private JButton closeButton;
    private JButton copyButton;
    private JTextField inputTextField;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JButton nextButton;
    private JButton prevButton;
    private JLabel spellLabel;
    private JLabel textLabel;
    private JList wordList;

    public PhoneticAlphabetDialog(PhoneticAlphabetDialogInterface dialogInterface) {
        super(dialogInterface.getFrame(), false);
        this.rb = dialogInterface.getResourceBundle();
        this.setTitle(this.rb.getString("GUI.PhoneticAlphabet.Title"));
        if (dialogInterface.getFrame().isUndecorated()) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(1);
        }
        this.phoneticAlphabet = new PhoneticAlphabet(PhoneticAlphabet.INTERNATIONAL);
        this.initComponents();
        this.setLocationRelativeTo(dialogInterface.getFrame());
        this.inputTextField.requestFocus();
        UnitRecordCellRenderer ncRecordCellRenderer = new UnitRecordCellRenderer(dialogInterface.getISO3166ResourceBundle());
        this.alphabetComboBox.setRenderer(ncRecordCellRenderer);
        this.setVisible(true);
    }

    private void initComponents() {
        this.closeButton = new JButton();
        this.alphabetLabel = new JLabel();
        this.textLabel = new JLabel();
        this.spellLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.wordList = new JList();
        this.jPanel5 = new JPanel();
        this.alphabetComboBox = new JComboBox();
        this.jPanel4 = new JPanel();
        this.prevButton = new JButton();
        this.nextButton = new JButton();
        this.inputTextField = new JTextField();
        this.copyButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PhoneticAlphabetDialog.this.closeDialog(evt);
            }
        });
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/close.png")));
        this.closeButton.setText(this.rb.getString("GUI.General.Close"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhoneticAlphabetDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.alphabetLabel.setText(this.rb.getString("GUI.PhoneticAlphabet.Alphabet"));
        this.textLabel.setText(this.rb.getString("GUI.PhoneticAlphabet.Text"));
        this.spellLabel.setText(this.rb.getString("GUI.PhoneticAlphabet.Spell"));
        this.jScrollPane1.setPreferredSize(new Dimension(300, 300));
        this.wordList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.wordList);
        this.jPanel5.setLayout(new BorderLayout());
        this.alphabetComboBox.setMaximumRowCount(17);
        this.alphabetComboBox.setModel(this.getAlphabetModel());
        this.alphabetComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PhoneticAlphabetDialog.this.alphabetComboBoxItemStateChanged(evt);
            }
        });
        this.jPanel5.add((Component)this.alphabetComboBox, "Center");
        this.jPanel4.setLayout(new GridLayout(2, 0));
        this.prevButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix6x3/up.png")));
        this.prevButton.setMargin(new Insets(2, 2, 2, 2));
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhoneticAlphabetDialog.this.prevButtonActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.prevButton);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix6x3/down.png")));
        this.nextButton.setMargin(new Insets(2, 2, 2, 2));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhoneticAlphabetDialog.this.nextButtonActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.nextButton);
        this.jPanel5.add((Component)this.jPanel4, "East");
        this.inputTextField.setBorder(BorderFactory.createEtchedBorder());
        this.inputTextField.setPreferredSize(new Dimension(200, 20));
        this.inputTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PhoneticAlphabetDialog.this.inputTextFieldKeyReleased(evt);
            }
        });
        this.copyButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-copy.png")));
        this.copyButton.setText(this.rb.getString("GUI.General.Copy"));
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhoneticAlphabetDialog.this.copyButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textLabel).addComponent(this.spellLabel).addComponent(this.alphabetLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 302, Short.MAX_VALUE).addComponent(this.inputTextField, GroupLayout.Alignment.TRAILING, -1, 302, Short.MAX_VALUE).addComponent(this.jPanel5, -1, 302, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.copyButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel5, -2, -1, -2).addComponent(this.alphabetLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textLabel).addComponent(this.inputTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spellLabel).addComponent(this.jScrollPane1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.copyButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
        ListModel lm = this.wordList.getModel();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lm.getSize(); ++i) {
            sb.append((String)lm.getElementAt(i));
            sb.append("\n");
        }
        GeneralIO.setClipboard(sb.toString());
        this.inputTextField.requestFocusInWindow();
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        int all;
        int now = this.alphabetComboBox.getSelectedIndex();
        if (now + 1 < (all = this.alphabetComboBox.getItemCount())) {
            this.alphabetComboBox.setSelectedIndex(now + 1);
        } else {
            this.alphabetComboBox.setSelectedIndex(0);
        }
    }

    private void prevButtonActionPerformed(ActionEvent evt) {
        int now = this.alphabetComboBox.getSelectedIndex();
        int all = this.alphabetComboBox.getItemCount();
        if (now > 0) {
            this.alphabetComboBox.setSelectedIndex(now - 1);
        } else {
            this.alphabetComboBox.setSelectedIndex(all - 1);
        }
    }

    private void alphabetComboBoxItemStateChanged(ItemEvent evt) {
        this.phoneticAlphabet = new PhoneticAlphabet(this.getAlphabet(this.alphabetComboBox.getSelectedIndex()));
        this.updateWordsList();
    }

    private void inputTextFieldKeyReleased(KeyEvent evt) {
        int code = evt.getKeyCode();
        boolean b = true;
        for (int i = 0; i < GeneralGUI.noTextChangeKeyEvents.length; ++i) {
            if (code != GeneralGUI.noTextChangeKeyEvents[i]) continue;
            b = false;
            break;
        }
        if (b) {
            this.updateWordsList();
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private ComboBoxModel getAlphabetModel() {
        Vector data = this.getAlphabetVector();
        JComboBox cb = new JComboBox(data);
        return cb.getModel();
    }

    protected String localize(String key, String fallback) {
        String value = this.rb.getString(key);
        return value == null ? fallback : value;
    }

    private Vector getAlphabetVector() {
        this.data = new Vector();
        this.data.add(new Unit(this.localize("PhoneticAlphabet.International", "International"), "int"));
        this.data.add(new Unit(this.localize("PhoneticAlphabet.Morse", "Morse"), "int"));
        this.data.add(new Unit(this.localize("PhoneticAlphabet.NATO", "NATO / ICAO"), "int"));
        this.data.add(new Unit(this.localize("Language.us", "American English"), "us"));
        this.data.add(new Unit(this.localize("Language.gb", "British English"), "gb"));
        this.data.add(new Unit(this.localize("Language.fr", "French"), "fr"));
        this.data.add(new Unit(this.localize("Language.es", "Spanish"), "es"));
        this.data.add(new Unit(this.localize("Language.de", "German"), "de"));
        this.data.add(new Unit(this.localize("Language.ch", "Swiss"), "ch"));
        this.data.add(new Unit(this.localize("Language.at", "Austrian"), "at"));
        this.data.add(new Unit(this.localize("Language.it", "Italian"), "it"));
        this.data.add(new Unit(this.localize("Language.pt", "Portuguese"), "pt"));
        this.data.add(new Unit(this.localize("Language.dk", "Danish"), "dk"));
        this.data.add(new Unit(this.localize("Language.nl", "Dutch"), "nl"));
        this.data.add(new Unit(this.localize("Language.se", "Swedish"), "se"));
        this.data.add(new Unit(this.localize("Language.il", "Hebrew"), "il"));
        this.data.add(new Unit("Joint Army/Navy (1941-1955)", "us", false));
        this.data.add(new Unit("Royal Air Force (1924-1942)", "gb", false));
        this.data.add(new Unit("Royal Air Force (1942-1943)", "gb", false));
        this.data.add(new Unit("Royal Air Force (1943-1956)", "gb", false));
        this.data.add(new Unit("Royal Navy (World War I)", "gb", false));
        return this.data;
    }

    private void updateWordsList() {
        this.wordList.removeAll();
        this.wordList.setModel(this.getWordsModel(this.phoneticAlphabet.get(this.inputTextField.getText())));
    }

    private ListModel getWordsModel(Vector v) {
        JList jl = new JList(v);
        return jl.getModel();
    }

    private String[] getAlphabet(int i) {
        switch (i) {
            case 0: {
                return PhoneticAlphabet.INTERNATIONAL;
            }
            case 1: {
                return PhoneticAlphabet.MORSE;
            }
            case 2: {
                return PhoneticAlphabet.NATO;
            }
            case 3: {
                return PhoneticAlphabet.AMERICAN;
            }
            case 4: {
                return PhoneticAlphabet.BRITISH;
            }
            case 5: {
                return PhoneticAlphabet.FRENCH;
            }
            case 6: {
                return PhoneticAlphabet.SPANISH;
            }
            case 7: {
                return PhoneticAlphabet.GERMAN;
            }
            case 8: {
                return PhoneticAlphabet.SWISS;
            }
            case 9: {
                return PhoneticAlphabet.AUSTRIAN;
            }
            case 10: {
                return PhoneticAlphabet.ITALIAN;
            }
            case 11: {
                return PhoneticAlphabet.PORTUGUESE;
            }
            case 12: {
                return PhoneticAlphabet.DANISH;
            }
            case 13: {
                return PhoneticAlphabet.DUTCH;
            }
            case 14: {
                return PhoneticAlphabet.SWEDISH;
            }
            case 15: {
                return PhoneticAlphabet.HEBREW;
            }
            case 16: {
                return PhoneticAlphabet.ARMYNAVY;
            }
            case 17: {
                return PhoneticAlphabet.RAF_1943_1956;
            }
            case 18: {
                return PhoneticAlphabet.RAF_1942_1943;
            }
            case 19: {
                return PhoneticAlphabet.RAF_1924_1942;
            }
            case 20: {
                return PhoneticAlphabet.BRITISH_ROYAL_NAVY;
            }
        }
        return null;
    }
}

