/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.gui.dialogs.summary;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import jonelo.sugar.util.GeneralString;
import net.numericalchameleon.data.Summary;
import net.numericalchameleon.gui.common.interfaces.DialogInterface;

public class SummaryDialog
extends JDialog {
    private ResourceBundle rb;
    private Summary sr;
    private JButton closeButton;
    private JLabel countLabel;
    private JScrollPane jScrollPane1;
    private JTable table;

    public SummaryDialog(DialogInterface dialogInterface, boolean modal, Summary sr) {
        super(dialogInterface.getFrame(), modal);
        this.rb = dialogInterface.getResourceBundle();
        this.sr = sr;
        this.initComponents();
        this.setTitle(this.rb.getString("GUI.Bookmarks.Info"));
        this.countLabel.setText(GeneralString.message(this.rb.getString("Moduls.Count"), sr.getUnitsComplete(), sr.getCategoriesComplete()));
        this.setLocationRelativeTo(dialogInterface.getFrame());
        this.setVisible(true);
    }

    public SummaryDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.closeButton = new JButton();
        this.countLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SummaryDialog.this.closeDialog(evt);
            }
        });
        this.table.setModel(new DefaultTableModel(new Object[][]{{this.rb.getString("GUI.Config.Categories"), 1, this.sr.getCategoriesFiltered(), this.sr.getCategoriesComplete()}, {this.rb.getString("GUI.Config.Units"), this.sr.getUnitsSelectable(), this.sr.getUnitsFiltered(), this.sr.getUnitsComplete()}}, new String[]{" ", this.rb.getString("GUI.Count.Selected"), this.rb.getString("GUI.Count.Filtered"), this.rb.getString("GUI.Count.Total")}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Integer.class, Integer.class, Integer.class};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.table.setEnabled(false);
        this.jScrollPane1.setViewportView(this.table);
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/ok.png")));
        this.closeButton.setText(this.rb.getString("GUI.General.OK"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SummaryDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.countLabel.setText(this.rb.getString("Moduls.Count"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, -1, 415, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.countLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 114, Short.MAX_VALUE).addComponent(this.closeButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 88, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.countLabel)).addContainerGap()));
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SummaryDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    public JTable getTable() {
        return this.table;
    }

    public void setTable(JTable table) {
        this.table = table;
    }
}

