/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.gui.dialogs.updatecenter;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import jonelo.sugar.gui.GUIHelper;
import jonelo.sugar.gui.SwingWorker;
import jonelo.sugar.util.GeneralNet;
import jonelo.sugar.util.GeneralString;
import net.numericalchameleon.gui.common.interfaces.DialogInterface;
import net.numericalchameleon.gui.common.interfaces.UpdateInterface;
import net.numericalchameleon.gui.dialogs.updatecenter.UpdateStatusRenderer;
import net.numericalchameleon.update.UpdateRecord;
import net.numericalchameleon.update.UpdateStatus;
import net.numericalchameleon.update.modules.ExchangeRatesVersionModule;
import net.numericalchameleon.update.modules.ProgramVersionModule;
import net.numericalchameleon.update.modules.TzdataModule;

public final class UpdateCenterDialog
extends JDialog {
    private final UpdateInterface updateInterface;
    private final ResourceBundle rb;
    private final UpdateRecord updateRecord;
    private static final int ROW_NCVER = 0;
    private static final int ROW_RATES = 1;
    private static final int ROW_TZDATA = 2;
    private static final int COL_VENDOR = 0;
    private static final int COL_NAME = 1;
    private static final int COL_INSTALLED = 2;
    private static final int COL_UPDATE = 3;
    private static final int COL_STATUS = 4;
    public static final String LAST_UPDATE_CHECK_PROPERTY_NAME = "last_update_check";
    private final DialogInterface i18nInterface;
    private JButton checkForUpdatesButton;
    private JButton closeButton;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JLabel lastCheckLabel;
    private JTable myTable;
    private JProgressBar progressBar;

    public UpdateCenterDialog(DialogInterface dialogInterface, UpdateInterface updateInterface) {
        super(dialogInterface.getFrame(), true);
        this.updateInterface = updateInterface;
        this.updateRecord = updateInterface.getUpdateRecord();
        this.rb = dialogInterface.getResourceBundle();
        this.i18nInterface = dialogInterface;
        this.initComponents();
        this.myTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.myTable.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.myTable.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.myTable.getColumnModel().getColumn(3).setPreferredWidth(80);
        Properties props = updateInterface.getUpdateProps();
        this.updateLastCheckedLabel(props);
        this.updateRecord.getTzdataModule().setLatestKnownVersion(props);
        this.updateRecord.getNcVersionModule().setLatestKnownVersion(props);
        this.updateRecord.getExchangeRatesVersionModule().setVendor(props);
        this.updateRecord.getExchangeRatesVersionModule().setInstalledVersion(props);
        this.updateTableWith(this.updateRecord);
        this.myTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    switch (UpdateCenterDialog.this.myTable.getSelectedRow()) {
                        case 0: {
                            UpdateCenterDialog.this.gotoNcUpdate();
                            break;
                        }
                        case 1: {
                            UpdateCenterDialog.this.gotoRatesUpdate();
                            break;
                        }
                        case 2: {
                            UpdateCenterDialog.this.gotoTzUpdate();
                            break;
                        }
                        default: {
                            System.err.println("missing update handler for " + UpdateCenterDialog.this.myTable.getSelectedRow());
                        }
                    }
                }
            }
        });
        this.setLocationRelativeTo(dialogInterface.getFrame());
        this.setVisible(true);
    }

    public void updateLastCheckedLabel(Properties props) {
        this.lastCheckLabel.setText(GeneralString.message(this.rb.getString("GUI.UpdateCenter.lastCheck"), props.getProperty(LAST_UPDATE_CHECK_PROPERTY_NAME, "-")));
    }

    public void updateTableWith(UpdateRecord updateRecord) {
        TzdataModule tzdataModule = updateRecord.getTzdataModule();
        this.myTable.getModel().setValueAt(tzdataModule.getLatestKnownVersion(), 2, 3);
        this.myTable.getModel().setValueAt(tzdataModule.getStatus(), 2, 4);
        ExchangeRatesVersionModule exchangeRatesVersionModule = updateRecord.getExchangeRatesVersionModule();
        this.myTable.getModel().setValueAt(exchangeRatesVersionModule.getInstalledVersion(), 1, 2);
        this.myTable.getModel().setValueAt(exchangeRatesVersionModule.getLatestKnownVersion(), 1, 3);
        this.myTable.getModel().setValueAt(exchangeRatesVersionModule.getStatus(), 1, 4);
        this.myTable.getModel().setValueAt(exchangeRatesVersionModule.getVendor(), 1, 0);
        ProgramVersionModule ncVersionModule = updateRecord.getNcVersionModule();
        this.myTable.getModel().setValueAt(ncVersionModule.getLatestKnownVersion(), 0, 3);
        this.myTable.getModel().setValueAt(ncVersionModule.getStatus(), 0, 4);
    }

    private boolean isModuleAlreadyUpToDate(int rowIndex) {
        return this.myTable.getModel().getValueAt(rowIndex, 2).equals(this.myTable.getModel().getValueAt(rowIndex, 3));
    }

    private void messageModuleIsAlreadyUpToDate() {
        JOptionPane.showMessageDialog(this, this.rb.getString("GUI.UpdateCenter.ModuleIsAlreadyUpToDate"), this.rb.getString("GUI.General.Info"), 1);
    }

    public void gotoRatesUpdate() {
        if (this.isModuleAlreadyUpToDate(1)) {
            this.messageModuleIsAlreadyUpToDate();
            return;
        }
        this.formWindowClosing(null);
        this.updateInterface.updateExchangeRates();
    }

    public void gotoTzUpdate() {
        if (this.isModuleAlreadyUpToDate(2)) {
            this.messageModuleIsAlreadyUpToDate();
            return;
        }
        String msg = GeneralString.message(this.rb.getString("GUI.UpdateCenter.Moduls.TimezoneDatabase.UpdateInstructions"), "http://www.oracle.com/technetwork/java/javase/downloads/index.html");
        String title = this.rb.getString("GUI.General.Info");
        JOptionPane.showMessageDialog(this, msg, title, 1);
        try {
            GUIHelper.openInBrowser("http://www.oracle.com/technetwork/java/javase/downloads/index.html");
        }
        catch (IOException e) {
            System.err.println(e);
        }
        catch (URISyntaxException e) {
            System.err.println(e);
        }
    }

    public void gotoNcUpdate() {
        if (this.isModuleAlreadyUpToDate(0)) {
            this.messageModuleIsAlreadyUpToDate();
        }
        this.formWindowClosing(null);
        this.updateInterface.appUpdateDialog();
    }

    private void initComponents() {
        this.checkForUpdatesButton = new JButton();
        this.lastCheckLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.myTable = new JTable();
        this.myTable.setDefaultRenderer(UpdateStatus.class, new UpdateStatusRenderer(this.i18nInterface));
        this.jLabel3 = new JLabel();
        this.closeButton = new JButton();
        this.progressBar = new JProgressBar();
        this.progressBar.setVisible(false);
        this.setDefaultCloseOperation(2);
        this.setTitle(this.rb.getString("GUI.General.Update"));
        this.setMinimumSize(new Dimension(640, 240));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                UpdateCenterDialog.this.formWindowClosing(evt);
            }
        });
        this.checkForUpdatesButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/magnifier-left.png")));
        this.checkForUpdatesButton.setText(this.rb.getString("GUI.UpdateCenter.CheckForUpdates"));
        this.checkForUpdatesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateCenterDialog.this.checkForUpdatesButtonActionPerformed(evt);
            }
        });
        this.lastCheckLabel.setText(this.rb.getString("GUI.UpdateCenter.lastCheck"));
        this.myTable.setModel(new DefaultTableModel(new Object[][]{{this.updateRecord.getNcVersionModule().getVendor(), this.updateRecord.getNcVersionModule().getName(), this.updateRecord.getNcVersionModule().getInstalledVersion(), this.updateRecord.getNcVersionModule().getLatestKnownVersion(), this.updateRecord.getNcVersionModule().getStatus()}, {this.updateRecord.getExchangeRatesVersionModule().getVendor(), this.updateRecord.getExchangeRatesVersionModule().getName(), this.updateRecord.getExchangeRatesVersionModule().getInstalledVersion(), this.updateRecord.getExchangeRatesVersionModule().getLatestKnownVersion(), this.updateRecord.getExchangeRatesVersionModule().getStatus()}, {this.updateRecord.getTzdataModule().getVendor(), this.updateRecord.getTzdataModule().getName(), this.updateRecord.getTzdataModule().getInstalledVersion(), this.updateRecord.getTzdataModule().getLatestKnownVersion(), this.updateRecord.getTzdataModule().getStatus()}}, new String[]{this.rb.getString("GUI.UpdateCenter.TableHeader.Vendor"), this.rb.getString("GUI.UpdateCenter.TableHeader.Module"), this.rb.getString("GUI.UpdateCenter.TableHeader.Installed"), this.rb.getString("GUI.UpdateCenter.TableHeader.Available"), this.rb.getString("GUI.UpdateCenter.TableHeader.Status")}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, UpdateStatus.class};
                this.canEdit = new boolean[]{false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.myTable.setAutoResizeMode(4);
        this.jScrollPane1.setViewportView(this.myTable);
        this.jLabel3.setFont(this.jLabel3.getFont().deriveFont(this.jLabel3.getFont().getStyle() | 1));
        this.jLabel3.setText(this.rb.getString("GUI.UpdateCenter.InstructionText"));
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/close.png")));
        this.closeButton.setText(this.rb.getString("GUI.General.Close"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateCenterDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.progressBar.setIndeterminate(true);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.checkForUpdatesButton).addGap(18, 18, 18).addComponent(this.lastCheckLabel)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 114, Short.MAX_VALUE).addComponent(this.closeButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkForUpdatesButton).addComponent(this.lastCheckLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 101, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.closeButton).addComponent(this.progressBar, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void checkForUpdatesButtonActionPerformed(ActionEvent evt) {
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                class ModuleWorker {
                    public ModuleWorker() {
                        this.start();
                        Properties properties = UpdateCenterDialog.this.updateInterface.getUpdateProps();
                        boolean success = true;
                        String date = DateFormat.getDateTimeInstance(2, 2).format(new Date());
                        try {
                            UpdateCenterDialog.this.updateRecord.getTzdataModule().setLatestKnownVersion(GeneralNet.whatIsTheLatestTzdata());
                        }
                        catch (Exception e) {
                            success = false;
                            UpdateCenterDialog.this.progressBar.setVisible(false);
                            JOptionPane.showMessageDialog(null, e.getMessage(), UpdateCenterDialog.this.rb.getString("GUI.General.Error"), 0);
                        }
                        properties.setProperty("latest_known_tzdata", UpdateCenterDialog.this.updateRecord.getTzdataModule().getLatestKnownVersion());
                        UpdateCenterDialog.this.progressBar.setVisible(true);
                        try {
                            UpdateCenterDialog.this.updateRecord.getNcVersionModule().setLatestKnownVersion(UpdateCenterDialog.this.updateRecord.getNcVersionModule().whatIsTheLastestVersion());
                        }
                        catch (IOException e) {
                            success = false;
                            JOptionPane.showMessageDialog(null, e.getMessage(), UpdateCenterDialog.this.rb.getString("GUI.General.Error"), 0);
                        }
                        properties.setProperty("latest_known_nc_version", UpdateCenterDialog.this.updateRecord.getNcVersionModule().getLatestKnownVersion());
                        properties.setProperty("latest_known_rates_version", UpdateCenterDialog.this.updateRecord.getExchangeRatesVersionModule().getLatestKnownVersion());
                        if (success) {
                            properties.setProperty(UpdateCenterDialog.LAST_UPDATE_CHECK_PROPERTY_NAME, date);
                        }
                        UpdateCenterDialog.this.updateInterface.saveUpdateProperties();
                        UpdateCenterDialog.this.updateLastCheckedLabel(properties);
                        UpdateCenterDialog.this.updateTableWith(UpdateCenterDialog.this.updateRecord);
                        this.done();
                    }

                    private void start() {
                        UpdateCenterDialog.this.progressBar.setVisible(true);
                        UpdateCenterDialog.this.checkForUpdatesButton.setEnabled(false);
                        UpdateCenterDialog.this.closeButton.setEnabled(false);
                    }

                    private void done() {
                        UpdateCenterDialog.this.progressBar.setVisible(false);
                        UpdateCenterDialog.this.checkForUpdatesButton.setEnabled(true);
                        UpdateCenterDialog.this.closeButton.setEnabled(true);
                    }
                }
                return new ModuleWorker();
            }
        };
        worker.start();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.formWindowClosing(null);
    }

    class MyTableModel
    extends AbstractTableModel {
        private UpdateRecord updateRecord;
        private static final boolean DEBUG = false;
        private final String[] columnNames = new String[]{"Vendor", "Module", "Installed", "Update Available", "Status"};
        private final Object[][] data = new Object[][]{{this.updateRecord.getNcVersionModule().getVendor(), this.updateRecord.getNcVersionModule().getName(), this.updateRecord.getNcVersionModule().getInstalledVersion(), this.updateRecord.getNcVersionModule().getLatestKnownVersion(), this.updateRecord.getNcVersionModule().getStatus()}, {this.updateRecord.getExchangeRatesVersionModule().getVendor(), this.updateRecord.getExchangeRatesVersionModule().getName(), this.updateRecord.getExchangeRatesVersionModule().getInstalledVersion(), this.updateRecord.getExchangeRatesVersionModule().getLatestKnownVersion(), this.updateRecord.getExchangeRatesVersionModule().getStatus()}, {this.updateRecord.getTzdataModule().getVendor(), this.updateRecord.getTzdataModule().getName(), this.updateRecord.getTzdataModule().getInstalledVersion(), this.updateRecord.getTzdataModule().getLatestKnownVersion(), this.updateRecord.getTzdataModule().getStatus()}};

        public MyTableModel(UpdateRecord updateRecord) {
            this.updateRecord = updateRecord;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }

        private void printDebugData() {
            int numRows = this.getRowCount();
            int numCols = this.getColumnCount();
            for (int i = 0; i < numRows; ++i) {
                System.out.print("    row " + i + ":");
                for (int j = 0; j < numCols; ++j) {
                    System.out.print("  " + this.data[i][j]);
                }
                System.out.println();
            }
            System.out.println("--------------------------");
        }
    }
}

