/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.update.modules;

import java.util.Properties;
import jonelo.sugar.util.GeneralProgram;
import net.numericalchameleon.update.UpdateStatus;
import net.numericalchameleon.update.modules.AbstractModule;

public class TzdataModule
extends AbstractModule {
    public static final String LATEST_KNOWN_VERSION = "tzdata2016j";
    public static final String DOWNLOAD_URL = "http://www.oracle.com/technetwork/java/javase/downloads/index.html";
    public static final String LATEST_KNOWN_VERSION_PROPERTY_NAME = "latest_known_tzdata";

    public TzdataModule() {
        this.name = "Time Zone Database";
        this.vendor = System.getProperty("java.vendor");
        this.installedVersion = null;
        this.latestKnownVersion = LATEST_KNOWN_VERSION;
    }

    @Override
    public String getInstalledVersion() {
        if (this.installedVersion == null) {
            String temp;
            try {
                temp = GeneralProgram.getTimeZoneDataVersion();
            }
            catch (Exception e) {
                temp = UpdateStatus.UNKNOWN.toString();
            }
            this.installedVersion = temp;
        }
        return this.installedVersion;
    }

    public void setLatestKnownVersion(Properties props) {
        this.latestKnownVersion = props.getProperty(LATEST_KNOWN_VERSION_PROPERTY_NAME, LATEST_KNOWN_VERSION);
    }

    @Override
    public UpdateStatus getStatus() {
        UpdateStatus status;
        String a = this.getInstalledVersion();
        String b = this.getLatestKnownVersion();
        if (a == null || b == null || a.equals("unknown") || b.equals("unknown")) {
            return UpdateStatus.UNKNOWN;
        }
        UpdateStatus updateStatus = status = a.compareToIgnoreCase(b) < 0 ? UpdateStatus.OUTDATED : UpdateStatus.UPTODATE;
        if (status == UpdateStatus.OUTDATED && a.regionMatches(0, b, 0, 10)) {
            return UpdateStatus.OLDER;
        }
        return status;
    }
}

