/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.calendarlistformats;

import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import jonelo.sugar.util.GeneralString;
import net.numericalchameleon.info.ProgInfo;
import net.numericalchameleon.util.calendarlistformats.ListFormat;

public class OutlookListFormat
extends ListFormat {
    private final Format formatter = new SimpleDateFormat("yyyy/MM/dd");
    private int count = 0;

    @Override
    public String getHeader() {
        return "[" + ProgInfo.getInstance().getProgramName() + "] " + this.count + " \n";
    }

    @Override
    public String getFooter() {
        return "";
    }

    @Override
    public String getFormat() {
        return "$TUNIT, $TVALUE";
    }

    @Override
    public String reformatDate(int dateformat, String date) throws ParseException {
        Date newdate = DateFormat.getDateInstance(dateformat).parse(date);
        ++this.count;
        return this.formatter.format(newdate);
    }

    @Override
    public String reformatUnit(String unit) {
        String temp = GeneralString.replaceChar(unit, ',', ';');
        temp = GeneralString.replaceChar(temp, ']', ')');
        return GeneralString.replaceChar(temp, '[', '(');
    }
}

