/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.exchangerates;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextArea;
import jonelo.sugar.util.Counter;
import jonelo.sugar.util.GeneralString;
import net.numericalchameleon.util.exchangerates.ExchangeRates;

public class CurrencyConverter {
    private static boolean debug = false;
    private static final BigDecimal _1 = BigDecimal.valueOf(1L);
    private ResourceBundle iso3166;

    public static void setDebug(boolean flag) {
        debug = flag;
    }

    public CurrencyConverter(String filenameFilter, String filenameRates, Counter current, JTextArea textArea, ExchangeRates exchangeRates, ResourceBundle iso3166) throws Exception {
        try {
            int found;
            String thisLine;
            long begin = System.currentTimeMillis();
            ResourceBundle iso4217 = ResourceBundle.getBundle("data.lang.iso4217");
            StringBuilder sb = new StringBuilder();
            String temp = null;
            textArea.setCaretPosition(0);
            textArea.setText("");
            Properties props = new Properties();
            props.load(this.getClass().getResourceAsStream(filenameFilter));
            String name = props.getProperty("name", "");
            exchangeRates.setName(name);
            String date = props.getProperty("date", "");
            String before_iso = props.getProperty("before_iso", "");
            String after_iso = props.getProperty("after_iso", "");
            String before_iso_inv = props.getProperty("before_iso_inv", "");
            String after_iso_inv = props.getProperty("after_iso_inv", "");
            char decimalSeparator = props.getProperty("decimalSeparator", " ").charAt(0);
            char decimalPoint = props.getProperty("decimalPoint", " ").charAt(0);
            String logicString = props.getProperty("logic", "false");
            exchangeRates.setLogic(logicString.equals("true"));
            String base = props.getProperty("base", "");
            boolean removeTags = props.getProperty("removeTags", "false").equals("true");
            boolean removeWhitespaces = props.getProperty("removeWhitespaces", "false").equals("true");
            boolean replaceCodes = props.getProperty("replaceCodes", "false").equals("true");
            boolean removeCommentBeforeParsing = props.getProperty("removeCommentBeforeParsing", "false").equals("true");
            String searchOnly = props.getProperty("searchOnlyFor", "");
            String cutBegin = props.getProperty("cutHead", "");
            int cutHeadCount = Integer.parseInt(props.getProperty("cutHead.count", "1"));
            String cutEnd = props.getProperty("cutBottom", "");
            temp = props.getProperty("valuepos", "1");
            int valuepos = 1;
            try {
                valuepos = Integer.valueOf(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            temp = props.getProperty("factorpos", "0");
            int factorpos = 0;
            try {
                factorpos = Integer.valueOf(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            temp = props.getProperty("factorForAll", "0");
            int factorForAll = 0;
            try {
                factorForAll = Integer.valueOf(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            FileInputStream fin = new FileInputStream(filenameRates);
            BufferedReader myInput = new BufferedReader(new InputStreamReader(fin));
            String allText = null;
            while ((thisLine = myInput.readLine()) != null) {
                sb.append(thisLine);
                sb.append("\n");
            }
            myInput.close();
            fin.close();
            if (removeCommentBeforeParsing) {
                CurrencyConverter.removeAllComment(sb);
            }
            allText = sb.toString();
            int count = 0;
            int real = 0;
            String isocode = null;
            String description = null;
            StringTokenizer stringTokenizer = null;
            InputStream is = this.getClass().getResourceAsStream("/data/lists/iso4217.list");
            myInput = new BufferedReader(new InputStreamReader(is));
            thisLine = null;
            Pattern pattern = null;
            if (date.length() == 0) {
                temp = "n/a";
            } else if (date.equals("today")) {
                temp = new Date().toString();
            } else {
                try {
                    pattern = Pattern.compile(date, 2);
                }
                catch (Exception e) {
                    System.err.println(e);
                }
                Matcher matcher = pattern.matcher(allText);
                temp = matcher.find() ? matcher.group(1) : "n/a";
            }
            exchangeRates.setDate(temp);
            for (int i = 0; i < cutHeadCount; ++i) {
                int found2;
                if (cutBegin.length() <= 0 || (found2 = allText.indexOf(cutBegin)) <= 0) continue;
                allText = allText.substring(found2 + cutBegin.length());
            }
            if (cutEnd.length() > 0 && (found = allText.indexOf(cutEnd)) > 0) {
                allText = allText.substring(0, found);
            }
            String out = "Exchange rates from: " + temp + "\n";
            if (debug) {
                System.out.print(out);
            }
            textArea.append(out);
            String value = null;
            String last_isocode = "---";
            String flag = "";
            String sourcetarget = "";
            String truefalse = "";
            boolean found3 = false;
            Counter counter2 = new Counter(0);
            String expr_template = before_iso + "   " + after_iso;
            String expr_template_inv = before_iso_inv + "   " + after_iso_inv;
            String expr = null;
            String country = null;
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.startsWith("#") || thisLine.equals("")) continue;
                current.inc();
                counter2.inc();
                if (current.get() != counter2.get()) {
                    throw new Exception("User cancellation.");
                }
                stringTokenizer = new StringTokenizer(thisLine, ":");
                isocode = stringTokenizer.nextToken();
                if (searchOnly.length() == 0 || searchOnly.length() > 0 && searchOnly.indexOf(isocode) > -1 || base.length() > 0 && base.equals(isocode)) {
                    description = stringTokenizer.nextToken();
                    try {
                        description = GeneralString.encodeUnicode(iso4217.getString(isocode));
                    }
                    catch (MissingResourceException mre) {
                        description = "UNKNOWN";
                    }
                    sourcetarget = "";
                    truefalse = "";
                    flag = "";
                    if (stringTokenizer.hasMoreTokens()) {
                        flag = stringTokenizer.nextToken().toLowerCase(Locale.US);
                        if (stringTokenizer.hasMoreTokens()) {
                            truefalse = stringTokenizer.nextToken().toLowerCase(Locale.US);
                            if (stringTokenizer.hasMoreTokens()) {
                                sourcetarget = stringTokenizer.nextToken().toLowerCase(Locale.US);
                            }
                        }
                    }
                    if (isocode.equals(base)) {
                        last_isocode = base;
                        value = "1";
                        found3 = true;
                    }
                    if (!isocode.equals(last_isocode)) {
                        BigDecimal bd;
                        String factor;
                        expr = GeneralString.replaceString(expr_template, before_iso.length(), isocode);
                        try {
                            pattern = Pattern.compile(expr, 10);
                        }
                        catch (Exception e) {
                            System.err.println(e.toString() + ": " + expr);
                        }
                        Matcher matcher = pattern.matcher(allText);
                        if (matcher.find()) {
                            value = matcher.group(valuepos);
                            factor = null;
                            if (factorForAll > 1) {
                                factor = factorForAll + "";
                            }
                            if (factorpos > 0) {
                                factor = matcher.group(factorpos);
                            }
                            if (factor == null || factor.length() == 0) {
                                factor = "1";
                            }
                            if (removeTags) {
                                value = this.removeTags(value);
                            }
                            if (removeWhitespaces) {
                                value = CurrencyConverter.removeWhitespaces(value);
                            }
                            if (replaceCodes) {
                                value = this.replaceCodes(value);
                            }
                            value = GeneralString.removeChar(value, decimalSeparator);
                            if (decimalPoint != '.') {
                                value = GeneralString.replaceChar(value, decimalPoint, '.');
                            }
                            if (factorpos > 0 || factorForAll > 1) {
                                bd = new BigDecimal(value);
                                bd = bd.divide(new BigDecimal(factor), 10, 4);
                                value = bd.toString();
                            }
                            if (!value.equals("0")) {
                                found3 = true;
                                ++real;
                                ++count;
                                country = iso3166.getString(flag);
                                if (country != null) {
                                    country = GeneralString.encodeUnicode(country);
                                }
                                country = country == null ? "" : " - " + country;
                                out = isocode + " (" + description + country + "):" + value + ":" + flag + ":" + truefalse + ":" + sourcetarget;
                                exchangeRates.add(out);
                            } else {
                                found3 = false;
                                out = isocode + " value is zero";
                            }
                        } else if (!before_iso_inv.equals("") || !after_iso_inv.equals("")) {
                            expr = GeneralString.replaceString(expr_template_inv, before_iso_inv.length(), isocode);
                            try {
                                pattern = Pattern.compile(expr, 10);
                            }
                            catch (Exception e) {
                                System.err.println(e.toString() + ": " + expr);
                            }
                            matcher = pattern.matcher(allText);
                            if (matcher.find()) {
                                value = matcher.group(valuepos);
                                factor = null;
                                if (factorForAll > 1) {
                                    factor = factorForAll + "";
                                }
                                if (factorpos > 0) {
                                    factor = matcher.group(factorpos);
                                }
                                if (factor == null || factor.length() == 0) {
                                    factor = "1";
                                }
                                value = GeneralString.removeChar(value, decimalSeparator);
                                if (decimalPoint != '.') {
                                    value = GeneralString.replaceChar(value, decimalPoint, '.');
                                }
                                bd = new BigDecimal(value);
                                if (factorpos > 0 || factorForAll > 1) {
                                    bd = bd.divide(new BigDecimal(factor), 10, 4);
                                }
                                if (!(value = (bd = _1.divide(bd, 10, 4)).toString()).equals("0")) {
                                    found3 = true;
                                    ++real;
                                    ++count;
                                    country = iso3166.getString(flag);
                                    if (country != null) {
                                        country = GeneralString.encodeUnicode(country);
                                    }
                                    country = country == null ? "" : " - " + country;
                                    out = isocode + " (" + description + country + "):" + value + ":" + flag + ":" + truefalse + ":" + sourcetarget;
                                    exchangeRates.add(out);
                                } else {
                                    found3 = false;
                                    out = isocode + " value is zero";
                                }
                            } else {
                                found3 = false;
                                out = isocode + " not found";
                            }
                        } else {
                            found3 = false;
                            out = isocode + " not found";
                        }
                        last_isocode = isocode;
                    } else if (found3) {
                        ++count;
                        country = iso3166.getString(flag);
                        if (country != null) {
                            country = GeneralString.encodeUnicode(country);
                        }
                        country = country == null ? "" : " - " + country;
                        sb = new StringBuilder(isocode.length() + description.length() + country.length() + value.length() + flag.length() + truefalse.length() + sourcetarget.length() + 7);
                        sb.append(isocode).append(" (").append(description).append(country).append("):").append(value).append(":").append(flag).append(":").append(truefalse).append(":").append(sourcetarget);
                        out = sb.toString();
                        exchangeRates.add(out);
                    } else {
                        out = isocode + " not found";
                    }
                } else {
                    out = isocode + " ignored";
                }
                if (debug) {
                    System.out.println(out);
                }
                textArea.append(out + "\n");
                textArea.setCaretPosition(textArea.getDocument().getLength());
            }
            myInput.close();
            fin.close();
            int tempi = current.get();
            if (tempi != counter2.get()) {
                throw new Exception("User cancellation.");
            }
            double d = (double)count * 100.0 / (double)tempi;
            BigDecimal bd = new BigDecimal(d);
            bd = bd.setScale(2, 4);
            d = bd.doubleValue();
            out = count + " of " + tempi + " exchange rates found (" + d + " %), [" + real + " unique]\n" + CurrencyConverter.duration(System.currentTimeMillis() - begin) + "\n";
            if (debug) {
                System.out.print(out);
            }
            textArea.append(out);
            if (count == 0) {
                exchangeRates.clear();
            }
        }
        catch (Exception e) {
            exchangeRates.clear();
            System.err.println(e.toString());
            throw e;
        }
    }

    private static String duration(long t) {
        long ms = 0L;
        long s = 0L;
        long m = 0L;
        long h = 0L;
        long d = 0L;
        ms = t % 1000L;
        if ((t /= 1000L) > 0L) {
            s = t % 60L;
            t /= 60L;
        }
        if (t > 0L) {
            m = t % 60L;
            t /= 60L;
        }
        if (t > 0L) {
            h = t % 24L;
            t /= 24L;
        }
        d = t;
        return d + " d, " + h + " h, " + m + " m, " + s + " s, " + ms + " ms";
    }

    public static void removeAllComment(StringBuilder source) {
        int begin = source.indexOf("<!--");
        int end = source.indexOf("-->");
        System.out.println(begin + "-" + end);
        while (begin > -1 && end > -1 && end > begin) {
            source.delete(begin, end + 3);
            begin = source.indexOf("<!--");
            end = source.indexOf("-->");
            System.out.println(begin + "-" + end);
        }
    }

    private static String removeWhitespaces(String string) {
        StringBuilder sbuf = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ' ' || string.charAt(i) == '\t') continue;
            sbuf.append(string.charAt(i));
        }
        return sbuf.toString();
    }

    private String removeTags(String string) {
        StringBuilder sbuf = new StringBuilder();
        boolean tag = false;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '<') {
                tag = true;
                continue;
            }
            if (string.charAt(i) == '>') {
                tag = false;
                continue;
            }
            if (tag) continue;
            sbuf.append(string.charAt(i));
        }
        return sbuf.toString();
    }

    private String replaceCodes(String string) {
        for (int i = 0; i <= 9; ++i) {
            string = GeneralString.replaceAllStrings(string, "&#" + (i + 48) + ";", String.valueOf(i));
            string = GeneralString.replaceAllStrings(string, "&#x" + Integer.toHexString(i + 48).toLowerCase() + ";", String.valueOf(i));
            string = GeneralString.replaceAllStrings(string, "&#x" + Integer.toHexString(i + 48).toUpperCase() + ";", String.valueOf(i));
        }
        string = GeneralString.replaceAllStrings(string, "&#69;", "E");
        string = GeneralString.replaceAllStrings(string, "&#x45;", "E");
        string = GeneralString.replaceAllStrings(string, "&#101;", "e");
        string = GeneralString.replaceAllStrings(string, "&#x65;", "e");
        string = GeneralString.replaceAllStrings(string, "&#43;", "+");
        string = GeneralString.replaceAllStrings(string, "&#x2B;", "+");
        string = GeneralString.replaceAllStrings(string, "&#x2b;", "+");
        string = GeneralString.replaceAllStrings(string, "&#44;", ",");
        string = GeneralString.replaceAllStrings(string, "&#x2C;", ",");
        string = GeneralString.replaceAllStrings(string, "&#x2c;", ",");
        string = GeneralString.replaceAllStrings(string, "&#45;", "-");
        string = GeneralString.replaceAllStrings(string, "&#x2D;", "-");
        string = GeneralString.replaceAllStrings(string, "&#x2d;", "-");
        string = GeneralString.replaceAllStrings(string, "&#46;", ".");
        string = GeneralString.replaceAllStrings(string, "&#x2E;", ".");
        string = GeneralString.replaceAllStrings(string, "&#x2e;", ".");
        return string.toString();
    }
}

