/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.misc;

import fi.joensuu.joyds1.calendar.ChineseCalendar;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class ChineseCalendarCalculations {
    public static final int RAT = 0;
    public static final int OX = 1;
    public static final int TIGER = 2;
    public static final int RABBIT = 3;
    public static final int DRAGON = 4;
    public static final int SNAKE = 5;
    public static final int HORSE = 6;
    public static final int GOAT = 7;
    public static final int MONKEY = 8;
    public static final int ROOSTER = 9;
    public static final int DOG = 10;
    public static final int PIG = 11;
    private static final int[] EARTHLY_BRANCHES = new int[]{8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7};
    public static final int WOOD = 0;
    public static final int FIRE = 1;
    public static final int EARTH = 2;
    public static final int METAL = 3;
    public static final int WATER = 4;
    private static final int[] HEAVENLY_STEMS = new int[]{3, 3, 4, 4, 0, 0, 1, 1, 2, 2};
    public static final int YING = 0;
    public static final int YANG = 1;
    private static final int[] YING_YANG = new int[]{1, 0};
    private static final byte[] chineseNewYearOffsets = new byte[]{26, 15, 4, 21, 11, 0, 19, 8, 27, 16, 5, 23, 12, 2, 21, 9, 28, 18, 7, 25, 14, 3, 22, 11, 0, 19, 9, 27, 16, 5, 24, 12, 2, 21, 10, 28, 17, 6, 25, 13, 3, 22, 12, 0, 19, 8, 27, 15, 4, 23, 13, 2, 21, 10, 29, 18, 7, 26, 15, 4, 23, 13, 2, 20, 9, 27, 17, 5, 24, 14, 3, 21, 10, 29, 18, 7, 26, 15, 5, 23, 12, 1, 20, 8, 27, 17, 6, 24, 14, 3, 22, 10, 29, 18, 8, 26, 15, 5, 23, 11, 1, 19, 9, 27, 17, 6, 25, 13, 2, 21, 10, 28, 18, 8, 27, 15, 4, 23, 12, 0, 19, 9, 28, 17, 6, 25, 14, 2, 21, 10, 29, 18, 7, 26, 15, 3, 22, 12, 1, 19, 9, 28, 17, 5, 24, 13, 3, 21, 10, 0, 19, 7, 26, 15, 4, 23, 13, 2, 21, 10, 28, 17, 7, 24, 14, 4, 23, 11, 0, 19, 8, 26, 15, 5, 24, 13, 2, 21, 10, 28, 17, 6, 25, 14, 4, 23, 12, 30, 19, 8, 27, 15, 5, 24, 13, 2, 20, 9, 28, 17, 6, 25, 15, 3, 22, 11, 30, 18, 8, 27, 16, 5, 24, 13, 2, 20, 9, 28, 18, 6, 25, 15, 4, 21, 10, 29, 19, 8, 27, 16, 5, 23, 12, 1, 20, 9, 28, 18, 7, 25, 14, 3, 22, 10, 0, 19, 9, 27, 16, 5, 23, 12, 1, 20, 10, 29, 18, 8, 26, 14, 4, 23, 12, 1, 20, 9, 28, 16, 5, 24, 13, 2, 21, 11, 30, 18, 7, 26, 15, 3, 23, 12, 2, 20, 9, 27, 16, 5, 24, 14, 3, 21, 10, 29, 18, 6, 25, 15, 4, 23, 12, 1, 20, 8, 27, 16, 6, 24, 13, 3, 22, 10, 28, 18, 7, 25, 15, 4, 23, 12, 0, 19, 9, 27, 16, 6, 25, 13, 2, 21, 10, 28, 17, 7, 26, 15, 4, 23, 12, 30, 19, 8, 27, 16, 6, 25, 14, 2, 20, 10, 29, 17, 7, 26, 15, 3, 22, 11, 1, 19, 8, 28, 17, 5, 24, 13, 2, 20, 10, 29, 18, 7, 26, 15, 4, 22, 11, 1, 20, 8, 27, 16, 5, 23, 13, 2, 21, 10, 29, 18, 7, 25, 14, 3, 22, 11, 1, 20, 9, 27, 16, 5, 24, 12, 2, 21, 11, 29, 18, 7, 25, 14, 3, 22, 12, 0, 19, 8, 27, 15, 5, 24, 13, 2, 21, 10, 29, 17, 6, 25, 15, 3, 22, 12, 1, 19, 8, 27, 16, 5, 24, 13, 3, 20, 9, 28, 17, 6, 25, 15, 4, 22, 11, 0, 19, 8, 27, 17, 7, 25, 14, 3, 22, 10, 29, 18, 8, 26, 16, 5, 24, 12, 1, 20, 9, 27, 17, 6, 25, 13, 2, 21, 11, 29, 18, 8, 27, 15, 4, 23, 12, 1, 20, 9, 28, 17, 6, 25, 14, 2, 21, 11, 30, 18, 8, 26, 15, 4, 22, 12, 2, 20, 9, 28, 17, 5, 24, 13, 3, 21, 11, 30, 19, 7, 26, 15, 4, 22, 12, 2, 21, 9, 28, 17, 6, 24, 13, 3, 22, 10, 0, 18, 7, 25, 15, 4, 23, 12, 1, 20, 9, 27, 16, 6, 25, 14, 4, 23, 12, 30, 19, 8, 27, 16, 5, 24, 14, 2, 20, 9, 28, 17, 7, 26, 15, 3, 22, 11, 30, 18, 8, 27, 17, 5, 24, 13, 2, 20, 9, 28, 18, 7, 26, 15, 4, 22, 11, 30, 19, 8, 27, 16, 6, 23, 12, 2, 21, 9, 28, 18, 7, 25, 14, 3, 22, 11, 0, 19, 9, 27, 16, 5, 24, 12, 1, 21, 10, 28, 18, 7, 25, 13, 3, 22, 12, 0, 19, 8, 27, 15, 4, 23, 13, 1, 21, 10, 29, 17, 6, 25, 14, 3, 22, 11, 1, 20, 9, 27, 17, 5, 24, 14, 3, 21, 11, 29, 18, 7, 26, 15, 5, 23, 12, 31, 20, 8, 27, 16, 6, 24, 14, 3, 22, 10, 29, 18, 7, 26, 15, 5, 24, 12, 1, 19, 9, 27, 16};

    public static GregorianCalendar chineseNewYearStartDate(int year) {
        return ChineseCalendarCalculations.chineseNewYearStartDate_OffsetImpl(year);
    }

    private static GregorianCalendar chineseNewYearStartDate_OffsetImpl(int year) {
        if (year >= 2343 || year < 1646) {
            throw new IllegalArgumentException("year has to be >= 1646 and < 2343 in order to produce correct results");
        }
        GregorianCalendar startDate = new GregorianCalendar(year, 0, 21, 0, 0, 0);
        startDate.add(5, chineseNewYearOffsets[year - 1646]);
        return startDate;
    }

    private static GregorianCalendar chineseNewYearStartDate_APIImpl(int year) {
        if (year >= 2343 || year <= 1646) {
            throw new IllegalArgumentException("year has to be > 1646 and < 2343 in order to produce correct results");
        }
        fi.joensuu.joyds1.calendar.GregorianCalendar afterNewYear = new fi.joensuu.joyds1.calendar.GregorianCalendar(year, 5, 1);
        ChineseCalendar chineseCalendar = new ChineseCalendar((fi.joensuu.joyds1.calendar.Calendar)afterNewYear);
        chineseCalendar.set(chineseCalendar.getCycle(), chineseCalendar.getYear(), 1, 1, false);
        fi.joensuu.joyds1.calendar.GregorianCalendar chineseNewYearAsGregorianCalendar = new fi.joensuu.joyds1.calendar.GregorianCalendar();
        chineseNewYearAsGregorianCalendar.set((fi.joensuu.joyds1.calendar.Calendar)chineseCalendar);
        return chineseNewYearAsGregorianCalendar.toJavaUtilGregorianCalendar();
    }

    public static GregorianCalendar chineseNewYearEndDate(int year) {
        GregorianCalendar chineseNewYearEnd = ChineseCalendarCalculations.chineseNewYearStartDate(year + 1);
        chineseNewYearEnd.add(5, -1);
        return chineseNewYearEnd;
    }

    public static int[] chineseYearInfo(int year, int month, int day) {
        return ChineseCalendarCalculations.chineseYearInfo(new GregorianCalendar(year, month - 1, day));
    }

    public static int[] chineseYearInfo(GregorianCalendar birthday) {
        int[] index = new int[3];
        GregorianCalendar chineseNewYear = ChineseCalendarCalculations.chineseNewYearStartDate(birthday.get(1));
        int refyear = birthday.get(1);
        if (birthday.before(chineseNewYear)) {
            --refyear;
        }
        index[0] = EARTHLY_BRANCHES[refyear % 12];
        index[1] = HEAVENLY_STEMS[refyear % 10];
        index[2] = YING_YANG[refyear % 2];
        return index;
    }

    private static String formattedDate(Calendar calendar) {
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
        String formattedDate = format.format(new Date(calendar.getTimeInMillis()));
        return formattedDate;
    }
}

