/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.misc;

import java.util.GregorianCalendar;
import net.numericalchameleon.util.misc.ChineseCalendarCalculations;

public class ChineseYearInfo {
    private GregorianCalendar date;
    private int earthlyBranch;
    private int heavenlyStem;
    private int yingYang;

    public ChineseYearInfo(GregorianCalendar date) {
        this.date = date;
        int[] index = ChineseCalendarCalculations.chineseYearInfo(date);
        this.earthlyBranch = index[0];
        this.heavenlyStem = index[1];
        this.yingYang = index[2];
    }

    public ChineseYearInfo(int year, int month, int day) {
        this(new GregorianCalendar(year, month - 1, day));
    }

    public GregorianCalendar getDate() {
        return this.date;
    }

    public int getEarthlyBranch() {
        return this.earthlyBranch;
    }

    public int getHeavenlyStem() {
        return this.heavenlyStem;
    }

    public int getYingYang() {
        return this.yingYang;
    }

    public GregorianCalendar chineseNewYearStartDate() {
        return ChineseCalendarCalculations.chineseNewYearEndDate(this.date.get(1));
    }

    public GregorianCalendar chineseNewYearEndDate() {
        return ChineseCalendarCalculations.chineseNewYearEndDate(this.date.get(1));
    }
}

