/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.misc;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class RandomGenerator {
    private static SecureRandom secureRandom = null;

    public static int getRandom(int lowerbound, int upperbound) {
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
        }
        return secureRandom.nextInt(upperbound + 1 - lowerbound) + lowerbound;
    }

    public static int[] generate(int count, int lowerbound, int upperbound, boolean duplicates, boolean sort) throws IllegalArgumentException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (lowerbound > upperbound) {
            throw new IllegalArgumentException(lowerbound + " > " + upperbound);
        }
        if (count < 1) {
            throw new IllegalArgumentException("count < 1");
        }
        if (upperbound - lowerbound + 1 < count && !duplicates) {
            duplicates = true;
        }
        HashMap<Integer, String> hash = null;
        for (int i = 0; i < count; ++i) {
            int number = RandomGenerator.getRandom(lowerbound, upperbound);
            if (!duplicates && count > 1) {
                if (hash == null) {
                    hash = new HashMap<Integer, String>();
                }
                while (hash.get(new Integer(number)) != null) {
                    number = RandomGenerator.getRandom(lowerbound, upperbound);
                }
                hash.put(new Integer(number), "");
            }
            list.add(new Integer(number));
        }
        Object[] IntArray = list.toArray();
        if (sort && count > 1) {
            Arrays.sort(IntArray);
        }
        int[] array = new int[IntArray.length];
        int i = 0;
        for (Object o : IntArray) {
            array[i++] = (Integer)o;
        }
        return array;
    }
}

