/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.phoneticalphabets;

import java.util.Hashtable;
import java.util.Vector;

public class PhoneticAlphabet {
    private Hashtable hash = new Hashtable();
    public static final String[] INTERNATIONAL = new String[]{"Amsterdam", "Baltimore", "Casablanca", "Danemark", "Edison", "Florida", "Gallipoli", "Havanna", "Italia", "Jerusalem", "Kilogramme", "Liverpool", "Madagaskar", "New York", "Oslo", "Paris", "Qu\u00e9bec", "Roma", "Santiago", "Tripoli", "Upsala", "Valencia", "Washington", "Xanthippe", "Yokohama", "Z\u00fcrich"};
    public static final String[] NATO = new String[]{"Alfa", "Bravo", "Charlie", "Delta", "Echo", "Foxtrot", "Golf", "Hotel", "India", "Juliett", "Kilo", "Lima", "Mike", "November", "Oscar", "Papa", "Quebec", "Romeo", "Sierra", "Tango", "Uniform", "Viktor", "Whiskey", "X-ray", "Yankee", "Zulu"};
    public static final String[] AMERICAN = new String[]{"Abel", "Baker", "Charlie", "Dog", "Easy", "Fox", "George", "How", "Item", "Jig", "King", "Love", "Mike", "Nan", "Oboe", "Peter", "Queen", "Roger", "Sugar", "Tare", "Uncle", "Victor", "William", "X", "Yoke", "Zebra"};
    public static final String[] ARMYNAVY = new String[]{"Able", "Baker", "Charlie", "Dog", "Easy", "Fox", "George", "How", "Item", "Jig", "King", "Love", "Mike", "Nutley", "Oboe", "Peter", "Queen", "Roger", "Sail", "Tare", "Uncle", "Victor", "William", "X-ray", "Zebra"};
    public static final String[] BRITISH = new String[]{"Andrew", "Benjamin", "Charlie", "David", "Edward", "Frederick", "George", "Harry", "Isaac", "Jack", "King", "Lucy", "Mary", "Nellie", "Oliver", "Peter", "Queenie", "Robert", "Sugar", "Tommy", "Uncle", "Victor", "William", "Xmas", "Yellow", "Zebra"};
    public static final String[] GERMAN = new String[]{"Anton", "\u00c4rger", "Berta", "C\u00e4sar", "CHarlotte", "Dora", "Emil", "Friedrich", "Gustav", "Heinrich", "Ida", "Julius", "Kaufmann", "Ludwig", "Martha", "Nordpol", "Otto", "\u00d6konom", "Paula", "Quelle", "Richard", "Samuel", "SCHule", "Theodor", "Ulrich", "\u00dcbermut", "Viktor", "Wilhelm", "Xanthippe", "Ypsilon", "Zacharias"};
    public static final String[] FRENCH = new String[]{"Anatole", "Berthe", "C\u00e9lestin", "D\u00e9sir\u00e9", "Eug\u00e8ne", "\u00c9mile", "Fran\u00e7ois", "Gaston", "Henri", "Irma", "Joseph", "Kl\u00e9ber", "Louis", "Marcel", "Nicolas", "Oscar", "Pierre", "Quintal", "Raoul", "Suzanne", "Th\u00e9r\u00e8se", "Ursule", "Victor", "William", "Xavier", "Yvonne", "Zo\u00e9"};
    public static final String[] SPANISH = new String[]{"Antonio", "Barcelona", "Carmen", "CHocolate", "Dolores", "Enrique", "Francia", "Gerona", "Historia", "In\u00e9s", "Jos\u00e9", "Kilo", "Lorenzo", "LLobregat", "Madrid", "Navarra", "\u00d1o\u00f1o", "Oviedo", "Par\u00eds", "Querido", "Ram\u00f3n", "S\u00e1bado", "Tarragona", "Ulises", "Valencia", "Washington", "Xiquena", "Yegua", "Zaragoza"};
    public static final String[] ITALIAN = new String[]{"Ancona", "Bologna", "Como", "Domodossola", "Empoli", "Forli", "Genova", "Hotel", "Imola", "Jolanda", "Kappa", "Livorno", "Milano", "Napoli", "Otranto", "Pisa", "Quattro", "Roma", "Salerno", "Torino", "Udine", "Venezia", "Washington", "Xilofono", "Ypsilon", "Zeta"};
    public static final String[] PORTUGUESE = new String[]{"Aveiro", "Braga", "Coimbra", "Dafundo", "\u00c9vora", "Faro", "Guarda", "Horta", "It\u00e1lia", "Jos\u00e9", "Kodak", "Lisboa", "Maria", "Nazar\u00e9", "Ovar", "Porto", "Queluz", "Rossio", "Set\u00fabal", "Tavira", "Unidade", "Vidago", "Waldemar", "Xavier", "York", "Zulmira"};
    public static final String[] DANISH = new String[]{"Anna", "\u00c5ase", "\u00c6gir", "Bernhard", "Cecilia", "David", "Erik", "Frederik", "Georg", "Hans", "Ida", "Johan", "Karen", "Ludvig", "Marie", "Nikolaj", "Odin", "\u00d8eresund", "Peter", "Quintus", "Rasmus", "Soeren", "Theodor", "Ulla", "Viggo", "William", "Xerxes", "Yrsa", "Zacharias"};
    public static final String[] DUTCH = new String[]{"Anna", "Bernard", "Cornelis", "Dirk", "Eduard", "Ferdinand", "Gerard", "Hendrik", "Izaak", "Jan", "Karel", "Lodewijk", "Marie", "Nico", "Otto", "Pieter", "Quadraat", "Rudolf", "Simon", "Teunis", "Utrecht", "Victor", "Willem", "Xantippe", "IJmuiden", "Ypsilon", "Zaandam"};
    public static final String[] SWEDISH = new String[]{"Adam", "Bertil", "Cesar", "David", "Erik", "Filip", "Gustav", "Helge", "Ivar", "Johan", "Kalle", "Ludvig", "Martin", "Niklas", "Olof", "Petter", "Quintus", "Rudolf", "Sigurd", "Tore", "Urban", "Viktor", "Wilhelm", "Xerxes", "Yngve", "Z\u00e4ta", "\u00c5ke", "\u00c4rlig", "\u00d6sten"};
    public static final String[] HEBREW = new String[]{"Affula", "Binyamina", "Carmel", "Dalia", "Eretz", "France", "Gedera", "Haifa", "Israel", "Jaffa", "Karkur", "Lod", "Moledet", "Naan", "Ogen", "Pardes", "Queen", "Rishon", "Sefer", "Tveria", "Urim", "Vered", "Wingate", "Express", "Yavniel", "Zikhron"};
    public static final String[] RAF_1924_1942 = new String[]{"Ace", "Beer", "Charlie", "Don", "Edward", "Freddie", "George", "Harry", "Ink", "Johnnie", "King", "London", "Monkey", "Nuts", "Orange", "Pip", "Queen", "Robert", "Sugar", "Toc", "Uncle", "Vic", "William", "X-ray", "Yorker", "Zebra"};
    public static final String[] RAF_1942_1943 = new String[]{"Apple", "Beer", "Charlie", "Dog", "Edward", "Freddy", "George", "Harry", "In", "Johnny", "King", "Love", "Mother", "Nuts", "Orange", "Peter", "Queen", "Roger", "Sugar", "Tommy", "Uncle", "Vic", "William", "X-ray", "Yorker", "Zebra"};
    public static final String[] RAF_1943_1956 = new String[]{"Able-Affirm", "Baker", "Charlie", "Dog", "Easy", "Fox", "George", "How", "Item", "Johnny", "King", "Love", "Mike", "Negat", "Oboe", "Peter", "Queen", "Roger", "Sugar", "Tare", "Uncle", "Victor", "William", "X-ray", "Yoke", "Zebra"};
    public static final String[] BRITISH_ROYAL_NAVY = new String[]{"Apples", "Butter", "Charlie", "Duff", "Edward", "Freddy", "George", "Harry", "Ink", "Johnny", "King", "London", "Monkey", "Nuts", "Orange", "Pudding", "Queenie", "Robert", "Sugar", "Tommy", "Uncle", "Vinegar", "Willie", "Xerxes", "Yellow", "Zebra"};
    public static final String[] AUSTRIAN = new String[]{"Anton", "\u00c4rger", "Berta", "C\u00e4sar", "Dora", "Emil", "Friedrich", "Gustav", "Heinrich", "Ida", "Julius", "Konrad", "Ludwig", "Martha", "Nordpol", "Otto", "\u00d6sterreich", "Paula", "Quelle", "Richard", "Siegfried", "SCHule", "Theodor", "Ulrich", "\u00dcbel", "Viktor", "Wilhelm", "Xaver", "Ypsilon", "Z\u00fcrich"};
    public static final String[] SWISS = new String[]{"Anna", "\u00c4sch", "Berta", "C\u00e4sar", "Daniel", "Emil", "Friedrich", "Gustav", "Heinrich", "Ida", "Jakob", "Kaiser", "Leopold", "Marie", "Niklaus", "Otto", "\u00d6rlikon", "Peter", "Quasi", "Rosa", "Sophie", "Theodor", "Ulrich", "\u00dcbermut", "Viktor", "Wilhelm", "Xaver", "Yverdon", "Z\u00fcrich"};
    public static final String[] MORSE = new String[]{".-", "-...", "-.-.", "-..", ".", "..-.", "--.", "....", "..", ".---", "-.-", ".-..", "--", "-.", "---", ".--.", "--.-", ".-.", "...", "-", "..-", "...-", ".--", "-..-", "-.--", "--..", "-----", ".----", "..---", "...--", "....-", ".....", "-....", "--...", "---..", "----.", "--..--", ".-.-.-", "..--..", "-.-.-", "---...", "-..-.", "-....-", ".----.", "-.--.-", "-.--.-", "..--.-", ".-..-.", ".-.-", ".--.-", ".--.-", "..-..", "--.--", "---.", "..--", ".--.-."};
    private String[] moreThanOne = null;

    public PhoneticAlphabet(String[] alphabet) {
        Vector<String> moreThanOneVector = new Vector<String>();
        if (alphabet == MORSE) {
            String code = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789,.?;:/-'()_\"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd@";
            for (int i = 0; i < code.length(); ++i) {
                this.hash.put(code.substring(i, i + 1), alphabet[i]);
            }
            this.hash.put("CH", "----");
            moreThanOneVector.add("CH");
        } else {
            for (int i = 0; i < alphabet.length; ++i) {
                int k;
                for (k = 0; k < alphabet[i].length() && alphabet[i].charAt(k) != Character.toLowerCase(alphabet[i].charAt(k)); ++k) {
                }
                if (k <= 1) {
                    this.hash.put(alphabet[i].substring(0, k), alphabet[i]);
                    continue;
                }
                this.hash.put(alphabet[i].substring(0, k), alphabet[i].substring(0, 1) + alphabet[i].substring(1, k).toLowerCase() + alphabet[i].substring(k, alphabet[i].length()));
                moreThanOneVector.add(alphabet[i].substring(0, k));
            }
        }
        this.moreThanOne = new String[moreThanOneVector.size()];
        for (int i = 0; i < moreThanOneVector.size(); ++i) {
            this.moreThanOne[i] = (String)moreThanOneVector.get(i);
        }
    }

    public PhoneticAlphabet() {
        this(INTERNATIONAL);
    }

    public Vector get(String text) {
        Vector<String> v = new Vector<String>();
        String textupper = text.toUpperCase();
        for (int i = 0; i < textupper.length(); ++i) {
            String temp;
            boolean done = false;
            for (int x = 0; x < this.moreThanOne.length; ++x) {
                int len = this.moreThanOne[x].length();
                if (textupper.length() - i < len || !textupper.substring(i, i + len).equals(this.moreThanOne[x].toUpperCase()) || (temp = (String)this.hash.get(this.moreThanOne[x])) == null) continue;
                v.add(temp);
                done = true;
                i += len - 1;
            }
            if (done) continue;
            temp = (String)this.hash.get(textupper.substring(i, i + 1));
            if (temp != null) {
                v.add(temp);
                continue;
            }
            v.add(textupper.substring(i, i + 1));
        }
        return v;
    }

    public String get(char c) {
        String key = String.valueOf(c);
        String temp = (String)this.hash.get(key.toUpperCase());
        return temp != null ? temp : key;
    }
}

